/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataintegration.plugin.DataIntegrationBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class BCMDataIntegrationPlugin
extends DataIntegrationBasePlugin {
    private static final String SRC_DIM_NAME = "bcmdimsourcename";
    private static final String POINT_SRC_MEM = "bcmpointsourceshow";
    private static final String MEM_MAPPING = "bcmdimmemmap";
    private static final String POINT_TAR_MEM = "bcmpointtarmemshow";
    private static final String YEAR_PERIOD = "Year-Period";

    @Override
    public void initialize() {
        super.initialize();
        EntryGrid mapEntryGrid = (EntryGrid)this.getControl("bcmdimmapentity");
        mapEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"srcmodel", "srcorgview"});
        this.addClickListeners(new String[]{SRC_DIM_NAME, POINT_SRC_MEM, "srcrangemembers"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateIntegrationRangeEntry(false);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap22"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"srcmodel", "srcorgview", "srcrangemembers"});
        this.getView().setVisible(Boolean.valueOf(!this.isNewEbForm()), new String[]{"flexpanelap3"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.fillSourceOrgRangeText();
        this.updateMappingEntryAfterLoad();
        this.updateIntegrationRangeEntry(false);
    }

    private void fillSourceOrgRangeText() {
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("srcrangememrecord");
        if (CollectionUtils.isNotEmpty((Collection)value)) {
            Object[] names = value.stream().map(e -> e.getString("fbasedataid.name")).distinct().toArray();
            this.getModel().setValue("srcrangemembers", (Object)StringUtils.join((Object[])names, (String)";"));
        }
    }

    private void updateMappingEntryAfterLoad() {
        this.getModel().beginInit();
        this.updateMapEntryNameShow();
        this.dealDataSetDimChanged();
        this.dealBcmDimChanged();
        this.getModel().endInit();
        this.getView().updateView("bcmdimmapentity");
    }

    private void dealBcmDimChanged() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        Set<String> existBcmDimNums = entryEntity.stream().map(e -> e.getString("bcmdimsourcenumber")).collect(Collectors.toSet());
        Map<String, SimpleObject> bcmModelDimensions = this.getBcmModelDimension(this.getSourceModelId());
        existBcmDimNums.forEach(bcmModelDimensions::remove);
        if (bcmModelDimensions.size() > 0) {
            Collection<SimpleObject> values = bcmModelDimensions.values();
            Set<Long> dimIds = values.stream().map(SimpleObject::getId).collect(Collectors.toSet());
            Map<Long, SimpleObject> bcmDimNoneMemMap = this.getBcmDimNoneMem(dimIds);
            int[] index = this.getModel().batchCreateNewEntryRow("bcmdimmapentity", values.size());
            int i = 0;
            for (SimpleObject value : values) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("bcmdimmapentity", index[i++]);
                rowEntity.set("bcmdimsourcenumber", (Object)value.getNumber());
                rowEntity.set(SRC_DIM_NAME, (Object)value.getName());
                SimpleObject bcmNoneMem = bcmDimNoneMemMap.get(value.getId());
                if (bcmNoneMem == null) continue;
                rowEntity.set("bcmpointsourcemem", (Object)bcmNoneMem.getNumber());
                rowEntity.set(POINT_SRC_MEM, (Object)bcmNoneMem.getName());
            }
        }
    }

    private Map<Long, SimpleObject> getBcmDimNoneMem(Set<Long> dimIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,shortnumber", (QFilter[])new QFilter("id", "in", dimIds).toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, SimpleObject>(0);
        }
        Map<Long, String> noneNumberMap = query.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("shortnumber") + "None"));
        QFilter qFilter = new QFilter("dimension", "in", noneNumberMap.keySet()).and("number", "in", noneNumberMap.values());
        DynamicObjectCollection noneMemberObjects = QueryServiceHelper.query((String)SysDimensionEnum.Project.getBcmMembermodel(), (String)"dimension,id,number,name", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)noneMemberObjects)) {
            return new HashMap<Long, SimpleObject>(0);
        }
        HashMap<Long, SimpleObject> bcmDimNoneMemMap = new HashMap<Long, SimpleObject>(noneMemberObjects.size());
        for (DynamicObject noneMember : noneMemberObjects) {
            bcmDimNoneMemMap.put(noneMember.getLong("dimension"), new SimpleObject(Long.valueOf(noneMember.getLong("id")), noneMember.getString("name"), noneMember.getString("number")));
        }
        return bcmDimNoneMemMap;
    }

    private Map<Long, String> getBcmDimensionMemberModel(Set<Long> dimIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,membermodel", (QFilter[])new QFilter("id", "in", dimIds).toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, String>(0);
        }
        return query.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("membermodel")));
    }

    private void dealDataSetDimChanged() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        Set existDimNums = entryEntity.stream().map(e -> e.getString("bcmdimtarnumber")).collect(Collectors.toSet());
        List dimensionList = this.getIModelCacheHelper().getDimensionList(Long.valueOf(this.getDatasetId()));
        for (Dimension dimension : dimensionList) {
            if (existDimNums.contains(dimension.getNumber())) continue;
            int newEntryRow = this.getModel().createNewEntryRow("bcmdimmapentity");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("bcmdimmapentity", newEntryRow);
            rowEntity.set("bcmdimtarnumber", (Object)dimension.getNumber());
            rowEntity.set("bcmdimtarname", (Object)dimension.getName());
            Member member = dimension.getMember(Long.valueOf(0L), dimension.getNoneNumber());
            if (member == null) continue;
            rowEntity.set("bcmpointtarmem", (Object)member.getNumber());
            rowEntity.set(POINT_TAR_MEM, (Object)member.getName());
        }
    }

    private void updateMapEntryNameShow() {
        long datasetId = this.getDatasetId();
        Long sourceModelId = this.getSourceModelId();
        IModelCacheHelper cacheHelper = this.getIModelCacheHelper();
        Map<String, SimpleObject> bcmModelDimensions = this.getBcmModelDimension(sourceModelId);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        for (DynamicObject object : entryEntity) {
            Member member;
            Dimension dimension;
            String tarDimNum;
            String bcmDim = object.getString("bcmdimsourcenumber");
            if (YEAR_PERIOD.equals(bcmDim)) {
                object.set(SRC_DIM_NAME, (Object)ResManager.loadKDString((String)"\u8d22\u5e74-\u671f\u95f4", (String)"BCMDataIntegrationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                SimpleObject simpleObject = bcmModelDimensions.get(bcmDim);
                if (simpleObject != null) {
                    object.set(SRC_DIM_NAME, (Object)simpleObject.getName());
                }
            }
            String pointSourceMemNum = object.getString("bcmpointsourcemem");
            if (StringUtils.isNotEmpty((CharSequence)pointSourceMemNum)) {
                SimpleObject mem = this.getPointSourceDimMemObject(sourceModelId, bcmDim, pointSourceMemNum);
                if (mem != null) {
                    object.set(POINT_SRC_MEM, (Object)mem.getName());
                } else {
                    object.set("bcmpointsourcemem", null);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)(tarDimNum = object.getString("bcmdimtarnumber"))) || (dimension = cacheHelper.getDimension(tarDimNum)) == null) continue;
            object.set("bcmdimtarname", (Object)dimension.getName());
            String tarMem = object.getString("bcmpointtarmem");
            long viewId = object.getLong("bcmpointtarmemview.id");
            if (!StringUtils.isNotEmpty((CharSequence)tarMem) || (member = dimension.getMember(Long.valueOf(viewId), tarMem)) == null) continue;
            object.set(POINT_TAR_MEM, (Object)member.getName());
        }
    }

    private SimpleObject getPointSourceDimMemObject(Long sourceModelId, String bcmDim, String pointSourceMemNum) {
        QFilter dimQFilter = new QFilter("model", "=", (Object)sourceModelId).and("number", "=", (Object)bcmDim);
        DynamicObject bcmDimObject = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,memberform", (QFilter[])dimQFilter.toArray());
        if (bcmDimObject != null) {
            QFilter memQFilter;
            long dimId = bcmDimObject.getLong("id");
            String memberForm = bcmDimObject.getString("memberform");
            DynamicObject bcmMember = QueryServiceHelper.queryOne((String)memberForm, (String)"id,number,name", (QFilter[])(memQFilter = new QFilter("model", "=", (Object)sourceModelId).and("dimension", "=", (Object)dimId).and("number", "=", (Object)pointSourceMemNum)).toArray());
            if (bcmMember != null) {
                return new SimpleObject(Long.valueOf(bcmMember.getLong("id")), bcmMember.getString("name"), bcmMember.getString("number"));
            }
        }
        return null;
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryKey = entryGrid.getEntryKey();
        if ("bcmdimmapentity".equals(entryKey)) {
            this.dimMappingEntryBindData();
        }
    }

    private void dimMappingEntryBindData() {
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            int row = 0;
            for (DynamicObject object : entryEntity) {
                String dimNumber = object.getString("bcmdimtarnumber");
                String bcmDimNum = object.getString("bcmdimsourcenumber");
                Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                this.getView().setEnable(Boolean.valueOf(this.isEnableSetSourceField(dimension)), row, new String[]{SRC_DIM_NAME});
                this.getView().setEnable(Boolean.valueOf(this.isEnableSetPointSrcMem(bcmDimNum)), row, new String[]{POINT_SRC_MEM});
                this.getView().setEnable(Boolean.valueOf(this.isEnableSetDimMemMapping(bcmDimNum, dimNumber)), row, new String[]{MEM_MAPPING});
                this.getView().setEnable(Boolean.valueOf(this.isEnableSetPointTarDimMem(dimension)), row, new String[]{POINT_TAR_MEM});
                ++row;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("srcmodel".equals(name)) {
            this.sourceModelChanged();
        } else if ("datasetid".equals(name)) {
            this.dataSetChanged();
        } else if ("srcorgview".equals(name)) {
            this.sourceOrgViewChanged();
        } else if ("srcrangemembers".equals(name)) {
            this.sourceOrgRangeChanged();
        } else if (MEM_MAPPING.equals(name)) {
            this.dimMemMapChanged(e);
        } else if (SRC_DIM_NAME.equals(name)) {
            this.sourceDimNameChanged();
        } else if (POINT_SRC_MEM.equals(name)) {
            this.pointSourceMemChanged();
        } else if (POINT_TAR_MEM.equals(name)) {
            this.pointTargetMemChanged();
        }
    }

    private void sourceOrgRangeChanged() {
        String value = (String)this.getModel().getValue("srcrangemembers");
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.getModel().setValue("srcrangememrecord", null);
        }
    }

    private void sourceOrgViewChanged() {
        this.getModel().setValue("srcrangemembers", null);
        this.dealMapEntryDimMemMap("Entity");
    }

    private void dealMapEntryDimMemMap(String ebDimNum) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            this.getModel().beginInit();
            for (DynamicObject object : entryEntity) {
                if (!ebDimNum.equals(object.getString("bcmdimtarnumber"))) continue;
                object.set(MEM_MAPPING, null);
                break;
            }
            this.getModel().endInit();
            this.getView().updateView("bcmdimmapentity");
        }
    }

    private void dataSetChanged() {
        Long srcModelId = this.getSourceModelId();
        if (IDUtils.isEmptyLong((Long)srcModelId).booleanValue()) {
            return;
        }
        this.loadDimMappingEntry(srcModelId);
        this.updateIntegrationRangeEntry(true);
    }

    private void pointTargetMemChanged() {
        String value = (String)this.getModel().getValue(POINT_TAR_MEM);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.getModel().beginInit();
            this.getModel().setValue("bcmpointtarmem", null);
            this.getModel().endInit();
            this.getView().updateView("bcmdimmapentity");
            this.updateIntegrationRangeEntry(false);
        }
    }

    private void pointSourceMemChanged() {
        String value = (String)this.getModel().getValue(POINT_SRC_MEM);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.getModel().beginInit();
            this.getModel().setValue("bcmpointsourcemem", null);
            this.getModel().endInit();
            this.getView().updateView("bcmdimmapentity");
        }
    }

    private void sourceDimNameChanged() {
        String value = (String)this.getModel().getValue(SRC_DIM_NAME);
        if (StringUtils.isEmpty((CharSequence)value)) {
            Map<String, SimpleObject> memoryPointSrcMemMap = this.getSelectedPointSrcMemMap();
            this.getModel().beginInit();
            this.getModel().setValue("bcmdimsourcenumber", null);
            this.getModel().setValue("bcmpointsourcemem", null);
            this.getModel().setValue(POINT_SRC_MEM, null);
            this.updateMapEntryAfterBcmDimChanged(memoryPointSrcMemMap);
            this.getModel().endInit();
            this.getView().updateView("bcmdimmapentity");
        }
    }

    public Map<String, SimpleObject> getSelectedPointSrcMemMap() {
        HashMap<String, SimpleObject> memoryPointSrcMemMap = new HashMap<String, SimpleObject>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                String bcmDimNum = object.getString("bcmdimsourcenumber");
                String pointSrcMemName = object.getString(POINT_SRC_MEM);
                String pointSrcMemNum = object.getString("bcmpointsourcemem");
                if (!StringUtils.isNotEmpty((CharSequence)bcmDimNum) || !StringUtils.isNotEmpty((CharSequence)pointSrcMemName) || !StringUtils.isNotEmpty((CharSequence)pointSrcMemNum)) continue;
                memoryPointSrcMemMap.put(bcmDimNum, new SimpleObject(pointSrcMemName, pointSrcMemNum));
            }
        }
        return memoryPointSrcMemMap;
    }

    private void dimMemMapChanged(PropertyChangedArgs e) {
        DynamicObject memMapping = (DynamicObject)this.getModel().getValue(MEM_MAPPING);
        if (memMapping != null) {
            String type = (String)this.getModel().getValue("type");
            this.getModel().beginInit();
            this.getModel().setValue(POINT_TAR_MEM, null);
            this.getModel().setValue("bcmpointtarmem", null);
            this.getModel().setValue("bcmpointtarmemview", null);
            this.getModel().setValue(POINT_SRC_MEM, null);
            this.getModel().setValue("bcmpointsourcemem", null);
            this.getModel().endInit();
            this.getView().updateView("bcmdimmapentity");
            this.updateIntegrationRangeEntry(false);
            DynamicObject dynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            String dimNum = null;
            Long viewId = 0L;
            if (dynamicObject != null) {
                if ("input".equals(type)) {
                    Map map;
                    dimNum = e.getChangeSet()[0].getDataEntity().getString("bcmdimtarnumber");
                    String targetsysinfo = dynamicObject.getString("targetsysinfo");
                    if (StringUtils.isNotEmpty((CharSequence)targetsysinfo) && (map = (Map)JSON.parseObject((String)targetsysinfo, Map.class)).containsKey("view")) {
                        viewId = IDUtils.toLong(map.get("view"));
                    }
                } else {
                    Map map;
                    dimNum = e.getChangeSet()[0].getDataEntity().getString("bcmdimsourcenumber");
                    String sourcesysinfo = dynamicObject.getString("sourcesysinfo");
                    if (StringUtils.isNotEmpty((CharSequence)sourcesysinfo) && (map = (Map)JSON.parseObject((String)sourcesysinfo, Map.class)).containsKey("view")) {
                        viewId = IDUtils.toLong(map.get("view"));
                    }
                }
            }
            this.clearIntegrationRangeEntryWhenViewChange(dimNum, viewId);
        }
    }

    private void sourceModelChanged() {
        DynamicObject srcModel = (DynamicObject)this.getModel().getValue("srcmodel");
        if (srcModel != null) {
            long srcModelId = srcModel.getLong("id");
            this.setDefaultOrgView(srcModelId);
            this.loadDimMappingEntry(srcModelId);
            this.updateIntegrationRangeEntry(false);
        } else {
            this.getModel().setValue("srcorgview", null);
            this.getModel().setValue("srcrangemembers", null);
            this.getModel().deleteEntryData("bcmdimmapentity");
            this.getModel().deleteEntryData("interangeentry");
        }
    }

    private void setDefaultOrgView(Long srcModelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)srcModelId);
        qFilter.and("number", "=", (Object)"DefaultScheme");
        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])qFilter.toArray());
        if (object != null) {
            this.getModel().setValue("srcorgview", (Object)object.getLong("id"));
        }
    }

    private void loadDimMappingEntry(Long srcModelId) {
        this.getModel().deleteEntryData("bcmdimmapentity");
        long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            return;
        }
        Map viewMap = this.getIModelCacheHelper().getViewsByDataSet(Long.valueOf(datasetId));
        Map<String, SimpleObject> bcmModelDimensions = this.getBcmModelDimension(srcModelId);
        List ebModelDimensions = this.getIModelCacheHelper().getDimensionList(Long.valueOf(datasetId));
        Set<Long> dimIds = bcmModelDimensions.values().stream().map(SimpleObject::getId).collect(Collectors.toSet());
        Map<Long, SimpleObject> bcmDimNoneMemMap = this.getBcmDimNoneMem(dimIds);
        Map<Long, String> bcmDimensionMemberModelMap = this.getBcmDimensionMemberModel(dimIds);
        this.getModel().beginInit();
        int[] index = this.getModel().batchCreateNewEntryRow("bcmdimmapentity", ebModelDimensions.size());
        int i = 0;
        for (Dimension ebDimension : ebModelDimensions) {
            Member defaultPointTarDimMem;
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("bcmdimmapentity", index[i++]);
            String dimNumber = ebDimension.getNumber();
            rowEntity.set("bcmdimtarnumber", (Object)dimNumber);
            rowEntity.set("bcmdimtarname", (Object)ebDimension.getName());
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                rowEntity.set("bcmdimsourcenumber", (Object)YEAR_PERIOD);
                rowEntity.set(SRC_DIM_NAME, (Object)ResManager.loadKDString((String)"\u8d22\u5e74-\u671f\u95f4", (String)"BCMDataIntegrationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                SimpleObject bcmDim = bcmModelDimensions.get(dimNumber);
                if (bcmDim != null) {
                    rowEntity.set("bcmdimsourcenumber", (Object)bcmDim.getNumber());
                    rowEntity.set(SRC_DIM_NAME, (Object)bcmDim.getName());
                    bcmModelDimensions.remove(dimNumber);
                    SimpleObject defaultPointSrcMem = this.getDefaultPointSrcMem(bcmDim.getNumber(), bcmDim.getId(), bcmDimNoneMemMap, bcmDimensionMemberModelMap);
                    if (defaultPointSrcMem != null) {
                        rowEntity.set("bcmpointsourcemem", (Object)defaultPointSrcMem.getNumber());
                        rowEntity.set(POINT_SRC_MEM, (Object)defaultPointSrcMem.getName());
                    }
                }
            }
            if ((defaultPointTarDimMem = this.getDefaultPointTarDimMem(ebDimension, viewMap)) == null) continue;
            rowEntity.set(POINT_TAR_MEM, (Object)defaultPointTarDimMem.getName());
            rowEntity.set("bcmpointtarmem", (Object)defaultPointTarDimMem.getNumber());
        }
        if (bcmModelDimensions.size() > 0) {
            int[] index1 = this.getModel().batchCreateNewEntryRow("bcmdimmapentity", bcmModelDimensions.size());
            int j = 0;
            for (SimpleObject value : bcmModelDimensions.values()) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("bcmdimmapentity", index1[j++]);
                String number = value.getNumber();
                rowEntity.set("bcmdimsourcenumber", (Object)number);
                rowEntity.set(SRC_DIM_NAME, (Object)value.getName());
                SimpleObject defaultPointSrcMem = this.getDefaultPointSrcMem(number, value.getId(), bcmDimNoneMemMap, bcmDimensionMemberModelMap);
                if (defaultPointSrcMem == null) continue;
                rowEntity.set("bcmpointsourcemem", (Object)defaultPointSrcMem.getNumber());
                rowEntity.set(POINT_SRC_MEM, (Object)defaultPointSrcMem.getName());
            }
        }
        this.getModel().endInit();
        this.getView().updateView("bcmdimmapentity");
    }

    private Map<String, SimpleObject> getBcmModelDimension(Long srcModelId) {
        HashSet ignoreBcmDims = Sets.newHashSet((Object[])new String[]{"Period", "Year"});
        QFilter qFilter = new QFilter("model", "=", (Object)srcModelId);
        qFilter.and("number", "not in", (Object)ignoreBcmDims);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            LinkedHashMap<String, SimpleObject> bcmDims = new LinkedHashMap<String, SimpleObject>(query.size());
            for (DynamicObject object : query) {
                long id = object.getLong("id");
                String number = object.getString("number");
                String name = object.getString("name");
                bcmDims.put(number, new SimpleObject(Long.valueOf(id), name, number));
            }
            return bcmDims;
        }
        return new HashMap<String, SimpleObject>(0);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (SRC_DIM_NAME.equals(sourceKey)) {
            this.sourceDimNameSelect();
        } else if (POINT_SRC_MEM.equals(sourceKey)) {
            this.pointSrcDimMemberSelect();
        } else if ("srcrangemembers".equals(sourceKey)) {
            this.sourceOrgRangeBeforeF7();
        }
    }

    private void sourceDimNameSelect() {
        Long sourceModelId = this.getSourceModelId();
        if (IDUtils.isEmptyLong((Long)sourceModelId).booleanValue()) {
            return;
        }
        String ebDimNum = (String)this.getModel().getValue("bcmdimtarnumber");
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(ebDimNum);
        if (!this.isEnableSetSourceField(dimension)) {
            return;
        }
        HashSet unableSelectBcmDimNum = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.ACCOUNT.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.CHANGETYPE.getNumber(), DimTypesEnum.SCENARIO.getNumber()});
        String bcmDimNum = (String)this.getModel().getValue("bcmdimsourcenumber");
        Long selectedSourceDimId = this.getSelectedSourceDimId(sourceModelId, bcmDimNum);
        Set<String> noMappingBcmDim = this.getNoMappingBcmDim();
        noMappingBcmDim.add(bcmDimNum);
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bcm_dimension", (boolean)false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sourceDimNameSelect"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("number", "not in", (Object)unableSelectBcmDimNum));
        qFilters.add(new QFilter("number", "in", noMappingBcmDim));
        qFilters.add(new QFilter("model", "=", (Object)sourceModelId));
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        listShowParameter.setSelectedRow((Object)selectedSourceDimId);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private Long getSelectedSourceDimId(Long sourceModelId, String bcmDimNum) {
        if (YEAR_PERIOD.equals(bcmDimNum)) {
            bcmDimNum = "Year";
        }
        if (StringUtils.isNotEmpty((CharSequence)bcmDimNum)) {
            QFilter qFilter = new QFilter("model", "=", (Object)sourceModelId);
            qFilter.and("number", "=", (Object)bcmDimNum);
            DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])qFilter.toArray());
            if (object != null) {
                return object.getLong("id");
            }
        }
        return 0L;
    }

    private Set<String> getNoMappingBcmDim() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        HashSet<String> noMappingBcmDim = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                String tarDim = object.getString("bcmdimtarnumber");
                String sourceDim = object.getString("bcmdimsourcenumber");
                if (!StringUtils.isEmpty((CharSequence)tarDim) || !StringUtils.isNotEmpty((CharSequence)sourceDim)) continue;
                noMappingBcmDim.add(sourceDim);
            }
        }
        return noMappingBcmDim;
    }

    private void pointSrcDimMemberSelect() {
        Long sourceModelId = this.getSourceModelId();
        if (IDUtils.isEmptyLong((Long)sourceModelId).booleanValue()) {
            return;
        }
        String srcDimNumber = (String)this.getModel().getValue("bcmdimsourcenumber");
        if (StringUtils.isEmpty((CharSequence)srcDimNumber)) {
            return;
        }
        if (!this.isEnableSetPointSrcMem(srcDimNumber)) {
            return;
        }
        DynamicObject sourceModel = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceModelId, (String)"bcm_model", (String)"id,number,shownumber");
        if (sourceModel == null) {
            return;
        }
        SimpleObject sourceDim = this.getSourceDim(sourceModelId, srcDimNumber);
        if (sourceDim == null) {
            return;
        }
        String pointSrcMem = (String)this.getModel().getValue("bcmpointsourcemem");
        SimpleObject selectPointSrcMem = this.getPointSourceDimMemObject(sourceModelId, srcDimNumber, pointSrcMem);
        String sourceModelNum = sourceModel.getString("number");
        Long dimId = sourceDim.getId();
        String dimNum = sourceDim.getNumber();
        String dimName = sourceDim.getName();
        MemberF7Parameter f7Param = new MemberF7Parameter();
        f7Param.setEbModelId(this.getModelId());
        f7Param.setModelId(sourceModelId);
        f7Param.setModelNumber(sourceModelNum);
        f7Param.setDimensionId(dimId);
        f7Param.setDimensionNumber(dimNum);
        f7Param.setDimensionName(dimName);
        f7Param.setReturnClassName(ListSelectedRowCollection.class.getName());
        f7Param.setMultiSelect(false);
        if (selectPointSrcMem != null) {
            ArrayList<String[]> members = new ArrayList<String[]>();
            members.add(new String[]{String.valueOf(selectPointSrcMem.getId()), selectPointSrcMem.getNumber(), selectPointSrcMem.getName()});
            f7Param.setSelectedVirtualMember(members);
        }
        NewF7Utils.openVirtualF74JC((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "pointSrcDimMemberSelect"));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String backKey = event.getActionId();
        Object returnData = event.getReturnData();
        if ("sourceDimNameSelect".equals(backKey)) {
            this.sourceDimNameSelectCallBack(returnData);
        } else if ("pointSrcDimMemberSelect".equals(backKey)) {
            this.pointSrcDimMemberSelectCallBack(returnData);
        } else if ("sourceRangeOrgMemSelect".equals(backKey)) {
            this.sourceRangeOrgMemSelect(returnData);
        }
    }

    private void sourceRangeOrgMemSelect(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection objects = (ListSelectedRowCollection)returnData;
            Object[] array = objects.stream().map(ListSelectedRow::getName).toArray();
            Object[] ids = objects.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().toArray();
            this.getModel().setValue("srcrangemembers", (Object)StringUtils.join((Object[])array, (String)";"));
            this.getModel().setValue("srcrangememrecord", (Object)ids);
        }
    }

    private void pointSrcDimMemberSelectCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRow selectedRow = ((ListSelectedRowCollection)returnData).get(0);
            String name = selectedRow.getName();
            String number = selectedRow.getNumber();
            this.getModel().beginInit();
            this.getModel().setValue(POINT_SRC_MEM, (Object)name);
            this.getModel().setValue("bcmpointsourcemem", (Object)number);
            this.getModel().setValue(MEM_MAPPING, null);
            this.getModel().endInit();
            this.getView().updateView("bcmdimmapentity");
            this.updateIntegrationRangeEntry(false);
        }
    }

    @Override
    protected void pointDimMemberSelectCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            this.getModel().beginInit();
            ListSelectedRow selectedRow = ((ListSelectedRowCollection)returnData).get(0);
            String number = selectedRow.getNumber();
            String name = selectedRow.getName();
            this.getModel().setValue(this.getPointTarMemShowFieldKey(), (Object)name);
            this.getModel().setValue(this.getPointTarMemFieldKey(), (Object)number);
            this.getModel().setValue(this.getDimMappingFieldKey(), null);
            if (selectedRow.getDataMap() != null) {
                this.getModel().setValue("bcmpointtarmemview", (Object)selectedRow.getDataMap().getOrDefault("viewid", 0L));
            }
            this.getModel().endInit();
            this.getView().updateView(this.getDimMappingEntryKey());
            this.updateIntegrationRangeEntry(false);
        }
    }

    private void sourceDimNameSelectCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            Map<String, SimpleObject> memoryPointSrcMemMap = this.getSelectedPointSrcMemMap();
            ListSelectedRow selectedRow = ((ListSelectedRowCollection)returnData).get(0);
            String number = selectedRow.getNumber();
            String name = selectedRow.getName();
            this.getModel().beginInit();
            this.getModel().setValue("bcmdimsourcenumber", (Object)number);
            this.getModel().setValue(SRC_DIM_NAME, (Object)name);
            this.getModel().setValue(MEM_MAPPING, null);
            SimpleObject simpleObject = memoryPointSrcMemMap.get(number);
            if (simpleObject != null) {
                this.getModel().setValue(POINT_SRC_MEM, (Object)simpleObject.getName());
                this.getModel().setValue("bcmpointsourcemem", (Object)simpleObject.getNumber());
            }
            this.updateMapEntryAfterBcmDimChanged(memoryPointSrcMemMap);
            this.getModel().endInit();
            this.getView().updateView("bcmdimmapentity");
        }
    }

    private void updateMapEntryAfterBcmDimChanged(Map<String, SimpleObject> memoryPointSrcMemMap) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            HashSet<Integer> needDelRows = new HashSet<Integer>(16);
            for (Object object : entryEntity) {
                String bcmDimNum = object.getString("bcmdimsourcenumber");
                String ebDimNum = object.getString("bcmdimtarnumber");
                if (!StringUtils.isEmpty((CharSequence)ebDimNum) || !StringUtils.isNotEmpty((CharSequence)bcmDimNum)) continue;
                needDelRows.add(object.getInt("seq") - 1);
            }
            if (needDelRows.size() > 0) {
                this.getModel().deleteEntryRows("bcmdimmapentity", needDelRows.stream().mapToInt(x -> x).toArray());
            }
            Map<String, SimpleObject> bcmModelDimensions = this.getBcmModelDimension(this.getSourceModelId());
            for (DynamicObject object : entryEntity) {
                String bcmDimNum = object.getString("bcmdimsourcenumber");
                bcmModelDimensions.remove(bcmDimNum);
            }
            if (bcmModelDimensions.size() > 0) {
                int[] index = this.getModel().batchCreateNewEntryRow("bcmdimmapentity", bcmModelDimensions.size());
                int i = 0;
                for (Map.Entry<String, SimpleObject> entry : bcmModelDimensions.entrySet()) {
                    SimpleObject value = entry.getValue();
                    DynamicObject rowEntity = this.getModel().getEntryRowEntity("bcmdimmapentity", index[i++]);
                    rowEntity.set("bcmdimsourcenumber", (Object)value.getNumber());
                    rowEntity.set(SRC_DIM_NAME, (Object)value.getName());
                    SimpleObject memoryPointSrcMem = memoryPointSrcMemMap.get(value.getNumber());
                    if (memoryPointSrcMem == null) continue;
                    rowEntity.set(POINT_SRC_MEM, (Object)memoryPointSrcMem.getName());
                    rowEntity.set("bcmpointsourcemem", (Object)memoryPointSrcMem.getNumber());
                }
            }
        }
    }

    @Override
    protected void beforeDoSave() {
        super.beforeDoSave();
        this.checkDimMappingInfo();
        this.checkInterRangeInfo();
        this.checkDimView();
    }

    private void checkDimMappingInfo() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            HashSet<String> invalidBcmDimName = new HashSet<String>(16);
            HashSet<String> invalidEbDimName = new HashSet<String>(16);
            for (DynamicObject object : entryEntity) {
                String bcmDim = object.getString("bcmdimsourcenumber");
                String bcmDimName = object.getString(SRC_DIM_NAME);
                String pointSrcMem = object.getString("bcmpointsourcemem");
                String ebDimName = object.getString("bcmdimtarname");
                String ebDim = object.getString("bcmdimtarnumber");
                String pointTarMem = object.getString("bcmpointtarmem");
                Long mappingId = object.getLong("bcmdimmemmap_id");
                if (StringUtils.isEmpty((CharSequence)ebDim) && StringUtils.isEmpty((CharSequence)pointSrcMem) && StringUtils.isNotEmpty((CharSequence)bcmDim) && StringUtils.isNotEmpty((CharSequence)bcmDimName)) {
                    invalidBcmDimName.add(bcmDimName);
                }
                if (StringUtils.isEmpty((CharSequence)bcmDim) && StringUtils.isEmpty((CharSequence)pointTarMem) && StringUtils.isNotEmpty((CharSequence)ebDim) && StringUtils.isNotEmpty((CharSequence)ebDimName)) {
                    invalidEbDimName.add(ebDimName);
                }
                if (StringUtils.isNotEmpty((CharSequence)bcmDim) && StringUtils.isNotEmpty((CharSequence)ebDim) && (StringUtils.isNotEmpty((CharSequence)pointSrcMem) && StringUtils.isEmpty((CharSequence)pointTarMem) || StringUtils.isNotEmpty((CharSequence)pointTarMem) && StringUtils.isEmpty((CharSequence)pointSrcMem))) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u76ee\u6807\u7ef4\u5ea6-%1\u7ef4\u5ea6\u7684\u76ee\u6807\u6210\u5458/\u6e90\u6210\u5458\u3002", (String)"BCMDataIntegrationPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{ebDimName}));
                }
                if (View.NoViewDimNums.contains(ebDim) || !IDUtils.isNotEmptyLong((Long)mappingId).booleanValue()) continue;
                this.dimToDimMappingIdMap.computeIfAbsent(ebDim, e -> new HashSet(16)).add(mappingId);
            }
            if (invalidBcmDimName.size() > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u6e90\u7ef4\u5ea6\u201c%1\u201d\u7684\u6e90\u6210\u5458\u3002", (String)"BCMDataIntegrationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])invalidBcmDimName.toArray(), (String)",")}));
            }
            if (invalidEbDimName.size() > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u76ee\u6807\u7ef4\u5ea6\u201c%1\u201d\u7684\u6307\u5b9a\u76ee\u6807\u6210\u5458\u3002", (String)"BCMDataIntegrationPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])invalidEbDimName.toArray(), (String)",")}));
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String name = event.getProperty().getName();
        if ("srcmodel".equals(name)) {
            this.sourceModelBeforeF7(event);
        } else if ("srcorgview".equals(name)) {
            this.sourceOrgViewBeforeF7(event);
        }
    }

    @Override
    protected QFilter getDimMappingFilter() {
        String ebDimNum = (String)this.getModel().getValue("bcmdimtarnumber");
        if (StringUtils.isEmpty((CharSequence)ebDimNum)) {
            return null;
        }
        String bcmDimNum = (String)this.getModel().getValue("bcmdimsourcenumber");
        if (StringUtils.isEmpty((CharSequence)bcmDimNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ef4\u5ea6\u3002", (String)"BCMDataIntegrationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        Long sourceModelId = this.getSourceModelId();
        if (IDUtils.isEmptyLong((Long)sourceModelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u4f53\u7cfb\u3002", (String)"BCMDataIntegrationPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        Long sourceOrgViewId = null;
        if ("Entity".equals(bcmDimNum) && IDUtils.isEmptyLong((Long)(sourceOrgViewId = this.getSourceOrgViewId())).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"BCMDataIntegrationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        SimpleObject sourceDim = this.getSourceDim(sourceModelId, bcmDimNum);
        if (sourceDim == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6id\u672a\u83b7\u53d6\u5230\uff0c\u5f53\u524d\u6e90\u7ef4\u5ea6\u4e0d\u5b58\u5728\u53ef\u80fd\u88ab\u5220\u9664\u3002", (String)"BCMDataIntegrationPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        Long modelId = this.getModelId();
        long datasetId = this.getDatasetId();
        Long sourceDimId = sourceDim.getId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long dimensionId = modelCacheHelper.getDimension(ebDimNum).getId();
        List viewIds = modelCacheHelper.getViewGroupViewsByDataSetAndDimNumber(Long.valueOf(datasetId), ebDimNum);
        return EASDataIntegrationUtil.getBcmDimMemberMapFilter((DataIntegrationType)DataIntegrationType.INPUT, (Long)sourceModelId, (Long)sourceDimId, (Long)sourceOrgViewId, (Long)modelId, (Long)datasetId, (Long)dimensionId, (List)viewIds);
    }

    private SimpleObject getSourceDim(Long sourceModelId, String bcmDimNum) {
        QFilter qFilter;
        DynamicObject object;
        if (YEAR_PERIOD.equals(bcmDimNum)) {
            bcmDimNum = "Year";
        }
        if ((object = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number,name", (QFilter[])(qFilter = new QFilter("model", "=", (Object)sourceModelId).and("number", "=", (Object)bcmDimNum)).toArray())) != null) {
            return new SimpleObject(Long.valueOf(object.getLong("id")), object.getString("name"), object.getString("number"));
        }
        return null;
    }

    private void sourceOrgRangeBeforeF7() {
        DynamicObject sourceModel = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getSourceModelId(), (String)"bcm_model", (String)"id,number,shownumber");
        if (sourceModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u4f53\u7cfb\u3002", (String)"BCMDataIntegrationPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject srcOrgView = (DynamicObject)this.getModel().getValue("srcorgview");
        if (srcOrgView == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"BCMDataIntegrationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long sourceModelId = sourceModel.getLong("id");
        SimpleObject sourceDim = this.getSourceDim(sourceModelId, "Entity");
        if (sourceDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5f53\u524d\u4f53\u7cfb\u7684\u7ec4\u7ec7\u7ef4\u5ea6\u3002", (String)"BCMDataIntegrationPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String sourceModelNum = sourceModel.getString("number");
        Long dimId = sourceDim.getId();
        String dimNum = sourceDim.getNumber();
        String dimName = sourceDim.getName();
        String viewNumber = srcOrgView.getString("number");
        MemberF7Parameter f7Param = new MemberF7Parameter();
        f7Param.setEbModelId(this.getModelId());
        f7Param.setModelId(sourceModelId);
        f7Param.setModelNumber(sourceModelNum);
        f7Param.setDimensionId(dimId);
        f7Param.setDimensionNumber(dimNum);
        f7Param.setDimensionName(dimName);
        f7Param.setSchemaNumber(viewNumber);
        f7Param.setReturnClassName(ListSelectedRowCollection.class.getName());
        DynamicObjectCollection selectedMems = (DynamicObjectCollection)this.getModel().getValue("srcrangememrecord");
        if (CollectionUtils.isNotEmpty((Collection)selectedMems)) {
            ArrayList<String[]> members = new ArrayList<String[]>(10);
            for (DynamicObject selectedMem : selectedMems) {
                DynamicObject memDynamicObject = selectedMem.getDynamicObject("fbasedataid");
                members.add(new String[]{memDynamicObject.getString("id"), memDynamicObject.getString("number"), memDynamicObject.getString("name")});
            }
            f7Param.setSelectedVirtualMember(members);
        }
        NewF7Utils.openVirtualF74JC((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "sourceRangeOrgMemSelect"));
    }

    private void sourceOrgViewBeforeF7(BeforeF7SelectEvent event) {
        DynamicObject sourceModel = (DynamicObject)this.getModel().getValue("srcmodel");
        if (sourceModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u4f53\u7cfb\u3002", (String)"BCMDataIntegrationPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> qFilters = ((BasedataEdit)this.getControl("srcorgview")).getQFilters();
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(16);
        }
        qFilters.add(new QFilter("model", "=", (Object)sourceModel.getLong("id")));
        showParameter.setCustomParam("custom", (Object)1);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
    }

    private void sourceModelBeforeF7(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.setCustomParam("noNeedDefaultQFilter", (Object)true);
        Map permModelInfo = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"BIModelService", (String)"getModels", (Object[])new Object[0]);
        HashSet modelNumbers = new HashSet(16);
        if (permModelInfo != null) {
            modelNumbers.addAll(permModelInfo.keySet());
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", modelNumbers));
    }

    private SimpleObject getDefaultPointSrcMem(String bcmDimNumber, Long bcmDimId, Map<Long, SimpleObject> bcmDimNoneMemMap, Map<Long, String> bcmDimensionMemberModelMap) {
        String defaultPointSrcMemNum;
        if (bcmDimNoneMemMap.containsKey(bcmDimId)) {
            return bcmDimNoneMemMap.get(bcmDimId);
        }
        switch (bcmDimNumber) {
            case "AuditTrail": {
                defaultPointSrcMemNum = "RptDS";
                break;
            }
            case "Currency": {
                defaultPointSrcMemNum = "CNY";
                break;
            }
            case "ChangeType": {
                defaultPointSrcMemNum = "CurrentPeriod";
                break;
            }
            case "Scenario": {
                defaultPointSrcMemNum = "MRpt";
                break;
            }
            case "Process": {
                defaultPointSrcMemNum = "EIRpt";
                break;
            }
            case "MultiGAAP": {
                defaultPointSrcMemNum = "IFRS";
                break;
            }
            case "DataSort": {
                defaultPointSrcMemNum = "Actual";
                break;
            }
            case "InternalCompany": {
                defaultPointSrcMemNum = "ICNone";
                break;
            }
            default: {
                defaultPointSrcMemNum = null;
            }
        }
        if (defaultPointSrcMemNum == null) {
            return null;
        }
        String memberModel = bcmDimensionMemberModelMap.get(bcmDimId);
        if (memberModel == null) {
            return null;
        }
        QFilter qFilter = new QFilter("dimension", "=", (Object)bcmDimId).and("number", "=", (Object)defaultPointSrcMemNum);
        DynamicObject object = QueryServiceHelper.queryOne((String)memberModel, (String)"id,number,name", (QFilter[])qFilter.toArray());
        if (object == null) {
            return null;
        }
        return new SimpleObject(Long.valueOf(object.getLong("id")), object.getString("name"), object.getString("number"));
    }

    private boolean isEnableSetPointSrcMem(String bcmDimNumber) {
        if (StringUtils.isEmpty((CharSequence)bcmDimNumber)) {
            return false;
        }
        if (YEAR_PERIOD.equals(bcmDimNumber)) {
            return false;
        }
        return DimTypesEnum.INTERCOMPANY.getNumber().equals(bcmDimNumber) || DimTypesEnum.AUDITTRIAL.getNumber().equals(bcmDimNumber) || DimTypesEnum.CURRENCY.getNumber().equals(bcmDimNumber) || DimTypesEnum.CHANGETYPE.getNumber().equals(bcmDimNumber) || DimTypesEnum.SCENARIO.getNumber().equals(bcmDimNumber) || DimTypesEnum.PROCESS.getNumber().equals(bcmDimNumber) || DimTypesEnum.MULTIGAAP.getNumber().equals(bcmDimNumber) || DimTypesEnum.DATASORT.getNumber().equals(bcmDimNumber) || DimTypesEnum.MYCOMPANY.getNumber().equals(bcmDimNumber) || !DimTypesEnum.include((String)bcmDimNumber);
    }

    @Override
    protected Set<String> getDimMapNoSetMembersDimNums() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            HashSet<String> numbers = new HashSet<String>(16);
            for (DynamicObject object : entryEntity) {
                String dimMember = (String)object.get("bcmpointtarmem");
                String dimTarNumber = object.getString("bcmdimtarnumber");
                if (!StringUtils.isNotEmpty((CharSequence)dimTarNumber) || !StringUtils.isEmpty((CharSequence)dimMember)) continue;
                numbers.add(dimTarNumber);
            }
            return numbers;
        }
        return new HashSet<String>(0);
    }

    private boolean isEnableSetSourceField(Dimension dimension) {
        if (dimension == null) {
            return false;
        }
        String dimensionNumber = dimension.getNumber();
        if (!dimension.isPreset() || SysDimensionEnum.Project.getNumber().equals(dimensionNumber)) {
            return true;
        }
        return SysDimensionEnum.Metric.getNumber().equals(dimensionNumber) || SysDimensionEnum.DataType.getNumber().equals(dimensionNumber) || SysDimensionEnum.Version.getNumber().equals(dimensionNumber);
    }

    private boolean isEnableSetDimMemMapping(String dimNum, String bcmDimNum) {
        return StringUtils.isNotEmpty((CharSequence)dimNum) && StringUtils.isNotEmpty((CharSequence)bcmDimNum);
    }

    private Long getSourceModelId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("srcmodel");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    private Long getSourceOrgViewId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("srcorgview");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    @Override
    String getTarDimNumberFieldKey() {
        return "bcmdimtarnumber";
    }

    @Override
    String getDimMappingFieldKey() {
        return MEM_MAPPING;
    }

    @Override
    String getPointTarMemFieldKey() {
        return "bcmpointtarmem";
    }

    @Override
    String getPointTarMemShowFieldKey() {
        return POINT_TAR_MEM;
    }

    @Override
    String getDimMappingEntryKey() {
        return "bcmdimmapentity";
    }

    @Override
    Long getDimMappingEntryView(String dimnumber) {
        Map map;
        String info;
        DynamicObject dynamicObject;
        DynamicObject bcmdimmemmap;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return 0L;
        }
        Optional<DynamicObject> bcmdimtarnumber = entryEntity.stream().filter(x -> dimnumber.equals(x.getString("bcmdimtarnumber"))).findFirst();
        if (bcmdimtarnumber.isPresent() && (bcmdimmemmap = (dynamicObject = bcmdimtarnumber.get()).getDynamicObject(MEM_MAPPING)) != null && StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("targetsysinfo"))) && (map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) {
            return IDUtils.toLong(map.get("view"));
        }
        return 0L;
    }

    @Override
    Long getpointTarEntryView(String dimnumber) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bcmdimmapentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return 0L;
        }
        Optional<DynamicObject> bcmdimtarnumber = entryEntity.stream().filter(x -> dimnumber.equals(x.getString("bcmdimtarnumber"))).findFirst();
        if (bcmdimtarnumber.isPresent()) {
            DynamicObject dynamicObject = bcmdimtarnumber.get();
            return dynamicObject.getLong("bcmpointtarmemview.id");
        }
        return 0L;
    }
}

