/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.lang.Lang;
import kd.epm.eb.business.dataintegration.entity.IntegrationSchemeBaseInfo;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class DataIntegrationBaseInfoFormPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadPageData();
    }

    private void loadPageData() {
        String baseInfoJson = (String)this.getCustomFormParam("baseInfo");
        if (StringUtils.isNotEmpty((String)baseInfoJson)) {
            IntegrationSchemeBaseInfo baseInfo = (IntegrationSchemeBaseInfo)ObjectSerialUtil.deSerializedBytes((String)baseInfoJson);
            DataIntegrationType type = baseInfo.getIntegrationType();
            this.getModel().setValue("type", (Object)type.getVal());
            this.getModel().setValue("number", (Object)baseInfo.getNumber());
            OrmLocaleValue ormLocaleValue = baseInfo.getName();
            if (ormLocaleValue.getLocaleValue() == null && ormLocaleValue.getItem("GLang") != null) {
                ormLocaleValue.setItem(Lang.get().toString(), ormLocaleValue.getItem("GLang"));
            }
            this.getModel().setValue("name", (Object)ormLocaleValue);
            this.getModel().setValue("status", (Object)baseInfo.getStatus());
            if (type == DataIntegrationType.INPUT) {
                this.getModel().setValue("schemetype", (Object)baseInfo.getSchemeType().getVal());
            }
        } else {
            this.getModel().setValue("type", this.getCustomFormParam("type"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
        this.getView().setEnable(Boolean.valueOf(!"scheme".equals(this.getSource())), new String[]{"schemetype"});
        Object type = this.getModel().getValue("type");
        if (DataIntegrationType.OUTPUT.getVal().equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"schemetype"});
        }
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.beforeDoOk();
        }
    }

    private void beforeDoOk() {
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.doOk();
        }
    }

    private void doOk() {
        IntegrationSchemeBaseInfo baseInfo = new IntegrationSchemeBaseInfo();
        baseInfo.setIntegrationType(DataIntegrationType.getTypeByVal((String)((String)this.getModel().getValue("type"))));
        baseInfo.setNumber((String)this.getModel().getValue("number"));
        baseInfo.setName((OrmLocaleValue)this.getModel().getValue("name"));
        baseInfo.setStatus(((Boolean)this.getModel().getValue("status")).booleanValue());
        baseInfo.setSchemeType(IntegrationSchemeType.getTypeByVal((String)((String)this.getModel().getValue("schemetype"))));
        this.getView().returnDataToParent((Object)baseInfo);
        this.getView().close();
    }

    public String getSource() {
        return (String)this.getCustomFormParam("source");
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("model"));
    }
}

