/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataintegration.plugin.AbstractDataIntegrationPlugin;

public abstract class DataIntegrationBasePlugin
extends AbstractDataIntegrationPlugin {
    protected static final String METRIC_MAP_FLEX = "flexmetricmap";
    protected static final String CUSTOM_DIM_MAPPING_FLEX = "flexpanelap2";
    protected static final String GL_DIM_MAPPING_FLEX = "flexpanelap21";
    protected static final String BCM_DIM_MAPPING_FLEX = "flexpanelap22";
    protected static final String SOURCE_OBJ = "sourceobj";
    protected static final String SOURCE_SYS = "sourcesys";
    protected static final String SOURCE_METRIC_TYPE = "srcmetrictype";
    protected static final String SOURCE_SINGLE_METRIC = "srcsinglemetric";
    protected static final String SOURCE_GET_DATA_TYPE = "getdatatype";
    protected static final String SOURCE_CAL_MODEL = "calculatemodel";
    protected static final String SOURCE_CAL_VIEW = "calculateview";
    protected static final String SOURCE_CAL_ORG_MEM = "calculateorgmem";
    protected static final String SOURCE_ACCOUNT_TABLE = "accounttable";
    protected static final String SOURCE_ACCOUNT_BOOK_TYPE = "accountbooktype";
    protected static final String SOURCE_CAL_PERIOD_TYPE = "calculateperiodtype";
    protected static final String SOURCE_CURRENCY = "currency";
    protected static final String SOURCE_MODEL = "srcmodel";
    protected static final String SOURCE_ORG_VIEW = "srcorgview";
    protected static final String SOURCE_RANGE_MEMBERS = "srcrangemembers";
    protected static final String SOURCE_RANGE_MEMBERS_RECORD = "srcrangememrecord";
    protected static final String TAR_SYSTEM = "targetsys";
    protected static final String TAR_INTER_OBJECT = "targetobj";
    protected static final String CUSTOM_MAP_ENTRY = "dimmapentity";
    protected static final String GL_MAP_ENTRY = "gldimmapentity";
    protected static final String BCM_MAP_ENTRY = "bcmdimmapentity";
    protected static final String METRIC_MAP_ENTRY = "metricmapentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.getPointTarMemShowFieldKey()});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CUSTOM_DIM_MAPPING_FLEX, GL_DIM_MAPPING_FLEX, BCM_DIM_MAPPING_FLEX, METRIC_MAP_FLEX});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SOURCE_OBJ, SOURCE_SYS, SOURCE_METRIC_TYPE, SOURCE_SINGLE_METRIC, SOURCE_GET_DATA_TYPE, SOURCE_CAL_MODEL, SOURCE_CAL_VIEW, SOURCE_CAL_ORG_MEM, SOURCE_ACCOUNT_TABLE, SOURCE_ACCOUNT_BOOK_TYPE, SOURCE_CAL_PERIOD_TYPE, SOURCE_MODEL, SOURCE_ORG_VIEW, SOURCE_RANGE_MEMBERS, TAR_INTER_OBJECT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TAR_SYSTEM});
        this.interRangeEntryBindData();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String backKey = event.getActionId();
        Object returnData = event.getReturnData();
        if ("pointDimMemberSelect".equals(backKey)) {
            this.pointDimMemberSelectCallBack(returnData);
        }
    }

    protected void pointDimMemberSelectCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            this.getModel().beginInit();
            ListSelectedRow selectedRow = ((ListSelectedRowCollection)returnData).get(0);
            String number = selectedRow.getNumber();
            String name = selectedRow.getName();
            this.getModel().setValue(this.getPointTarMemShowFieldKey(), (Object)name);
            this.getModel().setValue(this.getPointTarMemFieldKey(), (Object)number);
            this.getModel().setValue(this.getDimMappingFieldKey(), null);
            this.getModel().endInit();
            this.getView().updateView(this.getDimMappingEntryKey());
            this.updateIntegrationRangeEntry(false);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (this.getPointTarMemShowFieldKey().equals(sourceKey)) {
            this.pointTarDimMemberSelect();
        }
    }

    protected void pointTarDimMemberSelect() {
        Member mem;
        String dimNumber = (String)this.getModel().getValue(this.getTarDimNumberFieldKey());
        if (StringUtils.isEmpty((String)dimNumber)) {
            return;
        }
        long datasetId = this.getDatasetId();
        Long bizModelId = this.getBizModelId();
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long viewId = this.getpointTarEntryView(dimNumber);
        if (viewId == null) {
            viewId = (Long)modelCacheHelper.getViewsByDataSetIncludeBase(Long.valueOf(datasetId)).get(dimNumber);
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setCanSelectBudgetPeriodRoot(false);
        f7Param.setCanSelectRoot(false);
        f7Param.setDatasetId(Long.valueOf(datasetId));
        f7Param.setBusModelId(bizModelId);
        f7Param.setViewId(viewId);
        f7Param.setOnlySelLeaf(true);
        f7Param.setEnableView(true);
        String selectMemNum = (String)this.getModel().getValue(this.getPointTarMemFieldKey());
        if (StringUtils.isNotEmpty((String)selectMemNum) && (mem = modelCacheHelper.getMember(dimNumber, viewId, selectMemNum)) != null) {
            f7Param.setSelectId(mem.getId());
        }
        EASDataIntegrationUtil.setF7PermParam((MemberF7Parameter)f7Param, (Long)modelId, (boolean)this.isInput());
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)NewF7Utils.closeCallBack((IFormPlugin)this, (String)"pointDimMemberSelect"));
    }

    protected boolean isEnableSetPointTarDimMem(Dimension dimension) {
        if (dimension == null) {
            return false;
        }
        String dimensionNumber = dimension.getNumber();
        return !SysDimensionEnum.Entity.getNumber().equals(dimensionNumber) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNumber) && !SysDimensionEnum.Account.getNumber().equals(dimensionNumber);
    }

    protected Member getDefaultPointTarDimMem(Dimension dimension, Map<String, Long> viewMap) {
        String dimensionNumber = dimension.getNumber();
        Long viewId = viewMap.get(dimensionNumber);
        Member member = null;
        if ("DataType".equals(dimensionNumber)) {
            member = dimension.getMember(viewId, "Actual");
        } else if ("AuditTrail".equals(dimensionNumber)) {
            member = dimension.getMember(viewId, "EntityInput");
        } else if ("Version".equals(dimensionNumber)) {
            member = dimension.getMember(viewId, "ACTUAL");
        } else if ("Currency".equals(dimensionNumber)) {
            member = dimension.getMember(viewId, "CNY");
        } else if ("ChangeType".equals(dimensionNumber)) {
            member = dimension.getMember(viewId, "DataIntegration");
        } else if ("Metric".equals(dimensionNumber)) {
            member = dimension.getMember(viewId, "Money");
        } else if (!SysDimensionEnum.include((String)dimensionNumber, (Boolean)true) || SysDimensionEnum.InternalCompany.getNumber().equals(dimensionNumber)) {
            member = dimension.getMember(viewId, dimension.getNoneNumber());
        }
        return member;
    }

    @Override
    List<Dimension> getIntegrationRangeDimensions() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Set<String> dimMapNoSetMembersDimNums = this.getDimMapNoSetMembersDimNums();
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(10);
        for (String number : dimMapNoSetMembersDimNums) {
            dimensions.add(modelCacheHelper.getDimension(number));
        }
        return dimensions;
    }

    @Override
    DataIntegrationType getDataIntegrationType() {
        return DataIntegrationType.INPUT;
    }

    abstract String getTarDimNumberFieldKey();

    abstract String getPointTarMemFieldKey();

    abstract String getPointTarMemShowFieldKey();

    abstract Set<String> getDimMapNoSetMembersDimNums();
}

