/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataintegration.entity.EasDimension;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationEasListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(DataIntegrationEasListPlugin.class);
    private static final String EAS_MODEL_TREE = "easmodeltree";
    private static final String EAS_MODEL_TREENODE = "easmodeltreenode";
    private static final String BILLLIST_KEY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(EAS_MODEL_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(EAS_MODEL_TREE, EAS_MODEL_TREENODE));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"DataIntegrationEasListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String dsNumber = (String)fsp.getCustomParams().get("dsNumber");
        this.getPageCache().put("dsNumber", dsNumber);
        this.loadTree();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(BILLLIST_KEY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u3002", (String)"DataIntegrationEasListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                int rowKey = selectRows[0];
                Map dimMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("dimMap"));
                List dimList = (List)dimMap.get(rowKey);
                String easModelNumber = this.getLeftTreeNumber();
                HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
                returnMap.put("easModel", easModelNumber);
                returnMap.put("dimList", SerializationUtils.toJsonString((Object)dimList));
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnMap));
                this.getView().close();
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(EAS_MODEL_TREE, EAS_MODEL_TREENODE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(EAS_MODEL_TREE, EAS_MODEL_TREENODE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
        }
    }

    private String getLeftTreeNumber() {
        TreeView leftTree = (TreeView)this.getControl(EAS_MODEL_TREE);
        String focusNodeId = leftTree.getTreeState().getFocusNodeId();
        Map nodeCacheMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(EAS_MODEL_TREE));
        return (String)nodeCacheMap.get(focusNodeId);
    }

    private void loadTree() {
        String dsNumber = this.getPageCache().get("dsNumber");
        String service = "facade://com.kingdee.eas.ma.mbg.app.MbgDataSynFacade:getBgScheme";
        HashMap methodParam = new HashMap(16);
        Object proxyUser = null;
        Map result = null;
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscMetaSchemaService", (String)"callService", (Object[])new Object[]{dsNumber, service, methodParam, proxyUser});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"EAS\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4EAS\u63a5\u53e3\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"DataIntegrationEasListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List modelList = (List)result.get("result");
        if (CollectionUtils.isEmpty((Collection)modelList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230EAS\u4f53\u7cfb\u6570\u636e\u3002", (String)"DataIntegrationEasListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.setText(ResManager.loadKDString((String)"EAS\u6a21\u578b\u5217\u8868", (String)"DataIntegrationEasListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(modelList.size());
        HashMap nodeCacheMap = Maps.newHashMapWithExpectedSize((int)modelList.size());
        for (int i = 0; i < modelList.size(); ++i) {
            Map model = (Map)modelList.get(i);
            String number = (String)model.get("number");
            String name = (String)model.get("name");
            String nodeName = name + "(" + number + ")";
            String parentId = root.getId();
            String id = i + "";
            TreeNode node = new TreeNode(parentId, id, nodeName);
            nodeCacheMap.put(id, number);
            children.add(node);
        }
        root.setChildren(children);
        EpmTreeUtils.spreadAllNode((TreeNode)root);
        TreeView tree = (TreeView)this.getControl(EAS_MODEL_TREE);
        tree.deleteAllNodes();
        tree.addNode(root);
        tree.focusNode(root);
        this.getPageCache().put(EAS_MODEL_TREE, SerializationUtils.serializeToBase64((Object)nodeCacheMap));
        this.setEasTreeCache(root);
    }

    private void setEasTreeCache(TreeNode root) {
        this.getPageCache().put(EAS_MODEL_TREENODE, SerializationUtils.toJsonString((Object)root));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String modelNumber = this.getLeftTreeNumber();
        if (StringUtils.isBlank((CharSequence)modelNumber)) {
            return;
        }
        String dsNumber = this.getPageCache().get("dsNumber");
        String service = "facade://com.kingdee.eas.ma.mbg.app.MbgDataSynFacade:getBgSchemeDimension";
        HashMap<String, String> methodParam = new HashMap<String, String>(16);
        methodParam.put("bgSchemeNumber", modelNumber);
        Object proxyUser = null;
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscMetaSchemaService", (String)"callService", (Object[])new Object[]{dsNumber, service, methodParam, proxyUser});
        List dimList = (List)result.get("result");
        if (CollectionUtils.isEmpty((Collection)dimList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230EAS\u7ef4\u5ea6\u6570\u636e\u3002", (String)"DataIntegrationEasListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(BILLLIST_KEY);
        dataModel.batchCreateNewEntryRow(BILLLIST_KEY, dimList.size());
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)dimList.size());
        for (int i = 0; i < dimList.size(); ++i) {
            StringBuilder dimText = new StringBuilder();
            List groupList = (List)dimList.get(i);
            ArrayList<EasDimension> easDimensions = new ArrayList<EasDimension>(groupList.size());
            for (int j = 0; j < groupList.size(); ++j) {
                Map dim = (Map)groupList.get(j);
                String srcnumber = (String)dim.get("srcnumber");
                String srcname = (String)dim.get("srcname");
                String dimnumber = (String)dim.get("dimnumber");
                String dimname = (String)dim.get("dimname");
                dimText.append(dimname).append("-").append(srcnumber);
                if (j > 0 && j % 5 == 0) {
                    dimText.append("\r\n");
                } else {
                    dimText.append(";");
                }
                easDimensions.add(new EasDimension(srcnumber, srcname, dimnumber, dimname));
            }
            dataModel.setValue("dimgroup", (Object)dimText.toString(), i);
            dimMap.put(i, easDimensions);
        }
        this.getPageCache().put("dimMap", SerializationUtils.serializeToBase64((Object)dimMap));
        this.getView().updateView(BILLLIST_KEY);
    }
}

