/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.epm.eb.business.dataintegration.service.DataIntegrationExeSchemeService;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.ExecuteSchemeNodeType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.lang.StringUtils;

public class DataIntegrationExecuteSchemePlugin
extends AbstractBasePlugin {
    public void afterCreateNewData(EventObject e) {
        Object model = this.getCustomFormParam("model");
        Object bizModel = this.getCustomFormParam("bizmodel");
        Object parent = this.getCustomFormParam("parent");
        Object type = this.getCustomFormParam("type");
        Object parentName = this.getCustomFormParam("parentName");
        this.getModel().setValue("model", (Object)IDUtils.toLong((Object)model));
        this.getModel().setValue("bizModel", (Object)IDUtils.toLong((Object)bizModel));
        this.getModel().setValue("parent", (Object)IDUtils.toLong((Object)parent));
        this.getModel().setValue("type", type);
        this.getModel().setValue("nodetype", (Object)ExecuteSchemeNodeType.OTHER.getVal());
        this.getModel().setValue("parentshow", parentName);
    }

    public void afterLoadData(EventObject e) {
        this.getModel().setValue("parentshow", this.getCustomFormParam("parentName"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            this.beforeDoSave(args);
        }
    }

    private void beforeDoSave(BeforeDoOperationEventArgs args) {
        Long id = (Long)this.getModel().getValue("id");
        String number = (String)this.getModel().getValue("number");
        String checkNumber = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotBlank((String)checkNumber)) {
            this.getView().showTipNotification(checkNumber);
            args.setCancel(true);
            return;
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        Long modelId = this.getModelId();
        DataIntegrationType type = this.getDataIntegrationType();
        boolean existNumber = DataIntegrationExeSchemeService.getInstance().existExecuteScheme(modelId, type, number, false, id);
        if (existNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u6b64\u7f16\u7801\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DataIntegrationExecuteSchemePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean existName = DataIntegrationExeSchemeService.getInstance().existExecuteScheme(modelId, type, name.getLocaleValue(), true, id);
        if (existName) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u6b64\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DataIntegrationExecuteSchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private DataIntegrationType getDataIntegrationType() {
        return DataIntegrationType.getTypeByVal((String)((String)this.getCustomFormParam("type")));
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("model"));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

