/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.dataintegration.GLField;
import kd.epm.eb.business.dataintegration.entity.GlBizFieldType;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class DataIntegrationFieldSelectPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadPageData();
    }

    private void loadPageData() {
        ArrayList<GLField> objects = new ArrayList<GLField>(10);
        List<GlBizFieldType> needShowFieldType = this.getNeedShowFieldType();
        Set<String> selectedSourceFiled = this.getSelectedSourceFiled();
        for (GlBizFieldType fieldType : needShowFieldType) {
            if (fieldType == GlBizFieldType.DIMENSION) {
                objects.addAll(this.getCalDimensions(selectedSourceFiled));
                continue;
            }
            if (selectedSourceFiled.contains(fieldType.getNumber())) continue;
            objects.add(new GLField(Long.valueOf(0L), GlBizFieldType.getEntityTextByType((GlBizFieldType)fieldType), fieldType.getNumber(), GlBizFieldType.ORG));
        }
        this.getModel().deleteEntryData("entryentity");
        if (objects.size() > 0) {
            this.getModel().beginInit();
            int[] index = this.getModel().batchCreateNewEntryRow("entryentity", objects.size());
            int i = 0;
            for (GLField object : objects) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", index[i++]);
                rowEntity.set("relid", (Object)object.getId());
                rowEntity.set("number", (Object)object.getNumber());
                rowEntity.set("name", (Object)object.getName());
                rowEntity.set("fieldtype", (Object)object.getFieldType().getNumber());
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private List<GLField> getCalDimensions(Set<String> selectedSourceFiled) {
        List calDimensions = DataIntegrationQueryService.getInstance().getCalDimensions();
        if (CollectionUtils.isNotEmpty((Collection)calDimensions)) {
            ArrayList<GLField> fields = new ArrayList<GLField>(calDimensions.size());
            for (SimpleObject calDimension : calDimensions) {
                String number = calDimension.getNumber();
                if (selectedSourceFiled.contains(number)) continue;
                Long id = calDimension.getId();
                String name = calDimension.getName();
                fields.add(new GLField(id, name, number, GlBizFieldType.DIMENSION));
            }
            return fields;
        }
        return new ArrayList<GLField>(0);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
        long id = rowEntity.getLong("relid");
        String number = rowEntity.getString("number");
        String name = rowEntity.getString("name");
        GlBizFieldType fieldType = GlBizFieldType.getTypeByNumber((String)rowEntity.getString("fieldtype"));
        GLField glField = new GLField(Long.valueOf(id), name, number, fieldType);
        this.getView().returnDataToParent((Object)glField);
        this.getView().close();
    }

    private List<GlBizFieldType> getNeedShowFieldType() {
        String formCustomParam = (String)this.getFormCustomParam("needShowFieldType");
        if (StringUtils.isNotEmpty((String)formCustomParam)) {
            return (List)SerializationUtils.deSerializeFromBase64((String)formCustomParam);
        }
        return new ArrayList<GlBizFieldType>(0);
    }

    private Set<String> getSelectedSourceFiled() {
        String formCustomParam = (String)this.getFormCustomParam("selectedSourceFiled");
        if (StringUtils.isNotEmpty((String)formCustomParam)) {
            return (Set)SerializationUtils.deSerializeFromBase64((String)formCustomParam);
        }
        return new HashSet<String>(0);
    }
}

