/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.dataintegration.DataIntegrationStart;
import kd.epm.eb.business.dataintegration.entity.BcmDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMemberPojo;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQCondition;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.pageinteraction.model.Area;
import kd.epm.eb.common.pageinteraction.model.Element;
import kd.epm.eb.common.pageinteraction.model.Page;
import kd.epm.eb.common.pageinteraction.model.TextEditElement;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class DataIntegrationFilterEditPlugin
extends AbstractFormPlugin
implements DynamicPage,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(DataIntegrationFilterEditPlugin.class);
    private static final String SAVEQUERY_CLOSE = "saveQuery_close";
    private static final String SELECT_DIMENSION_MEMBER_CALLBACK = "SELECT_DIMENSION_MEMBER_CALLBACK";
    public static final String INPUT_ONLY_SOME_ORGANIZATION_MEMBERS_HAVE_PERMISSIONS = "INPUT_ONLY_SOME_ORGANIZATION_MEMBERS_HAVE_PERMISSIONS";
    private IModelCacheHelper modelCacheHelper = null;

    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickCtrlKey = this.getClickCtrlKey(evt);
        Map<String, String> dimLowNums = this.getOrCacheDimLowNums(null);
        if (dimLowNums.containsKey(clickCtrlKey)) {
            this.dealDimF7Click(clickCtrlKey);
        }
    }

    private void dealDimF7Click(String dimLowNumber) {
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        List dimensionList = iModelCacheHelper.getDimensionList();
        Dimension dimension = null;
        for (Dimension dim : dimensionList) {
            if (!dim.getNumber().toLowerCase(Locale.getDefault()).equals(dimLowNumber)) continue;
            dimension = dim;
            break;
        }
        if (dimension != null) {
            Dimension _dimension;
            List<Long> set;
            Long busModelId = this.getBizModelId();
            String currentDimNum = dimension.getNumber();
            Long viewId = null;
            RangeF7Param rangeF7Param = new RangeF7Param();
            rangeF7Param.setBizModelId(busModelId);
            rangeF7Param.setRangeType(F7RangeTypeEnum.MINI);
            rangeF7Param.setOpenProperty(false);
            rangeF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, StrUtils.format((String)"{}_{}", (Object[])new Object[]{SELECT_DIMENSION_MEMBER_CALLBACK, dimLowNumber})));
            List<DataIntegrationQuery> dataIntegrationQueryList = this.getOrCacheQueryList(null);
            DataIntegrationQuery dataIntegrationQuery = (DataIntegrationQuery)LambdaUtils.getTarget(dataIntegrationQueryList, item -> item != null && item.getDimNumber().equals(currentDimNum));
            if (dataIntegrationQuery != null) {
                List dataIntegrationMemberPojoList = dataIntegrationQuery.getDataIntegrationMemberPojoList();
                if (CollectionUtils.isNotEmpty((Collection)dataIntegrationMemberPojoList)) {
                    ArrayList<MemberCondition> memberConditionList = new ArrayList<MemberCondition>(16);
                    for (DataIntegrationMemberPojo dataIntegrationMemberPojo : dataIntegrationMemberPojoList) {
                        MemberCondition memberCondition = new MemberCondition();
                        memberCondition.setNumber(dataIntegrationMemberPojo.getMemberNumberString());
                        memberCondition.setRange(dataIntegrationMemberPojo.getScopeString());
                        memberConditionList.add(memberCondition);
                    }
                    rangeF7Param.setCon_list(memberConditionList);
                }
                viewId = dataIntegrationQuery.getViewId();
            }
            EASDataIntegrationUtil.setF7PermParam((RangeF7Param)rangeF7Param, (Long)iModelCacheHelper.getModelobj().getId(), (boolean)this.isInputType());
            Map<String, List<Long>> dimView = this.getDimView();
            boolean isCanChangeView = true;
            if (dimView != null && dimView.containsKey(currentDimNum) && CollectionUtils.isNotEmpty(set = dimView.get(currentDimNum))) {
                viewId = set.get(0);
                isCanChangeView = set.size() != 1;
            }
            rangeF7Param.setMustSelected(!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)(_dimension = iModelCacheHelper.getDimension(dimension.getId()))));
            rangeF7Param.setEnableView(isCanChangeView);
            CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimension.getNumber(), (Long)viewId, (IFormView)this.getView(), (RangeF7Param)rangeF7Param);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_sync".equals(itemKey)) {
            this.executeScheme();
        } else if ("bar_savequery".equals(itemKey)) {
            this.checkIsNotEmptyWhenIsDelete();
            this.showSaveQueryForm();
            this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "DataIntegrationFilterEditPlugin_14", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u91c7\u96c6\u4fdd\u5b58\u67e5\u8be2\u6761\u4ef6\u6210\u529f", "DataIntegrationFilterEditPlugin_15", "epm-eb-formplugin"));
        }
    }

    private void executeScheme() {
        Set<Long> schemeIds = this.getSchemeIdsFromPage();
        if (this.isEmpty(schemeIds)) {
            return;
        }
        this.checkIsNotEmptyWhenIsDelete();
        this.checkAccountAndPeriod(schemeIds);
        List<DataIntegrationQuery> dataIntegrationQueryList = this.getOrCacheQueryList(null);
        this.syncData(schemeIds, dataIntegrationQueryList);
    }

    private void checkIsNotEmptyWhenIsDelete() {
        if (this.delOldData() && this.isInputType()) {
            Set<String> dimNumberSet = this.getOrCacheDimLowNums(null).keySet();
            IDataModel dataModel = this.getModel();
            for (String dim : dimNumberSet) {
                Object value = dataModel.getValue(dim);
                if (!this.isEmpty(value)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u5220\u9664\u65e7\u6570\u636e\u65f6\uff0c\u6240\u6709\u7ef4\u5ea6\u5fc5\u9009\u3002", (String)"DataIntegrationDataService_14", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkAccountAndPeriod(Set<Long> schemeIds) {
        if (this.notEmpty(schemeIds) && this.isInputType()) {
            boolean periodEmpty;
            Set<String> dimNumberSet = this.getOrCacheDimLowNums(null).keySet();
            boolean accountEmpty = dimNumberSet.contains(SysDimensionEnum.Account.getNumber().toLowerCase()) && this.isEmpty(this.getValue(SysDimensionEnum.Account.getNumber().toLowerCase(), null));
            boolean bl = periodEmpty = dimNumberSet.contains(SysDimensionEnum.BudgetPeriod.getNumber().toLowerCase()) && this.isEmpty(this.getValue(SysDimensionEnum.BudgetPeriod.getNumber().toLowerCase(), null));
            if (accountEmpty || periodEmpty) {
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_integration", (String)"schemetype", (QFilter[])new QFilter("id", "in", schemeIds).toArray());
                boolean hasBcm = false;
                boolean hasGl = false;
                for (DynamicObject obj : dynamicObjects) {
                    String type = obj.getString("schemetype");
                    if (IntegrationSchemeType.BCM.getVal().equals(type)) {
                        hasBcm = true;
                        continue;
                    }
                    if (!IntegrationSchemeType.GL.getVal().equals(type)) continue;
                    hasGl = true;
                }
                HashSet<String> schemeName = new HashSet<String>(2);
                HashSet<String> dimName = new HashSet<String>(2);
                if (accountEmpty && hasGl) {
                    schemeName.add(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91-\u603b\u8d26", (String)"DataIntegrationDataService_22", (String)"epm-eb-business", (Object[])new Object[0]));
                    dimName.add(SysDimensionEnum.Account.getChineseName());
                }
                if (periodEmpty) {
                    if (hasBcm) {
                        schemeName.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91-\u5408\u5e76\u62a5\u8868", (String)"DataIntegrationDataService_21", (String)"epm-eb-business", (Object[])new Object[0]));
                        dimName.add(SysDimensionEnum.BudgetPeriod.getChineseName());
                    }
                    if (hasGl) {
                        schemeName.add(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91-\u603b\u8d26", (String)"DataIntegrationDataService_22", (String)"epm-eb-business", (Object[])new Object[0]));
                        dimName.add(SysDimensionEnum.BudgetPeriod.getChineseName());
                    }
                }
                if (this.notEmpty(schemeName) && this.notEmpty(dimName)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728%1\u7c7b\u578b\u7684\u91c7\u96c6\u65b9\u6848\uff0c\u540c\u6b65\u65f6%2\u7ef4\u5ea6\u7684\u8303\u56f4\u5fc5\u9009\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u70b9\u51fb\u5f00\u59cb\u540c\u6b65\u3002", (String)"DataIntegrationDataService_23", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", schemeName), String.join((CharSequence)"\u3001", dimName)}));
                }
            }
        }
    }

    private boolean delOldData() {
        return (Boolean)this.getValue("isdeletedata", null);
    }

    private void showSaveQueryForm() {
        Set<Long> schemeIdsFromPage = this.getSchemeIdsFromPage();
        List<DataIntegrationQuery> dataIntegrationQueryList = this.getOrCacheQueryList(null);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(this.getModelId());
        for (DataIntegrationQuery query : dataIntegrationQueryList) {
            Dimension dimension = modelCacheHelper.getDimension(query.getDimNumber());
            Long viewId = query.getViewId();
            if (query.getDataIntegrationMemberPojoList() == null) continue;
            for (DataIntegrationMemberPojo pojo : query.getDataIntegrationMemberPojoList()) {
                Member member;
                if (!IDUtils.isNull((Long)pojo.getMemberIdLong()) || (member = dimension.getMember(viewId, pojo.getMemberNumberString())) == null) continue;
                pojo.setMemberIdLong(member.getId());
            }
        }
        String queryJson = JSON.toJSONString(dataIntegrationQueryList);
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("eb_integration_query");
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCustomParam("integrationids", (Object)SerializationUtils.toJsonString(schemeIdsFromPage));
        fsp.setCustomParam("bizmodelid", (Object)this.getBizModelId());
        fsp.setCustomParam("queryJson", (Object)queryJson);
        fsp.setCustomParam("isdeletedata", (Object)this.delOldData());
        fsp.setCustomParam("model", (Object)this.getModelId());
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SAVEQUERY_CLOSE));
        this.getView().showForm(fsp);
    }

    private void syncData(Set<Long> targetSchemeIds, List<DataIntegrationQuery> dataIntegrationQueryList) {
        ExecuteCondition executeCondition = new ExecuteCondition();
        executeCondition.setDelOldData(this.delOldData());
        executeCondition.setFilters(dataIntegrationQueryList);
        executeCondition.setTargetSchemeIds(targetSchemeIds);
        executeCondition.setModelId(this.getModelId());
        executeCondition.setBizModelId(this.getBizModelId());
        executeCondition.setActionId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
        executeCondition.setOut(!this.isInputType());
        try {
            DataIntegrationStart dataIntegrationStart = DataIntegrationStart.getInstance((ExecuteCondition)executeCondition);
            dataIntegrationStart.run(true);
            this.getView().returnDataToParent((Object)dataIntegrationStart.getActionId().toString());
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6267\u884c", "DataIntegrationFilterEditPlugin_16", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u91c7\u96c6\u6267\u884c\u6210\u529f", "DataIntegrationFilterEditPlugin_17", "epm-eb-formplugin");
            this.writeLog(null, "execute", opName, opDesc, null);
        }
        catch (Throwable ex) {
            log.error("syncData-error", ex);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"DataIntegrationFilterEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ex.getMessage(), MessageTypes.Default);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6267\u884c", "DataIntegrationFilterEditPlugin_16", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u91c7\u96c6\u6267\u884c\u5931\u8d25", "DataIntegrationFilterEditPlugin_18", "epm-eb-formplugin");
            this.writeLog(null, "execute", opName, opDesc, null, false);
            return;
        }
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildFormPage();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateDelDataItemStatus();
    }

    private void updateDelDataItemStatus() {
        if (!this.isInputType()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdeletedata"});
        } else {
            boolean modelManage = MemberPermHelper.ifUserHasRootPermByModel((long)UserUtils.getUserId(), (String)String.valueOf(this.getModelId()));
            if (modelManage) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"isdeletedata"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"isdeletedata"});
            }
        }
    }

    private void buildFormPage() {
        Set<Long> schemeIdsFromPage = this.getSchemeIdsFromPage();
        if (this.isEmpty(schemeIdsFromPage)) {
            return;
        }
        boolean isInputType = this.isInputType();
        DataIntegrationType type = isInputType ? DataIntegrationType.INPUT : DataIntegrationType.OUTPUT;
        HashSet allRefDimNumbers = new HashSet(16);
        Counter bcmSchemeCounter = new Counter();
        DataIntegrationQueryService.getInstance().getDataIntegrationObjects(type, schemeIdsFromPage, true).forEach(dataIntegration -> {
            if (dataIntegration instanceof BcmDataIntegration) {
                bcmSchemeCounter.addOne();
            }
            dataIntegration.getIntegrationRanges().forEach(range -> {
                if (range.getGetValType() == DataIntegrationGetValType.CONDITION) {
                    allRefDimNumbers.add(range.getDimNumber());
                }
            });
        });
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        HashMap<String, String> dimNumberMap = new HashMap<String, String>(10);
        Page page = new Page();
        Area area = new Area("flexpanelap");
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("20px");
        mg.setBottom("0");
        mg.setRight("20px");
        mg.setLeft("20px");
        sl.setMargin(mg);
        List dimensionList = modelCache.getDimensionListByBusModel(this.getBizModelId());
        for (Dimension dimension : dimensionList) {
            String membermodel;
            String dimNumber = dimension.getNumber();
            String dimName = dimension.getName();
            if (!allRefDimNumbers.contains(dimNumber)) continue;
            dimNumberMap.put(dimNumber.toLowerCase(), dimNumber);
            if (dimension.isPreset()) {
                SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
                if (dimEnum == null) continue;
                membermodel = dimEnum.getMemberTreemodel();
            } else {
                membermodel = "epm_userdefinedmembertree";
            }
            TextEditElement dimItem = new TextEditElement(dimName, dimNumber.toLowerCase(), membermodel);
            if (bcmSchemeCounter.getSize() > 0) {
                dimItem.setMustInput(true);
            }
            dimItem.setLabelDirection("v");
            if (dimension.isPreset() && !isInputType) {
                dimItem.setMustInput(true);
            }
            dimItem.setStyle(sl);
            area.addElement((Element)dimItem);
        }
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.getOrCacheDimLowNums(dimNumberMap);
        this.fillDefQueryCondition(schemeIdsFromPage, dimNumberMap);
    }

    private void fillDefQueryCondition(Set<Long> integrationSchemeIds, Map<String, String> dimNumberMap) {
        List conditionIdsBySchemes = EASDataIntegrationUtil.getConditionIdsBySchemes(integrationSchemeIds);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        List dataIntegrationQueryMap = DataIntegrationService.getDataIntegrationQueryMap((Collection)conditionIdsBySchemes, (boolean)false, (boolean)true);
        if (this.isEmpty(dataIntegrationQueryMap)) {
            if (!this.isInputType()) {
                this.getModel().setValue("isdeletedata", (Object)false);
            }
            return;
        }
        DataIntegrationQCondition condition = (DataIntegrationQCondition)dataIntegrationQueryMap.get(0);
        this.getModel().setValue("isdeletedata", (Object)condition.isDelOldData());
        List dataIntegrationQueryList = condition.getQueryList();
        if (CommonUtils.integraitonFilterswitch((Long)modelCacheHelper.getModelobj().getId())) {
            dataIntegrationQueryList = EASDataIntegrationUtil.changeRangeByPerm((List)dataIntegrationQueryList, (IModelCacheHelper)modelCacheHelper, (!this.isInputType() ? 1 : 0) != 0, (Long)this.getBizModelId());
        }
        Iterator iterator = dataIntegrationQueryList.iterator();
        while (iterator.hasNext()) {
            DataIntegrationQuery dataIntegrationQuery = (DataIntegrationQuery)iterator.next();
            String dimLowNumber = dataIntegrationQuery.getDimNumber().toLowerCase();
            if (!dimNumberMap.containsKey(dimLowNumber)) {
                iterator.remove();
                continue;
            }
            Dimension dimension = modelCacheHelper.getDimension(dataIntegrationQuery.getDimNumber());
            if (dimension == null) {
                iterator.remove();
                continue;
            }
            this.getModel().setValue(dimLowNumber, (Object)DimensionServiceHelper.buildRangeF7ShowStr((Dimension)dimension, (Iterable)dataIntegrationQuery.getDataIntegrationMemberPojoList(), DataIntegrationMemberPojo::getMemberNumberString, DataIntegrationMemberPojo::getScopeString, (Long)dataIntegrationQuery.getViewId(), (IModelCacheHelper)modelCacheHelper));
        }
        this.getOrCacheQueryList(dataIntegrationQueryList);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (this.getPage(this.getView()) == null) {
            return;
        }
        Element c = this.getPage(this.getView()).findElementBySign(e.getKey());
        if (c != null) {
            TextEdit nus = (TextEdit)c.getControl(this.getView());
            nus.addClickListener((ClickListener)this);
            e.setControl((Control)nus);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    @Override
    public Long getModelId() {
        return (Long)this.getCustomFormParam("model");
    }

    public IModelCacheHelper getModelCacheHelper(@NotNull Long modelId) {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionIdString = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if (SAVEQUERY_CLOSE.equals(actionIdString)) {
            if ("saveQuerySuccess".equals(returnData.toString())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataIntegrationFilterEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        if (actionIdString.startsWith(SELECT_DIMENSION_MEMBER_CALLBACK)) {
            this.dealMemberF7Back(actionIdString, returnData);
        }
    }

    private void dealMemberF7Back(String actionIdString, Object returnData) {
        String dimensionNumberString = actionIdString.substring(SELECT_DIMENSION_MEMBER_CALLBACK.length() + 1);
        String dimNumber = this.getOrCacheDimLowNums(null).get(dimensionNumberString);
        if (this.notEmpty(dimNumber)) {
            String f7Val = null;
            if (returnData instanceof DynamicObjectCollection) {
                DataIntegrationQuery integrationQuery = this.selAndCacheMemberInfo(dimNumber, (DynamicObjectCollection)returnData);
                f7Val = this.queryToShowStr(integrationQuery);
            }
            this.getModel().getDataEntity().set(dimensionNumberString, f7Val);
            this.getView().updateView(dimensionNumberString);
        }
    }

    private String queryToShowStr(DataIntegrationQuery integrationQuery) {
        if (integrationQuery == null) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(this.getModelId());
        return DimensionServiceHelper.buildRangeF7ShowStr((Dimension)this.getIModelCacheHelper().getDimension(integrationQuery.getDimNumber()), (Iterable)integrationQuery.getDataIntegrationMemberPojoList(), DataIntegrationMemberPojo::getMemberIdLong, DataIntegrationMemberPojo::getScopeString, (Long)integrationQuery.getViewId(), (IModelCacheHelper)modelCacheHelper);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        String key = e.getProperty().getName();
        this.dealMemberF7Clear(key, changeData);
    }

    private void dealMemberF7Clear(String propKey, ChangeData changeData) {
        String dimNumber;
        Object newValue = changeData.getNewValue();
        if (this.isEmpty(newValue) && this.notEmpty(dimNumber = this.getOrCacheDimLowNums(null).get(propKey))) {
            List<DataIntegrationQuery> queryList = this.getOrCacheQueryList(null);
            queryList.removeIf(list -> dimNumber.equals(list.getDimNumber()));
            this.getOrCacheQueryList(queryList);
        }
    }

    private DataIntegrationQuery selAndCacheMemberInfo(String dimNumber, DynamicObjectCollection members) {
        List<DataIntegrationQuery> dataIntegrationQueryList = this.getOrCacheQueryList(null);
        DataIntegrationQuery query = null;
        for (DataIntegrationQuery dataIntegrationQuery : dataIntegrationQueryList) {
            if (!dimNumber.equals(dataIntegrationQuery.getDimNumber())) continue;
            query = dataIntegrationQuery;
            break;
        }
        if (query == null) {
            query = new DataIntegrationQuery();
            query.setDimNumber(dimNumber);
            dataIntegrationQueryList.add(query);
        }
        ArrayList<DataIntegrationMemberPojo> dataIntegrationMemberPojoList = new ArrayList<DataIntegrationMemberPojo>(16);
        Long viewId = null;
        if (members != null && !members.isEmpty()) {
            List mapList = DbUtils.getMapList((DynamicObjectCollection)members);
            for (Map memberColumnMap : mapList) {
                DataIntegrationMemberPojo dataIntegrationMemberPojo = new DataIntegrationMemberPojo();
                if (memberColumnMap.containsKey("memberid")) {
                    dataIntegrationMemberPojo.setMemberIdLong(ObjUtils.getLong(memberColumnMap.get("memberid")));
                    dataIntegrationMemberPojo.setScopeString((String)memberColumnMap.get("scope"));
                    dataIntegrationMemberPojo.setMemberNumberString((String)memberColumnMap.get("number"));
                } else if (memberColumnMap.containsKey("fid")) {
                    dataIntegrationMemberPojo.setMemberIdLong(ObjUtils.getLong(memberColumnMap.get("fid")));
                    dataIntegrationMemberPojo.setScopeString(String.valueOf(RangeEnum.ONLY.getIndex()));
                    dataIntegrationMemberPojo.setMemberNumberString((String)memberColumnMap.get("fnumber"));
                }
                dataIntegrationMemberPojo.setDimensionNumberString(dimNumber);
                dataIntegrationMemberPojoList.add(dataIntegrationMemberPojo);
                viewId = IDUtils.toLong(memberColumnMap.get("viewid"));
            }
        }
        query.setViewId(viewId);
        query.setDataIntegrationMemberPojoList(dataIntegrationMemberPojoList);
        this.getOrCacheQueryList(dataIntegrationQueryList);
        return query;
    }

    private Map<String, String> getOrCacheDimLowNums(Map<String, String> dimNumbers) {
        return (Map)this.getOrCacheObjWithDef(dimNumbers, null, "dimNumbersSet", true, HashMap.class, false);
    }

    private Set<Long> getSchemeIdsFromPage() {
        return (Set)SerializationUtils.fromJsonString((String)((String)this.getCustomFormParam("schemeIds")), Set.class);
    }

    private Long getBizModelId() {
        return Long.valueOf((String)this.getCustomFormParam("bizModelId"));
    }

    private List<DataIntegrationQuery> getOrCacheQueryList(List<DataIntegrationQuery> dataIntegrationQueryList) {
        return (List)this.getOrCacheObjWithDef(dataIntegrationQueryList, null, "QueryList", false, ArrayList.class, true);
    }

    private boolean isInputType() {
        return DataIntegrationType.getTypeByVal((String)((String)this.getCustomFormParam("inputType"))) == DataIntegrationType.INPUT;
    }

    private Map<String, List<Long>> getDimView() {
        Map viewMap = (Map)JSONUtils.parse((String)((String)this.getCustomFormParam("viewMap")), Map.class);
        return viewMap;
    }
}

