/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationExeScheme;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationPlan;
import kd.epm.eb.business.dataintegration.entity.IntegrationSchemeBaseInfo;
import kd.epm.eb.business.dataintegration.service.DataIntegrationExeSchemeService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationStoreService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.ExecuteSchemeNodeType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class DataIntegrationListBasePlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener {
    protected static final String EXECUTE_SCHEME_TREE = "datasettree";
    protected static final String PRO_MODEL = "model";
    protected static final String BILLLIST_KEY = "billlistap";
    protected static final String FILTER_CLOSE = "filter_close";
    protected static final DataIntegrationExeSchemeService exeSchemeService = DataIntegrationExeSchemeService.getInstance();
    private static final Log log = LogFactory.getLog(DataIntegrationListBasePlugin.class);

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId(this.getBillFormId());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{PRO_MODEL});
        this.addClickListeners(new String[]{"add_executescheme", "edit_executescheme", "del_executescheme", "searchbefore", "searchnext"});
        TreeView treeView = (TreeView)this.getControl(EXECUTE_SCHEME_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener(this::treeNodeSearch);
    }

    private void treeNodeSearch(SearchEnterEvent event) {
        if (StringUtils.isNotEmpty((CharSequence)event.getText())) {
            TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(EXECUTE_SCHEME_TREE));
            this.afterTreeNodeSearch();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"DataIntegrationListBasePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_execute": {
                this.executeTrigger();
                break;
            }
            case "bar_showlog": {
                this.showLogTab();
                break;
            }
            case "bar_showquery": {
                this.showQuery();
                break;
            }
            case "bar_new": {
                this.addScheme();
                break;
            }
            case "bar_copy": {
                this.copyScheme();
                break;
            }
            case "bar_move": {
                this.moveScheme();
                break;
            }
            case "bar_enable": {
                this.enableScheme(true);
                break;
            }
            case "bar_unable": {
                this.enableScheme(false);
                break;
            }
        }
    }

    protected void executeTrigger() {
        HashSet<Long> enableSchemeIds = new HashSet<Long>(16);
        HashSet<Long> unableSchemeIds = new HashSet<Long>(16);
        HashMap<String, Set<Long>> viewMap = new HashMap<String, Set<Long>>(16);
        boolean isExistError = this.getSelEnableAndUnableSchemeIds(enableSchemeIds, unableSchemeIds, true, viewMap);
        if (isExistError || enableSchemeIds.isEmpty()) {
            return;
        }
        this.getOrCacheExecuteOrQuerySchemes(enableSchemeIds);
        if (unableSchemeIds.isEmpty()) {
            this.doExecuteTrigger(JSONUtils.toString(viewMap));
        } else {
            this.getPageCache().put("viewMap", JSONUtils.toString(viewMap));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u91c7\u96c6\u65b9\u6848\uff0c\u7ee7\u7eed\u6267\u884c\u5c06\u4f1a\u8df3\u8fc7\u8fd9\u4e9b\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"DataIntegrationListBasePlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("executeTriggerCallBack", (IFormPlugin)this));
        }
    }

    private void doExecuteTrigger(String viewMap) {
        Long bizModelId = this.getCurExecuteSchemeBizModelId();
        Set<Long> schemeIds = this.getOrCacheExecuteOrQuerySchemes(null);
        if (CollectionUtils.isEmpty(schemeIds)) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("eb_integration_filter");
        fsp.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u8303\u56f4", (String)"DataIntegrationListBasePlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCustomParam("bizModelId", (Object)bizModelId.toString());
        fsp.setCustomParam("schemeIds", (Object)SerializationUtils.toJsonString(schemeIds));
        fsp.setCustomParam("inputType", (Object)this.getDataIntegrationType().getVal());
        fsp.setCustomParam("viewMap", (Object)viewMap);
        fsp.setCustomParam(PRO_MODEL, (Object)this.getModelId());
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FILTER_CLOSE));
        StyleCss css = new StyleCss();
        css.setWidth("600px");
        css.setHeight("480px");
        fsp.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm(fsp);
    }

    protected Set<Long> getOrCacheExecuteOrQuerySchemes(Set<Long> schemeIds) {
        if (schemeIds != null) {
            this.getPageCache().put("executeOrQuerySchemesCache", SerializationUtils.serializeToBase64(schemeIds));
        } else {
            String executeOrQuerySchemesCache = this.getPageCache().get("executeOrQuerySchemesCache");
            if (StringUtils.isNotEmpty((CharSequence)executeOrQuerySchemesCache)) {
                return (Set)SerializationUtils.deSerializeFromBase64((String)executeOrQuerySchemesCache);
            }
        }
        return new HashSet<Long>(0);
    }

    protected boolean getSelEnableAndUnableSchemeIds(Set<Long> enableSchemeIds, Set<Long> unableSchemeIds, boolean isUseOfExecute, Map<String, Set<Long>> viewMap) {
        String operation;
        String executeSchemeId = this.getOrCacheFocusExecuteSchemeId(null);
        TreeNode executeSchemeTree = this.getOrCacheExecuteSchemeTree(null);
        TreeNode focusNode = executeSchemeTree.getTreeNode(executeSchemeId, 20);
        String string = operation = isUseOfExecute ? ResManager.loadKDString((String)"\u6267\u884c", (String)"DataIntegrationListBasePlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u67e5\u770b", (String)"DataIntegrationListBasePlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u6267\u884c\u65b9\u6848\u5206\u7c7b\u6216\u91c7\u96c6\u65b9\u6848\u540e\u70b9\u51fb%1\u3002", (String)"DataIntegrationListBasePlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{operation}));
            return true;
        }
        if (!this.isNewEbForm() && StringUtils.isEmpty((CharSequence)focusNode.getParentid())) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u6216\u4e0b\u7ea7\u6267\u884c\u65b9\u6848\u5206\u7c7b\u8282\u70b9%1\u3002", (String)"DataIntegrationListBasePlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[]{operation}));
            return true;
        }
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            Set allIds = exeSchemeService.getCurExecuteSchemeCatLogAll(this.getModelId(), this.getDataIntegrationType(), IDUtils.toLong((Object)focusNode.getId()));
            DynamicObjectCollection query = QueryServiceHelper.query((String)this.getBillFormId(), (String)"id,status", (QFilter[])new QFilter("executescheme", "in", (Object)allIds).toArray());
            if (CollectionUtils.isNotEmpty((Collection)query)) {
                for (DynamicObject object : query) {
                    if (object.getBoolean("status")) {
                        enableSchemeIds.add(object.getLong("id"));
                        continue;
                    }
                    unableSchemeIds.add(object.getLong("id"));
                }
            }
            this.checkDimView(isUseOfExecute, viewMap, allIds);
            if (enableSchemeIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u6267\u884c\u65b9\u6848\u5206\u7c7b\u4e0b\u65e0\u542f\u7528\u72b6\u6001\u91c7\u96c6\u65b9\u6848\uff0c\u8bf7\u542f\u7528\u6216\u65b0\u589e\u91c7\u96c6\u65b9\u6848\u540e%1\u3002", (String)"DataIntegrationListBasePlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{operation}));
                return true;
            }
        } else {
            Set<Long> selectSchemeIds = selectedRows.stream().map(e -> IDUtils.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toSet());
            DynamicObjectCollection query = QueryServiceHelper.query((String)this.getBillFormId(), (String)"id,status,bizmodel", (QFilter[])new QFilter("id", "in", selectSchemeIds).toArray());
            HashSet<Long> bizModelIds = new HashSet<Long>(16);
            if (CollectionUtils.isNotEmpty((Collection)query)) {
                for (DynamicObject object : query) {
                    if (object.getBoolean("status")) {
                        enableSchemeIds.add(object.getLong("id"));
                    } else {
                        unableSchemeIds.add(object.getLong("id"));
                    }
                    bizModelIds.add(object.getLong("bizmodel"));
                }
            }
            if (bizModelIds.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e1a\u52a1\u6a21\u578b\u4e0b\u7684\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (enableSchemeIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u9009\u62e9\u7684\u91c7\u96c6\u65b9\u6848\u65e0\u542f\u7528\u72b6\u6001\u7684\uff0c\u8bf7\u542f\u7528\u6216\u65b0\u589e\u91c7\u96c6\u65b9\u6848\u540e%1\u3002", (String)"DataIntegrationListBasePlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{operation}));
                return true;
            }
            if (this.checkDimView(isUseOfExecute, viewMap, selectSchemeIds)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkDimView(boolean isUseOfExecute, Map<String, Set<Long>> viewMap, Set<Long> selectSchemeIds) {
        DynamicObject[] load;
        if (isUseOfExecute && (load = BusinessDataServiceHelper.load((Object[])selectSchemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getBillFormId()))) != null) {
            HashMap<String, List<Map<String, String>>> dimSchemViewMap = new HashMap<String, List<Map<String, String>>>(16);
            for (DynamicObject dynamicObject : load) {
                String string = dynamicObject.getString("type");
                if ("output".equals(string)) {
                    this.readOutPutSchemeView(dynamicObject, viewMap, dimSchemViewMap);
                    continue;
                }
                Object schemetype = dynamicObject.get("schemetype");
                if ("1".equals(schemetype)) {
                    this.readCusSchemeViewMap(dynamicObject, viewMap, dimSchemViewMap);
                    continue;
                }
                if ("2".equals(schemetype)) {
                    this.readGlSchemeViewMap(dynamicObject, viewMap, dimSchemViewMap);
                    continue;
                }
                if (!"3".equals(schemetype)) continue;
                this.readBcmSchemeViewMap(dynamicObject, viewMap, dimSchemViewMap);
            }
            if (!viewMap.isEmpty()) {
                ArrayList<String> dimName = new ArrayList<String>(16);
                ArrayList<String> schemeInfo = new ArrayList<String>(16);
                ArrayList infoList = new ArrayList(16);
                for (Map.Entry entry : viewMap.entrySet()) {
                    Dimension dimension;
                    if (((Set)entry.getValue()).size() <= 1 || (dimension = this.getIModelCacheHelper().getDimension((String)entry.getKey())) == null) continue;
                    List mapList = (List)dimSchemViewMap.get(dimension.getNumber());
                    dimName.add(dimension.getName());
                    for (Map map : mapList) {
                        StringBuilder stringBuilder = new StringBuilder((String)map.get("name"));
                        stringBuilder.append(":").append(dimension.getName()).append("_").append((String)map.get("viewName"));
                        String infoStr = stringBuilder.toString();
                        if (schemeInfo.contains(infoStr)) continue;
                        schemeInfo.add(infoStr);
                        HashMap temp = new HashMap(3);
                        temp.put("name", map.get("name"));
                        temp.put("view", map.get("viewName"));
                        temp.put("dimname", dimension.getName());
                        infoList.add(temp);
                    }
                }
                if (CollectionUtils.isNotEmpty(dimName)) {
                    FormShowParameter parameters = new FormShowParameter();
                    parameters.getOpenStyle().setShowType(ShowType.Modal);
                    parameters.setFormId("eb_listinfoshow");
                    parameters.setShowTitle(false);
                    parameters.setCustomParam("hasMore", (Object)(schemeInfo.size() > 2 ? 1 : 0));
                    parameters.setCustomParam("errorMsg", schemeInfo);
                    parameters.setCustomParam("infoList", (Object)SerializationUtils.toJsonString(infoList));
                    String string = ResManager.loadKDString((String)"\u6279\u91cf\u6267\u884c\u65f6\uff0c\u65b9\u6848\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u6240\u5c5e\u7ef4\u5ea6\u89c6\u56fe\u9700\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6267\u884c\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    parameters.setCustomParam("title", (Object)string);
                    this.getView().showForm(parameters);
                    return true;
                }
            }
        }
        return false;
    }

    private void readOutPutSchemeView(DynamicObject dynamicObject, Map<String, Set<Long>> viewMap, Map<String, List<Map<String, String>>> dimSchemViewMap) {
        DynamicObjectCollection interangeentry = dynamicObject.getDynamicObjectCollection("dimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)interangeentry)) {
            String name = dynamicObject.getString("name");
            Set<String> userSchemeDim = this.getRangeDimNum(dynamicObject);
            for (DynamicObject object : interangeentry) {
                Map map;
                String info;
                String bcmdimtarnumber;
                DynamicObject bcmdimmemmap = object.getDynamicObject("dimmembmap");
                if (bcmdimmemmap == null || userSchemeDim.contains(bcmdimtarnumber = object.getString("dimsource")) || !StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("sourcesysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) continue;
                Set set = viewMap.computeIfAbsent(bcmdimtarnumber, k -> new HashSet(16));
                set.add(IDUtils.toLong(map.get("view")));
                if (!IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                List mapList = dimSchemViewMap.computeIfAbsent(bcmdimtarnumber, k -> new ArrayList(16));
                HashMap<String, String> tempMap = new HashMap<String, String>(2);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong(map.get("view")))});
                if (!CollectionUtils.isNotEmpty((Collection)query)) continue;
                tempMap.put("name", name);
                tempMap.put("viewName", ((DynamicObject)query.get(0)).getString("name"));
                mapList.add(tempMap);
            }
        }
    }

    private void readCusSchemeViewMap(DynamicObject dynamicObject, Map<String, Set<Long>> viewMap, Map<String, List<Map<String, String>>> dimSchemViewMap) {
        DynamicObjectCollection interangeentry = dynamicObject.getDynamicObjectCollection("dimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)interangeentry)) {
            Set<String> userSchemeDim = this.getRangeDimNum(dynamicObject);
            String name = dynamicObject.getString("name");
            for (DynamicObject object : interangeentry) {
                Map map;
                String info;
                String bcmdimtarnumber;
                DynamicObject bcmdimmemmap = object.getDynamicObject("dimmembmap");
                if (bcmdimmemmap == null || userSchemeDim.contains(bcmdimtarnumber = object.getString("dimtarget")) || !StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("targetsysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) continue;
                Set set = viewMap.computeIfAbsent(bcmdimtarnumber, k -> new HashSet(16));
                set.add(IDUtils.toLong(map.get("view")));
                if (!IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                List mapList = dimSchemViewMap.computeIfAbsent(bcmdimtarnumber, k -> new ArrayList(16));
                HashMap<String, String> tempMap = new HashMap<String, String>(2);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong(map.get("view")))});
                if (!CollectionUtils.isNotEmpty((Collection)query)) continue;
                tempMap.put("name", name);
                tempMap.put("viewName", ((DynamicObject)query.get(0)).getString("name"));
                mapList.add(tempMap);
            }
        }
    }

    private void readGlSchemeViewMap(DynamicObject dynamicObject, Map<String, Set<Long>> viewMap, Map<String, List<Map<String, String>>> dimSchemViewMap) {
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("dimmapscheme_entry");
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            Set<String> userSchemeDim = this.getRangeDimNum(dynamicObject);
            String name = dynamicObject.getString("name");
            for (DynamicObject object : dynamicObjects) {
                String dimMemMapJson = object.getString("dimmemmapjson");
                if (dimMemMapJson == null) continue;
                List dimMapList = (List)kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                for (DataIntegrationDimMap dataIntegrationDimMap : dimMapList) {
                    Map map;
                    String info;
                    DynamicObject dynamicObject1;
                    if (userSchemeDim.contains(dataIntegrationDimMap.getDimtarget()) || View.NoViewDimNums.contains(dataIntegrationDimMap.getDimtarget()) || (dynamicObject1 = BusinessDataServiceHelper.loadSingle((String)"eb_integration_map", (String)"targetsysinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataIntegrationDimMap.getDimmembmapid())})) == null || !StringUtils.isNotEmpty((CharSequence)(info = dynamicObject1.getString("targetsysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) continue;
                    Set set = viewMap.computeIfAbsent(dataIntegrationDimMap.getDimtarget(), k -> new HashSet(16));
                    set.add(IDUtils.toLong(map.get("view")));
                    if (!IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                    List mapList = dimSchemViewMap.computeIfAbsent(dataIntegrationDimMap.getDimtarget(), k -> new ArrayList(16));
                    HashMap<String, String> tempMap = new HashMap<String, String>(2);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong(map.get("view")))});
                    if (!CollectionUtils.isNotEmpty((Collection)query)) continue;
                    tempMap.put("name", name);
                    tempMap.put("viewName", ((DynamicObject)query.get(0)).getString("name"));
                    mapList.add(tempMap);
                }
            }
        }
    }

    private void readBcmSchemeViewMap(DynamicObject dynamicObject, Map<String, Set<Long>> viewMap, Map<String, List<Map<String, String>>> dimSchemViewMap) {
        DynamicObjectCollection interangeentry = dynamicObject.getDynamicObjectCollection("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)interangeentry)) {
            String name = dynamicObject.getString("name");
            Set<String> userSchemeDim = this.getRangeDimNum(dynamicObject);
            for (DynamicObject object : interangeentry) {
                Map map;
                String info;
                String bcmdimtarnumber;
                DynamicObject bcmdimmemmap = object.getDynamicObject("bcmdimmemmap");
                if (bcmdimmemmap == null || userSchemeDim.contains(bcmdimtarnumber = object.getString("bcmdimtarnumber")) || !StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("targetsysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) continue;
                Set set = viewMap.computeIfAbsent(bcmdimtarnumber, k -> new HashSet(16));
                set.add(IDUtils.toLong(map.get("view")));
                if (!IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                List mapList = dimSchemViewMap.computeIfAbsent(bcmdimtarnumber, k -> new ArrayList(16));
                HashMap<String, String> tempMap = new HashMap<String, String>(2);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong(map.get("view")))});
                if (!CollectionUtils.isNotEmpty((Collection)query)) continue;
                tempMap.put("name", name);
                tempMap.put("viewName", ((DynamicObject)query.get(0)).getString("name"));
                mapList.add(tempMap);
            }
        }
    }

    @NotNull
    private Set<String> getRangeDimNum(DynamicObject dynamicObject) {
        DynamicObjectCollection range = dynamicObject.getDynamicObjectCollection("interangeentry");
        HashSet<String> userSchemeDim = new HashSet<String>(16);
        for (DynamicObject object : range) {
            if (!DataIntegrationGetValType.SCHEME.getVal().equals(object.getString("rangegetvalway"))) continue;
            userSchemeDim.add(object.getString("rangedimnum"));
        }
        return userSchemeDim;
    }

    protected void showLogTab() {
        Set pks;
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        String integrationTypeVal = this.getDataIntegrationType().getVal();
        if (selectedPks.length == 0) {
            QFilter filter = new QFilter("modelid", "=", (Object)this.getModelId());
            filter.and(new QFilter("type", "=", (Object)integrationTypeVal));
            DynamicObjectCollection outList = QueryServiceHelper.query((String)this.getBillFormId(), (String)"id", (QFilter[])new QFilter[]{filter});
            pks = outList.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        } else {
            pks = Stream.of(selectedPks).collect(Collectors.toSet());
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setPageId(lsp.getBillFormId() + this.getModelId() + "_" + this.getView().getPageId());
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setBillFormId("eb_integration_log");
        ListFilterParameter listFilterParameter = lsp.getListFilterParameter();
        listFilterParameter.setQFilters(Collections.singletonList(new QFilter("integration", "in", pks)));
        listFilterParameter.setOrderBy("id desc");
        lsp.setCustomParam("integration_type", (Object)integrationTypeVal);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "log_close"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    protected void showQuery() {
        HashSet<Long> enableSchemeIds = new HashSet<Long>(16);
        HashSet<Long> unableSchemeIds = new HashSet<Long>(16);
        HashMap<String, Set<Long>> viewMap = new HashMap<String, Set<Long>>(16);
        boolean isExistError = this.getSelEnableAndUnableSchemeIds(enableSchemeIds, unableSchemeIds, false, viewMap);
        if (isExistError || enableSchemeIds.isEmpty()) {
            return;
        }
        this.getOrCacheExecuteOrQuerySchemes(enableSchemeIds);
        if (unableSchemeIds.isEmpty()) {
            this.doShowQuery();
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u91c7\u96c6\u65b9\u6848\uff0c\u7ee7\u7eed\u67e5\u770b\u5c06\u4f1a\u8df3\u8fc7\u8fd9\u4e9b\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u67e5\u770b\uff1f", (String)"DataIntegrationListBasePlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showQueryCallBack", (IFormPlugin)this));
        }
    }

    private void doShowQuery() {
        Set<Long> schemeIds = this.getOrCacheExecuteOrQuerySchemes(null);
        if (CollectionUtils.isEmpty(schemeIds)) {
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setPageId("query_" + lsp.getBillFormId() + this.getModelId() + "_" + this.getView().getPageId());
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setBillFormId("eb_integration_query");
        lsp.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("integrationids.fbasedataid_id", "in", schemeIds)));
        lsp.setCustomParam("integrationType", (Object)this.getDataIntegrationType().getVal());
        lsp.setCustomParam("modelId", (Object)this.getModelId());
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void moveScheme() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        if (selectedPks == null || selectedPks.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.getBillFormId(), (String)"executescheme.id,executescheme.bizmodel", (QFilter[])new QFilter("id", "in", (Object)selectedPks).toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set executeSchemeIds = dynamicObjects.stream().map(e -> e.getLong("executescheme.id")).collect(Collectors.toSet());
        if (executeSchemeIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u6267\u884c\u65b9\u6848\u5206\u7c7b\u7684\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject scheme = (DynamicObject)dynamicObjects.get(0);
        Long executeSchemeId = scheme.getLong("executescheme.id");
        Long bizModelId = scheme.getLong("executescheme.bizmodel");
        QFilter qFilter = new QFilter(PRO_MODEL, "=", (Object)this.getModelId());
        qFilter.and("type", "=", (Object)this.getDataIntegrationType().getVal());
        qFilter.and("id", "!=", (Object)executeSchemeId);
        qFilter.and("bizmodel", "=", (Object)bizModelId);
        QFilter nodeTypeFilter = new QFilter("nodetype", "=", (Object)ExecuteSchemeNodeType.DEFAULT.getVal()).or("nodetype", "=", (Object)ExecuteSchemeNodeType.OTHER.getVal());
        qFilter.and(nodeTypeFilter);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_integraexecutescheme", (String)"id,parent", (QFilter[])new QFilter("bizmodel", "=", (Object)bizModelId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashSet<Long> noLeafIds = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : query) {
                long parent = dynamicObject.getLong("parent");
                if (IDUtils.isEmptyLong((Long)parent).booleanValue()) continue;
                noLeafIds.add(parent);
            }
            qFilter.and("id", "not in", noLeafIds);
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"eb_integraexecutescheme", (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "moveSchemeCloseCallBack"));
        listShowParameter.setMultiSelect(false);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void copyScheme() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e910\u4e2a\u65b9\u6848\u590d\u5236\u3002", (String)"DataIntegrationListBasePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List schemeIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        try {
            StringBuilder msg = new StringBuilder();
            int size = DataIntegrationStoreService.getInstance().copyScheme(this.getModelId(), this.getDataIntegrationType(), IDUtils.toLongs(schemeIds), msg);
            if (size > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"DataIntegrationListBasePlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("copy", new MultiLangEnumBridge("\u590d\u5236\u65b9\u6848\u3002", "DataIntegrationListBasePlugin_33", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u6210\u529f\u3002", "DataIntegrationListBasePlugin_32", "epm-eb-formplugin"));
            }
            if (msg.length() > 0) {
                this.getView().showTipNotification(msg.toString());
            }
        }
        catch (Exception e) {
            log.info("copyScheme error." + ThrowableHelper.toString((Exception)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u590d\u5236\u5f02\u5e38\u3002", (String)"DataIntegrationListBasePlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        billList.refresh();
    }

    private void addScheme() {
        Long executeSchemeId = IDUtils.toLong((Object)this.getOrCacheFocusExecuteSchemeId(null));
        if (this.isNoLeafExecuteSchemeNode(executeSchemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u6267\u884c\u65b9\u6848\u5206\u7c7b\u3002", (String)"DataIntegrationListBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DataIntegrationType type = this.getDataIntegrationType();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_integration_baseinfo");
        showParameter.setCaption(type == DataIntegrationType.INPUT ? ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u91c7\u96c6\u65b9\u6848", (String)"DataIntegrationListBasePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f93\u51fa\u65b9\u6848", (String)"DataIntegrationListBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("type", (Object)type.getVal());
        showParameter.setCustomParam(PRO_MODEL, (Object)this.getModelId());
        showParameter.setCustomParam("isEdit", (Object)false);
        showParameter.setCustomParam("source", (Object)"list");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baseInfoCloseCallBack"));
        this.getView().showForm(showParameter);
    }

    private void enableScheme(boolean enable) {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        if (selectedPks == null || selectedPks.length == 0) {
            this.getView().showTipNotification(enable ? ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.getBillFormId(), (String)"status", (QFilter[])new QFilter("id", "in", (Object)selectedPks).toArray());
        if (load != null && load.length > 0) {
            for (DynamicObject object : load) {
                object.set("status", (Object)enable);
            }
            SaveServiceHelper.save((DynamicObject[])load);
            billList.refresh();
            MultiLangEnumBridge operation = enable ? new MultiLangEnumBridge("\u542f\u7528\u65b9\u6848", "DataIntegrationListBasePlugin_28", "epm-eb-formplugin") : new MultiLangEnumBridge("\u7981\u7528\u65b9\u6848", "DataIntegrationListBasePlugin_29", "epm-eb-formplugin");
            MultiLangEnumBridge tip = enable ? new MultiLangEnumBridge("\u542f\u7528\u65b9\u6848\u6210\u529f\u3002", "DataIntegrationListBasePlugin_22", "epm-eb-formplugin") : new MultiLangEnumBridge("\u7981\u7528\u65b9\u6848\u6210\u529f\u3002", "DataIntegrationListBasePlugin_23", "epm-eb-formplugin");
            this.getView().showSuccessNotification(tip.loadKDString());
            this.writeLog(enable ? "enable" : "disable", operation, tip);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "add_executescheme": {
                this.addExecuteScheme();
                break;
            }
            case "edit_executescheme": {
                this.editExecuteScheme();
                break;
            }
            case "del_executescheme": {
                this.delExecuteScheme();
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(EXECUTE_SCHEME_TREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                this.afterTreeNodeSearch();
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(EXECUTE_SCHEME_TREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                this.afterTreeNodeSearch();
                break;
            }
        }
    }

    protected void afterTreeNodeSearch() {
        TreeView treeView = (TreeView)this.getControl(EXECUTE_SCHEME_TREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        TreeNode executeSchemeTree = this.getOrCacheExecuteSchemeTree(null);
        TreeNode curNode = executeSchemeTree.getTreeNode(focusNodeId, 20);
        if (curNode != null) {
            this.treeNodeClick(new TreeNodeEvent((Object)treeView, (Object)curNode.getParentid(), (Object)curNode.getId()));
        }
    }

    private void addExecuteScheme() {
        Long executeSchemeId = IDUtils.toLong((Object)this.getOrCacheFocusExecuteSchemeId(null));
        DataIntegrationExeScheme exeScheme = exeSchemeService.getExeScheme(executeSchemeId);
        if (exeScheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u65b9\u6848\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ExecuteSchemeNodeType nodeType = exeScheme.getNodeType();
        if (!this.isNewEbForm() && nodeType == ExecuteSchemeNodeType.ROOT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u589e\u52a0\u4e0b\u7ea7\u3002", (String)"DataIntegrationListBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isExistScheme(executeSchemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6267\u884c\u65b9\u6848\u5206\u7c7b\u4e0b\u5df2\u5b58\u5728\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u589e\u52a0\u4e0b\u7ea7\u5206\u7c7b\u3002", (String)"DataIntegrationListBasePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bizModelId = exeScheme.getBizModelId();
        if (IDUtils.isNotEmptyLong((Long)bizModelId).booleanValue()) {
            this.openExecuteSchemePage(OperationStatus.ADDNEW, String.valueOf(executeSchemeId), bizModelId);
        }
    }

    private void editExecuteScheme() {
        Long executeSchemeId = IDUtils.toLong((Object)this.getOrCacheFocusExecuteSchemeId(null));
        DataIntegrationExeScheme exeScheme = exeSchemeService.getExeScheme(executeSchemeId);
        if (exeScheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u65b9\u6848\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ExecuteSchemeNodeType nodeType = exeScheme.getNodeType();
        if (this.isNewEbForm() && nodeType == ExecuteSchemeNodeType.BIZMODEL || !this.isNewEbForm() && nodeType == ExecuteSchemeNodeType.ROOT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"DataIntegrationListBasePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bizModelId = exeScheme.getBizModelId();
        if (!this.isNewEbForm() && nodeType == ExecuteSchemeNodeType.BIZMODEL) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"DataIntegrationListBasePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openExecuteSchemePage(OperationStatus.EDIT, String.valueOf(executeSchemeId), bizModelId);
    }

    private void delExecuteScheme() {
        String tip;
        Long executeSchemeId = IDUtils.toLong((Object)this.getOrCacheFocusExecuteSchemeId(null));
        DataIntegrationExeScheme exeScheme = exeSchemeService.getExeScheme(executeSchemeId);
        if (exeScheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6267\u884c\u65b9\u6848\u3002", (String)"DataIntegrationListBasePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DataIntegrationType type = this.getDataIntegrationType();
        ExecuteSchemeNodeType nodeType = exeScheme.getNodeType();
        if (this.isNewEbForm() && nodeType == ExecuteSchemeNodeType.BIZMODEL || !this.isNewEbForm() && nodeType == ExecuteSchemeNodeType.ROOT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.isNewEbForm() && nodeType == ExecuteSchemeNodeType.BIZMODEL) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (nodeType == ExecuteSchemeNodeType.DEFAULT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u65b9\u6848\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isNoLeafExecuteSchemeNode(executeSchemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean existScheme = this.isExistScheme(executeSchemeId);
        if (existScheme) {
            String input = ResManager.loadKDString((String)"\u91c7\u96c6", (String)"DataIntegrationListBasePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String out = ResManager.loadKDString((String)"\u8f93\u51fa", (String)"DataIntegrationListBasePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            tip = ResManager.loadResFormat((String)"\u88ab\u5220\u6267\u884c\u65b9\u6848\u5206\u7c7b\u4e0b\u7684%1\u65b9\u6848\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u540c\u4e00\u4e1a\u52a1\u6a21\u578b\u4e2d\u7684\u9ed8\u8ba4\u5206\u7c7b\u4e0a\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"DataIntegrationListBasePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{type == DataIntegrationType.INPUT ? input : out});
        } else {
            tip = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u6267\u884c\u65b9\u6848\u5206\u7c7b\uff1f", (String)"DataIntegrationListBasePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delExecuteSchemeCallBack", (IFormPlugin)this));
    }

    private void openExecuteSchemePage(OperationStatus operationStatus, String executeSchemeId, Long bizModelId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        TreeNode executeSchemeTree = this.getOrCacheExecuteSchemeTree(null);
        TreeNode curNode = executeSchemeTree.getTreeNode(executeSchemeId, 20);
        if (curNode == null) {
            return;
        }
        if (operationStatus == OperationStatus.ADDNEW) {
            showParameter.setCustomParam("parent", (Object)executeSchemeId);
            showParameter.setCustomParam("parentName", (Object)curNode.getText());
        } else {
            showParameter.setPkId((Object)executeSchemeId);
            TreeNode parentNode = executeSchemeTree.getTreeNode(curNode.getParentid(), 20);
            if (parentNode != null) {
                showParameter.setCustomParam("parentName", (Object)parentNode.getText());
            }
        }
        showParameter.setStatus(operationStatus);
        showParameter.setFormId("eb_integraexecutescheme");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addExecuteSchemeCloseCallBack"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(PRO_MODEL, (Object)this.getModelId());
        showParameter.setCustomParam("bizmodel", (Object)bizModelId);
        showParameter.setCustomParam("type", (Object)this.getDataIntegrationType().getVal());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (PRO_MODEL.equals(propName)) {
            PluginUtils.setModelFilter(beforeF7SelectEvent, this.getView());
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)beforeF7SelectEvent);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            String operation = ((FormOperate)args.getSource()).getOperateKey();
            if ("delete".equals(operation)) {
                this.beforeDoDelete();
            } else if ("refresh".equals(operation)) {
                this.refreshExecuteSchemeTree(this.getModelId());
            }
        }
    }

    protected void beforeDoDelete() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.required((String)"deleteSchemeLogAndRouter");){
            try {
                DBRoute epm = DBRoute.of((String)"epm");
                String logSql = "delete from t_eb_integration_logdet where fintegrationid in (" + StringUtils.join((Iterable)selectedRows, (String)",") + ")";
                String logDetailSql = "delete from t_eb_integration_log where fintegrationid in (" + StringUtils.join((Iterable)selectedRows, (String)",") + ")";
                DB.execute((DBRoute)epm, (String)logSql);
                DB.execute((DBRoute)epm, (String)logDetailSql);
                List schemeIds = selectedRows.stream().map(e -> IDUtils.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toList());
                DataIntegrationStoreService.getInstance().deleteCusIntegrationSchemeTableRouter(schemeIds);
            }
            catch (Exception ex) {
                log.info("beforeDoDelete error:" + ThrowableHelper.toString((Exception)ex));
                tx.markRollback();
                throw ex;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operation;
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operation = ((FormOperate)args.getSource()).getOperateKey()) {
            case "refresh": {
                this.afterDoRefresh();
                break;
            }
            case "delete": {
                this.afterDoDelete();
                break;
            }
        }
    }

    protected void afterDoRefresh() {
        String executeSchemeId = this.getOrCacheFocusExecuteSchemeId(null);
        if (StringUtils.isNotEmpty((CharSequence)executeSchemeId)) {
            TreeView treeView = (TreeView)this.getControl(EXECUTE_SCHEME_TREE);
            TreeNode schemeTree = this.getOrCacheExecuteSchemeTree(null);
            TreeNode node = schemeTree.getTreeNode(executeSchemeId, 20);
            if (node != null) {
                treeView.focusNode(node);
            }
        }
    }

    protected void afterDoDelete() {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (FILTER_CLOSE.equals(actionId)) {
            this.filterCloseCallBack(returnData);
        } else if ("baseInfoCloseCallBack".equals(actionId)) {
            this.baseInfoCloseCallBack(returnData);
        } else if ("addSchemeCloseCallBack".equals(actionId)) {
            this.addSchemeCloseCallBack();
        } else if ("addExecuteSchemeCloseCallBack".equals(actionId)) {
            this.refreshExecuteSchemeTree(this.getModelId());
        } else if ("moveSchemeCloseCallBack".equals(actionId)) {
            this.moveSchemeCloseCallBack(returnData);
        }
    }

    private void moveSchemeCloseCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                return;
            }
            Long moveToExecuteSchemeId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            if (IDUtils.isEmptyLong((Long)moveToExecuteSchemeId).booleanValue()) {
                return;
            }
            if (!QueryServiceHelper.exists((String)"eb_integraexecutescheme", (QFilter[])new QFilter("id", "=", (Object)moveToExecuteSchemeId).toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8981\u79fb\u81f3\u7684\u6267\u884c\u65b9\u6848\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"DataIntegrationListBasePlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
            Object[] selectedPks = billList.getSelectedRows().getPrimaryKeyValues();
            if (selectedPks == null || selectedPks.length == 0) {
                return;
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getBillFormId(), (String)"executescheme", (QFilter[])new QFilter("id", "in", (Object)selectedPks).toArray());
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("executescheme", (Object)moveToExecuteSchemeId);
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                this.refreshExecuteSchemeTree(this.getModelId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u65b9\u6848\u6210\u529f\u3002", (String)"DataIntegrationListBasePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("move", new MultiLangEnumBridge("\u79fb\u52a8\u65b9\u6848", "DataIntegrationListBasePlugin_27", "epm-eb-formplugin"), new MultiLangEnumBridge("\u79fb\u52a8\u65b9\u6848\u6210\u529f\u3002", "DataIntegrationListBasePlugin_26", "epm-eb-formplugin"));
            }
        }
    }

    protected void addSchemeCloseCallBack() {
        BillList billList = (BillList)this.getControl(BILLLIST_KEY);
        billList.refresh();
    }

    protected void baseInfoCloseCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        if (returnData instanceof IntegrationSchemeBaseInfo) {
            IntegrationSchemeBaseInfo baseInfo = (IntegrationSchemeBaseInfo)returnData;
            DataIntegrationType type = this.getDataIntegrationType();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(this.getBillFormId());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addSchemeCloseCallBack"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowTitle(true);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("modelId", (Object)this.getModelId());
            showParameter.setCustomParam("bizModelId", (Object)this.getCurExecuteSchemeBizModelId());
            showParameter.setCustomParam("baseInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)baseInfo));
            showParameter.setCustomParam("type", (Object)type.getVal());
            showParameter.setCustomParam("executeSchemeId", (Object)this.getOrCacheFocusExecuteSchemeId(null));
            if (type == DataIntegrationType.INPUT) {
                this.showParameterSpecialDeal(showParameter, baseInfo.getSchemeType());
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    protected void showParameterSpecialDeal(BaseShowParameter showParameter, IntegrationSchemeType schemeType) {
    }

    protected void filterCloseCallBack(Object returnData) {
        log.info("filterCloseCallBack:" + returnData);
        if (returnData instanceof String) {
            IFormView formView = this.getView();
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setTaskClassname("kd.epm.eb.formplugin.dataintegration.task.IntegrationBackRunTask");
            jobInfo.setName(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210", (String)"DataIntegrationListBasePlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            jobInfo.setId(UUID.randomUUID().toString());
            jobInfo.setCanStop(Boolean.valueOf(true));
            jobInfo.setFailNotify(true);
            jobInfo.setTimeout(3600);
            jobInfo.setOverTime(true);
            jobInfo.setExecuteTime(3600);
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
            jobInfo.setAppId(this.getBizAppId());
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            customParams.put("actionId", returnData);
            jobInfo.setParams(customParams);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setJobInfo(jobInfo);
            jobFormInfo.setCaption(jobInfo.getName());
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setTimeout(3600);
            jobFormInfo.setClickClassName("kd.epm.eb.formplugin.dataintegration.task.IntegrationBackRunTaskClick");
            jobFormInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "exec_progress_job"));
            jobFormInfo.setParentPageId(formView.getFormShowParameter().getPageId());
            jobFormInfo.setRootPageId(formView.getFormShowParameter().getRootPageId());
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formView);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String backId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("delExecuteSchemeCallBack".equals(backId)) {
            this.delExecuteSchemeCallBack(result);
        } else if ("executeTriggerCallBack".equals(backId)) {
            if (result == MessageBoxResult.Yes) {
                this.doExecuteTrigger(this.getPageCache().get("viewMap"));
            }
            this.getPageCache().remove("viewMap");
        } else if ("showQueryCallBack".equals(backId) && result == MessageBoxResult.Yes) {
            this.doShowQuery();
        }
    }

    private void delExecuteSchemeCallBack(MessageBoxResult result) {
        if (result != MessageBoxResult.Yes) {
            return;
        }
        Long executeSchemeId = IDUtils.toLong((Object)this.getOrCacheFocusExecuteSchemeId(null));
        DataIntegrationExeScheme exeScheme = exeSchemeService.getExeScheme(executeSchemeId);
        if (exeScheme == null) {
            return;
        }
        boolean isDeleteSuccess = false;
        if (this.isExistScheme(executeSchemeId)) {
            Long firstLeafExecuteSchemeId;
            DynamicObject[] load = BusinessDataServiceHelper.load((String)this.getBillFormId(), (String)"executescheme", (QFilter[])new QFilter("executescheme", "=", (Object)executeSchemeId).toArray());
            if (load != null && load.length > 0 && IDUtils.isNotEmptyLong((Long)(firstLeafExecuteSchemeId = exeSchemeService.getCurBizModelDefaultFirstLeafExecuteScheme(exeScheme.getBizModelId(), this.getDataIntegrationType()))).booleanValue()) {
                for (DynamicObject object : load) {
                    object.set("executescheme", (Object)firstLeafExecuteSchemeId);
                }
                SaveServiceHelper.save((DynamicObject[])load);
                DeleteServiceHelper.delete((String)"eb_integraexecutescheme", (QFilter[])new QFilter("id", "=", (Object)executeSchemeId).toArray());
                isDeleteSuccess = true;
            }
        } else {
            DeleteServiceHelper.delete((String)"eb_integraexecutescheme", (QFilter[])new QFilter("id", "=", (Object)executeSchemeId).toArray());
            isDeleteSuccess = true;
        }
        if (isDeleteSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataIntegrationListBasePlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshExecuteSchemeTree(this.getModelId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (PRO_MODEL.equals(name)) {
            this.modelChanged();
        }
    }

    protected void modelChanged() {
        Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)PRO_MODEL);
        if (IDUtils.isNull((Long)modelId)) {
            this.getModel().setValue(PRO_MODEL, (Object)this.getPageCache().get("KEY_MODEL_ID"));
            return;
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        this.refreshExecuteSchemeTree(modelId);
    }

    /*
     * WARNING - void declaration
     */
    protected void refreshExecuteSchemeTree(Long modelId) {
        void var7_15;
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        DataIntegrationType type = this.getDataIntegrationType();
        this.createDefaultExecuteSchemes(modelId);
        try {
            this.upgradeOldSchemeData(modelId);
        }
        catch (Exception e) {
            log.info("upgradeOldSchemeData error." + ThrowableHelper.toString((Exception)e));
        }
        TreeNode rootNode = new TreeNode();
        LinkedHashMap<String, TreeNode> treeNodeMap = new LinkedHashMap<String, TreeNode>(16);
        List exeSchemes = exeSchemeService.getExeScheme(modelId, type);
        for (DataIntegrationExeScheme dataIntegrationExeScheme : exeSchemes) {
            String id = String.valueOf(dataIntegrationExeScheme.getId());
            Long parentId = dataIntegrationExeScheme.getParentId();
            TreeNode node = new TreeNode();
            node.setId(id);
            node.setLongNumber(dataIntegrationExeScheme.getNumber());
            node.setText(dataIntegrationExeScheme.getName());
            if (IDUtils.isEmptyLong((Long)parentId).booleanValue()) {
                node.setParentid("");
                rootNode = node;
            } else {
                node.setParentid(String.valueOf(parentId));
            }
            treeNodeMap.put(id, node);
        }
        for (Map.Entry entry : treeNodeMap.entrySet()) {
            TreeNode node = (TreeNode)entry.getValue();
            TreeNode parentNode = (TreeNode)treeNodeMap.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        if (this.isNewEbForm()) {
            rootNode = this.treeEbSpecialDeal(rootNode);
        }
        EpmTreeUtils.spreadAllNode((TreeNode)rootNode);
        TreeView treeView = (TreeView)this.getControl(EXECUTE_SCHEME_TREE);
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        this.getOrCacheExecuteSchemeTree(rootNode);
        TreeNode treeNode = rootNode;
        TreeNode lastFocusNode = rootNode.getTreeNode(this.getOrCacheFocusExecuteSchemeId(null), 20);
        if (lastFocusNode != null) {
            TreeNode treeNode2 = lastFocusNode;
        } else if (CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            TreeNode treeNode3 = (TreeNode)rootNode.getChildren().get(0);
            if (!this.isNewEbForm() && CollectionUtils.isNotEmpty((Collection)treeNode3.getChildren())) {
                TreeNode treeNode4 = (TreeNode)treeNode3.getChildren().get(0);
            }
        }
        treeView.focusNode((TreeNode)var7_15);
        this.treeNodeClick(new TreeNodeEvent((Object)treeView, (Object)var7_15.getParentid(), (Object)var7_15.getId()));
    }

    private TreeNode treeEbSpecialDeal(TreeNode rootNode) {
        List children = rootNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            TreeNode defaultBizModel = (TreeNode)children.get(0);
            defaultBizModel.setText(rootNode.getText());
            defaultBizModel.setParentid("");
            return defaultBizModel;
        }
        return new TreeNode();
    }

    private void createDefaultExecuteSchemes(Long modelId) {
        DynamicObjectCollection bizModelObjects;
        long rootId;
        boolean newEbForm = this.isNewEbForm();
        DataIntegrationType type = this.getDataIntegrationType();
        List executeSchemeList = exeSchemeService.getExeScheme(modelId, type);
        ArrayList<DataIntegrationExeScheme> exeSchemes = new ArrayList<DataIntegrationExeScheme>(10);
        Optional<DataIntegrationExeScheme> first = executeSchemeList.stream().filter(e -> ExecuteSchemeNodeType.ROOT == e.getNodeType()).findFirst();
        if (first.isPresent()) {
            rootId = first.get().getId();
        } else {
            rootId = GlobalIdUtil.genGlobalLongId();
            exeSchemes.add(new DataIntegrationExeScheme(Long.valueOf(rootId), "root", ResManager.loadKDString((String)"\u6267\u884c\u65b9\u6848\u5206\u7c7b", (String)"DataIntegrationListBasePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), type, ExecuteSchemeNodeType.ROOT, null, modelId, null));
        }
        Set existExecuteSchemeBizModelIds = executeSchemeList.stream().map(DataIntegrationExeScheme::getBizModelId).collect(Collectors.toSet());
        QFilter qFilter = new QFilter(PRO_MODEL, "=", (Object)modelId).and("id", "not in", existExecuteSchemeBizModelIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])qFilter.toArray(), (String)"number");
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)(query.size() * 2));
            int i = 0;
            for (DynamicObject object : query) {
                long bizModelId = object.getLong("id");
                String number = object.getString("number");
                String name = object.getString("name");
                long bizModelNodeId = ids[i++];
                exeSchemes.add(new DataIntegrationExeScheme(Long.valueOf(bizModelNodeId), number, name, type, ExecuteSchemeNodeType.BIZMODEL, Long.valueOf(rootId), modelId, Long.valueOf(bizModelId)));
                String defaultName = ResManager.loadResFormat((String)"%1\u9ed8\u8ba4\u6267\u884c\u65b9\u6848", (String)"DataIntegrationListBasePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{newEbForm ? "" : name});
                exeSchemes.add(new DataIntegrationExeScheme(Long.valueOf(ids[i++]), number + "01", defaultName, type, ExecuteSchemeNodeType.DEFAULT, Long.valueOf(bizModelNodeId), modelId, Long.valueOf(bizModelId)));
            }
        }
        if (exeSchemes.size() > 0) {
            exeSchemeService.saveExecuteSchemes(exeSchemes);
        }
        if (CollectionUtils.isNotEmpty((Collection)(bizModelObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter(PRO_MODEL, "=", (Object)modelId).toArray())))) {
            Set bizModelIds = bizModelObjects.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter1 = new QFilter(PRO_MODEL, "=", (Object)modelId);
            qFilter1.and("bizmodel", "!=", (Object)0);
            qFilter1.and("bizmodel", "not in", bizModelIds);
            DeleteServiceHelper.delete((String)"eb_integraexecutescheme", (QFilter[])qFilter1.toArray());
        }
    }

    protected void upgradeOldSchemeData(Long modelId) {
        DataIntegrationType type = this.getDataIntegrationType();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("type", "=", (Object)type.getVal());
        qFilter.and("bizmodel", "=", (Object)0L);
        qFilter.and("datasetid", "!=", (Object)0L);
        List idList = CentralAppBillService.getInstance().getIdList(qFilter, this.getBillFormId(), null);
        if (idList.size() > 0) {
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getBillFormId()));
            List exeSchemes = exeSchemeService.getExeScheme(modelId, type, ExecuteSchemeNodeType.DEFAULT);
            HashMap bizModelNodeToIdMap = new HashMap(16);
            exeSchemes.forEach(e -> bizModelNodeToIdMap.put(e.getBizModelId(), e.getId()));
            for (DynamicObject object : load) {
                long schemeId = object.getLong("id");
                long dataSetId = object.getLong("datasetid_id");
                Long bizModelId = modelCacheHelper.getBusModelByDataSet(Long.valueOf(dataSetId));
                Long defaultTypeNodeId = (Long)bizModelNodeToIdMap.get(bizModelId);
                if (defaultTypeNodeId != null) {
                    object.set("bizmodel", (Object)bizModelId);
                    object.set("executescheme", (Object)defaultTypeNodeId);
                    if (type == DataIntegrationType.INPUT) {
                        object.set("schemetype", (Object)IntegrationSchemeType.CUSTOM.getVal());
                    }
                }
                if (type == DataIntegrationType.INPUT) {
                    long sourceObjId = object.getLong("sourceobj_id");
                    long targetSysId = object.getLong("targetsys_id");
                    DataIntegrationPlan plan = DataIntegrationService.getInstance().createPlan(schemeId, modelId.longValue(), dataSetId, Long.valueOf(sourceObjId), Long.valueOf(targetSysId));
                    object.set("targetobj", (Object)plan.getTargetObjId());
                    object.set("tablename", (Object)plan.getTableName());
                    object.set("triggerid", (Object)plan.getTriggerId());
                } else {
                    long sourceSysId = object.getLong("sourcesys_id");
                    long targetObjId = object.getLong("targetobj_id");
                    String srcSingleMetric = object.getString("srcsinglemetric");
                    String pkField = object.getString("pkfield");
                    DynamicObjectCollection dimMapEntry = object.getDynamicObjectCollection("dimmapentity");
                    DataIntegrationPlan plan = DataIntegrationService.getInstance().createOutPlan(Long.valueOf(schemeId), modelId, Long.valueOf(dataSetId), Long.valueOf(sourceSysId), Long.valueOf(targetObjId), dimMapEntry, srcSingleMetric, pkField);
                    object.set("sourceobj", (Object)plan.getSrcObjId());
                    object.set("tablename", (Object)plan.getTableName());
                    object.set("triggerid", (Object)plan.getTriggerId());
                }
                DynamicObjectCollection interRangeEntry = object.getDynamicObjectCollection("interangeentry");
                interRangeEntry.clear();
                List<Dimension> dimensionList = this.getInterRangeDimensions(modelCacheHelper, object, type);
                if (!CollectionUtils.isNotEmpty(dimensionList)) continue;
                for (Dimension dimension : dimensionList) {
                    DynamicObject rangeEntry = interRangeEntry.addNew();
                    rangeEntry.set("rangedimnum", (Object)dimension.getNumber());
                    rangeEntry.set("rangegetvalway", (Object)DataIntegrationGetValType.CONDITION.getVal());
                }
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    private List<Dimension> getInterRangeDimensions(IModelCacheHelper modelCacheHelper, DynamicObject object, DataIntegrationType type) {
        long dataSetId = object.getLong("datasetid_id");
        if (IDUtils.isEmptyLong((Long)dataSetId).booleanValue()) {
            return new ArrayList<Dimension>(0);
        }
        if (type == DataIntegrationType.INPUT) {
            DynamicObjectCollection dimMapEntity = object.getDynamicObjectCollection("dimmapentity");
            if (CollectionUtils.isNotEmpty((Collection)dimMapEntity)) {
                ArrayList<Dimension> dimensions = new ArrayList<Dimension>(dimMapEntity.size());
                for (DynamicObject dynamicObject : dimMapEntity) {
                    Dimension dimension;
                    String dimMemNum = dynamicObject.getString("dimmembnum");
                    String dimNum = dynamicObject.getString("dimtarget");
                    if (!StringUtils.isNotEmpty((CharSequence)dimNum) || !StringUtils.isEmpty((CharSequence)dimMemNum) || (dimension = modelCacheHelper.getDimension(dimNum)) == null) continue;
                    dimensions.add(dimension);
                }
                return dimensions;
            }
        } else {
            return modelCacheHelper.getDimensionList(Long.valueOf(dataSetId));
        }
        return new ArrayList<Dimension>(0);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getOrCacheFocusExecuteSchemeId((String)evt.getNodeId());
        BillList billList = (BillList)this.getControl(BILLLIST_KEY);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        Long executeSchemeId = IDUtils.toLong((Object)this.getOrCacheFocusExecuteSchemeId(null));
        Set allIds = exeSchemeService.getCurExecuteSchemeCatLogAll(this.getModelId(), this.getDataIntegrationType(), executeSchemeId);
        e.getQFilters().add(new QFilter("executescheme", "in", (Object)allIds));
    }

    protected boolean isExistScheme(Long executeSchemeId) {
        return QueryServiceHelper.exists((String)this.getBillFormId(), (QFilter[])new QFilter("executescheme", "=", (Object)executeSchemeId).toArray());
    }

    protected boolean isNoLeafExecuteSchemeNode(Long executeSchemeId) {
        return QueryServiceHelper.exists((String)"eb_integraexecutescheme", (QFilter[])new QFilter("parent", "=", (Object)executeSchemeId).toArray());
    }

    protected TreeNode getOrCacheExecuteSchemeTree(TreeNode node) {
        if (node == null) {
            String executeSchemeTreeCache = this.getPageCache().get("treeCacheName");
            if (StringUtils.isEmpty((CharSequence)executeSchemeTreeCache)) {
                return new TreeNode();
            }
            return (TreeNode)SerializationUtils.fromJsonString((String)executeSchemeTreeCache, TreeNode.class);
        }
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)node));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(EXECUTE_SCHEME_TREE));
        return new TreeNode();
    }

    protected String getOrCacheFocusExecuteSchemeId(String executeSchemeId) {
        if (executeSchemeId == null) {
            executeSchemeId = this.getPageCache().get("ExecuteSchemeId");
        } else {
            this.getPageCache().put("ExecuteSchemeId", executeSchemeId);
        }
        return executeSchemeId;
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(PRO_MODEL);
        if (model == null) {
            return 0L;
        }
        return model.getLong("id");
    }

    public Long getCurExecuteSchemeBizModelId() {
        String executeSchemeId = this.getOrCacheFocusExecuteSchemeId(null);
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_integraexecutescheme", (String)"bizmodel", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)executeSchemeId)).toArray());
        if (object != null) {
            return object.getLong("bizmodel");
        }
        return 0L;
    }

    abstract String getBillFormId();

    abstract DataIntegrationType getDataIntegrationType();
}

