/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DataIntegrationLogDetListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_export": {
                this.exportExcel();
                break;
            }
        }
    }

    private void exportExcel() {
        Object logId = this.getView().getFormShowParameter().getCustomParam("logId");
        QFBuilder qb = new QFBuilder("logid", "=", logId);
        String selectFields = "failmsg,datajson,integration.id,integration.number,integration.name";
        if (!LogSignHelper.needLog((String)"DataIntegrationHandler", (String)"logAllMapData")) {
            qb.add(new QFilter("failmsg", "!=", (Object)""));
        }
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_integration_logdet", (String)selectFields, (QFilter[])qb.toArrays());
        ArrayList<String[]> dataList = new ArrayList<String[]>(10);
        for (DynamicObject row : list) {
            String integrationNumber = row.getString("integration.number");
            String integrationName = row.getString("integration.name");
            String failmsg = row.getString("failmsg");
            String datajson = row.getString("datajson");
            String[] data = new String[]{integrationNumber, integrationName, failmsg, datajson};
            dataList.add(data);
        }
        String tempPath = "dataintegration/logdet.xlsx";
        String filename = ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u6210\u9519\u8bef\u65e5\u5fd7%1", (String)"DataIntegrationLogDetListPlugin_new_01", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 3, 0, 0);
        String url = ExcelImExportUtils.getInstance().writeWithTemplate(tempPath, filename, dataList, sheet);
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }
}

