/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.dataintegration.entity.BaseFormLockType;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMapBaseInfo;
import kd.epm.eb.business.dataintegration.service.DataIntegrationMapService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class DataIntegrationMapListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener {
    private static final String MAPCATTREE = "mapcattree";
    public static final String ACTTION_ADD_CAT = "acttion_addCat";
    public static final String ENTRYENTITY = "entryentity";
    public static final String TOOLBARID = "toolbarap";
    public static final String MODELID = "modelid";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = IDUtils.toLong((Object)UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODELID, (boolean)false));
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataIntegrationMapListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId1 = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
        if (IDUtils.isNotNull((Long)modelId1)) {
            modelId = modelId1;
        }
        this.getModel().setValue(MODELID, (Object)modelId);
        this.refreshTree(modelId);
    }

    private void refreshTree(Long modelId) {
        TreeNode treeNode = DataIntegrationMapService.getInstance().getMapCatTree(modelId);
        EpmTreeUtils.spreadAllNode((TreeNode)treeNode);
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(MAPCATTREE, MAPCATTREE));
        this.cacheLeftRoot(treeNode);
        TreeView tree = (TreeView)this.getControl(MAPCATTREE);
        tree.deleteAllNodes();
        tree.addNode(treeNode);
        tree.focusNode(treeNode);
        tree.setRootVisible(Boolean.TRUE.booleanValue());
    }

    protected void collapseChild(TreeNode leftRoot) {
        List children = leftRoot.getChildren();
        if (children != null && children.size() > 0) {
            leftRoot.setIsOpened(true);
            for (TreeNode child : children) {
                this.collapseChild(child);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addcat", "btn_editcat", "btn_delcat", "searchbefore", "searchnext"});
        if (this.getView().getClass().equals(FormView.class)) {
            this.addItemClickListeners(new String[]{TOOLBARID});
        }
        TreeView tview = (TreeView)this.getControl(MAPCATTREE);
        tview.addTreeNodeClickListener((TreeNodeClickListener)this);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                DataIntegrationMapListPlugin.this.refrushBillList();
            }
        });
        BasedataEdit model = (BasedataEdit)this.getControl(MODELID);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), DataIntegrationMapListPlugin.this.getView(), DataIntegrationMapListPlugin.this.getPageCache(), new TreeSearchUtil.TreeSearchParam(DataIntegrationMapListPlugin.MAPCATTREE, DataIntegrationMapListPlugin.MAPCATTREE));
                    DataIntegrationMapListPlugin.this.refrushBillList();
                } else {
                    DataIntegrationMapListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"DataIntegrationMapListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().put(MAPCATTREE, SerializationUtils.toJsonString((Object)rootleft));
    }

    public void setFilter(SetFilterEvent e) {
        Long catId;
        TreeView treeView = (TreeView)this.getControl(MAPCATTREE);
        String catelogId = treeView.getTreeState().getFocusNodeId();
        QFilter ctIdQf = new QFilter(MODELID, "=", (Object)this.getModelId());
        Long l = catId = StringUtils.isEmpty((String)catelogId) ? null : Long.valueOf(catelogId);
        if (this.notEmpty(catId)) {
            ctIdQf.and(new QFilter("mapcat", "=", (Object)catId));
        }
        e.getQFilters().add(ctIdQf);
    }

    private void refrushBillList() {
        Map<String, Object> focusNode = this.getFocusNode();
        this.getPageCache().put("parent", focusNode.get("parentid").toString());
        this.getPageCache().put("nodeid", focusNode.get("id").toString());
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "btn_addcat": {
                this.showAddCatForm();
                break;
            }
            case "btn_editcat": {
                this.showEditcatForm();
                break;
            }
            case "btn_delcat": {
                this.showDelcatForm();
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(MAPCATTREE, MAPCATTREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(MAPCATTREE, MAPCATTREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
        }
    }

    private void showDelcatForm() {
        Map<String, Object> focusNode = this.getFocusNode();
        Long id = Long.valueOf(focusNode.get("id").toString());
        if (id == 0L && ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u7c7b", (String)"DataIntegrationMapListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(focusNode.get("text"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataIntegrationMapListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFBuilder mapcatQuery = new QFBuilder();
        mapcatQuery.add("parentid", "=", (Object)id);
        boolean existsParent = QueryServiceHelper.exists((String)"eb_integration_mapcat", (QFilter[])mapcatQuery.toArrays());
        if (existsParent) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5220\u9664\u53f6\u5b50\u8282\u70b9\u3002", (String)"DataIntegrationMapListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFBuilder mapQuery = new QFBuilder();
        mapQuery.add("mapcat", "=", (Object)id);
        boolean exists = QueryServiceHelper.exists((String)"eb_integration_map", (QFilter[])mapQuery.toArrays());
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5220\u9664\u8282\u70b9\u4e0b\u7684\u6570\u636e\u3002", (String)"DataIntegrationMapListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u6620\u5c04\u65b9\u6848\u5206\u7c7b\uff1f", (String)"DataIntegrationMapListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    private void showEditcatForm() {
        Map<String, Object> focusNode = this.getFocusNode();
        Object id = focusNode.get("id");
        if ("0".equals(id) && ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u7c7b", (String)"DataIntegrationMapListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(focusNode.get("text"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"DataIntegrationMapListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODELID);
        BaseShowParameter fsp = new BaseShowParameter();
        fsp.setPkId(id);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("eb_integration_mapcat");
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setCustomParam(MODELID, (Object)model.getLong("id"));
        fsp.setCustomParam("parentid", (Object)id.toString());
        fsp.setCustomParam("sign", (Object)"1");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTTION_ADD_CAT));
        this.getView().showForm((FormShowParameter)fsp);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_close".equals(key)) {
            return;
        }
        Map<String, Object> focusNode = this.getFocusNode();
        switch (key) {
            case "btn_add": {
                this.openAddDimenMap(focusNode);
                break;
            }
            case "btn_refresh": {
                this.refreshBill();
                break;
            }
            case "btn_delete": {
                BillList control = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = control.getSelectedRows();
                if (selectedRows != null && selectedRows.size() > 0) {
                    HashMap<Long, String> idNameMap = new HashMap<Long, String>(selectedRows.size());
                    List ids = selectedRows.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toList());
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_integration_map", (String)"id,name", (QFilter[])new QFilter("id", "in", ids).toArray());
                    for (DynamicObject _row : query) {
                        idNameMap.put(_row.getLong("id"), _row.getString("name"));
                    }
                    Map dimMappingRelInterScheme = DataIntegrationQueryService.getInstance().getDimMappingRelInterScheme(this.getModelId(), idNameMap.keySet());
                    if (!dimMappingRelInterScheme.isEmpty()) {
                        HashSet integrationSchemeIds = new HashSet(16);
                        dimMappingRelInterScheme.values().forEach(integrationSchemeIds::addAll);
                        HashMap schemeIdNameMap = new HashMap(16);
                        LinkedList mapList = new LinkedList();
                        QueryServiceHelper.query((String)"eb_integration", (String)"id,name", (QFilter[])new QFilter("id", "in", integrationSchemeIds).toArray()).forEach(obj -> schemeIdNameMap.put(obj.getLong("id"), obj.getString("name")));
                        dimMappingRelInterScheme.forEach((mapId, schemeIds) -> {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = idNameMap.get(mapId);
                            objectArray[1] = schemeIds.stream().map(schemeIdNameMap::get).collect(Collectors.joining(","));
                            mapList.add(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u6210\u6210\u5458\u6620\u5c04\u65b9\u6848(%1)\u88ab\u6570\u636e\u91c7\u96c6\u6216\u8005\u8f93\u51fa\u65b9\u6848(%2)\u5f15\u7528", (String)"MbgDataIntegrationMapDeleteValidator_0", (String)"epm-eb-formplugin", (Object[])objectArray));
                        });
                        this.getView().showTipNotification(StringUtils.join(mapList, (char)','));
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664?", (String)"DataIntegrationMapListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del_data", (IFormPlugin)this));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"DataIntegrationMapListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (MessageBoxResult.Yes != event.getResult()) {
            return;
        }
        String callBackId = event.getCallBackId();
        if ("del_data".equals(callBackId)) {
            this.deleteDimensionMap();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DataSetListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if ("delete_comfirm".equals(callBackId)) {
            Map<String, Object> focusNode = this.getFocusNode();
            Object id = focusNode.get("id");
            QFilter ctIdQf = new QFilter(MODELID, "=", (Object)this.getModelId());
            ctIdQf.and(new QFilter("id", "in", (Object)Long.valueOf(id.toString())));
            DeleteServiceHelper.delete((String)"eb_integration_mapcat", (QFilter[])ctIdQf.toArray());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DataSetListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refreshTree(this.getModelId());
        }
    }

    private void deleteDimensionMap() {
        TreeView treeView = (TreeView)this.getControl(MAPCATTREE);
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        QFilter ctIdQf = new QFilter(MODELID, "=", (Object)this.getModelId());
        Long capId = Convert.toLong((Object)focusNodeId);
        if (this.notEmpty(capId)) {
            ctIdQf.and(new QFilter("mapcat", "=", (Object)capId));
        }
        ctIdQf.and(new QFilter("id", "in", (Object)primaryKeyValues));
        DeleteServiceHelper.delete((String)"eb_integration_map", (QFilter[])ctIdQf.toArray());
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.Integration_Mapping.getType(), IDUtils.toLongs((Object[])primaryKeyValues)});
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "AbstractMultiReportPlugin_60", "epm-eb-budget"), new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u6210\u5458\u6620\u5220\u9664\u6210\u529f", "AbstractMultiReportPlugin_151", "epm-eb-budget"));
        treeView.treeNodeClick(this.getPageCache().get("parent"), this.getPageCache().get("nodeid"));
        this.refrushBillList();
    }

    private void refreshBill() {
        TreeView treeView = (TreeView)this.getControl(MAPCATTREE);
        treeView.treeNodeClick(this.getPageCache().get("parent"), this.getPageCache().get("nodeid"));
        this.refrushBillList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODELID.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODELID);
            Long modelId = model != null ? model.getLong("id") : 0L;
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            this.refreshTree(modelId);
            this.refreshBill();
        }
    }

    private void openAddDimenMap(Map<String, Object> focusNode) {
        if (focusNode.get("id").equals("0") && focusNode.get("text").equals(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u7c7b", (String)"DataIntegrationMapListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"DataIntegrationMapListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            Long modelid = this.getModelId();
            if (IDUtils.isNull((Long)modelid)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataIntegrationMapListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            TreeView treeView = (TreeView)this.getControl(MAPCATTREE);
            String catelogId = treeView.getTreeState().getFocusNodeId();
            if (StringUtils.isEmpty((String)catelogId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7ef4\u5ea6\u6620\u5c04\u5206\u7c7b\u3002", (String)"DataIntegrationMapListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("treeId", focusNode.get("id").toString());
            EASDataIntegrationUtil.openMemberMapBaseForm((IFormView)this.getView(), (IFormPlugin)this, null, (String)focusNode.get("id").toString(), (Long)modelid, (BaseFormLockType)BaseFormLockType.NOT);
        }
    }

    private void showAddCatForm() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODELID);
        if (model == null || model.getLong("id") < 1L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataIntegrationMapListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map<String, Object> focusNode = this.getFocusNode();
        String parentId = (String)focusNode.get("id");
        QFBuilder builder = new QFBuilder();
        builder.add(MODELID, "=", (Object)this.getModelId());
        builder.add("mapcat", "=", (Object)Long.valueOf(parentId));
        boolean existData = QueryServiceHelper.exists((String)"eb_integration_map", (QFilter[])builder.toArrays());
        if (existData) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u65b0\u589e\u5206\u7c7b\u3002", (String)"DataIntegrationMapListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("eb_integration_mapcat");
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCustomParam(MODELID, (Object)model.getLong("id"));
        fsp.setCustomParam("parentid", (Object)parentId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTTION_ADD_CAT));
        this.getView().showForm(fsp);
    }

    public Map<String, Object> getFocusNode() {
        TreeView treeView = (TreeView)this.getControl(MAPCATTREE);
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (focusNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6620\u5c04\u5206\u7c7b\u3002", (String)"DataIntegrationMapListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return focusNode;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("dimenMap".equals(actionId)) {
            this.openMemberMapEditForm(e.getReturnData());
        } else if (ACTTION_ADD_CAT.equals(actionId)) {
            this.refreshTree(this.getModelId());
            TreeView treeView = (TreeView)this.getControl(MAPCATTREE);
            treeView.treeNodeClick(this.getPageCache().get("parent"), this.getPageCache().get("nodeid"));
            this.refrushBillList();
        } else if ("dimenMapNew".equals(actionId)) {
            this.refrushBillList();
        }
    }

    public void openMemberMapEditForm(Object backData) {
        if (this.isEmpty(backData)) {
            return;
        }
        DataIntegrationDimMapBaseInfo mapBaseInfo = (DataIntegrationDimMapBaseInfo)ObjectSerialUtil.deSerializedBytes((String)((String)backData));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_integration_map");
        formShowParameter.setShowTitle(Boolean.TRUE.booleanValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        mapBaseInfo.setModelId(this.getModelId());
        mapBaseInfo.setMapCatId(Long.valueOf(this.getPageCache().get("treeId")));
        formShowParameter.setCustomParam("MapCatBaseInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)mapBaseInfo));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimenMapNew"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODELID);
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (key.equals(MODELID)) {
            PluginUtils.setModelFilter(e, this.getView());
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)e);
        }
    }
}

