/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.dataintegration.entity.BaseFormLockType;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMapBaseInfo;
import kd.epm.eb.business.dataintegration.entity.EntryFieldType;
import kd.epm.eb.business.dataintegration.entity.syssetting.EasSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.EbSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.DynamicCreate.CreateItemApHelper;
import kd.epm.eb.common.DynamicCreate.FieldItemType;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.MemberMapF7ValPojo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.PCPage.ParentPageHandler;
import kd.epm.eb.formplugin.PCPage.event.PCPageEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.CellClickEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.CheckRefBizFieldEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.DataChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.EmptyRowEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.EntryNewRowEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.F7ClickCallBackEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.GetBizFieldKeysEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.MulBizFieldBoxChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.RefBizFieldBoxChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.SysSettingChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.SysSettingSelEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.UpBizFieldListEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.UpBizFieldValEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.UpdateAcctOrgShowEvent;
import kd.epm.eb.formplugin.billimpexp.star.BillExportStart;
import kd.epm.eb.formplugin.billimpexp.util.BillImpExpStarFactory;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationMapPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ParentPageHandler {
    private static final String TOOLBARID = "toolbarap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String targetPanelKey = "targetsyspanel";
    private static final String sourcePanelKey = "sourcesyspanel";
    private boolean lockSysForm = false;
    private boolean needCheckRefField = true;

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBaseInfo();
        this.loadSysSettingForm();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.checkQuoteAndLockPanel();
        this.loadSysSettingForm();
    }

    private void checkQuoteAndLockPanel() {
        Long id = (Long)this.getValue("id", null);
        Map dimMappingRelInterScheme = DataIntegrationQueryService.getInstance().getDimMappingRelInterScheme(this.getmodelId(), Collections.singletonList(id));
        if (this.notEmpty(dimMappingRelInterScheme)) {
            this.lockSysForm = true;
        }
    }

    private void updateItemStatus() {
        this.updateEntryShow();
        IntegrationSchemeType schemeType = this.getSchemeType();
        DataIntegrationType type = this.getType();
        this.getView().setVisible(Boolean.valueOf(EASDataIntegrationUtil.showRangeCol((DataIntegrationType)type, (IntegrationSchemeType)schemeType)), new String[]{"scope"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acctorgname", "acctorgnumber", "acctorggroupap"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"refacctorgname", "refacctorgnumber", "refacctorggroupap"});
    }

    private void updateEntryShow() {
        IntegrationSchemeType schemeType = this.getSchemeType();
        DataIntegrationType type = this.getType();
        Pair<String, Boolean> fieldGroupInfo = type == DataIntegrationType.OUTPUT && schemeType == IntegrationSchemeType.CUSTOM ? this.getFieldGroupInfoByScheme(IntegrationSchemeType.EB) : this.getFieldGroupInfoByScheme(schemeType);
        EntryAp entryAp = CreateItemApHelper.createEntryAp((String)ENTRYENTITY);
        FieldAp bizFieldCol = CreateItemApHelper.getFieldAp((String)"bizfieldcol", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5b57\u6bb5\uff08\u6e90\uff09", (String)"DataIntegrationMapPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]), (boolean)true, (FieldItemType)FieldItemType.COMBO);
        entryAp.getItems().add(bizFieldCol);
        entryAp.getItems().add(this.buildItemGroup(fieldGroupInfo, true));
        FieldAp rangeAp = CreateItemApHelper.getFieldAp((String)"scope", (String)ResManager.loadKDString((String)"\u8303\u56f4", (String)"DataIntegrationMapPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]), (boolean)true, (FieldItemType)FieldItemType.COMBO);
        rangeAp.getField().setMustInput(true);
        ((ComboField)rangeAp.getField()).setItems(this.getRangeList());
        entryAp.getItems().add(rangeAp);
        FieldAp idAp = CreateItemApHelper.getFieldAp((String)"sourceid", (String)"idcol", (boolean)true, (FieldItemType)FieldItemType.NUMBER);
        idAp.setHidden(true);
        entryAp.getItems().add(idAp);
        EntryFieldGroupAp orgGroupAp = this.buildItemGroup("acctorggroupap", "acctorgname", "acctorgnumber", ResManager.loadKDString((String)"\u79d1\u76ee\u521b\u5efa\u7ec4\u7ec7\uff08\u6e90\uff09", (String)"MemberMapImpExpHandler_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), false);
        orgGroupAp.getItems().forEach(item -> item.setLock("new,edit,view"));
        entryAp.getItems().add(orgGroupAp);
        EntryFieldGroupAp assistGroupAp = this.buildItemGroup("assistgroupap", "assistname", "assistnumber", ResManager.loadResFormat((String)"\u8f85\u52a9%1\uff08\u6e90\uff09", (String)"DataIntegrationMapPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{fieldGroupInfo.p1}), (Boolean)fieldGroupInfo.p2);
        entryAp.getItems().add(assistGroupAp);
        FieldAp refIdAp = CreateItemApHelper.getFieldAp((String)"assistid", (String)"refidcol", (boolean)true, (FieldItemType)FieldItemType.NUMBER);
        refIdAp.setHidden(true);
        entryAp.getItems().add(refIdAp);
        EntryFieldGroupAp refOrgGroupAp = this.buildItemGroup("refacctorggroupap", "refacctorgname", "refacctorgnumber", ResManager.loadKDString((String)"\u8f85\u52a9\u79d1\u76ee\u521b\u5efa\u7ec4\u7ec7\uff08\u6e90\uff09", (String)"MemberMapImpExpHandler_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), false);
        refOrgGroupAp.getItems().forEach(item -> item.setLock("new,edit,view"));
        entryAp.getItems().add(refOrgGroupAp);
        Pair<String, Boolean> targetFieldGroupInfo = type == DataIntegrationType.OUTPUT && schemeType == IntegrationSchemeType.CUSTOM ? this.getFieldGroupInfoByScheme(IntegrationSchemeType.CUSTOM) : this.getFieldGroupInfoByScheme(IntegrationSchemeType.EB);
        entryAp.getItems().add(this.buildItemGroup(targetFieldGroupInfo, false));
        entryAp.getItems().add(CreateItemApHelper.getFieldAp((String)"state", (String)ResManager.loadKDString((String)"\u72b6\u6001", (String)"DataIntegrationMapPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]), (boolean)true, (FieldItemType)FieldItemType.CHECKBO));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map control = entryAp.createControl();
        clientViewProxy.preInvokeControlMethod(entryAp.getKey(), "createGridColumns", new Object[]{control});
    }

    private List<ComboItem> getRangeList() {
        ArrayList<ComboItem> rangeList = new ArrayList<ComboItem>(3);
        rangeList.add(new ComboItem(0, new LocaleString(RangeEnum.ONLY.getName()), String.valueOf(RangeEnum.ONLY.getIndex())));
        rangeList.add(new ComboItem(1, new LocaleString(RangeEnum.ALL.getName()), String.valueOf(RangeEnum.ALL.getIndex())));
        rangeList.add(new ComboItem(2, new LocaleString(RangeEnum.ALL_EXCLUDE.getName()), String.valueOf(RangeEnum.ALL_EXCLUDE.getIndex())));
        return rangeList;
    }

    private Pair<String, Boolean> getFieldGroupInfoByScheme(IntegrationSchemeType schemeType) {
        return EASDataIntegrationUtil.getFieldGroupInfoByScheme((IntegrationSchemeType)schemeType);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARID, "advcontoolbarap"});
        this.addClickListeners(new String[]{"sourcename", "assistname", "targetname"});
        this.addItemClickListeners(new String[]{"btn_addrow", "btn_delrow", "btn_import", "btn_export"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void setBaseInfo() {
        DataIntegrationDimMapBaseInfo mapInfo = EASDataIntegrationUtil.getOrSelMapInfo((boolean)false, (IFormView)this.getView());
        this.setBaseInfo(mapInfo);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("dimenMap".equals(actionId) && returnData != null) {
            DataIntegrationDimMapBaseInfo mapBaseInfo = (DataIntegrationDimMapBaseInfo)ObjectSerialUtil.deSerializedBytes((String)((String)returnData));
            this.setBaseInfo(mapBaseInfo);
        } else if ("importExcel".equals(actionId)) {
            this.afterImportData();
        }
    }

    private void afterImportData() {
        IntegrationSchemeType schemeType = this.getSchemeType();
        DataIntegrationType type = this.getType();
        if (schemeType == IntegrationSchemeType.CUSTOM && type == DataIntegrationType.INPUT) {
            Set<String> allBizField = this.selAllBizField();
            CheckRefBizFieldEvent event = new CheckRefBizFieldEvent();
            event.setBizFieldsVal(allBizField);
            this.callChildes(event);
        }
    }

    public void setBaseInfo(DataIntegrationDimMapBaseInfo mapInfo) {
        if (mapInfo != null) {
            IDataModel dataModel = this.getModel();
            dataModel.setValue("number", (Object)mapInfo.getNumber());
            dataModel.setValue("name", (Object)mapInfo.getName());
            dataModel.setValue("type", (Object)mapInfo.getIntegrationType().getVal());
            dataModel.setValue("schemetype", (Object)mapInfo.getSchemeType().getVal());
            if (this.notEmpty(mapInfo.getModelId())) {
                dataModel.setValue("modelid", (Object)mapInfo.getModelId());
            }
            if (this.notEmpty(mapInfo.getMapCatId())) {
                dataModel.setValue("mapcat", (Object)mapInfo.getMapCatId());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("closeConfirm".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.markValChanged(false);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateItemStatus();
        this.markValChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
        if (this.hasValChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u6570\u636e\u53d8\u52a8\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff1f", (String)"DataIntegrationMapPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closeConfirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("bizfieldcol".equals(propName)) {
            this.delBizFieldColChange((String)newVal);
        } else if (propName.endsWith("name") && this.isEmpty(newVal)) {
            this.delMemberNameDel(propName, rowIndex);
        }
        this.markValChanged(true);
    }

    private void delMemberNameDel(String fieldKey, int rowIndex) {
        DataIntegrationType type = this.getType();
        IntegrationSchemeType schemeType = this.getSchemeType();
        if (schemeType == IntegrationSchemeType.CUSTOM && (type == DataIntegrationType.INPUT && ("sourcename".equals(fieldKey) || "assistname".equals(fieldKey)) || type == DataIntegrationType.OUTPUT && "targetname".equals(fieldKey))) {
            return;
        }
        String numberKey = this.getMemberColKey(fieldKey, true);
        this.getModel().setValue(numberKey, null, rowIndex);
        if (this.isSourceCol(fieldKey)) {
            this.getModel().setValue("sourceid", null, rowIndex);
            this.getModel().setValue("acctorgname", null, rowIndex);
        } else if ("assistname".equals(fieldKey)) {
            this.getModel().setValue("assistid", null, rowIndex);
            this.getModel().setValue("refacctorgname", null, rowIndex);
        }
    }

    private boolean isSourceCol(String colKey) {
        return this.notEmpty(colKey) && colKey.startsWith("source");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String name = e.getEntryProp().getName();
        if (ENTRYENTITY.equals(name)) {
            int insertRow = e.getInsertRow();
            EntryNewRowEvent newRowEvent = new EntryNewRowEvent(insertRow);
            newRowEvent.setTargetContainerKey(sourcePanelKey);
            this.callChildes(newRowEvent);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int entryRowCount;
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (ENTRYENTITY.equals(name) && (entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY)) == 0) {
            EmptyRowEvent event = new EmptyRowEvent();
            event.setTargetContainerKey(sourcePanelKey);
            this.callChildes(event);
        }
    }

    private void delBizFieldColChange(String newValue) {
        this.checkRefBizField(this.isEmpty(newValue) ? Collections.emptySet() : Sets.newHashSet((Object[])new String[]{newValue}));
    }

    private void checkRefBizField(Set<String> bizFieldsVal) {
        if (this.needCheckRefField) {
            CheckRefBizFieldEvent fieldEvent = new CheckRefBizFieldEvent();
            fieldEvent.setBizFieldsVal(bizFieldsVal);
            fieldEvent.setTargetContainerKey(sourcePanelKey);
            this.callChildes(fieldEvent);
        }
    }

    private void dealOpenMultBizField(MulBizFieldBoxChangeEvent event) {
        boolean open = event.isOpen();
        this.getView().setVisible(Boolean.valueOf(open), new String[]{"bizfieldcol"});
        if (!open && !event.isInit()) {
            this.clearColsVal("bizfieldcol");
        }
    }

    private void dealOpenAssistBizField(RefBizFieldBoxChangeEvent event) {
        boolean open = event.isOpen();
        this.getView().setVisible(Boolean.valueOf(open), new String[]{"assistnumber", "assistname", "assistgroupap"});
        if (!open && !event.isInit()) {
            this.clearColsVal("assistnumber", "assistname");
        }
    }

    private void loadSysSettingForm() {
        DataIntegrationType type = this.getType();
        IntegrationSchemeType schemeType = this.getSchemeType();
        if (type == DataIntegrationType.INPUT) {
            this.loadSystemForm(schemeType, true);
            this.loadSystemForm(IntegrationSchemeType.EB, false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{targetPanelKey});
        } else {
            this.loadSystemForm(IntegrationSchemeType.EB, true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{targetPanelKey});
        }
    }

    private void loadSystemForm(IntegrationSchemeType schemeType, boolean isSourceSystem) {
        String settingInfo = isSourceSystem ? (String)this.getValue("sourcesysinfo", null) : (String)this.getValue("targetsysinfo", null);
        boolean isInputScheme = DataIntegrationType.INPUT.getVal().equals(this.getValue("type", null));
        this.loadChildForm(schemeType.getSysFormKey(), isSourceSystem ? sourcePanelKey : targetPanelKey, form -> {
            form.setCustomParam("isSourceSystem", (Object)String.valueOf(isSourceSystem));
            form.setCustomParam("isInputScheme", (Object)String.valueOf(isInputScheme));
            form.setCustomParam("SystemSetting", (Object)settingInfo);
            form.setCustomParam("SchemeType", (Object)schemeType.getVal());
            form.setCustomParam("ModelId", (Object)String.valueOf(this.getModelId()));
            form.setCustomParam("lockAll", (Object)String.valueOf(this.lockSysForm));
        });
    }

    private void clearColsVal(String ... cols) {
        if (this.notEmpty(cols)) {
            this.batUpEntryColVal(false, cols, null);
        }
    }

    private EntryFieldGroupAp buildItemGroup(Pair<String, Boolean> fieldGroupInfo, boolean isSource) {
        String numberKey;
        String nameKey;
        String groupKey;
        String groupName = (String)fieldGroupInfo.p1;
        boolean setNumberEditBox = (Boolean)fieldGroupInfo.p2;
        if (isSource) {
            groupKey = "sourcegroupap";
            nameKey = "sourcename";
            numberKey = "sourcenumber";
            groupName = ResManager.loadResFormat((String)"%1\uff08\u6e90\uff09", (String)"DataIntegrationMapPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{groupName});
        } else {
            groupKey = "targetgroupap";
            nameKey = "targetname";
            numberKey = "targetnumber";
            groupName = ResManager.loadResFormat((String)"%1\uff08\u76ee\u6807\uff09", (String)"DataIntegrationMapPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{groupName});
        }
        return this.buildItemGroup(groupKey, nameKey, numberKey, groupName, setNumberEditBox);
    }

    private EntryFieldGroupAp buildItemGroup(String groupKey, String nameKey, String numberKey, String groupName, boolean setNumberEditBox) {
        EntryFieldGroupAp groupAp = new EntryFieldGroupAp();
        groupAp.setKey(groupKey);
        groupAp.setId(groupKey);
        groupAp.setName(new LocaleString(groupName));
        FieldAp nameAp = CreateItemApHelper.getFieldAp((String)nameKey, (String)ResManager.loadKDString((String)"\u540d\u79f0", (String)"DataIntegrationMapPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]), (boolean)true, (FieldItemType)FieldItemType.TEXT);
        FieldAp numberAp = CreateItemApHelper.getFieldAp((String)numberKey, (String)ResManager.loadKDString((String)"\u7f16\u7801", (String)"DataIntegrationMapPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), (boolean)true, (FieldItemType)FieldItemType.TEXT);
        numberAp.getField().setMustInput(!"assistnumber".equals(numberKey));
        if (setNumberEditBox) {
            ((TextField)nameAp.getField()).setEditStyle(1);
            numberAp.setLock("new,edit,view");
        } else {
            ((TextField)nameAp.getField()).setEditStyle(0);
        }
        ((TextField)nameAp.getField()).setMaxLength(200);
        ((TextField)numberAp.getField()).setMaxLength(100);
        groupAp.getItems().add(nameAp);
        groupAp.getItems().add(numberAp);
        return groupAp;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.saveDimMemberMap();
                break;
            }
            case "btn_addrow": {
                this.getModel().createNewEntryRow(ENTRYENTITY);
                break;
            }
            case "btn_delrow": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DataIntegrationMapPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
                break;
            }
            case "btn_import": {
                this.importExcel();
                break;
            }
            case "btn_export": {
                this.exportExcel();
                break;
            }
            case "btn_baseinfo": {
                Long id = (Long)this.getValue("id", null);
                BaseFormLockType lockType = this.isEmpty(id) ? BaseFormLockType.TYPE : BaseFormLockType.TYPEANDNAME;
                EASDataIntegrationUtil.openMemberMapBaseForm((IFormView)this.getView(), (IFormPlugin)this, (DataIntegrationDimMapBaseInfo)EASDataIntegrationUtil.getOrSelMapInfo((boolean)true, (IFormView)this.getView()), null, (Long)this.getModelId(), (BaseFormLockType)lockType);
                break;
            }
        }
    }

    private void importExcel() {
        SysSettingInfo targetSysSetting;
        SysSettingInfo sourceSysSetting;
        try {
            sourceSysSetting = this.getSystemSetting(true);
            targetSysSetting = this.getSystemSetting(false);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("type", this.getType().getVal());
        param.put("scheme", this.getSchemeType().getVal());
        param.put("model", this.getModelId());
        if (sourceSysSetting != null) {
            param.put("sourceSysSetting", EASDataIntegrationUtil.serSysSetting((SysSettingInfo)sourceSysSetting, (String[])new String[0]));
        }
        if (targetSysSetting != null) {
            param.put("targetSysSetting", EASDataIntegrationUtil.serSysSetting((SysSettingInfo)targetSysSetting, (String[])new String[0]));
        }
        param.put("importCategory", "EntryEntity");
        param.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.dataintegration.plugin.syssetting.MemberMapImportHandler");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importExcel");
        BillImpExpUtils.openImportPage((IFormView)this.getView(), (String)ENTRYENTITY, (String)ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u6210\u5458\u6620\u5c04", (String)"DataIntegrationMapPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]), param, (CloseCallBack)closeCallBack);
    }

    private void exportExcel() {
        SysSettingInfo targetSysSetting;
        SysSettingInfo sourceSysSetting;
        try {
            sourceSysSetting = this.getSystemSetting(true);
            targetSysSetting = this.getSystemSetting(false);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("type", this.getType().getVal());
        param.put("scheme", this.getSchemeType().getVal());
        if (sourceSysSetting != null) {
            param.put("sourceSysSetting", EASDataIntegrationUtil.serSysSetting((SysSettingInfo)sourceSysSetting, (String[])new String[0]));
        }
        if (targetSysSetting != null) {
            param.put("targetSysSetting", EASDataIntegrationUtil.serSysSetting((SysSettingInfo)targetSysSetting, (String[])new String[0]));
        }
        param.put("exportCategory", "EntryEntity");
        param.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.dataintegration.plugin.syssetting.MemberMapExportHandler");
        BillExportStart exportStart = BillImpExpStarFactory.getExportStart(ENTRYENTITY, param);
        exportStart.exportData(this.getView(), param);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (this.notEmpty(key) && key.endsWith("name")) {
            this.dealCellClick(key);
        }
    }

    private void dealCellClick(String colKey) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRYENTITY, currentRowIndex);
        boolean isRef = colKey.startsWith("assist");
        CellClickEvent event = new CellClickEvent(currentRowIndex, colKey, isRef);
        if (colKey.endsWith("name")) {
            String numberVal = rowInfo.getString(this.getMemberColKey(colKey, true));
            event.setCurrentNumbVal(numberVal);
        }
        event.setTargetContainerKey(colKey.startsWith("target") ? targetPanelKey : sourcePanelKey);
        this.callChildes(event);
    }

    private String getMemberColKey(String sourceKey, boolean toNumber) {
        return toNumber ? sourceKey.replace("name", "number") : sourceKey.replace("number", "name");
    }

    @Override
    public Long getModelId() {
        return this.getmodelId();
    }

    private Long getmodelId() {
        Object modelObj = this.getModel().getValue("modelid");
        if (modelObj != null) {
            return ((DynamicObject)modelObj).getLong("id");
        }
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
    }

    private void saveDimMemberMap() {
        List<MemberQuoteDao> memberQuoteDaoList;
        Object targetSysSetting;
        try {
            this.checkNumber((String)this.getValue("number", null));
            SysSettingInfo sourceSysSetting = this.getSystemSetting(true);
            targetSysSetting = this.getSystemSetting(false);
            memberQuoteDaoList = this.checkMapEntryAndSelQ(sourceSysSetting, (SysSettingInfo)targetSysSetting);
            this.fillBackInfoB4Save(sourceSysSetting, (SysSettingInfo)targetSysSetting);
            this.markValChanged(false);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        TXHandle txHandle = TX.required((String)"DataIntegrationMap");
        targetSysSetting = null;
        try {
            try {
                DynamicObject obj = this.getModel().getDataEntity(true);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                if (this.notEmpty(memberQuoteDaoList)) {
                    Long sourceId = obj.getLong("id");
                    memberQuoteDaoList.forEach(q -> q.setResourceId(sourceId));
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{memberQuoteDaoList});
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"DataIntegrationMapPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Throwable throwable) {
            targetSysSetting = throwable;
            throw throwable;
        }
        finally {
            if (txHandle != null) {
                if (targetSysSetting != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)targetSysSetting).addSuppressed(throwable);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ExecuteAnalyze_16", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u6210\u5458\u6620\u5c04\u4fdd\u5b58\u6210\u529f", "AbstractMultiReportPlugin_143", "epm-eb-budget");
        this.writeLog(null, "save", opName, opDesc, null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DataIntegrationMapPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void fillBackInfoB4Save(SysSettingInfo sourceSettingInfo, SysSettingInfo targetSettingInfo) {
        IDataModel dataModel = this.getModel();
        Long dimId = null;
        if (this.getType() == DataIntegrationType.OUTPUT) {
            if (sourceSettingInfo instanceof EbSysSetting) {
                dimId = ((EbSysSetting)sourceSettingInfo).getDim();
            }
        } else if (targetSettingInfo instanceof EbSysSetting) {
            dimId = ((EbSysSetting)targetSettingInfo).getDim();
        }
        String sourceInfoStr = null;
        String targetInfoStr = null;
        if (sourceSettingInfo != null) {
            sourceInfoStr = EASDataIntegrationUtil.serSysSetting((SysSettingInfo)sourceSettingInfo, (String[])new String[0]);
        }
        if (targetSettingInfo != null) {
            targetInfoStr = EASDataIntegrationUtil.serSysSetting((SysSettingInfo)targetSettingInfo, (String[])new String[0]);
        }
        dataModel.setValue("tdim", (Object)dimId);
        dataModel.setValue("sourcesysinfo", (Object)sourceInfoStr);
        dataModel.setValue("targetsysinfo", (Object)targetInfoStr);
    }

    private SysSettingInfo getSystemSetting(boolean isSource) {
        SysSettingSelEvent event = new SysSettingSelEvent();
        event.setTargetContainerKey(isSource ? sourcePanelKey : targetPanelKey);
        this.callChildes(event);
        return event.getResult();
    }

    private void checkNumber(String schemeName) {
        String errorInfo = NumberCheckUtils.checkNumberRule((String)((String)this.getModel().getValue("number")));
        if (this.notEmpty(errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        QFilter ctIdQf = new QFilter("modelid", "=", (Object)this.getmodelId());
        ctIdQf.and(new QFilter("number", "=", (Object)schemeName));
        ctIdQf.and(new QFilter("id", "!=", this.getValue("id", null)));
        if (QueryServiceHelper.exists((String)"eb_integration_map", (QFilter[])new QFilter[]{ctIdQf})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u65b9\u6848\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DataIntegrationMapPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private List<MemberQuoteDao> checkMapEntryAndSelQ(SysSettingInfo sourceSysSetting, SysSettingInfo targetSysSetting) {
        MemberQuoteDao memberQuoteDao;
        ArrayList<MemberQuoteDao> memberQuoteDaoList = new ArrayList<MemberQuoteDao>(16);
        if (sourceSysSetting == null) {
            return memberQuoteDaoList;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataIntegrationMapPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Integer> existSourceInfo = new HashMap<String, Integer>(entryEntity.size());
        int rowIndex = 1;
        boolean checkBizField = sourceSysSetting instanceof EasSysSetting && ((EasSysSetting)sourceSysSetting).isUseMulBizField();
        boolean checkRef = sourceSysSetting.isUseRefField();
        boolean ebOnSource = this.getSchemeType() == IntegrationSchemeType.EB;
        LinkedList<String> dimMembers = new LinkedList<String>();
        LinkedList<String> refDimMembers = new LinkedList<String>();
        HashSet<String> bizFieldKeys = new HashSet<String>(16);
        boolean showRange = EASDataIntegrationUtil.showRangeCol((DataIntegrationType)this.getType(), (IntegrationSchemeType)this.getSchemeType());
        for (DynamicObject row : entryEntity) {
            String rangeStr;
            String sourceNumber = row.getString("sourcenumber");
            String targetNumber = row.getString("targetnumber");
            String acctOrgNumber = row.getString("acctorgnumber");
            String bizFieldKey = row.getString("bizfieldcol");
            String string = rangeStr = showRange ? row.getString("scope") : null;
            if (bizFieldKey == null) {
                bizFieldKey = "";
            }
            if (rangeStr == null) {
                rangeStr = "";
            }
            if (acctOrgNumber == null) {
                acctOrgNumber = "";
            }
            boolean anyBlank1 = StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sourceNumber, targetNumber});
            boolean anyBlank2 = checkBizField && this.isEmpty(bizFieldKey);
            bizFieldKeys.add(bizFieldKey);
            String rowStr = rangeStr + "!" + bizFieldKey + "!" + sourceNumber + "!" + acctOrgNumber;
            if (checkRef) {
                String refNumber = row.getString("assistnumber");
                rowStr = rowStr + "!" + refNumber;
                if (ebOnSource) {
                    refDimMembers.add(refNumber);
                }
            }
            if (anyBlank1 || anyBlank2) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6574", (String)"DataIntegrationMapPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex}));
            }
            Integer existRowIndex = existSourceInfo.put(rowStr, rowIndex);
            if (existRowIndex != null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u7684\u6e90\u7f16\u7801\u914d\u7f6e\u51b2\u7a81", (String)"DataIntegrationMapPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[]{existRowIndex, rowIndex}));
            }
            dimMembers.add(ebOnSource ? sourceNumber : targetNumber);
            ++rowIndex;
        }
        this.checkBizFieldContains(bizFieldKeys);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        if (dimMembers.size() > 0 && (memberQuoteDao = this.toQuoteInfo(modelCacheHelper, dimMembers, ebOnSource ? sourceSysSetting : targetSysSetting, false)) != null) {
            memberQuoteDaoList.add(memberQuoteDao);
        }
        if (refDimMembers.size() > 0 && (memberQuoteDao = this.toQuoteInfo(modelCacheHelper, refDimMembers, sourceSysSetting, true)) != null) {
            memberQuoteDaoList.add(memberQuoteDao);
        }
        return memberQuoteDaoList;
    }

    private void checkBizFieldContains(Set<String> bizFieldKeys) {
        Map refSchemeInfo;
        bizFieldKeys.remove(null);
        bizFieldKeys.remove("");
        if (bizFieldKeys.isEmpty()) {
            return;
        }
        IntegrationSchemeType schemeType = this.getSchemeType();
        DataIntegrationType type = this.getType();
        if (schemeType == IntegrationSchemeType.CUSTOM && type == DataIntegrationType.INPUT && this.notEmpty(refSchemeInfo = DataIntegrationQueryService.getInstance().getCusDimMappingRelInterSchemeSourceField(this.getmodelId(), (Long)this.getValue("id", null)))) {
            for (Map.Entry entry : refSchemeInfo.entrySet()) {
                if (!Collections.disjoint(bizFieldKeys, (Collection)entry.getValue())) continue;
                String schemeName = (String)CommonServiceHelper.getValueFromDB((String)"eb_integration", (String)"name", (String)"id", (Object[])new Object[]{entry.getKey()});
                throw new KDBizException(ResManager.loadResFormat((String)"\u91c7\u96c6\u65b9\u6848\u201c%1\u201d\u4e2d\u914d\u7f6e\u7684\u4e1a\u52a1\u5b57\u6bb5\u4e0e\u5f53\u524d\u6620\u5c04\u4e2d\u7684\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u5b58\u5728\u4ea4\u96c6\uff0c\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"DataIntegrationMapPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeName}));
            }
        }
    }

    private MemberQuoteDao toQuoteInfo(IModelCacheHelper modelCacheHelper, List<String> memberNums, SysSettingInfo setting, boolean isRef) {
        MemberQuoteDao quoteDao = null;
        if (setting instanceof EbSysSetting) {
            List memberIds;
            EbSysSetting ebSysSetting = (EbSysSetting)setting;
            Long viewId = ebSysSetting.getView();
            Dimension dimension = modelCacheHelper.getDimension(isRef ? ebSysSetting.getRefDim() : ebSysSetting.getDim());
            if (dimension != null && (memberIds = dimension.getMemberByNumbers(viewId, memberNums).stream().map(BaseCache::getId).collect(Collectors.toList())).size() > 0) {
                Long datasetId;
                Long l = datasetId = isRef ? ebSysSetting.getRefDataset() : ebSysSetting.getDataset();
                if (datasetId == null) {
                    datasetId = 0L;
                }
                quoteDao = new MemberQuoteDao(modelCacheHelper.getModelobj().getId(), datasetId, dimension.getId(), memberIds, MemberQuoteResourceEnum.Integration_Mapping, Long.valueOf(0L));
            }
        }
        return quoteDao;
    }

    private DataIntegrationType getType() {
        String typeVal = (String)this.getValue("type", null);
        return DataIntegrationType.getTypeByVal((String)typeVal);
    }

    private IntegrationSchemeType getSchemeType() {
        String typeVal = (String)this.getValue("schemetype", null);
        return IntegrationSchemeType.getTypeByVal((String)typeVal);
    }

    @Override
    public void onCall(PCPageEvent event) {
        if (event instanceof RefBizFieldBoxChangeEvent) {
            this.dealOpenAssistBizField((RefBizFieldBoxChangeEvent)event);
        } else if (event instanceof MulBizFieldBoxChangeEvent) {
            this.dealOpenMultBizField((MulBizFieldBoxChangeEvent)event);
        } else if (event instanceof UpBizFieldListEvent) {
            this.updateBizFieldList((UpBizFieldListEvent)event);
        } else if (event instanceof F7ClickCallBackEvent) {
            this.dealF7ClickCallBack((F7ClickCallBackEvent)event);
        } else if (event instanceof SysSettingChangeEvent) {
            this.dealSysSettingChange((SysSettingChangeEvent)event);
        } else if (event instanceof UpBizFieldValEvent) {
            this.updateBizFiledColVal((UpBizFieldValEvent)event);
        } else if (event instanceof GetBizFieldKeysEvent) {
            GetBizFieldKeysEvent keysEvent = (GetBizFieldKeysEvent)event;
            Set<String> allBizField = this.selAllBizField();
            keysEvent.setBizFieldKeys(allBizField);
        } else if (event instanceof DataChangeEvent) {
            this.markValChanged(true);
        } else if (event instanceof UpdateAcctOrgShowEvent) {
            this.updateAcctOrgShow((UpdateAcctOrgShowEvent)event);
        }
    }

    private void updateAcctOrgShow(UpdateAcctOrgShowEvent event) {
        boolean showCol = event.isShowCol();
        if (event.isRef()) {
            this.getView().setVisible(Boolean.valueOf(showCol), new String[]{"refacctorgnumber", "refacctorgname", "refacctorggroupap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(showCol), new String[]{"acctorgnumber", "acctorgname", "acctorggroupap"});
        }
        if (!showCol && !event.isInit()) {
            if (event.isRef()) {
                this.clearColsVal("refacctorgnumber", "refacctorgname");
            } else {
                this.clearColsVal("acctorgnumber", "acctorgname");
            }
        }
    }

    private void markValChanged(boolean changed) {
        if (changed) {
            if (!this.hasValChanged()) {
                this.getPageCache().put("hasValChanged", "true");
            }
        } else {
            this.getPageCache().remove("hasValChanged");
        }
    }

    private boolean hasValChanged() {
        String result = this.getPageCache().get("hasValChanged");
        return this.notEmpty(result);
    }

    private Set<String> selAllBizField() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        HashSet<String> allKeys = new HashSet<String>(entryEntity.size());
        for (DynamicObject row : entryEntity) {
            String val = row.getString("bizfieldcol");
            if (!this.notEmpty(val)) continue;
            allKeys.add(val);
        }
        return allKeys;
    }

    private void dealSysSettingChange(SysSettingChangeEvent event) {
        EntryFieldType fieldType = event.getFieldType();
        String preKey = fieldType.name().toLowerCase();
        String nameKey = preKey + "name";
        String numberKey = preKey + "number";
        if (fieldType == EntryFieldType.SOURCE) {
            this.batUpEntryColVal(true, new String[]{nameKey, numberKey, "sourceid"}, null);
        } else if (fieldType == EntryFieldType.ASSIST) {
            this.batUpEntryColVal(true, new String[]{nameKey, numberKey, "assistid"}, null);
        } else {
            this.batUpEntryColVal(true, new String[]{nameKey, numberKey}, null);
        }
    }

    private void dealF7ClickCallBack(F7ClickCallBackEvent event) {
        String nameKey = event.getColKey();
        if (this.isEmpty(nameKey) || !nameKey.endsWith("name")) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        MemberMapF7ValPojo f7Val = event.getF7Val();
        String numberKey = this.getMemberColKey(nameKey, true);
        String idKey = this.getIdKey(nameKey);
        if (f7Val != null) {
            BasedataPojo refObj;
            this.getModel().setValue(nameKey, (Object)f7Val.getName(), rowIndex);
            this.getModel().setValue(numberKey, (Object)f7Val.getNumber(), rowIndex);
            if (idKey != null) {
                this.getModel().setValue(idKey, (Object)f7Val.getId(), rowIndex);
            }
            if (nameKey.startsWith("source") && EASDataIntegrationUtil.showRangeCol((DataIntegrationType)this.getType(), (IntegrationSchemeType)this.getSchemeType())) {
                this.getModel().setValue("scope", (Object)(f7Val.isLeaf() ? RangeEnum.ONLY.getIndex() : RangeEnum.ALL.getIndex()), rowIndex);
            }
            if ((refObj = f7Val.getRefObj()) != null) {
                boolean isRef = nameKey.startsWith("assist");
                this.getModel().setValue(isRef ? "refacctorgname" : "acctorgname", (Object)refObj.getName(), rowIndex);
                this.getModel().setValue(isRef ? "refacctorgnumber" : "acctorgnumber", (Object)refObj.getNumber(), rowIndex);
            }
        }
    }

    private String getIdKey(String nameKey) {
        if (this.isEmpty(nameKey) || nameKey.startsWith("target")) {
            return null;
        }
        return nameKey.replace("name", "id");
    }

    private void updateBizFieldList(UpBizFieldListEvent event) {
        if (!event.isInit()) {
            this.batUpEntryColVal(true, new String[]{"bizfieldcol"}, new Object[]{null});
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("bizfieldcol");
        comboEdit.setComboItems(event.getFieldList());
    }

    private void updateBizFiledColVal(UpBizFieldValEvent event) {
        this.needCheckRefField = false;
        if (event.getRowIndex() != -1) {
            this.getModel().setValue("bizfieldcol", (Object)event.getFieldVal(), event.getRowIndex());
        } else {
            this.batUpEntryColVal(true, new String[]{"bizfieldcol"}, new Object[]{event.getFieldVal()});
        }
        this.needCheckRefField = true;
    }

    private void batUpEntryColVal(boolean updateCache, String[] cols, Object[] values) {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(ENTRYENTITY);
        if (this.notEmpty(entryRows)) {
            entryRows.forEach(row -> {
                for (int i = 0; i < cols.length; ++i) {
                    row.set(cols[i], values == null ? null : values[i]);
                }
            });
            if (updateCache) {
                this.getModel().updateEntryCache(entryRows);
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }
}

