/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationPlan;
import kd.epm.eb.business.dataintegration.service.DataIntegrationService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.dataintegration.entity.EasDimension;
import kd.epm.eb.formplugin.dataintegration.plugin.AbstractDataIntegrationPlugin;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationOutPlugin
extends AbstractDataIntegrationPlugin {
    private static final Log log = LogFactory.getLog(DataIntegrationOutPlugin.class);
    private static final String TARGETOBJ_KEY = "targetobj";
    private static final String DIMMAPENTITY_KEY = "dimmapentity";
    private static final String DIMSOURCENAME_KEY = "dimsourcename";
    private static final String FIXEDMEMBER_KEY = "fixedmember";
    private static final String DIMMEMBMAP_KEY = "dimmembmap";
    private static final String SOURCESYS_KEY = "sourcesys";
    private static final String METRICFIELD_KEY = "srcsinglemetric";
    private static final String PKFIELD_KEY = "pkfield";
    private static final String EASMODEL_KEY = "easmodel";
    private static final String EASEDITSTATUS_KEY = "easeditstatus";
    private static final String EASLIST_CLOSE = "easlist_close";
    private static final String EASDIMLIST_CACHE = "easdimlist_cache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{TARGETOBJ_KEY, SOURCESYS_KEY});
        this.addClickListeners(new String[]{EASMODEL_KEY});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject newDatasetObj = (DynamicObject)this.getModel().getValue("datasetid");
        this.updateMapEntity4Dataset(newDatasetObj, Boolean.FALSE);
        this.updateIntegrationRangeEntry(false);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject newDatasetObj = (DynamicObject)this.getModel().getValue("datasetid");
        this.updateMapEntity4Dataset(newDatasetObj, Boolean.FALSE);
        this.updateIntegrationRangeEntry(false);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (EASMODEL_KEY.equals(key)) {
            this.showEasListPage();
        }
    }

    private void showEasListPage() {
        DynamicObject targetsys = (DynamicObject)this.getModel().getValue("targetsys");
        if (targetsys == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u3002", (String)"DataIntegrationOutPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("eb_easlist");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EASLIST_CLOSE));
        fsp.setCustomParam("dsNumber", (Object)targetsys.getString("number"));
        this.getView().showForm(fsp);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "targetobj": {
                DynamicObject newTarObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.getModel().setValue(METRICFIELD_KEY, null);
                this.getModel().setValue(PKFIELD_KEY, null);
                this.getModel().deleteEntryData(DIMMAPENTITY_KEY);
                Long tarSysId = null;
                if (newTarObj != null) {
                    DynamicObject tarSysObj = newTarObj.getDynamicObject("group");
                    if (tarSysObj != null) {
                        tarSysId = tarSysObj.getLong("id");
                    }
                    this.updateDimMapEntity4TarObj(newTarObj);
                }
                this.getModel().setValue("targetsys", tarSysId);
                this.setTarVisible();
                break;
            }
            case "srcsinglemetric": {
                DynamicObject tarObj = (DynamicObject)this.getModel().getValue(TARGETOBJ_KEY);
                String metricField = (String)e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isNotBlank((CharSequence)metricField)) break;
                this.updateDimMapEntity4TarObj(tarObj);
                break;
            }
            case "pkfield": {
                DynamicObject tar = (DynamicObject)this.getModel().getValue(TARGETOBJ_KEY);
                String pkField = (String)e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isNotBlank((CharSequence)pkField)) break;
                this.updateDimMapEntity4TarObj(tar);
                break;
            }
            case "datasetid": {
                this.updateMapEntity4Dataset((DynamicObject)e.getChangeSet()[0].getNewValue(), Boolean.TRUE);
                this.updateIntegrationRangeEntry(true);
                break;
            }
            case "dimsourcename": {
                Object newValueSrcName = e.getChangeSet()[0].getNewValue();
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                if (newValueSrcName != null) {
                    this.getModel().setValue("dimsource", newValueSrcName, rowIndex);
                    this.getModel().setValue(DIMMEMBMAP_KEY, null, rowIndex);
                    this.getModel().setValue(FIXEDMEMBER_KEY, (Object)Boolean.FALSE, rowIndex);
                    break;
                }
                this.getModel().setValue("dimsource", null, rowIndex);
                break;
            }
            case "fixedmember": {
                Boolean fixedmember = (Boolean)e.getChangeSet()[0].getNewValue();
                int rowIndexFixedmember = e.getChangeSet()[0].getRowIndex();
                if (fixedmember != null && fixedmember.equals(Boolean.TRUE)) {
                    this.getModel().setValue(DIMMEMBMAP_KEY, null, rowIndexFixedmember);
                    this.getModel().setValue(DIMSOURCENAME_KEY, null, rowIndexFixedmember);
                    this.getView().setEnable(Boolean.TRUE, rowIndexFixedmember, new String[]{"dimmembnum"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, rowIndexFixedmember, new String[]{"dimmembnum"});
                this.getModel().setValue("dimmembnum", null, rowIndexFixedmember);
                break;
            }
            case "dimmembmap": {
                String sourcesysinfo;
                Object newDimmebMap = e.getChangeSet()[0].getNewValue();
                int rowIndexMap = e.getChangeSet()[0].getRowIndex();
                if (newDimmebMap == null) break;
                this.getModel().setValue(FIXEDMEMBER_KEY, (Object)Boolean.FALSE, rowIndexMap);
                DynamicObject dynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
                String dimNum = null;
                Long viewId = 0L;
                if (dynamicObject != null && StringUtils.isNotEmpty((CharSequence)(sourcesysinfo = dynamicObject.getString("sourcesysinfo")))) {
                    Dimension dim;
                    Map map = (Map)JSON.parseObject((String)sourcesysinfo, Map.class);
                    if (map.containsKey("view")) {
                        viewId = IDUtils.toLong(map.get("view"));
                    }
                    if (map.containsKey("dim") && (dim = this.getIModelCacheHelper().getDimension(IDUtils.toLong(map.get("dim")))) != null) {
                        dimNum = dim.getNumber();
                    }
                }
                if (!StringUtils.isNotEmpty(dimNum)) break;
                this.clearIntegrationRangeEntryWhenViewChange(dimNum, viewId);
                break;
            }
        }
    }

    private void updateMapEntity4Dataset(DynamicObject newDatasetObj, boolean needClear) {
        IDataModel dataModel = this.getModel();
        if (needClear) {
            int dimMampEntityRowCount = dataModel.getEntryRowCount(DIMMAPENTITY_KEY);
            for (int index = 0; index < dimMampEntityRowCount; ++index) {
                dataModel.setValue(DIMSOURCENAME_KEY, null, index);
            }
        }
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        if (newDatasetObj != null) {
            IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List dims = cacheHelper.getDimensionList(Long.valueOf(newDatasetObj.getLong("id")));
            for (Dimension dim : dims) {
                String name = dim.getName();
                String number = dim.getNumber();
                ComboItem item = new ComboItem(new LocaleString(name), number);
                itemList.add(item);
            }
        }
        ComboEdit dimCombo = (ComboEdit)this.getControl(DIMSOURCENAME_KEY);
        dimCombo.setComboItems(itemList);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "deleteentry".equals(operation = ((FormOperate)args.getSource()).getOperateKey())) {
            List<EasDimension> easDimlistCache;
            DynamicObject tarObj = (DynamicObject)this.getModel().getValue(TARGETOBJ_KEY);
            String tarType = tarObj.getString("type");
            String iscDatabaseType = this.getIscDatabaseType();
            if ("SERVICE".equalsIgnoreCase(tarType) && "eas".equalsIgnoreCase(iscDatabaseType) && (easDimlistCache = this.getEasDimlistCache()).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u884c\uff0c\u539f\u56e0\uff1a\u7f16\u8f91\u65f6\u5220\u9664\u884c\u5fc5\u987b\u91cd\u65b0\u9009\u62e9EAS\u6a21\u578b\u3002", (String)"DataIntegrationOutPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Override
    protected void beforeDoSave() {
        super.beforeDoSave();
        Long tarObjId = (Long)this.getPropValueOfF7Obj(TARGETOBJ_KEY, "id");
        if (this.getSelectedTarObjIds().contains(tarObjId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u5df2\u5728\u5176\u4ed6\u96c6\u6210\u65b9\u6848\u4e2d\u88ab\u9009\u62e9\u3002", (String)"DataIntegrationOutPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.baseValidate();
        DynamicObjectCollection dimMaperList = this.getModel().getEntryEntity(DIMMAPENTITY_KEY);
        String metricField = (String)this.getModel().getValue(METRICFIELD_KEY);
        String pkField = (String)this.getModel().getValue(PKFIELD_KEY);
        DynamicObject tarObj = (DynamicObject)this.getModel().getValue(TARGETOBJ_KEY);
        String tarType = tarObj.getString("type");
        String iscDatabaseType = this.getIscDatabaseType();
        if (!("SERVICE".equalsIgnoreCase(tarType) && "eas".equalsIgnoreCase(iscDatabaseType) || !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{metricField, pkField}) && !metricField.equals(pkField))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u5b57\u6bb5\u548c\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u76f8\u540c\u3002", (String)"DataIntegrationOutPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.checkInterRangeInfo();
        this.checkDimView();
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            id = DBServiceHelper.genGlobalLongId();
        }
        DataIntegrationPlan plan = DataIntegrationService.getInstance().createOutPlan(id, this.getModelId(), Long.valueOf(this.getDatasetId()), (Long)this.getPropValueOfF7Obj(SOURCESYS_KEY, "id"), tarObjId, dimMaperList, metricField, pkField);
        this.getModel().setValue("id", (Object)id);
        this.getModel().setValue("sourceobj", (Object)plan.getSrcObjId());
        this.getModel().setValue("triggerid", (Object)plan.getTriggerId());
        this.getModel().setValue("tablename", (Object)plan.getTableName());
    }

    private void baseValidate() {
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection dimMapInfo = dataEntity.getDynamicObjectCollection(DIMMAPENTITY_KEY);
        for (DynamicObject row : dimMapInfo) {
            String dimsource = row.getString("dimsource");
            String dimmembnum = row.getString("dimmembnum");
            Long dimMemMapId = row.getLong("dimmembmap_id");
            if (StringUtils.isBlank((CharSequence)dimsource) && StringUtils.isBlank((CharSequence)dimmembnum)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\u6709\u884c\u672a\u9009\u62e9\u6e90\u7ef4\u5ea6\u4e14\u672a\u8f93\u5165\u6307\u5b9a\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DataIntegrationOutPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (View.NoViewDimNums.contains(dimsource) || !IDUtils.isNotEmptyLong((Long)dimMemMapId).booleanValue()) continue;
            this.dimToDimMappingIdMap.computeIfAbsent(dimmembnum, e -> new HashSet(16)).add(dimMemMapId);
        }
        DynamicObject tarObj = (DynamicObject)this.getModel().getValue(TARGETOBJ_KEY);
        String tarType = tarObj.getString("type");
        String iscDatabaseType = this.getIscDatabaseType();
        if ("SERVICE".equalsIgnoreCase(tarType) && "eas".equalsIgnoreCase(iscDatabaseType)) {
            if (!dimMapInfo.stream().anyMatch(e -> SysDimensionEnum.Account.getNumber().equals(e.getString("dimsource")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u5fc5\u987b\u9009\u62e9\u79d1\u76ee\u7ef4\u5ea6\u3002", (String)"DataIntegrationOutPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!dimMapInfo.stream().anyMatch(e -> SysDimensionEnum.Metric.getNumber().equals(e.getString("dimsource")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u5fc5\u987b\u9009\u62e9\u5ea6\u91cf\u7ef4\u5ea6\u3002", (String)"DataIntegrationOutPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!dimMapInfo.stream().anyMatch(e -> SysDimensionEnum.BudgetPeriod.getNumber().equals(e.getString("dimsource")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u5fc5\u987b\u9009\u62e9\u9884\u7b97\u671f\u95f4\u7ef4\u5ea6\u3002", (String)"DataIntegrationOutPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!dimMapInfo.stream().anyMatch(e -> SysDimensionEnum.Version.getNumber().equals(e.getString("dimsource")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u5fc5\u987b\u9009\u62e9\u7248\u672c\u7ef4\u5ea6\u3002", (String)"DataIntegrationOutPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!dimMapInfo.stream().anyMatch(e -> SysDimensionEnum.Currency.getNumber().equals(e.getString("dimsource")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u5fc5\u987b\u9009\u62e9\u5e01\u79cd\u7ef4\u5ea6\u3002", (String)"DataIntegrationOutPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject row : dimMapInfo) {
                DynamicObject dimmembmap;
                String dimsourcename = row.getString(DIMSOURCENAME_KEY);
                String dimsource = row.getString("dimsource");
                if (!StringUtils.isNotBlank((CharSequence)dimsource) || (dimmembmap = row.getDynamicObject(DIMMEMBMAP_KEY)) != null) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataIntegrationOutPlugin_new_01", (String)"epm-eb-formplugin", (Object[])new Object[]{dimsourcename}));
            }
        }
        if ("eas".equalsIgnoreCase(iscDatabaseType) && "SERVICE".equalsIgnoreCase(tarType) && this.getModel().getValue("id").equals(0L)) {
            List<EasDimension> easDimlist = this.getEasDimlistCache();
            Map<String, EasDimension> dimnumberMap = easDimlist.stream().collect(Collectors.toMap(EasDimension::getDimnumber, e -> e, (v1, v2) -> v1));
            Set dimtargetSet = dimMapInfo.stream().map(e -> e.getString("dimtarget")).collect(Collectors.toSet());
            List dimMapperList = easDimlist.stream().filter(e -> dimtargetSet.contains(e.getSrcnumber())).collect(Collectors.toList());
            Map<String, EasDimension> dimnumberMapperMap = dimMapperList.stream().collect(Collectors.toMap(EasDimension::getDimnumber, e -> e, (v1, v2) -> {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u7ef4\u5ea6\u91cd\u590d\u6210\u5458\uff1a%1---%2\u3002", (String)"DataIntegrationOutPlugin_10_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{v1.getSrcnumber(), v2.getSrcnumber()}));
            }));
            for (Map.Entry<String, EasDimension> entry : dimnumberMap.entrySet()) {
                String dimnumber = entry.getKey();
                EasDimension easDimension = entry.getValue();
                if (dimnumberMapperMap.containsKey(dimnumber)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f3a\u5c11EAS\u7ef4\u5ea6\u6620\u5c04:%1\u3002", (String)"DataIntegrationOutPlugin_11_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{easDimension.getDimname()}));
            }
        }
    }

    @Override
    public void afterBindData(EventObject ent) {
        super.afterBindData(ent);
        DynamicObject tarObj = (DynamicObject)this.getModel().getValue(TARGETOBJ_KEY);
        if (!this.getModel().getValue("id").equals(0L)) {
            this.checkTarObjChange(tarObj);
            this.setTarDimMemberEnable();
        }
        this.setTarVisible();
        this.interRangeEntryBindData();
    }

    private void setTarDimMemberEnable() {
        DynamicObjectCollection dimMaperList = this.getModel().getEntryEntity(DIMMAPENTITY_KEY);
        for (int i = 0; i < dimMaperList.size(); ++i) {
            DynamicObject mapper = (DynamicObject)dimMaperList.get(i);
            boolean fixedmember = mapper.getBoolean(FIXEDMEMBER_KEY);
            if (fixedmember) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"dimmembnum"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"dimmembnum"});
        }
    }

    private void checkTarObjChange(DynamicObject tarObj) {
        String tarType = tarObj.getString("type");
        if (!"TABLE".equalsIgnoreCase(tarType) && !"ENTITY".equalsIgnoreCase(tarType)) {
            return;
        }
        DynamicObjectCollection dimMaperList = this.getModel().getEntryEntity(DIMMAPENTITY_KEY);
        DynamicObjectCollection props = tarObj.getDynamicObjectCollection("prop_entryentity");
        this.setComboList(props);
    }

    private void updateDimMapEntity4TarObj(DynamicObject newTarObj) {
        if (newTarObj == null) {
            return;
        }
        String tarType = (newTarObj = BusinessDataServiceHelper.loadSingle((Object)newTarObj.getLong("id"), (String)"isc_metadata_schema")).getString("type");
        if (!"TABLE".equalsIgnoreCase(tarType) && !"ENTITY".equalsIgnoreCase(tarType)) {
            return;
        }
        DynamicObjectCollection props = newTarObj.getDynamicObjectCollection("prop_entryentity");
        this.setComboList(props);
        String metricField = (String)this.getModel().getValue(METRICFIELD_KEY);
        String pkField = (String)this.getModel().getValue(PKFIELD_KEY);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{metricField, pkField})) {
            return;
        }
        if (metricField.equals(pkField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u5b57\u6bb5\u548c\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u76f8\u540c\u3002", (String)"DataIntegrationOutPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{metricField, pkField})) {
            return;
        }
        HashSet<String> excludeField = new HashSet<String>(Arrays.asList(metricField, pkField));
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(DIMMAPENTITY_KEY);
        dataModel.batchCreateNewEntryRow(DIMMAPENTITY_KEY, props.size() - excludeField.size());
        int rowIdx = 0;
        for (int i = 0; i < props.size(); ++i) {
            DynamicObject prop = (DynamicObject)props.get(i);
            String name = prop.getString("prop_label");
            String number = prop.getString("prop_name");
            if (excludeField.contains(number)) continue;
            dataModel.setValue("dimtarget", (Object)number, rowIdx);
            dataModel.setValue("dimtargetname", (Object)name, rowIdx);
            this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{"dimmembnum"});
            ++rowIdx;
        }
        this.getView().updateView(DIMMAPENTITY_KEY);
    }

    private void updateDimMapEntity4Eas(List<EasDimension> easDimensions) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(DIMMAPENTITY_KEY);
        dataModel.batchCreateNewEntryRow(DIMMAPENTITY_KEY, easDimensions.size());
        int rowIdx = 0;
        for (int i = 0; i < easDimensions.size(); ++i) {
            EasDimension easDim = easDimensions.get(i);
            String name = easDim.getDimname();
            String number = easDim.getSrcnumber();
            dataModel.setValue("dimtarget", (Object)number, rowIdx);
            dataModel.setValue("dimtargetname", (Object)name, rowIdx);
            ++rowIdx;
        }
        this.getView().updateView(DIMMAPENTITY_KEY);
    }

    private void setComboList(DynamicObjectCollection props) {
        List<ComboItem> comboList = this.getComboList(props);
        ComboEdit metricFieldCombo = (ComboEdit)this.getControl(METRICFIELD_KEY);
        metricFieldCombo.setComboItems(comboList);
        ComboEdit pkFieldCombo = (ComboEdit)this.getControl(PKFIELD_KEY);
        pkFieldCombo.setComboItems(comboList);
    }

    private void setTarVisible() {
        DynamicObject tarObj = (DynamicObject)this.getModel().getValue(TARGETOBJ_KEY);
        if (tarObj == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PKFIELD_KEY, METRICFIELD_KEY, EASMODEL_KEY, EASEDITSTATUS_KEY});
            return;
        }
        String tarType = tarObj.getString("type");
        if ("TABLE".equalsIgnoreCase(tarType) || "ENTITY".equalsIgnoreCase(tarType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PKFIELD_KEY, METRICFIELD_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EASMODEL_KEY, EASEDITSTATUS_KEY});
        } else {
            String databaseType = this.getIscDatabaseType();
            if ("eas".equalsIgnoreCase(databaseType)) {
                this.getModel().setValue(PKFIELD_KEY, null);
                this.getView().setVisible(Boolean.TRUE, new String[]{EASMODEL_KEY, EASEDITSTATUS_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{PKFIELD_KEY, METRICFIELD_KEY});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{EASMODEL_KEY, EASEDITSTATUS_KEY});
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u4e0d\u662fEAS\u7cfb\u7edf\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataIntegrationOutPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private String getIscDatabaseType() {
        try {
            DynamicObject targetSys = (DynamicObject)this.getModel().getValue("targetsys");
            if (targetSys == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u3002", (String)"DataIntegrationOutPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObject iscDataSource = BusinessDataServiceHelper.loadSingle((Object)targetSys.getLong("id"), (String)"isc_data_source");
            DynamicObject dblink = iscDataSource.getDynamicObject("dblink");
            DynamicObject iscDbLink = BusinessDataServiceHelper.loadSingle((Object)dblink.getLong("id"), (String)"isc_database_link");
            return iscDbLink.getString("database_type");
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u8fde\u63a5\u5f02\u5e38,\u8bf7\u68c0\u67e5\u3002" + e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u670d\u52a1\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataIntegrationOutPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private List<ComboItem> getComboList(DynamicObjectCollection props) {
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(props.size());
        for (DynamicObject prop : props) {
            String name = prop.getString("prop_label");
            String number = prop.getString("prop_name");
            ComboItem item = new ComboItem(new LocaleString(name), number);
            itemList.add(item);
        }
        return itemList;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String propKey = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (propKey) {
            case "targetobj": {
                filterParameter.getQFilters().add(new QFilter("type", "in", Arrays.asList("TABLE", "SERVICE")));
                filterParameter.getQFilters().add(new QFilter("id", "not in", this.getSelectedTarObjIds()));
                break;
            }
            case "sourcesys": {
                filterParameter.getQFilters().add(new QFilter("dblink.database_type", "=", (Object)"self"));
                break;
            }
        }
    }

    private Set<Long> getSelectedTarObjIds() {
        HashSet tarObjIds = Sets.newHashSetWithExpectedSize((int)20);
        QFBuilder qfBuilder = new QFBuilder("datasetid", "=", (Object)this.getDatasetId());
        qfBuilder.add(new QFilter("type", "=", (Object)"output"));
        Long id = (Long)this.getModel().getValue("id");
        if (!id.equals(0L)) {
            qfBuilder.add("id", "!=", (Object)id);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_integration", (String)TARGETOBJ_KEY, (QFilter[])qfBuilder.toArrays(), null);
        while (dataSet.hasNext()) {
            tarObjIds.add(dataSet.next().getLong(TARGETOBJ_KEY));
        }
        return tarObjIds;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (EASLIST_CLOSE.equalsIgnoreCase(actionId)) {
            this.easListCloseCallBack(evt);
        }
    }

    protected void easListCloseCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null || StringUtils.isBlank((CharSequence)returnData.toString())) {
            return;
        }
        Map returnMap = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
        String dimJson = (String)returnMap.get("dimList");
        List easDimensions = SerializationUtils.fromJsonStringToList((String)dimJson, EasDimension.class);
        String easModel = (String)returnMap.get("easModel");
        this.getModel().setValue("easModel", (Object)easModel);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)easDimensions)) {
            return;
        }
        this.updateDimMapEntity4Eas(easDimensions);
        this.setTarDimMemberEnable();
        this.setEasDimlistCache(easDimensions);
    }

    private void setEasDimlistCache(List<EasDimension> easDimensions) {
        this.getPageCache().put(EASDIMLIST_CACHE, SerializationUtils.toJsonString(easDimensions));
    }

    private List<EasDimension> getEasDimlistCache() {
        String dimlistJson = this.getPageCache().get(EASDIMLIST_CACHE);
        if (StringUtils.isBlank((CharSequence)dimlistJson)) {
            return Collections.EMPTY_LIST;
        }
        List easDimensions = SerializationUtils.fromJsonStringToList((String)dimlistJson, EasDimension.class);
        return easDimensions;
    }

    @Override
    List<Dimension> getIntegrationRangeDimensions() {
        long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            return new ArrayList<Dimension>(0);
        }
        return this.getIModelCacheHelper().getDimensionList(Long.valueOf(datasetId));
    }

    @Override
    DataIntegrationType getDataIntegrationType() {
        return DataIntegrationType.OUTPUT;
    }

    @Override
    QFilter getDimMappingFilter() {
        String dimNum = (String)this.getModel().getValue("dimsource");
        if (StringUtils.isEmpty((CharSequence)dimNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5b57\u6bb5\u540d\u79f0\u3002", (String)"DataIntegrationPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(dimNum);
        if (dimension == null) {
            return null;
        }
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        Long dimensionId = dimension.getId();
        List viewId = modelCacheHelper.getViewGroupViewsByDataSetAndDimNumber(datasetId, dimNum);
        return EASDataIntegrationUtil.getEbDimMemberMapFilter((Long)modelId, (Long)datasetId, (Long)dimensionId, (List)viewId);
    }

    @Override
    String getDimMappingFieldKey() {
        return DIMMEMBMAP_KEY;
    }

    @Override
    String getDimMappingEntryKey() {
        return DIMMAPENTITY_KEY;
    }

    @Override
    Long getDimMappingEntryView(String dimnumber) {
        Map map;
        String info;
        DynamicObject dynamicObject;
        DynamicObject bcmdimmemmap;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DIMMAPENTITY_KEY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return 0L;
        }
        Optional<DynamicObject> bcmdimtarnumber = entryEntity.stream().filter(x -> dimnumber.equals(x.getString("dimsource"))).findFirst();
        if (bcmdimtarnumber.isPresent() && (bcmdimmemmap = (dynamicObject = bcmdimtarnumber.get()).getDynamicObject(DIMMEMBMAP_KEY)) != null && StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("sourcesysinfo"))) && (map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) {
            return IDUtils.toLong(map.get("view"));
        }
        return 0L;
    }

    @Override
    Long getpointTarEntryView(String dimnumber) {
        return null;
    }
}

