/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.business.dataintegration.entity.IntegrationExecStatus;
import kd.epm.eb.business.easupgrade.utils.IntegrationLogHelper;
import kd.epm.eb.common.orm.EbIntegrationLog;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class DataIntegrationProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getBarControl().start();
        int progress = this.getCurrentProgress();
        this.updateStatus(progress);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progress");
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"backrun", "close"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickCtrlKey = this.getClickCtrlKey(evt);
        if ("backrun".equals(clickCtrlKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u662f\u5426\u786e\u8ba4\u8981\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff1f", (String)"DataIntegrationProgressPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("backrun", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("backrun".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.backRun();
        }
    }

    private void backRun() {
        this.getView().returnDataToParent((Object)this.getActionId().toString());
        this.getView().close();
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = this.getCurrentProgress();
        progressEvent.setProgress(progress);
        this.updateStatus(progress);
    }

    private int getCurrentProgress() {
        int progress;
        Long actionId = this.getActionId();
        List logPjs = IntegrationLogHelper.getLogPjByAction((Long)actionId);
        if (this.isEmpty(logPjs)) {
            progress = 100;
        } else {
            int notEndCount = 0;
            for (EbIntegrationLog log : logPjs) {
                if (!IntegrationExecStatus.WAIT.getVal().equals(log.getStatusStr()) && !IntegrationExecStatus.ING.getVal().equals(log.getStatusStr())) continue;
                ++notEndCount;
            }
            progress = notEndCount / logPjs.size();
        }
        return progress;
    }

    private void updateStatus(int progress) {
        boolean finish;
        boolean bl = finish = progress == 100;
        if (finish) {
            this.getModel().setValue("tip", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u5b8c\u6210", (String)"DataIntegrationProgressPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("tip", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u6570\u636e\u96c6\u6210", (String)"DataIntegrationProgressPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().setVisible(Boolean.valueOf(!finish), new String[]{"backrun"});
        this.getView().setVisible(Boolean.valueOf(finish), new String[]{"close"});
        this.getBarControl().setPercent(progress, progress + "%");
    }

    private Long getActionId() {
        return (Long)this.getFormCustomParam("actionId");
    }

    private ProgressBar getBarControl() {
        return (ProgressBar)this.getControl("progressbar");
    }
}

