/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class DataIntegrationQueryListPlugin
extends AbstractListPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isOutput()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdeletedata"});
        }
    }

    private boolean isOutput() {
        String integrationType = (String)this.getCustomFormParam("integrationType");
        return DataIntegrationType.OUTPUT.getVal().equals(integrationType);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_defaultshow": {
                this.setDefaultShow();
                break;
            }
            case "bar_scheduleenable": {
                this.setScheduleEnable();
                break;
            }
            case "bar_scheduleunable": {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() < 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bbe\u7f6e\u7684\u6570\u636e\u3002", (String)"DataIntegrationQueryListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object[] ids = selectedRows.getPrimaryKeyValues();
                ArrayList<Object> params = new ArrayList<Object>(ids.length + 1);
                params.add(new Date());
                params.addAll(Arrays.asList(ids));
                String sql1 = "update t_eb_integration_query set fschedulestatus='0',fmodifydatefield=? where fid in(" + SqlBatchUtils.getBatchParamsSql((int)ids.length) + ")";
                DB.execute((DBRoute)BgBaseConstant.epm, (String)sql1, (Object[])params.toArray());
                this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528\u5b9a\u65f6\u4efb\u52a1", "AbstractMultiReportPlugin_145", "epm-eb-budget"), new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u67e5\u8be2\u6761\u4ef6\u7981\u7528\u5b9a\u65f6\u4efb\u52a1\u6210\u529f", "AbstractMultiReportPlugin_146", "epm-eb-budget"));
                billList.refreshData();
                break;
            }
        }
    }

    private void setDefaultShow() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DataIntegrationQueryListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object pk = selectedRows.getPrimaryKeyValues()[0];
        List schemeIdsByCondition = EASDataIntegrationUtil.getSchemeIdsByCondition((Long)((Long)pk));
        List conditionIdsBySchemes = EASDataIntegrationUtil.getConditionIdsBySchemes((Collection)schemeIdsByCondition);
        if (conditionIdsBySchemes.size() == 0) {
            return;
        }
        ArrayList<Object[]> upValues = new ArrayList<Object[]>(conditionIdsBySchemes.size());
        Date now = TimeServiceHelper.now();
        for (Long conditionId : conditionIdsBySchemes) {
            upValues.add(new Object[]{conditionId.equals(pk), now, conditionId});
        }
        String sql = "update t_eb_integration_query set fdefaultshowstatus= ?,fmodifydatefield=? where fid=?";
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, upValues);
        billList.refreshData();
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8bbe\u7f6e\u9ed8\u8ba4", "AbstractMultiReportPlugin_147", "epm-eb-budget");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u67e5\u8be2\u6761\u4ef6\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u6761\u4ef6\u6210\u529f", "AbstractMultiReportPlugin_148", "epm-eb-budget");
        this.writeLogWithEntityNumber("eb_integration_query", null, "update", opName, opDesc, null);
    }

    private void setScheduleEnable() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bbe\u7f6e\u7684\u6570\u636e\u3002", (String)"DataIntegrationQueryListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] ids = selectedRows.getPrimaryKeyValues();
        ArrayList<Object> params = new ArrayList<Object>(ids.length + 1);
        params.add(new Date());
        params.addAll(Arrays.asList(ids));
        String sql1 = "update t_eb_integration_query set fschedulestatus='1',fmodifydatefield=? where fid in(" + SqlBatchUtils.getBatchParamsSql((int)ids.length) + ")";
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql1, (Object[])params.toArray());
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u542f\u7528\u5b9a\u65f6\u4efb\u52a1", "AbstractMultiReportPlugin_149", "epm-eb-budget");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210\u67e5\u8be2\u6761\u4ef6\u8bbe\u7f6e\u4e3a\u5b9a\u65f6\u4efb\u52a1\u6210\u529f", "AbstractMultiReportPlugin_150", "epm-eb-budget");
        this.writeLogWithEntityNumber("eb_integration_query", null, "update", opName, opDesc, null);
        billList.refreshData();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                HashMap rowMap = new HashMap(rows.size());
                rows.forEach(row -> rowMap.put(row.getLong("id"), row));
                if (DataIntegrationQueryListPlugin.this.notEmpty(rowMap)) {
                    DynamicObject[] objects = BusinessDataServiceHelper.load((String)"eb_integration_query", (String)"id,integrationids,queryjson,bizmodelid", (QFilter[])new QFilter("id", "in", rowMap.keySet()).toArray());
                    StringBuilder sb = new StringBuilder();
                    boolean filterPerm = CommonUtils.integraitonFilterswitch((Long)DataIntegrationQueryListPlugin.this.getModelId());
                    boolean isOutput = DataIntegrationQueryListPlugin.this.isOutput();
                    for (DynamicObject obj : objects) {
                        DynamicObjectCollection integrations = obj.getDynamicObjectCollection("integrationids");
                        integrations.forEach(op -> {
                            DynamicObject intObj = op.getDynamicObject("fbasedataid");
                            if (intObj != null) {
                                sb.append(intObj.getString("name")).append(',');
                            }
                        });
                        String queryJsonString = obj.getString("queryjson");
                        List queryList = JSON.parseArray((String)queryJsonString, DataIntegrationQuery.class);
                        DynamicObject cRow = (DynamicObject)rowMap.get(obj.getLong("id"));
                        Long bizModelId = obj.getLong("bizmodelid.id");
                        cRow.set("execjsonshow", (Object)EASDataIntegrationUtil.parserRange2Show((List)queryList, (IModelCacheHelper)modelCacheHelper, (boolean)isOutput, (boolean)filterPerm, (Long)bizModelId));
                        if (sb.length() <= 0) continue;
                        sb.setLength(sb.length() - 1);
                        cRow.set("insshowstr", (Object)sb.toString());
                        sb.setLength(0);
                    }
                }
                return rows;
            }
        });
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("modelId"));
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("execjsonshow".equals(fieldName)) {
            LambdaUtils.run(() -> {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                Long conditionId = ObjUtils.getLong((Object)billList.getFocusRowPkId());
                DynamicObject obj = QueryServiceHelper.queryOne((String)"eb_integration_query", (String)"bizmodelid,queryjson", (QFilter[])new QFilter("id", "=", (Object)conditionId).toArray());
                if (obj == null) {
                    return;
                }
                boolean filterPerm = CommonUtils.integraitonFilterswitch((Long)this.getModelId());
                List queryList = JSON.parseArray((String)obj.getString("queryjson"), DataIntegrationQuery.class);
                Long bizModelId = obj.getLong("bizmodelid");
                String scopeString = EASDataIntegrationUtil.parserRange2Show((List)queryList, (IModelCacheHelper)this.getIModelCacheHelper(), (boolean)this.isOutput(), (boolean)filterPerm, (Long)bizModelId);
                EASDataIntegrationUtil.showExecuteRangeInfo((String)scopeString, (IFormView)this.getView());
            });
            args.setCancel(true);
        }
    }
}

