/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataintegration.entity.DataIntegrationMemberMapObj;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DataIntegrationUploadPlugin
extends AbstractFormPlugin
implements UploadListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
        }
    }

    private void importData() {
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 3, 0, 5);
        String file_url = this.getPageCache().get("file_url");
        List dataList = ExcelImExportUtils.getInstance().read(file_url, sheet);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DataIntegrationMapPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!this.validExcel(dataList).booleanValue()) {
            this.getView().close();
            return;
        }
        List<DataIntegrationMemberMapObj> mapObjList = this.toObj(dataList);
        this.getView().returnDataToParent(mapObjList);
        this.getView().close();
    }

    private Boolean validExcel(List<String[]> dataList) {
        List allMembers;
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String dimNumber = (String)this.getView().getFormShowParameter().getCustomParam("dimNumber");
        String viewId = this.getView().getFormShowParameter().getCustomParam("viewId").toString();
        Long datasetId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("datasetId"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            allMembers = modelCache.getMembers(dimNumber);
            allMembers = allMembers.stream().filter(e -> datasetId.equals(e.getDatasetId())).collect(Collectors.toList());
        } else {
            allMembers = modelCache.getMembers(Long.valueOf(Long.parseLong(viewId)), dimNumber);
        }
        List leafMembers = allMembers.stream().filter(Member::isLeaf).collect(Collectors.toList());
        Set leafNums = leafMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        Boolean hasErr = Boolean.FALSE;
        for (int i = 0; i < dataList.size(); ++i) {
            Object[] row = dataList.get(i);
            if ("input".equals(type)) {
                String sourcenumber = row[0];
                String aimnumber = row[2];
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sourcenumber, aimnumber})) {
                    dataList.set(i, (String[])ArrayUtils.add((Object[])row, (Object)ResManager.loadKDString((String)"\u6e90\u548c\u76ee\u6807\u7684\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataIntegrationUploadPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                    hasErr = Boolean.TRUE;
                    continue;
                }
                if (!leafNums.contains(aimnumber)) {
                    dataList.set(i, (String[])ArrayUtils.add((Object[])row, (Object)ResManager.loadResFormat((String)"\u8be5\u660e\u7ec6\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u5c5e\u4e8e\u7ef4\u5ea6\u201c%1\u201d\u3002", (String)"DataIntegrationUploadPlugin_1_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber})));
                    hasErr = Boolean.TRUE;
                    continue;
                }
                if (dataList.stream().filter(e -> sourcenumber.equals(e[0])).count() <= 1L) continue;
                dataList.set(i, (String[])ArrayUtils.add((Object[])row, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u201c\u6210\u5458\u7f16\u7801(\u6e90)\u201d\u91cd\u590d\u7684\u884c\u3002", (String)"DataIntegrationUploadPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                hasErr = Boolean.TRUE;
                continue;
            }
            String aimnumber = row[0];
            String goalnumber = row[2];
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{aimnumber, goalnumber})) {
                dataList.set(i, (String[])ArrayUtils.add((Object[])row, (Object)ResManager.loadKDString((String)"\u6e90\u548c\u76ee\u6807\u7684\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataIntegrationUploadPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                hasErr = Boolean.TRUE;
                continue;
            }
            if (!leafNums.contains(aimnumber)) {
                dataList.set(i, (String[])ArrayUtils.add((Object[])row, (Object)ResManager.loadResFormat((String)"\u8be5\u660e\u7ec6\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u5c5e\u4e8e\u7ef4\u5ea6\u201c%1\u201d\u3002", (String)"DataIntegrationUploadPlugin_1_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber})));
                hasErr = Boolean.TRUE;
                continue;
            }
            if (dataList.stream().filter(e -> goalnumber.equals(e[2])).count() <= 1L) continue;
            dataList.set(i, (String[])ArrayUtils.add((Object[])row, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u6210\u5458\u7f16\u7801(\u76ee\u6807)\u91cd\u590d\u7684\u884c\u3002", (String)"DataIntegrationUploadPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            hasErr = Boolean.TRUE;
        }
        if (hasErr.booleanValue()) {
            String tempPath = "dataintegration/membermap.xlsx";
            String filename = ResManager.loadKDString((String)"\u6210\u5458\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"DataIntegrationUploadPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 3, 0, 0);
            String url = ExcelImExportUtils.getInstance().writeWithTemplate(tempPath, filename, dataList, sheet);
            ExcelImExportUtils.getInstance().download(this.getView(), url);
        }
        return hasErr == false;
    }

    private List<DataIntegrationMemberMapObj> toObj(List<String[]> dataList) {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String dimNumber = (String)this.getView().getFormShowParameter().getCustomParam("dimNumber");
        String viewId = this.getView().getFormShowParameter().getCustomParam("viewId").toString();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List members = modelCache.getMembers(Long.valueOf(Long.parseLong(viewId)), dimNumber);
        ArrayList<DataIntegrationMemberMapObj> objList = new ArrayList<DataIntegrationMemberMapObj>(dataList.size());
        for (String[] row : dataList) {
            DataIntegrationMemberMapObj mapObj = new DataIntegrationMemberMapObj();
            if ("input".equals(type)) {
                mapObj.setsNum(row[0]);
                String sourcename = row[1];
                mapObj.setsName(StringUtils.isNotBlank((CharSequence)sourcename) ? sourcename : row[0]);
                mapObj.setaNum(row[2]);
                String memberName = members.stream().filter(e -> e.getNumber().equals(row[2])).findFirst().get().getName();
                mapObj.setaName(memberName);
            } else {
                mapObj.setaNum(row[0]);
                String memberName = members.stream().filter(e -> e.getNumber().equals(row[0])).findFirst().get().getName();
                mapObj.setaName(memberName);
                mapObj.settNum(row[2]);
                String goalname = row[3];
                mapObj.settName(StringUtils.isNotBlank((CharSequence)goalname) ? goalname : row[2]);
            }
            String stateStr = row[4];
            mapObj.setState(ResManager.loadKDString((String)"\u542f\u7528", (String)"DataIntegrationUploadPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(stateStr) ? Boolean.TRUE : Boolean.FALSE);
            objList.add(mapObj);
        }
        return objList;
    }

    private void downloadTemplate() {
        String tempPath = "dataintegration/membermap.xlsx";
        String filename = ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u6210\u6210\u5458\u6620\u5c04_%1", (String)"DataIntegrationUploadPlugin_7_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 3, 0, 0);
        String url = ExcelImExportUtils.getInstance().writeWithTemplate(tempPath, filename, new ArrayList(1), sheet);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }
}

