/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.Close;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class DimMemberMapperListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String MODEL_KEY = "model";
    private static final String BILLLIST_KEY = "billlistap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{MODEL_KEY});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_KEY, (boolean)Boolean.FALSE);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DimMemberMapperListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL_KEY, (Object)modelId);
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (model == null) {
            return 0L;
        }
        return model.getLong("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "model": {
                long modelId = this.getModelId();
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
                billList.clearSelection();
                billList.refresh();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setCustomQFilters(Collections.singletonList(new QFilter("srcmodel", "=", (Object)this.getModelId())));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter billShowParameter = e.getParameter();
        billShowParameter.setCustomParam("modelId", (Object)this.getModelId());
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!(args.getSource() instanceof Close) && this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DimMemberMapperListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }
}

