/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.dataintegration.entity.ModelDimMemberMapObj;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class DimMemberMapperPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String SRCMODEL_KEY = "srcmodel";
    private static final String TARMODEL_KEY = "tarmodel";
    private static final String SRCDIM_KEY = "srcdim";
    private static final String SRCDIMVIEW_KEY = "srcdimview";
    private static final String TARDIM_KEY = "tardim";
    private static final String TARDIMVIEW_KEY = "tardimview";
    private static final String MEMBERMAPENTITY_KEY = "membermapentity";
    private static final String SRCMEMBERNAME_KEY = "srcmembername";
    private static final String TARMEMBERNAME_KEY = "tarmembername";
    private static final String NUMBER = "number";
    private static List<String> enableDims = Arrays.asList("BudgetPeriod", "Version");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap1"});
        this.addF7SelectListener(TARMODEL_KEY, SRCDIM_KEY, SRCDIMVIEW_KEY, TARDIM_KEY, TARDIMVIEW_KEY);
        this.addClickListeners(new String[]{SRCMEMBERNAME_KEY, TARMEMBERNAME_KEY});
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("modelId");
        this.getModel().setValue(SRCMODEL_KEY, (Object)modelId);
        this.getView().setEnable(Boolean.FALSE, new String[]{SRCMODEL_KEY});
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, "name", SRCMODEL_KEY});
        if (this.isBeQuoteByScheme()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SRCDIM_KEY, SRCDIMVIEW_KEY, TARMODEL_KEY, TARDIM_KEY, TARDIMVIEW_KEY, "status"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        switch (propName) {
            case "srcmodel": {
                this.getModel().setValue(SRCDIM_KEY, null);
                break;
            }
            case "tarmodel": {
                this.getModel().setValue(TARDIM_KEY, null);
                break;
            }
            case "srcdim": {
                this.getModel().setValue(SRCDIMVIEW_KEY, null);
                this.getModel().deleteEntryData(MEMBERMAPENTITY_KEY);
                this.setViewVisible(this.getModel().getDataEntity().getDynamicObject(SRCDIM_KEY), SRCDIMVIEW_KEY);
                break;
            }
            case "tardim": {
                this.getModel().setValue(TARDIMVIEW_KEY, null);
                this.getModel().deleteEntryData(MEMBERMAPENTITY_KEY);
                this.setViewVisible(this.getModel().getDataEntity().getDynamicObject(TARDIM_KEY), TARDIMVIEW_KEY);
                break;
            }
            case "tardimview": 
            case "srcdimview": {
                this.getModel().deleteEntryData(MEMBERMAPENTITY_KEY);
                break;
            }
            case "tarmembername": {
                if (!StringUtils.isEmpty((String)newValue.toString())) break;
                this.getModel().setValue("tarmembernumber", (Object)"", rowIndex);
                break;
            }
            case "srcmembername": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                this.getModel().setValue("srcmembernumber", (Object)"", rowIndex);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_import": {
                this.importExcel();
                break;
            }
            case "btn_export": {
                this.exportExcel();
                break;
            }
        }
    }

    private void exportExcel() {
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("dataintegration/modelMembermap.xlsx");
        CellStyle _style = POIUtils.getErrorStyle((Workbook)excelWriter.getWorkbook());
        _style.setVerticalAlignment(VerticalAlignment.CENTER);
        _style.setAlignment(HorizontalAlignment.CENTER);
        excelWriter.setStarPosition(0, 0);
        excelWriter.createRow(_style, new Object[]{ResManager.loadKDString((String)"\u4f53\u7cfb\u95f4\u6210\u5458\u6620\u5c04\u6a21\u677f", (String)"DimMemberMapperPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        _style = POIUtils.getErrorStyle((Workbook)excelWriter.getWorkbook());
        excelWriter.createRow(_style, new Object[]{ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"DimMemberMapperPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        excelWriter.createRow(_style, new Object[]{ResManager.loadKDString((String)"*\u6e90\u6210\u5458\u7f16\u7801", (String)"DimMemberMapperPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u76ee\u6807\u6210\u5458\u7f16\u7801", (String)"DimMemberMapperPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u72b6\u6001", (String)"DimMemberMapperPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        for (DynamicObject row : dataEntity.getDynamicObjectCollection(MEMBERMAPENTITY_KEY)) {
            String srcmembernumber = row.getString("srcmembernumber");
            String tarmembernumber = row.getString("tarmembernumber");
            boolean state = row.getBoolean("state");
            excelWriter.createRow(new Object[]{srcmembernumber, tarmembernumber, state ? ResManager.loadKDString((String)"\u542f\u7528", (String)"OffsetRuleListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"OffsetRuleListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        }
        String[] statusOpt = new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"OffsetRuleListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7981\u7528", (String)"OffsetRuleListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])};
        excelWriter.setDropDownBox(statusOpt, Integer.valueOf(3), Integer.valueOf(100), Integer.valueOf(2), Integer.valueOf(2));
        String fileName = ResManager.loadResFormat((String)"\u4f53\u7cfb\u95f4\u6210\u5458\u6620\u5c04_%1", (String)"DimMemberMapperPlugin_new_01", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd") + ".xlsx"});
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void importExcel() {
        DynamicObject srcdim = (DynamicObject)this.getModel().getValue(SRCDIM_KEY);
        if (srcdim == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ef4\u5ea6\u3002", (String)"DataIntegrationMapPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject tardim = (DynamicObject)this.getModel().getValue(TARDIM_KEY);
        if (tardim == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ef4\u5ea6\u3002", (String)"DataIntegrationMapPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String srcDimNumber = srcdim.getString(NUMBER);
        Long srcViewId = 0L;
        SysDimensionEnum srcDimEnum = SysDimensionEnum.getEnumByNumber((String)srcDimNumber);
        if (srcDimEnum == null || SysDimensionEnum.Entity == srcDimEnum || SysDimensionEnum.InternalCompany == srcDimEnum || SysDimensionEnum.ChangeType == srcDimEnum) {
            DynamicObject dimViewObj = (DynamicObject)this.getModel().getValue(SRCDIMVIEW_KEY);
            if (dimViewObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DataIntegrationMapPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            srcViewId = dimViewObj.getLong("id");
        }
        String tarDimNumber = tardim.getString(NUMBER);
        Long tarViewId = 0L;
        SysDimensionEnum tarDimEnum = SysDimensionEnum.getEnumByNumber((String)tarDimNumber);
        if (tarDimEnum == null || SysDimensionEnum.Entity == tarDimEnum || SysDimensionEnum.InternalCompany == tarDimEnum) {
            DynamicObject dimViewObj = (DynamicObject)this.getModel().getValue(TARDIMVIEW_KEY);
            if (dimViewObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DataIntegrationMapPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            tarViewId = dimViewObj.getLong("id");
        }
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "epm_import");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("srcModel", (Object)this.getModel().getDataEntity().getDynamicObject(SRCMODEL_KEY).getLong("id"));
        showParameter.setCustomParam("srcDimNumber", (Object)srcDimNumber);
        showParameter.setCustomParam("srcViewId", (Object)srcViewId);
        showParameter.setCustomParam("tarModel", (Object)this.getModel().getDataEntity().getDynamicObject(TARMODEL_KEY).getLong("id"));
        showParameter.setCustomParam("tarDimNumber", (Object)tarDimNumber);
        showParameter.setCustomParam("tarViewId", (Object)tarViewId);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.dataintegration.plugin.DimMemberUploadPlugin");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import_close"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u5bfc\u5165", (String)"DataIntegrationMapPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operation = ((FormOperate)args.getSource()).getOperateKey())) {
            if (this.checkNumber() || this.checkName() || this.checkEntryEntity()) {
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
            DynamicObjectCollection membermapentity = dataEntity.getDynamicObjectCollection(MEMBERMAPENTITY_KEY);
            Map<String, String> srcMemberMap = membermapentity.stream().collect(Collectors.toMap(e -> e.getString("srcmembernumber"), e -> e.getString(SRCMEMBERNAME_KEY), (v1, v2) -> v1));
            Map<String, String> tarMemberMap = membermapentity.stream().collect(Collectors.toMap(e -> e.getString("tarmembernumber"), e -> e.getString(TARMEMBERNAME_KEY), (v1, v2) -> v1));
            membermapentity.stream().collect(Collectors.toMap(e -> e.getString("srcmembernumber"), e -> 1, Integer::sum)).entrySet().stream().anyMatch(e -> {
                if ((Integer)e.getValue() > 1) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6e90\u7ef4\u5ea6\u6210\u5458\u5b58\u5728\u91cd\u590d\u5143\u7d20%1\u3002", (String)"DimMemberMapperPlugin_new_02", (String)"epm-eb-formplugin", (Object[])new Object[]{srcMemberMap.get(e.getKey())}));
                }
                return (Integer)e.getValue() > 1;
            });
            membermapentity.stream().collect(Collectors.toMap(e -> e.getString("tarmembernumber"), e -> 1, Integer::sum)).entrySet().stream().anyMatch(e -> {
                if ((Integer)e.getValue() > 1) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u76ee\u6807\u7ef4\u5ea6\u6210\u5458\u5b58\u5728\u91cd\u590d\u5143\u7d20%1\u3002", (String)"DimMemberMapperPlugin_new_03", (String)"epm-eb-formplugin", (Object[])new Object[]{tarMemberMap.get(e.getKey())}));
                }
                return (Integer)e.getValue() > 1;
            });
        }
    }

    private boolean checkName() {
        Object name = this.getModel().getValue("name");
        if (StringUtils.isEmpty((String)String.valueOf(name))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"DimMemberMapperPlugin_new_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterBindData(EventObject ent) {
        super.afterBindData(ent);
        DynamicObject srcDim = this.getModel().getDataEntity().getDynamicObject(SRCDIM_KEY);
        DynamicObject tarDim = this.getModel().getDataEntity().getDynamicObject(TARDIM_KEY);
        this.setViewVisible(srcDim, SRCDIMVIEW_KEY);
        this.setViewVisible(tarDim, TARDIMVIEW_KEY);
    }

    private void setViewVisible(DynamicObject dim, String dimviewKey) {
        this.getView().setVisible(Boolean.FALSE, new String[]{dimviewKey});
        if (dim == null) {
            return;
        }
        String dimNumber = dim.getString(NUMBER);
        SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
        if (dimEnum == null || SysDimensionEnum.Entity == dimEnum || SysDimensionEnum.InternalCompany == dimEnum || SysDimensionEnum.ChangeType == dimEnum) {
            this.getView().setVisible(Boolean.TRUE, new String[]{dimviewKey});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propKey = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter lfp = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        List qFilters = lfp.getQFilters();
        switch (propKey) {
            case "srcmodel": {
                DynamicObject tarModel = this.getModel().getDataEntity().getDynamicObject(TARMODEL_KEY);
                if (tarModel == null) break;
                qFilters.add(new QFilter("id", "!=", (Object)tarModel.getLong("id")));
                break;
            }
            case "tarmodel": {
                DynamicObject srcModel = this.getModel().getDataEntity().getDynamicObject(SRCMODEL_KEY);
                if (srcModel == null) break;
                ArrayList<QFilter> filters = ((BasedataEdit)beforeF7SelectEvent.getSource()).getQFilters();
                if (filters == null) {
                    filters = new ArrayList<QFilter>(16);
                }
                filters.addAll(ModelUtil.getModelFilter((IFormView)this.getView().getParentView()));
                filters.add(new QFilter("id", "!=", (Object)srcModel.getLong("id")));
                ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                lsp.setListFilterParameter(new ListFilterParameter(filters, null));
                break;
            }
            case "srcdim": {
                DynamicObject srcModel = this.getModel().getDataEntity().getDynamicObject(SRCMODEL_KEY);
                DynamicObject tarModel = this.getModel().getDataEntity().getDynamicObject(TARMODEL_KEY);
                if (srcModel == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u4f53\u7cfb\u3002", (String)"DimMemberMapperPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                qFilters.add(new QFilter("model", "=", (Object)srcModel.getLong("id")));
                qFilters.add(new QFilter(NUMBER, "not in", enableDims));
                if (tarModel == null) break;
                qFilters.add(new QFilter("model", "!=", (Object)tarModel.getLong("id")));
                break;
            }
            case "tardim": {
                DynamicObject srcModel = this.getModel().getDataEntity().getDynamicObject(SRCMODEL_KEY);
                DynamicObject tarModel = this.getModel().getDataEntity().getDynamicObject(TARMODEL_KEY);
                if (tarModel == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u4f53\u7cfb\u3002", (String)"DimMemberMapperPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                qFilters.add(new QFilter("model", "=", (Object)tarModel.getLong("id")));
                qFilters.add(new QFilter(NUMBER, "not in", enableDims));
                if (srcModel == null) break;
                qFilters.add(new QFilter("model", "!=", (Object)srcModel.getLong("id")));
                break;
            }
            case "srcdimview": {
                DynamicObject srcModel = this.getModel().getDataEntity().getDynamicObject(SRCMODEL_KEY);
                DynamicObject srcDim = this.getModel().getDataEntity().getDynamicObject(SRCDIM_KEY);
                if (srcDim == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ef4\u5ea6\u3002", (String)"DimMemberMapperPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                qFilters.add(new QFilter("model", "=", (Object)srcModel.getLong("id")));
                qFilters.add(new QFilter("dimension", "=", (Object)srcDim.getLong("id")));
                break;
            }
            case "tardimview": {
                DynamicObject tarModel = this.getModel().getDataEntity().getDynamicObject(TARMODEL_KEY);
                DynamicObject tarDim = this.getModel().getDataEntity().getDynamicObject(TARDIM_KEY);
                if (tarDim == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ef4\u5ea6\u3002", (String)"DimMemberMapperPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                qFilters.add(new QFilter("model", "=", (Object)tarModel.getLong("id")));
                qFilters.add(new QFilter("dimension", "=", (Object)tarDim.getLong("id")));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "srcmembername": {
                DynamicObject srcDim = this.getModel().getDataEntity().getDynamicObject(SRCDIM_KEY);
                DynamicObject tarDim = this.getModel().getDataEntity().getDynamicObject(TARDIM_KEY);
                if (srcDim == null || tarDim == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ef4\u5ea6\u548c\u76ee\u6807\u7ef4\u5ea6\u3002", (String)"DimMemberMapperPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                DynamicObject srcDimView = this.getModel().getDataEntity().getDynamicObject(SRCDIMVIEW_KEY);
                DynamicObject srcModel = this.getModel().getDataEntity().getDynamicObject(SRCMODEL_KEY);
                SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByNumber((String)srcDim.getString(NUMBER));
                if ((dimEnum == null || SysDimensionEnum.Entity == dimEnum) && srcDimView == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DimMemberMapperPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.showDimMemberSelectPage(srcModel, srcDim, srcDimView, SRCMEMBERNAME_KEY);
                break;
            }
            case "tarmembername": {
                DynamicObject srcDim = this.getModel().getDataEntity().getDynamicObject(SRCDIM_KEY);
                DynamicObject tarDim = this.getModel().getDataEntity().getDynamicObject(TARDIM_KEY);
                if (srcDim == null || tarDim == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ef4\u5ea6\u548c\u76ee\u6807\u7ef4\u5ea6\u3002", (String)"DimMemberMapperPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                DynamicObject tarModel = this.getModel().getDataEntity().getDynamicObject(TARMODEL_KEY);
                DynamicObject tarDimView = this.getModel().getDataEntity().getDynamicObject(TARDIMVIEW_KEY);
                SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByNumber((String)tarDim.getString(NUMBER));
                if ((dimEnum == null || SysDimensionEnum.Entity == dimEnum) && tarDimView == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DimMemberMapperPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.showDimMemberSelectPage(tarModel, tarDim, tarDimView, TARMEMBERNAME_KEY);
                break;
            }
        }
    }

    private void showDimMemberSelectPage(DynamicObject bizModel, DynamicObject dim, DynamicObject dimView, String fieldKey) {
        Member ebChangesMember;
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dimMemberSelect!" + fieldKey);
        long viewId = 0L;
        if (dimView != null) {
            viewId = dimView.getLong("id");
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        long modelId = bizModel.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String changeTypeNumber = SysDimensionEnum.ChangeType.getNumber();
        if (ModelServiceHelper.isBGMDModel((Long)modelId) && changeTypeNumber.equals(dim.getString(NUMBER)) && (ebChangesMember = modelCacheHelper.getMember(changeTypeNumber, Long.valueOf(viewId), "EBChanges")) != null) {
            List allMembers = ebChangesMember.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toList());
            qFilters.add(new QFilter(NUMBER, "not in", allMembers));
        }
        boolean isonleaf = fieldKey.startsWith("tar");
        IDataModel dataModel = this.getModel();
        Long selectId = 0L;
        int rowIndex = this.getModel().getEntryCurrentRowIndex(MEMBERMAPENTITY_KEY);
        if (SRCMEMBERNAME_KEY.equals(fieldKey)) {
            String srcmembernumber = (String)dataModel.getValue("srcmembernumber", rowIndex);
            Member member = modelCacheHelper.getMember(dim.getString(NUMBER), Long.valueOf(viewId), srcmembernumber);
            if (member != null) {
                selectId = member.getId();
            }
        } else if (TARMEMBERNAME_KEY.equals(fieldKey)) {
            String tarmembernumber = (String)dataModel.getValue("tarmembernumber", rowIndex);
            Member member = modelCacheHelper.getMember(dim.getString(NUMBER), Long.valueOf(viewId), tarmembernumber);
            if (member != null) {
                selectId = member.getId();
            }
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dim.getString(NUMBER)), (String)ListSelectedRow.class.getName());
        f7Param.setViewId(Long.valueOf(viewId));
        f7Param.setSelectId(selectId);
        f7Param.setLoadDefaultBusModel(false);
        f7Param.setOnlySelLeaf(isonleaf);
        f7Param.addCustomFilter(qFilters);
        f7Param.setCanSelectRoot(false);
        f7Param.setVerifyPermission(false);
        f7Param.setCutTree(false);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent ent) {
        List mapObjList;
        super.closedCallBack(ent);
        String actionId = ent.getActionId();
        if (actionId.startsWith("dimMemberSelect")) {
            ListSelectedRowCollection backData = (ListSelectedRowCollection)ent.getReturnData();
            if (backData == null) {
                return;
            }
            String fieldKey = actionId.split("!")[1];
            IDataModel dataModel = this.getModel();
            int rowIndex = dataModel.getEntryCurrentRowIndex(MEMBERMAPENTITY_KEY);
            if (SRCMEMBERNAME_KEY.equals(fieldKey)) {
                if (backData.isEmpty()) {
                    dataModel.setValue(SRCMEMBERNAME_KEY, null, rowIndex);
                    dataModel.setValue("srcmembernumber", null, rowIndex);
                } else {
                    dataModel.setValue(SRCMEMBERNAME_KEY, (Object)backData.get(0).getName(), rowIndex);
                    dataModel.setValue("srcmembernumber", (Object)backData.get(0).getNumber(), rowIndex);
                }
            } else if (TARMEMBERNAME_KEY.equals(fieldKey)) {
                if (backData.isEmpty()) {
                    dataModel.setValue(TARMEMBERNAME_KEY, null, rowIndex);
                    dataModel.setValue("tarmembernumber", null, rowIndex);
                } else {
                    dataModel.setValue(TARMEMBERNAME_KEY, (Object)backData.get(0).getName(), rowIndex);
                    dataModel.setValue("tarmembernumber", (Object)backData.get(0).getNumber(), rowIndex);
                }
            }
        } else if ("import_close".equals(actionId) && CollectionUtils.isNotEmpty((Collection)(mapObjList = (List)ent.getReturnData()))) {
            this.refreshDataEntity(mapObjList);
        }
    }

    private void refreshDataEntity(List<ModelDimMemberMapObj> mapObjList) {
        IDataModel dataModel = this.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection oldDataList = dataEntity.getDynamicObjectCollection(MEMBERMAPENTITY_KEY);
        block0: for (int i = 0; i < oldDataList.size(); ++i) {
            DynamicObject row = (DynamicObject)oldDataList.get(i);
            String srcmembernumber = row.getString("srcmembernumber");
            String tarmembernumber = row.getString("tarmembernumber");
            Iterator<ModelDimMemberMapObj> ite = mapObjList.iterator();
            while (ite.hasNext()) {
                ModelDimMemberMapObj obj = ite.next();
                if (!obj.getSrcmembernumber().equals(srcmembernumber) || !obj.getTarmembernumber().equals(tarmembernumber)) continue;
                dataModel.setValue(SRCMEMBERNAME_KEY, (Object)obj.getSrcmembername(), i);
                dataModel.setValue("srcmembernumber", (Object)obj.getSrcmembernumber(), i);
                dataModel.setValue(TARMEMBERNAME_KEY, (Object)obj.getTarmembername(), i);
                dataModel.setValue("tarmembernumber", (Object)obj.getTarmembernumber(), i);
                dataModel.setValue("state", (Object)obj.getState(), i);
                ite.remove();
                continue block0;
            }
        }
        for (ModelDimMemberMapObj obj : mapObjList) {
            int newRowIndex = this.getModel().createNewEntryRow(MEMBERMAPENTITY_KEY);
            dataModel.setValue(SRCMEMBERNAME_KEY, (Object)obj.getSrcmembername(), newRowIndex);
            dataModel.setValue("srcmembernumber", (Object)obj.getSrcmembernumber(), newRowIndex);
            dataModel.setValue(TARMEMBERNAME_KEY, (Object)obj.getTarmembername(), newRowIndex);
            dataModel.setValue("tarmembernumber", (Object)obj.getTarmembernumber(), newRowIndex);
            dataModel.setValue("state", (Object)obj.getState(), newRowIndex);
        }
    }

    private boolean checkEntryEntity() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MEMBERMAPENTITY_KEY);
        if (entryEntity.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u5173\u7cfb\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DimMemberMapperPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        List collect = entryEntity.stream().filter(e -> StringUtils.isEmpty((String)e.getString(SRCMEMBERNAME_KEY)) || StringUtils.isEmpty((String)e.getString(TARMEMBERNAME_KEY))).collect(Collectors.toList());
        if (collect.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u5173\u7cfb\u4e2d\u6e90\u7ef4\u5ea6\u6210\u5458\u3001\u76ee\u6807\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimMemberMapperPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isBeQuoteByScheme() {
        long id = (Long)this.getModel().getValue("id");
        QFilter qFilter = new QFilter("dimmapentity.membermap", "=", (Object)id);
        return QueryServiceHelper.exists((String)"eb_modelupload", (QFilter[])new QFilter[]{qFilter});
    }

    private boolean checkNumber() {
        if (!this.isAddNew()) {
            return Boolean.FALSE;
        }
        String number = this.getModel().getValue(NUMBER).toString();
        if (!CheckStringsUtil.checkNumber((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u4ee5\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u5c0f\u6570\u70b9\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u5b58\u5728\u4e24\u4e2a\u8fde\u7eed\u7684\u5c0f\u6570\u70b9\u4ee5\u53ca\u4ee5\u5c0f\u6570\u70b9\u5f00\u5934\u548c\u7ed3\u5c3e\u3002", (String)"DimMemberMapperPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        qFilter.and(SRCMODEL_KEY, "=", (Object)((DynamicObject)this.getModel().getValue(SRCMODEL_KEY)).getLong("id"));
        if (QueryServiceHelper.exists((String)"eb_dim_membermap", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5728\u8be5\u6e90\u4f53\u7cfb\u5df2\u7ecf\u5b58\u5728\u3002", (String)"DimMemberMapperPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isAddNew() {
        long id = (Long)this.getModel().getValue("id");
        return id == 0L;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        OperationResult operationResult = evt.getOperationResult();
        String operateKey = evt.getOperateKey();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, "name", SRCMODEL_KEY});
        }
    }
}

