/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataintegration.entity.ModelDimMemberMapObj;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DimMemberUploadPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static String CACHE_TEMPLATEDATA = "templateDataCache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
        }
    }

    private void returnExceptionMessage(String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            throw new KDBizException(message);
        }
    }

    private void importData() {
        String fileUrl = this.getPageCache().get("file_url");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"DimMemberUploadPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List inputStreams = UploadUtil.getFileInputStreams((String)fileUrl);
        List<Workbook> uploadBooks = this.getXSSFWorkbooks(inputStreams);
        String message = this.checkFileFormat(uploadBooks);
        this.returnExceptionMessage(message);
        LinkedList<List<String>> dataList = new LinkedList<List<String>>();
        for (Workbook workbook : uploadBooks) {
            BgExcelReader excelReader = BgExcelReader.getInstance().readByWorkbook(workbook);
            List datas = excelReader.readString(3, 0, 2);
            dataList.addAll(datas);
        }
        if (CollectionUtils.isEmpty(dataList)) {
            this.returnExceptionMessage(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"DimMemberUploadPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<List<String>> errList = new ArrayList<List<String>>(4);
        List<List<String>> successList = this.validExcel(dataList, errList);
        List<ModelDimMemberMapObj> mapObjList = this.toObj(successList);
        this.getView().returnDataToParent(mapObjList);
        if (errList.size() > 0 && CollectionUtils.isEmpty(mapObjList)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u8be6\u60c5\u3002", (String)"DimMemberUploadPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (errList.size() > 0 && CollectionUtils.isNotEmpty(mapObjList)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"DimMemberUploadPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DimMemberMapperPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().close();
    }

    protected List<Workbook> getXSSFWorkbooks(List<InputStream> inputStreams) {
        ArrayList<Workbook> xssFWorkbooks = new ArrayList<Workbook>();
        try {
            String fileTypes = this.getPageCache().get("fileType");
            List types = (List)SerializationUtils.fromJsonString((String)fileTypes, List.class);
            for (int i = 0; i <= inputStreams.size() - 1; ++i) {
                if (types.get(i) != null && ((String)types.get(i)).equals("xls")) {
                    xssFWorkbooks.add((Workbook)new HSSFWorkbook(inputStreams.get(i)));
                    continue;
                }
                xssFWorkbooks.add((Workbook)new XSSFWorkbook(inputStreams.get(i)));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return xssFWorkbooks;
    }

    private String checkFileFormat(List<Workbook> uploadBooks) {
        try {
            for (Workbook uploadBook : uploadBooks) {
                Row row3 = uploadBook.getSheetAt(0).getRow(2);
                if (row3 == null) {
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u7f3a\u5c11\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemberUploadPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                Map sheetHeaderMap = this.getTemplateData().getSheetHeaderMap();
                for (Map.Entry entry : sheetHeaderMap.entrySet()) {
                    int colNum = Integer.parseInt((String)entry.getKey());
                    if (row3.getCell(colNum).getStringCellValue().trim().equals(((Header)entry.getValue()).getHeader())) continue;
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemberUploadPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemberUploadPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    protected ImportEntity getTemplateData() {
        String cache = this.getPageCache().get(CACHE_TEMPLATEDATA);
        if (cache != null) {
            return (ImportEntity)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        ImportEntity importEntity = this.prepareTemplateData();
        this.getPageCache().put(CACHE_TEMPLATEDATA, SerializationUtils.serializeToBase64((Object)importEntity));
        return importEntity;
    }

    protected ImportEntity prepareTemplateData() {
        ImportEntity importData = new ImportEntity();
        importData.setSheetHeaderMap(this.getHeaderData());
        HashMap<Integer, String[]> comboList = new HashMap<Integer, String[]>(1);
        String use = ResManager.loadKDString((String)"\u542f\u7528", (String)"DimMemberUploadPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String delete = ResManager.loadKDString((String)"\u7981\u7528", (String)"DimMemberUploadPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        comboList.put(2, new String[]{use, delete});
        importData.setComboBoxList(comboList);
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"DimMemberUploadPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        importData.setTemplateName(ResManager.loadResFormat((String)"\u4f53\u7cfb\u95f4\u6210\u5458\u6620\u5c04_%1", (String)"DimMemberUploadPlugin_new_01", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")}));
        importData.setSheetTitle(ResManager.loadKDString((String)"\u4f53\u7cfb\u95f4\u6210\u5458\u6620\u5c04\u6a21\u677f", (String)"DimMemberUploadPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return importData;
    }

    protected Map<String, Header> getHeaderData() {
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        headerMap.put("0", new Header(ResManager.loadKDString((String)"*\u6e90\u6210\u5458\u7f16\u7801", (String)"DimMemberUploadPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"DimMemberUploadPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("1", new Header(ResManager.loadKDString((String)"*\u76ee\u6807\u6210\u5458\u7f16\u7801", (String)"DimMemberUploadPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"DimMemberUploadPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("2", new Header(ResManager.loadKDString((String)"*\u72b6\u6001", (String)"DimMemberUploadPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"DimMemberUploadPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        return headerMap;
    }

    private List<List<String>> validExcel(List<List<String>> dataList, List<List<String>> errList) {
        Long srcModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("srcModel"));
        String srcDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("srcDimNumber");
        Long srcViewId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("srcViewId"));
        Long tarModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("tarModel"));
        String tarDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("tarDimNumber");
        Long tarViewId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("tarViewId"));
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        Set srcAllMembers = srcModelCache.getMembers(srcViewId, srcDimNumber).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        IModelCacheHelper tarModelCache = ModelCacheContext.getOrCreate((Long)tarModelId);
        List tarAllMembers = tarModelCache.getMembers(tarViewId, tarDimNumber);
        Set tarAllMemberNums = tarAllMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        Set tarLeafMembers = tarAllMembers.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
        Boolean hasErr = Boolean.FALSE;
        LinkedList<List<String>> successList = new LinkedList<List<String>>();
        LinkedHashSet<String> repeats = new LinkedHashSet<String>();
        for (int i = 0; i < dataList.size(); ++i) {
            List<String> row = dataList.get(i);
            String srcMember = row.get(0);
            String tarMember = row.get(1);
            LinkedList<String> errMsgList = new LinkedList<String>();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)srcMember) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tarMember)) {
                errMsgList.add(ResManager.loadKDString((String)"\u6e90\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u76ee\u6807\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"DimMemberUploadPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)srcMember)) {
                errMsgList.add(ResManager.loadKDString((String)"\u6e90\u6210\u5458\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DimMemberUploadPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tarMember)) {
                errMsgList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u76ee\u6807\u6210\u5458\u7f16\u7801", (String)"DimMemberUploadPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                if (!srcAllMembers.contains(srcMember)) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u6e90\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728\u201c%1\u201d", (String)"DimMemberUploadPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{srcMember}));
                }
                if (!tarAllMemberNums.contains(tarMember)) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728\u201c%1\u201d", (String)"DimMemberUploadPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{tarMember}));
                } else if (!tarLeafMembers.contains(tarMember)) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u6210\u5458\u7f16\u7801\u201c%1\u201d\u975e\u53f6\u5b50\u8282\u70b9", (String)"DimMemberUploadPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{tarMember}));
                }
                repeats.clear();
                for (int j = 0; j < dataList.size(); ++j) {
                    List<String> strings;
                    boolean disjoint;
                    if (i == j || (disjoint = Collections.disjoint(row, strings = dataList.get(j)))) continue;
                    if (row.get(0).equals(strings.get(0)) && row.get(1).equals(strings.get(1))) {
                        repeats.add(ResManager.loadKDString((String)"\u5b58\u5728\u4e0e\u6e90\u6210\u5458\u7f16\u7801\u53ca\u76ee\u6807\u6210\u5458\u7f16\u7801\u5747\u91cd\u590d\u7684\u884c", (String)"DimMemberUploadPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (row.get(1).equals(strings.get(1))) {
                        repeats.add(ResManager.loadKDString((String)"\u5b58\u5728\u4e0e\u6e90\u6210\u5458\u7f16\u7801\u91cd\u590d\u7684\u884c", (String)"DimMemberUploadPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!row.get(0).equals(strings.get(0))) continue;
                    repeats.add(ResManager.loadKDString((String)"\u5b58\u5728\u4e0e\u6e90\u6210\u5458\u7f16\u7801\u91cd\u590d\u7684\u884c", (String)"DimMemberUploadPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                errMsgList.addAll(repeats);
            }
            ArrayList<String> cloneRow = new ArrayList<String>(row.size() + 1);
            cloneRow.add(String.join((CharSequence)",", errMsgList) + "\u3002");
            cloneRow.addAll(row);
            errList.add(cloneRow);
            if (!errMsgList.isEmpty()) {
                hasErr = Boolean.TRUE;
                continue;
            }
            successList.add(row);
        }
        if (hasErr.booleanValue()) {
            successList.clear();
            String tempPath = "dataintegration/modelMembermap.xlsx";
            BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(tempPath);
            XSSFWorkbook errorBook = new XSSFWorkbook();
            POIUtils.POIConfig poiConfig = new POIUtils.POIConfig();
            poiConfig.getSheetConfig((int)0).COPY_ColBeginIndex = 1;
            POIUtils.get().copyBook(excelWriter.getWorkbook(), (Workbook)errorBook, poiConfig);
            Sheet errorSheet = errorBook.getSheetAt(0);
            int in = errList.size();
            for (int i = 0; i < in; ++i) {
                List<String> errInfo = errList.get(i);
                int jn = errInfo.size();
                for (int j = 0; j < jn; ++j) {
                    Cell errorCell = POIUtils.getCell((Sheet)errorSheet, (int)(i + 3), (int)j);
                    if (j == 0) {
                        POIUtils.setCellStyleOfRed((Cell)errorCell);
                    }
                    errorCell.setCellValue(errInfo.get(j));
                }
            }
            POIUtils.downloadFile((IFormView)this.getView(), (Workbook)errorBook);
        } else {
            errList.clear();
        }
        return successList;
    }

    private List<ModelDimMemberMapObj> toObj(List<List<String>> dataList) {
        Long srcModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("srcModel"));
        String srcDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("srcDimNumber");
        Long srcViewId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("srcViewId"));
        Long tarModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("tarModel"));
        String tarDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("tarDimNumber");
        Long tarViewId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("tarViewId"));
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        Map<String, Member> srcMemberMap = srcModelCache.getMembers(srcViewId, srcDimNumber).stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e));
        IModelCacheHelper tarModelCache = ModelCacheContext.getOrCreate((Long)tarModelId);
        Map<String, Member> tarMemberMap = tarModelCache.getMembers(tarViewId, tarDimNumber).stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e));
        String stateStr = ResManager.loadKDString((String)"\u542f\u7528", (String)"DimMemberUploadPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        ArrayList<ModelDimMemberMapObj> objList = new ArrayList<ModelDimMemberMapObj>(dataList.size());
        for (List<String> row : dataList) {
            String srcMemberNumber = row.get(0);
            String tarMemberNumber = row.get(1);
            ModelDimMemberMapObj mapObj = (ModelDimMemberMapObj)Builder.of(ModelDimMemberMapObj::new).with(ModelDimMemberMapObj::setSrcmembername, (Object)srcMemberMap.get(srcMemberNumber).getName()).with(ModelDimMemberMapObj::setSrcmembernumber, (Object)srcMemberNumber).with(ModelDimMemberMapObj::setTarmembername, (Object)tarMemberMap.get(tarMemberNumber).getName()).with(ModelDimMemberMapObj::setTarmembernumber, (Object)tarMemberNumber).build();
            String _stateStr = row.get(2);
            mapObj.setState(stateStr.equals(_stateStr) || "1".equals(_stateStr));
            objList.add(mapObj);
        }
        return objList;
    }

    private void downloadTemplate() {
        ImportEntity importEntity = this.getTemplateData();
        FileImportUtils instance = FileImportUtils.getInstance((ImportEntity)importEntity);
        String url = instance.saveFileAsUrl(instance.createImportTemplate(), importEntity.getTemplateName());
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        ArrayList<String> fileType = new ArrayList<String>(16);
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            Map fileInfo = (Map)url;
            urls.add(fileInfo.get("url"));
            if (fileInfo.get("name") != null && (((String)fileInfo.get("name")).endsWith("xls") || ((String)fileInfo.get("name")).endsWith("XLS"))) {
                fileType.add("xls");
                continue;
            }
            if (fileInfo.get("name") == null || !((String)fileInfo.get("name")).endsWith("xlsx") && !((String)fileInfo.get("name")).endsWith("XLSX")) continue;
            fileType.add("xlsx");
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        this.getPageCache().put("fileType", SerializationUtils.toJsonString(fileType));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }
}

