/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.DimensionUtil;

public class EbShareDimensionEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SELECTDIMENSIONRANG = "selectdimensionrang";
    private static final String ENTRYENTITY = "dimentity";
    private static final String MODEL = "model";
    private static final String BIZMODEL = "bizmodel";
    private static final String DIMENSION = "dimension";
    private static final String APP = "app";
    private static final String CLOUD = "cloud";
    private static final String BILL = "bill";
    private static final String FIELD = "field";
    private static final String DIMENSIONRANGE = "dimensionrangejson";
    public static final String EB_ADDINSIDEBILL = "eb_addinsidebill";
    private static final String FIELDNUMBER = "fieldnumber";
    private static final String MEMBERID = "memberid";
    private static final String MEMBERNUMBER = "membernumber";
    private static final String MEMBERNAME = "membername";
    private static final String MEMBER_RANGE = "memberrange";
    private static final String MEMBER_VIEW_ID = "memberviewid";
    private static final String CACHE_DIMS = "cache_dims";

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MODEL});
        this.initModelId();
    }

    private void initModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            modelId = this.getView().getParentView().getPageCache().get("KEY_MODEL_ID");
        }
        if (modelId != null) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
        }
    }

    public void afterBindData(EventObject e) {
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            this.addDimensionFilter(model);
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION);
            String jsonString = (String)this.getModel().getValue(DIMENSIONRANGE);
            this.setDimensionRangeCache(dimension, jsonString);
            String strModelId = this.getPageCache().get("KEY_MODEL_ID");
            if (StringUtils.isEmpty((String)strModelId) && model != null) {
                this.getPageCache().put("KEY_MODEL_ID", model.getString("id"));
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete"});
        } else if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"saveandnew", MODEL});
        this.getModel().setDataChanged(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"bar_disable"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (SELECTDIMENSIONRANG.equals(key)) {
            this.openDimensionMemberRangeSelect();
        } else if (FIELD.equals(key)) {
            this.showSelectFieldForm();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (SELECTDIMENSIONRANG.equals(evt.getItemKey())) {
            this.openDimensionMemberRangeSelect();
        }
    }

    private void showSelectFieldForm() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(BILL);
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5355\u636e", (String)"EbShareDimensionEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_fieldselectform");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("billNumber", (Object)bill.getString("number"));
        formShowParameter.setCustomParam("billName", (Object)bill.getString("name"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectField"));
        this.getView().showForm(formShowParameter);
    }

    private void openDimensionMemberRangeSelect() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7ef4\u5ea6", (String)"EbShareDimensionEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long viewId = 0L;
        String number = dimension.getString("number");
        RangeF7Param param = new RangeF7Param();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dimrang");
        param.setCloseCallBack(closeCallBack);
        param.setNeedPermCheck(true);
        param.setEnableView(true);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entity != null && !entity.isEmpty()) {
            ArrayList<MemberCondition> members = new ArrayList<MemberCondition>(entity.size());
            for (DynamicObject dynamicObject : entity) {
                members.add(new MemberCondition(dynamicObject.getString(MEMBERNUMBER), dynamicObject.getString(MEMBERNAME), null, dynamicObject.getString(MEMBER_RANGE)));
                if (!IDUtils.isNull((long)viewId)) continue;
                viewId = dynamicObject.getLong(MEMBER_VIEW_ID);
            }
            param.setCon_list(members);
        }
        param.setBizModelId((Long)this.getValue(BIZMODEL, "id"));
        if (SysDimensionEnum.Account.getNumber().equals(number)) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("dataset", "in", (Object)BusinessModelServiceHelper.getInstance().queryDataSetIds(param.getBizModelId())));
            param.setqFilters(builder.toList());
        }
        param.setUserRange(CollectionUtils.asList((Object[])new String[]{String.valueOf(RangeEnum.ONLY.getIndex()), String.valueOf(RangeEnum.DIRECTSUB_EXCLUDE.getIndex()), String.valueOf(RangeEnum.DIRECTSUB.getIndex()), String.valueOf(RangeEnum.ALL_EXCLUDE.getIndex()), String.valueOf(RangeEnum.ALL.getIndex()), String.valueOf(RangeEnum.ALL_DETAIL.getIndex()), String.valueOf(RangeEnum.ALL_NOTDETAIL.getIndex())}));
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)number, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap"});
        BasedataEdit dimension = (BasedataEdit)this.getControl(DIMENSION);
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizModel = (BasedataEdit)this.getControl(BIZMODEL);
        bizModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bill = (BasedataEdit)this.getControl(BILL);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{SELECTDIMENSIONRANG, FIELD});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)e.getSource();
        baseShowParameter.setCustomParam("noNeedDefaultQFilter", null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (MODEL.equals(name)) {
            this.clearData(true);
            DynamicObject model = (DynamicObject)e.getProperty().getValue((Object)this.getModel().getDataEntity());
            this.addDimensionFilter(model);
        } else if (BIZMODEL.equals(name)) {
            this.clearData(false);
        } else if (DIMENSION.equals(name)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
        } else if (BILL.equals(name)) {
            this.getModel().setValue(FIELD, (Object)"");
            this.getModel().setValue(FIELDNUMBER, (Object)"");
            this.getModel().setValue(APP, null);
            this.getModel().setValue(CLOUD, null);
            this.getModel().setDataChanged(false);
            DynamicObject dynamicObject = (DynamicObject)e.getProperty().getValue((Object)this.getModel().getDataEntity());
            if (dynamicObject != null) {
                this.dealWithBillCloseCallBack(dynamicObject.getString("id"));
            }
        }
    }

    private void addDimensionFilter(DynamicObject model) {
        if (model == null) {
            return;
        }
        BasedataEdit dimension = (BasedataEdit)this.getControl(DIMENSION);
        ArrayList<QFilter> qFilters = dimension.getQFilters();
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(1);
        }
        qFilters.clear();
        qFilters.add(new QFilter(MODEL, "=", model.getPkValue()));
        dimension.setQFilters(qFilters);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (BILL.equals(name)) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BILL));
            listShowParameter.setFormId(EB_ADDINSIDEBILL);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u9009\u62e9\u5217\u8868", (String)"EbShareDimensionEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            listShowParameter.setShowTitle(true);
            listShowParameter.setStatus(OperationStatus.ADDNEW);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setHeight("680");
            css.setWidth("1200");
            listShowParameter.getOpenStyle().setInlineStyleCss(css);
            beforeF7SelectEvent.setFormShowParameter((FormShowParameter)listShowParameter);
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
        } else if (BIZMODEL.equals(name)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4f53\u7cfb", (String)"EbShareDimensionEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter(MODEL, "=", (Object)model.getLong("id")));
        } else if (DIMENSION.equals(name)) {
            DynamicObject bizModel = (DynamicObject)this.getModel().getValue(BIZMODEL);
            if (bizModel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"EbShareDimensionEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<String> dimensions = this.getDimensionList(bizModel.getLong("id"));
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("number", "in", dimensions));
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            Long modleId = model == null ? 0L : model.getLong("id");
            qFilters.add(new QFilter(MODEL, "=", (Object)modleId));
        }
    }

    private List<String> getDimensionList(long bizModelId) {
        List<String> dimensionList = DimensionUtil.getDimensionByBizModel(bizModelId);
        if (dimensionList.size() > 0) {
            this.getPageCache().put(CACHE_DIMS, SerializationUtils.toJsonString(dimensionList));
        }
        return dimensionList;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("dimrang".equals(actionId)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.dealReturnData((DynamicObjectCollection)returnData);
        } else if (BILL.equals(actionId)) {
            this.getModel().setValue(BILL, ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue());
        } else if ("selectField".equals(actionId)) {
            DynamicObject data = (DynamicObject)returnData;
            String number = data.getString("fullnumber");
            String name = data.getString("fullname");
            this.getModel().setValue(FIELDNUMBER, (Object)number);
            this.getModel().setDataChanged(false);
            this.getModel().setValue(FIELD, (Object)name);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"saveandnew"});
        }
    }

    private void dealReturnData(DynamicObjectCollection returnData) {
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        ArrayList<HashMap<String, Object>> cacheDimensionData = new ArrayList<HashMap<String, Object>>(16);
        for (int i = 0; i < returnData.size(); ++i) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            DynamicObject dynamicObject = (DynamicObject)returnData.get(i);
            String num = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            String id = dynamicObject.getString("mid");
            String scope = dynamicObject.getString("scope");
            String pid = dynamicObject.getString("pid");
            data.put("number", num);
            data.put("name", name);
            data.put("id", id);
            data.put("parent", pid);
            data.put("scope", scope);
            data.put("view", IDUtils.toLong((Object)dynamicObject.getString("viewId")));
            cacheDimensionData.add(data);
        }
        this.doFillDimEntry(cacheDimensionData);
    }

    private void doFillDimEntry(List<HashMap<String, Object>> dimensionData) {
        if (dimensionData == null || dimensionData.size() == 0) {
            return;
        }
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION);
        for (HashMap<String, Object> dimMap : dimensionData) {
            String num = dimMap.get("number").toString();
            String name = dimMap.get("name").toString();
            String id = dimMap.get("id").toString();
            String scope = dimMap.get("scope").toString();
            String view = dimMap.get("view").toString();
            int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, newEntryRow);
            entryRowEntity.set(MEMBERID, (Object)id);
            entryRowEntity.set(MEMBERNUMBER, (Object)num);
            entryRowEntity.set(MEMBERNAME, (Object)name);
            entryRowEntity.set(MEMBER_RANGE, (Object)scope);
            entryRowEntity.set(MEMBER_VIEW_ID, (Object)view);
        }
        String jsonString = SerializationUtils.toJsonString(dimensionData);
        this.getModel().beginInit();
        this.getModel().setValue(DIMENSIONRANGE, (Object)jsonString);
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        this.setDimensionRangeCache(dimension, jsonString);
    }

    private void dealWithBillCloseCallBack(String primaryKeyValue) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)};
        DynamicObject bill = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"bizappid", (QFilter[])qFilters);
        String bizappid = bill.getString("bizappid");
        QFilter[] qFilters1 = new QFilter[]{new QFilter("id", "=", (Object)bizappid)};
        DynamicObject bizapp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])qFilters1);
        if (bizapp != null) {
            String bizcloud = bizapp.getString("bizcloud");
            this.getModel().setValue(CLOUD, (Object)bizcloud);
        }
        this.getModel().setValue(APP, (Object)bizappid);
        this.getModel().setValue(BILL, (Object)primaryKeyValue);
    }

    private void clearData(Boolean bizmodel) {
        this.getModel().beginInit();
        if (bizmodel.booleanValue()) {
            this.getModel().setValue(BIZMODEL, null);
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().setValue(DIMENSION, null);
        this.getModel().setValue(DIMENSIONRANGE, null);
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        if (bizmodel.booleanValue()) {
            this.getView().updateView(BIZMODEL);
        }
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView(DIMENSION);
        this.getView().updateView(DIMENSIONRANGE);
    }

    private void setDimensionRangeCache(DynamicObject dimension, String jsonString) {
        String memberTreemodelByNumber = SysDimensionEnum.getMemberTreemodelByNumber((String)dimension.getString("number"));
        if (StringUtils.isEmpty((String)memberTreemodelByNumber)) {
            memberTreemodelByNumber = "bcm_userdefinemembertree";
        }
        this.getPageCache().put(memberTreemodelByNumber + dimension.getString("dseq"), jsonString);
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)strModelId)) {
            return Long.valueOf(strModelId);
        }
        Long modelid = (Long)this.getValue(MODEL, "id");
        if (this.isEmpty(modelid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a", (String)"EbShareDimensionEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelid;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String checkInfo;
        super.beforeDoOperation(args);
        String opearate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ((opearate.equals("save") || opearate.equals("saveandnew")) && (checkInfo = this.checkBeforeSave()) != null) {
            this.getView().showTipNotification(checkInfo);
            args.setCancel(true);
        }
    }

    public String checkBeforeSave() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String number = dynamicObject.getString("number");
        StringBuilder errorInfo = new StringBuilder();
        String regEx = "[A-Za-z0-9_]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            errorInfo.append(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u3002", (String)"EbSchemeGroupPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return errorInfo.toString();
        }
        return null;
    }

    public String getBizCtrlRangeKey() {
        return BIZMODEL;
    }
}

