/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;

public class EbShareDimensionList2Plugin
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.getPageCache().remove("KEY_MODEL_ID");
        this.getPageCache().remove("KEY_MODEL_IDS");
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumns.stream().filter(c -> c.getFieldName().equals("model.shownumber")).findFirst().get();
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>(16);
        modelQFilters.addAll(this.getModelFilter(true));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
        filterColumn.getComboItems().clear();
        ArrayList comboItems = new ArrayList(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        filterColumn.setComboItems(comboItems);
        Long modelid = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (IDUtils.isNull((Long)modelid)) {
            modelid = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        }
        if (this.isExistModel(modelid)) {
            filterColumn.setDefaultValue(modelid.toString());
            this.getPageCache().put("KEY_MODEL_ID", modelid.toString());
        }
    }

    private List<QFilter> getModelFilter(Boolean isModelList) {
        List modelQFilters = ModelUtil.getModelFilter((IFormView)this.getView());
        if (isModelList.booleanValue()) {
            long userId = UserUtils.getUserId();
            ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
            LinkedHashSet ids = Sets.newLinkedHashSet();
            Set limitedIds = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
            Set manageModelIds = FunPermissionHelper.getRoleModel((long)userId, (String)"epm_model", (ApplicationTypeEnum)application);
            ids.addAll(limitedIds);
            ids.addAll(manageModelIds);
            String billEntity = ((ListView)this.getView()).getBillFormId();
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            HasPermDimObjResult hasPermDimObjResult = permissionService.getHasPermDimObjs(userId, application.getAppnum(), billEntity, "47150e89000000ac");
            if (!hasPermDimObjResult.hasAllDimObjPerm()) {
                ids.retainAll(hasPermDimObjResult.getHasPermDimObjs());
            }
            modelQFilters.add(new QFilter("id", "in", (Object)ids));
            modelQFilters.add(new QFilter("enable", "=", (Object)"1"));
            modelQFilters.add(new QFilter("status", "=", (Object)"C"));
        }
        return modelQFilters;
    }

    private boolean isExistModel(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return Boolean.FALSE;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        if (orCreate == null) {
            return Boolean.FALSE;
        }
        Model model = orCreate.getModelobj();
        if (model == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("model.shownumber".equals(args.getFieldName())) {
            args.setCustomQFilters(this.getModelFilter(false));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List qFilters = args.getFilterParameter().getQFilters();
        this.getPageCache().remove("KEY_MODEL_ID");
        this.getPageCache().remove("KEY_MODEL_IDS");
        if (qFilters != null) {
            SearchClickEvent searchClickEvent;
            Long modelId;
            List pks;
            boolean isModelFilter = false;
            ArrayList<QFilter> modelFilters = new ArrayList<QFilter>(qFilters.size());
            for (QFilter qfilter : qFilters) {
                if (!qfilter.getProperty().startsWith("model.")) continue;
                modelFilters.add(new QFilter(qfilter.getProperty().replaceFirst("model.", ""), qfilter.getCP(), qfilter.getValue()));
            }
            if (!modelFilters.isEmpty() && (pks = QueryServiceHelper.queryPrimaryKeys((String)"epm_model", (QFilter[])modelFilters.toArray(new QFilter[0]), null, (int)2)) != null) {
                if (pks.size() == 1) {
                    modelId = IDUtils.toLong(pks.get(0));
                    this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                    UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
                    isModelFilter = true;
                } else if (pks.size() > 1) {
                    this.getPageCache().put("KEY_MODEL_IDS", JSONUtils.toString((Object)pks));
                }
            }
            if (!isModelFilter && (searchClickEvent = args.getSearchClickEvent()).getSelectMainOrgIds() != null && searchClickEvent.getSelectMainOrgIds().size() > 0) {
                modelId = (Long)searchClickEvent.getSelectMainOrgIds().get(0);
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = 0L;
        try {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("new".equals(opType)) {
            this.toNew(args);
        }
    }

    private void toNew(BeforeDoOperationEventArgs args) {
        Long modelId = this.getModelId();
        if (modelId == null || modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbShareDimensionList2Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)strModelId)) {
            try {
                return Long.valueOf(strModelId);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbShareDimensionList2Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        String strModelIds = this.getPageCache().get("KEY_MODEL_IDS");
        if (StringUtils.isNotEmpty((String)strModelIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8fc7\u6ee4\u6761\u4ef6\u5339\u914d\u5230\u591a\u4e2a\u4f53\u7cfb\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u4f53\u7cfb\u3002", (String)"EbShareDimensionList2Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbShareDimensionList2Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

