/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.common.utils.obj.ObjectUtils;
import kd.epm.eb.control.face.ICalcParameter;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.CalcObjectParameter;
import kd.epm.eb.control.impl.ControlParameter;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BudgetBalance;
import kd.epm.eb.control.utils.BgControlParamUtils;
import kd.epm.eb.control.utils.BgControlSchemeUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.control.utils.OQLBuilder;
import kd.epm.eb.formplugin.dataintegration.plugin.EbShareDimensionTreef7Plugin;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class EbShareDimensionTreef7ByControlPlugin
extends EbShareDimensionTreef7Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFilterDataMemberNumbers(List<String> memberNumbers, Set<String> shareMemberNumbers, Boolean filterNoneData) {
        log.info("EbShareDimensionTreef7ByControl begin");
        String billNumber = super.getBillNumber();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ControlParameter parameter = new ControlParameter();
        IFormView parentView = this.getView().getViewNoPlugin(formShowParameter.getParentPageId());
        if (parentView == null) {
            return;
        }
        DynamicObject dataEntity = parentView.getModel().getDataEntity(true);
        DynamicObject bizObjClone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dataEntity, (boolean)true, (boolean)false);
        parameter.setCalcParameter((ICalcParameter)new CalcObjectParameter(bizObjClone, null));
        parameter.setHasShareQuery(true);
        LogStats logStats = new LogStats("budget-control-log : ");
        logStats.addInfo("begin ebShareByControl");
        String[] props = BgRegisterUtils.queryRegisterBizUnit((String)parameter.getEntityNumber());
        if (props == null) {
            ControlException.notDefaultBizProp((String)parameter.getEntityNumber());
        }
        Object[] objProps = BgRegisterUtils.getBizUnit((LogStats)logStats, (IControlParameter)parameter, (String[])props);
        BgRegisterUtils.checkDefaultProps((LogStats)logStats, (Object[])objProps, (String[])props);
        BizOrgUnit bizOrgUnit = (BizOrgUnit)objProps[0];
        Date bizTime = (Date)objProps[1];
        BgControlData controlData = new BgControlData(null, bizOrgUnit, bizTime, logStats);
        controlData.setMultiControl(BgRegisterUtils.isMultiControl((String[])props));
        logStats.add("bizOrgUnit(id = " + bizOrgUnit.getId() + "; number = " + bizOrgUnit.getNumber() + ")");
        logStats.add("bizTime = " + DateTimeUtils.format((LocalDateTime)DateTimeUtils.parse((Date)bizTime)));
        Collection models = parameter.getBizUtils().queryModel(bizTime, false);
        models = parameter.getBizUtils().filterModel(models, controlData);
        if (models != null && !models.isEmpty()) {
            if (models.size() > 1 && !controlData.isMultiControl()) {
                ControlException.existMoreModel((Collection)models);
            }
            BizModel bizModel = (BizModel)models.iterator().next();
            List dimensions = BgDimensionServiceHelper.getDimensionByModel((BizModel)bizModel, (boolean)false);
            dimensions = bizModel.filterControlDims(dimensions);
            bizModel.setDimension(dimensions);
            Long controlBusModelId = bizModel.getControlBusModelId();
            long bizModelId = super.getBizModelId();
            if (!controlBusModelId.equals(bizModelId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63a7\u5236\u83b7\u53d6\u5230\u7684\u4e1a\u52a1\u6a21\u578b\u4e0e\u5171\u4eab\u7684\u4e1a\u52a1\u6a21\u578b\u4e0d\u4e00\u81f4\u3002", (String)"EbShareDimensionTreef7Plugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObject startVersion = bizModel.getStartVersion();
            if (startVersion == null) {
                ControlException.notModelOrVersion();
                return;
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)bizModel.getId());
            long dataTypeId = startVersion.getLong("datatype.id");
            kd.epm.eb.common.cache.impl.Member dataTypeMember = modelCacheHelper.getMember(SysDimensionEnum.DataType.getNumber(), null, Long.valueOf(dataTypeId));
            if (dataTypeMember == null) {
                dataTypeMember = modelCacheHelper.getMember(SysDimensionEnum.DataType.getNumber(), null, "Budget");
            }
            long auditTrailId = startVersion.getLong("audittrail.id");
            kd.epm.eb.common.cache.impl.Member auditTrailMember = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, Long.valueOf(auditTrailId));
            if (auditTrailMember == null) {
                auditTrailMember = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, "ATTotal");
            }
            long versionId = startVersion.getLong("version.id");
            kd.epm.eb.common.cache.impl.Member versionMember = modelCacheHelper.getMember(SysDimensionEnum.Version.getNumber(), null, Long.valueOf(versionId));
            controlData.setBizModels(models);
            Map schemas = BgControlSchemeUtils.query((BgControlData)controlData, (String)billNumber, (Boolean)true);
            if (schemas == null || schemas.isEmpty()) {
                if (controlData.isMultiControl()) {
                    ControlException.notDimensionMappings((String)parameter.getEntityNumber());
                } else {
                    ControlException.notDimensionMapping((BizModel)((BizModel)controlData.getBizModels().values().iterator().next()), (String)parameter.getEntityNumber());
                }
                return;
            }
            Collection<IControlParam> controlParams = this.getControlParams((IControlParameter)parameter, controlData, schemas);
            if (controlParams.isEmpty()) {
                super.getFilterDataMemberNumbers(memberNumbers, shareMemberNumbers, filterNoneData);
                return;
            }
            OlapConnection connection = null;
            String shareDimNumber = super.getDimmensionNumber();
            HashSet existDataMemberNumbers = new HashSet(shareMemberNumbers.size());
            if (filterNoneData.booleanValue()) {
                for (IControlParam controlParam : controlParams) {
                    kd.epm.eb.common.cache.impl.Member member;
                    Member accountMember;
                    Long accountDatasetId = 0L;
                    Long modelId = controlParam.getBizModel().getId();
                    IModelCacheHelper helper = ModelCacheContext.getOrCreate((Long)modelId);
                    String accountDimNumber = SysDimensionEnum.Account.getNumber();
                    if (!accountDimNumber.equals((accountMember = ((BudgetBalance)controlParam).getMember(true, accountDimNumber)).getNumber()) && (member = helper.getMember(accountDimNumber, null, accountMember.getNumber())) != null) {
                        accountDatasetId = member.getDatasetId();
                    }
                    try {
                        List allDatasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
                        for (Dataset dataset : allDatasets) {
                            if (accountDatasetId > 0L && !accountDatasetId.equals(dataset.getId())) continue;
                            HashMap executeMap = new HashMap(16);
                            executeMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                            executeMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                            if (versionMember != null) {
                                executeMap.put(SysDimensionEnum.Version.getNumber(), versionMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                            }
                            List dimNumList = helper.getDimensionList(dataset.getId()).stream().map(BaseCache::getNumber).collect(Collectors.toList());
                            for (String dimNumber : dimNumList) {
                                if (dimNumber.equals(SysDimensionEnum.Version.getNumber()) || dimNumber.equals(SysDimensionEnum.DataType.getNumber()) || dimNumber.equals(SysDimensionEnum.AuditTrail.getNumber())) continue;
                                Member budMember = ((BudgetBalance)controlParam).getMember(true, dimNumber);
                                Long viewId = BusinessModelServiceHelper.getInstance().getViewId(controlBusModelId, dimNumber, modelId);
                                kd.epm.eb.common.cache.impl.Member member2 = helper.getMember(dimNumber, viewId, budMember.getNumber());
                                if (member2 == null) continue;
                                executeMap.put(dimNumber, member2.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                            }
                            connection = ShrekOlapServiceHelper.getConnection((Model)helper.getModelobj(), (Dataset)dataset);
                            Map hasTrimRightMap = ShrekExecuteServiceHelper.analyzeRange((Model)helper.getModelobj(), (Dataset)dataset, null, executeMap);
                            Set members = (Set)hasTrimRightMap.get(shareDimNumber);
                            if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                            existDataMemberNumbers.addAll(members);
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.Close();
                    }
                }
                memberNumbers.clear();
                memberNumbers.addAll(existDataMemberNumbers);
            } else {
                HashSet<String> actShareMemberNumbers = new HashSet<String>(shareMemberNumbers.size());
                for (IControlParam controlParam : controlParams) {
                    Long modelId = controlParam.getBizModel().getId();
                    IModelCacheHelper helper = ModelCacheContext.getOrCreate((Long)modelId);
                    Member member = ((BudgetBalance)controlParam).getMember(true, shareDimNumber);
                    Long viewId = BusinessModelServiceHelper.getInstance().getViewId(controlBusModelId, shareDimNumber, modelId);
                    kd.epm.eb.common.cache.impl.Member shareMember = helper.getMember(shareDimNumber, viewId, member.getNumber());
                    if (shareMember == null || shareDimNumber.equals(shareMember.getNumber())) {
                        actShareMemberNumbers.addAll(shareMemberNumbers);
                        continue;
                    }
                    if (!shareMemberNumbers.contains(member.getNumber())) continue;
                    actShareMemberNumbers.add(member.getNumber());
                }
                memberNumbers.clear();
                memberNumbers.addAll(actShareMemberNumbers);
            }
        } else {
            ControlException.notModelOrVersion();
        }
        log.info("EbShareDimensionTreef7ByControl end memberNumbers " + JSON.toJSONString(memberNumbers));
    }

    @NotNull
    private Collection<IControlParam> getControlParams(IControlParameter parameter, BgControlData controlData, Map<String, Collection<BgControlScheme>> schemas) {
        DynamicObject model = null;
        boolean hasSchema = false;
        List<Map<String, Object>> propsMap = new LinkedList();
        OQLBuilder oqlBuilder = new OQLBuilder();
        HashSet<Long> hasSchemeKeys = new HashSet<Long>(10);
        BizModel bizModel = null;
        HashMap<String, Collection> bizModelMap = new HashMap<String, Collection>(10);
        LinkedList<IControlParam> controlParams = new LinkedList<IControlParam>();
        for (Map.Entry<String, Collection<BgControlScheme>> _schemas : schemas.entrySet()) {
            hasSchemeKeys.clear();
            hasSchema = false;
            for (BgControlScheme schema : _schemas.getValue()) {
                Collection<IControlParam> _params;
                if (hasSchemeKeys.contains(schema.getBizModelKey())) continue;
                bizModel = (BizModel)controlData.getBizModels().get(schema.getBizModelKey());
                if (bizModel == null) {
                    log.info("budget-control-log : nofound-scheme=" + schema.getBizModelKey());
                    continue;
                }
                propsMap.clear();
                oqlBuilder.builder(parameter, parameter.getEntityNumber(), controlData, schema, true);
                if (parameter.getControlManager().isStandard()) {
                    if (parameter.getBizObj() == null) {
                        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBizBill", (String)parameter.getEntityNumber(), (String)oqlBuilder.getFields(), (QFilter[])oqlBuilder.getBuilder().toArrays(), null);){
                            propsMap.addAll(CommonServiceHelper.transDataSet((DataSet)ds));
                        }
                    }
                    model = ObjectUtils.filterObject((DynamicObject)parameter.getBizObj(), (QFilter[])oqlBuilder.getBuilder().toArrays(), (boolean)true);
                    if (model != null) {
                        propsMap = ObjectUtils.toMap((DynamicObject)model, (String[])oqlBuilder.getFields().split(","));
                    }
                } else {
                    Map.Entry entry2 = null;
                    HashMap propMap = null;
                    for (Map bizObj : parameter.getBizObjMaps()) {
                        propMap = Maps.newHashMapWithExpectedSize((int)bizObj.size());
                        for (Map.Entry entry2 : bizObj.entrySet()) {
                            propMap.put(((String)entry2.getKey()).toLowerCase(), entry2.getValue());
                        }
                        propsMap.add(propMap);
                    }
                }
                try {
                    log.info("budget-control-log : " + JSONUtils.toString(propsMap));
                }
                catch (Throwable entry2) {
                    // empty catch block
                }
                if (StringUtils.isNotEmpty((String)schema.getCondition())) {
                    controlData.getStats().addInfo("begin-run-condition.");
                    log.info("budget-control-log : " + schema.getCondition());
                    ArrayList _filterProps = Lists.newArrayListWithCapacity((int)propsMap.size());
                    ConditionUtils utils = ConditionUtils.get();
                    ConditionUtils.QFilterEvaluator evaluator = new ConditionUtils.QFilterEvaluator();
                    for (Map<String, Object> variable : propsMap) {
                        evaluator.setValues(variable);
                        if (!utils.run(schema.getFilter(), evaluator)) continue;
                        _filterProps.add(variable);
                    }
                    propsMap.clear();
                    propsMap.addAll(_filterProps);
                    controlData.getStats().add("end-run-condition.");
                }
                hasSchemeKeys.add(schema.getBizModelKey());
                hasSchema = true;
                if (schema.hasMapping((BizModel)controlData.getBizModels().get(schema.getBizModelKey()))) {
                    schema.loadMapping((BizModel)controlData.getBizModels().get(schema.getBizModelKey()));
                }
                if ((_params = this.builderParams(parameter, schema, controlData, oqlBuilder.getProps(), propsMap)) == null) continue;
                controlParams.addAll(_params);
                break;
            }
            for (BizModel _bizModel : controlData.getBizModels().values()) {
                if (hasSchemeKeys.contains(_bizModel.getKey())) continue;
                bizModelMap.computeIfAbsent(_schemas.getKey(), f -> new ArrayList(10)).add(_bizModel);
            }
        }
        if (controlData.isMultiControl()) {
            if (!bizModelMap.isEmpty()) {
                ControlException.notDimensionMappings(bizModelMap, (String)parameter.getEntityNumber(), null);
            }
        } else if (controlParams.isEmpty()) {
            ControlException.notDimensionMapping((BizModel)((BizModel)controlData.getBizModels().values().iterator().next()), (String)parameter.getEntityNumber());
        }
        return controlParams;
    }

    private Collection<IControlParam> builderParams(IControlParameter parameter, BgControlScheme schema, BgControlData controlData, Map<String, String> props, List<Map<String, Object>> propsMap) {
        return BgControlParamUtils.get().setParameter(parameter).setScheme(schema).builderParams(controlData, props, propsMap);
    }
}

