/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.entity.memberF7.BaseDataInfo;
import kd.epm.eb.common.entity.memberF7.BaseF7Parameter;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimShareType;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberF7.MemberF7ServiceHelper;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.control.impl.model.BgItemMapping;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import kd.epm.eb.formplugin.utils.DimensionUtil;
import org.apache.commons.collections4.CollectionUtils;

public class EbShareDimensionTreef7Plugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
CreateListColumnsListener,
CreateListDataProviderListener,
ListRowClickListener,
F7SelectedListRemoveListener,
SetFilterListener {
    private static final String TREEVIEW = "treeview";
    private static final String BILLLIST = "billlistap";
    private Map<String, String> listShowFieldsMap = new HashMap<String, String>(16);
    private boolean isOnlyLoadLeaf = true;
    private Long modelId = 0L;
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String BILLNUMBER = "billNumber";
    private static final String FIELDNUMBER = "fieldNumber";
    private static final String DYNAMICOBJECT = "dynamicObject";
    private static final String ALLLEAF = "allleaf";
    private List<String> relationMems = null;
    private List<HashMap<String, Object>> shareMems = null;
    private List<DynamicObject> dimMapRuleDys = null;
    private static final String CACHEKEY_RELATIONMEM = "CacheKey_RelataionMem";
    private static final String CACHEKEY_RELATIONFLAG = "CacheKey_RelataionFlag";
    private static final String CACHEKEY_DIM2MEM = "CacheKey_Dim2Mem";
    private static final String CACHEKEY_SHAREMEMS = "CacheKey_ShareMems";
    private static final String EB_STRUCTOFBILL = "eb_structofbill";
    private static final String EB_BGCONTROLDEFAULT = "eb_bgcontroldefault";
    private static final String EB_DIMMATERULE = "eb_dimmaterule";
    public static Log log = LogFactory.getLog(EbShareDimensionTreef7Plugin.class);
    private static Boolean writelog = true;
    private static final String EB_SHARE_DIMENSION = "ebsharedimension";

    public EbShareDimensionTreef7Plugin() {
        this.listShowFieldsMap.put("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"EbShareDimensionTreef7Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.listShowFieldsMap.put("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"EbShareDimensionTreef7Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.listShowFieldsMap.put("isleaf", ResManager.loadKDString((String)"\u660e\u7ec6\u8282\u70b9", (String)"EbShareDimensionTreef7Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void initialize() {
        this.initData();
        this.init();
        this.initBillList();
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(this.isMulSelect()), new String[]{F7SELECTEDLISTAP});
        this.openLeftTreeF7();
    }

    private void openLeftTreeF7() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EB_SHARE_DIMENSION);
        LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
        leftTreeF7Parameter.setCheckPerm(false);
        leftTreeF7Parameter.setKeepTree(false);
        leftTreeF7Parameter.setMultiple(false);
        IFormView formView = this.getView();
        leftTreeF7Parameter.setOpenByButto(Boolean.TRUE.booleanValue());
        String dimensionNumber = this.getDimmensionNumber();
        List<HashMap<String, Object>> shareMemberMaps = this.getShareMembersMap();
        ArrayList<String> memberNumbers = new ArrayList<String>(shareMemberMaps.size());
        Set<String> shareMemberNumbers = shareMemberMaps.stream().map(e -> (String)e.get("number")).collect(Collectors.toSet());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean filterNoneData = (Boolean)formShowParameter.getCustomParam("filternonedata");
        this.getFilterDataMemberNumbers(memberNumbers, shareMemberNumbers, filterNoneData);
        Long viewId = (Long)formShowParameter.getCustomParam("view");
        if (viewId != null) {
            leftTreeF7Parameter.setViewId(viewId);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("number", "in", memberNumbers));
        leftTreeF7Parameter.setqFilters(filters);
        MemberF7ServiceHelper memberF7Utils = MemberF7ServiceHelper.getInstance();
        BaseDataInfo baseInfo = memberF7Utils.getBaseDataInfoByBusModel(this.getBizModelId(), dimensionNumber, (BaseF7Parameter)leftTreeF7Parameter);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)baseInfo.getMemberKey(), (boolean)leftTreeF7Parameter.isMultiple());
        memberF7Utils.setDisplayForTextButton(showParameter, leftTreeF7Parameter.getEchoIds(), baseInfo);
        memberF7Utils.setListShowParameterByF7(showParameter, baseInfo, (BaseF7Parameter)leftTreeF7Parameter, false);
        memberF7Utils.setPlugin(baseInfo, showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap3");
        showParameter.getListFilterParameter().getQFilters().addAll(leftTreeF7Parameter.getqFilters());
        showParameter.setCloseCallBack(closeCallBack);
        formView.showForm((FormShowParameter)showParameter);
    }

    public void getFilterDataMemberNumbers(List<String> memberNumbers, Set<String> shareMemberNumbers, Boolean filterNoneData) {
        log.info("EbShareDimensionTreef7 begin");
        String dimensionNumber = this.getDimmensionNumber();
        if (filterNoneData.booleanValue()) {
            boolean isIgnoreZero = true;
            Long busModelId = this.getBizModelId();
            List<Dataset> datasets = new ArrayList();
            if (IDUtils.isNotNull((Long)busModelId)) {
                List datasetIds = DatasetServiceHelper.getDataSetIdByBusModelIds((Set)kd.epm.eb.common.utils.CollectionUtils.asSet((Object[])new Long[]{busModelId}));
                if (!datasetIds.isEmpty()) {
                    QFBuilder builder = new QFBuilder();
                    builder.add("id", "in", (Object)datasetIds);
                    Map _datasets = BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)"id,number", (QFilter[])builder.toArray());
                    for (DynamicObject _dataset : _datasets.values()) {
                        datasets.add(new Dataset(Long.valueOf(_dataset.getLong("id")), _dataset.getString("number")));
                    }
                }
            } else {
                datasets = DatasetServiceHelper.getAllDatasets((Long)this.modelId);
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
            Model model = modelCacheHelper.getModelobj();
            Set existDataMembers = ShrekOlapServiceHelper.getExistDataMemberByNotNull((Model)model, datasets, (String)dimensionNumber, shareMemberNumbers, (boolean)isIgnoreZero);
            memberNumbers.addAll(existDataMembers);
        } else {
            memberNumbers.addAll(shareMemberNumbers);
        }
        log.info("EbShareDimensionTreef7 end memberNumbers " + JSON.toJSONString(memberNumbers));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok", "btnclose"});
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        if (f7SelectedList != null) {
            f7SelectedList.addF7SelectedListRemoveAllListener(this::removeAllClick);
            f7SelectedList.addF7SelectedListRemoveListener(this::RemoveClick);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ALLLEAF.equals(name)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            billList.refresh();
        }
    }

    private void initData() {
        this.modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
        Boolean isOnlyLoadLeaf = (Boolean)this.getView().getFormShowParameter().getCustomParam("isOnlyLoadLeaf");
        if (isOnlyLoadLeaf != null) {
            this.isOnlyLoadLeaf = isOnlyLoadLeaf;
        }
    }

    private void initBillList() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListGridView gridview = (ListGridView)this.getControl("gridview");
        gridview.setOrderAndFilter(1);
        billList.setBillFormId(this.getDimmensionMemberTree());
        billList.setDraggable(false);
        billList.setDroppable(false);
        if (this.isMulSelect()) {
            billList.setMulti(true);
        }
        billList.setOrderBy("level,number,dseq");
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addSetFilterListener(this::setFilter);
    }

    private void init() {
        FilterContainer filtercontainerap = (FilterContainer)this.getControl("filtercontainerap");
        if (filtercontainerap != null) {
            filtercontainerap.setBillFormId(this.getDimmensionMemberTree());
            filtercontainerap.setTitle(new LocaleString(ResManager.loadKDString((String)"\u7ef4\u5ea6\u9009\u62e9\u5217\u8868", (String)"EbShareDimensionTreef7Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            filtercontainerap.getContext().setLookup(true);
            filtercontainerap.addSearchClickListener(listener -> {
                List fastQFilters = listener.getFastQFilters();
                BillList billList = (BillList)this.getControl(BILLLIST);
                billList.getQueryFilterParameter().getQFilters().addAll(fastQFilters);
                billList.refreshData();
            });
        }
    }

    private Set<String> getRelationFilterMems() {
        HashSet<String> memFilters = new HashSet<String>(16);
        Set<String> shareMems = this.getShareMems();
        memFilters.addAll(shareMems);
        return memFilters;
    }

    Boolean isFilterRelation() {
        Boolean result = false;
        result = !StringUtils.isEmpty((String)this.getPageCache().get(CACHEKEY_RELATIONFLAG)) && "1".equals(this.getPageCache().get(CACHEKEY_RELATIONFLAG));
        return result;
    }

    private String getDimmensionMemberTree() {
        return (String)this.getView().getFormShowParameter().getCustomParam("memberTree");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.clearSelection();
        billList.bindData(null);
        if (!this.isMulSelect()) {
            billList.selectRows(0, true);
        }
    }

    private List<QFilter> getBillListQFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)this.getModelId()));
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        Map focusNode = treeView.getTreeState().getFocusNode();
        Boolean value = (Boolean)this.getModel().getValue(ALLLEAF);
        if (focusNode != null) {
            Object id = focusNode.get("id");
            if (value != null && value.booleanValue()) {
                TreeNode treeNode;
                String longnumber = null;
                TreeNode virtualRoot = this.getVirtualRoot();
                if (virtualRoot != null && (treeNode = virtualRoot.getTreeNode((String)id, 20)) != null) {
                    longnumber = treeNode.getLongNumber();
                }
                if (StringUtils.isNotEmpty(longnumber)) {
                    qFilters.add(new QFilter("longnumber", "like", (Object)(longnumber + "%")));
                }
            }
            if (value != null && !value.booleanValue() && StringUtils.isNotEmpty((String)((String)id))) {
                QFilter qf1 = new QFilter("id", "=", id).or("parent", "=", id);
                qFilters.add(qf1);
            }
        }
        if (this.isOnlyLoadLeaf) {
            qFilters.add(new QFilter("isleaf", "=", (Object)true));
        }
        Set<String> relationFilterMems = this.getRelationFilterMems();
        String dimMemData = this.getPageCache().get("dimmemberData");
        if (dimMemData != null && !dimMemData.isEmpty()) {
            Set dimmemberData = (Set)SerializationUtils.deSerializeFromBase64((String)dimMemData);
            relationFilterMems.retainAll(dimmemberData);
        }
        qFilters.add(new QFilter("number", "in", relationFilterMems));
        String qFiltersStr = (String)this.getView().getFormShowParameter().getCustomParam("qFilters");
        try {
            if (!StringUtils.isEmpty((String)qFiltersStr)) {
                List cusQFilters = (List)SerializationUtils.deSerializeFromBase64((String)qFiltersStr);
                qFilters.addAll(cusQFilters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return qFilters;
    }

    public void createListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        List listColumns = beforeCreateListColumnsArgs.getListColumns();
        listColumns.clear();
        for (Map.Entry<String, String> entry : this.listShowFieldsMap.entrySet()) {
            ListColumn listColumn = new ListColumn();
            listColumn.setListFieldKey(entry.getKey());
            listColumn.setCaption(new LocaleString(entry.getValue()));
            listColumn.setWidth(new LocaleString("140px"));
            listColumns.add(listColumn);
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        BillList billList = (BillList)beforeCreateListDataProviderArgs.getSource();
        billList.getQueryFilterParameter().getQFilters().addAll(this.getBillListQFilters());
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                return data;
            }
        });
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u884c\uff01", (String)"EbShareDimensionTreef7Plugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getView().returnDataToParent((Object)selectedRows);
            this.getView().close();
        } else if ("btnclose".equals(source.getKey())) {
            this.getView().close();
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String billNumber = (String)formShowParameter.getCustomParam(BILLNUMBER);
        String fieldNumber = (String)formShowParameter.getCustomParam(FIELDNUMBER);
        log.info("getbillnumberandfieldnumber-" + billNumber + "," + fieldNumber);
        if (StringUtils.isNotEmpty((String)billNumber) && StringUtils.isNotEmpty((String)fieldNumber)) {
            this.initNeedData(formShowParameter, billNumber, fieldNumber);
            formShowParameter.setCustomParam("isMul", (Object)false);
        }
        this.checkNeedData(formShowParameter);
        Boolean isMul = (Boolean)formShowParameter.getCustomParam("isMul");
        if (isMul != null && !isMul.booleanValue()) {
            e.setFormWidth("900px");
        }
        try {
            Field formConfigField = e.getClass().getDeclaredField("formConfig");
            ReflectionUtils.makeAccessible((Field)formConfigField);
            Map formConfig = (Map)formConfigField.get(e);
            HashMap metas = new HashMap(1);
            ArrayList list = new ArrayList(3);
            HashMap<String, Object> ctl = new HashMap<String, Object>(2);
            ctl.put("id", BILLLIST);
            ctl.put("ismul", isMul);
            list.add(ctl);
            HashMap<String, Object> ctl2 = new HashMap<String, Object>(2);
            ctl2.put("id", "filtercontainerap");
            ctl2.put("islk", true);
            list.add(ctl2);
            metas.put("items", list);
            formConfig.put("metas", metas);
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u591a\u9009\u5931\u8d25", (String)"EbShareDimensionTreef7Plugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "", "splitcontainerap", "flexpanelap2"});
        HashMap<String, Object> gridview = new HashMap<String, Object>(16);
        gridview.put("gr", 1);
        gridview.put("id", "gridview");
        gridview.put("phide", true);
        gridview.put("type", "grid");
        gridview.put("vi", 63);
        this.getView().updateControlMetadata("gridview", gridview);
        BillList billList = (BillList)this.getControl(BILLLIST);
        if (!this.isMulSelect()) {
            billList.selectRows(0, true);
        }
    }

    private boolean isMulSelect() {
        Object isMul = this.getView().getFormShowParameter().getCustomParam("isMul");
        return isMul == null ? false : (Boolean)isMul;
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        if (f7SelectedList != null) {
            ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(16);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                valueTextItems.add(new ValueTextItem(selectedRow.getPrimaryKeyValue().toString(), selectedRow.getName()));
            }
            f7SelectedList.addItems(valueTextItems);
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        Object param = f7SelectedListRemoveEvent.getParam();
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        selectedRows.removeIf(row -> row.getPrimaryKeyValue().toString().equals(param));
        this.getPageCache().put("billlistap_listSelectedRowCollection", selectedRows.serialize());
        billList.refresh();
    }

    public void removeAllClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.clearSelection();
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        for (QFilter qFilter : qFilters) {
            if (!"isleaf".equals(qFilter.getProperty())) continue;
            if (!"in".equals(qFilter.getCP())) break;
            if (!(qFilter.getValue() instanceof ArrayList) || ((ArrayList)qFilter.getValue()).size() != 1) continue;
            if (((ArrayList)qFilter.getValue()).get(0).equals("1")) {
                ((ArrayList)qFilter.getValue()).set(0, "0");
                continue;
            }
            ((ArrayList)qFilter.getValue()).set(0, "1");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (!EB_SHARE_DIMENSION.equals(actionId)) return;
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
        if (selectedRowCollection != null) {
            if (selectedRowCollection.size() == 0) throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u884c\uff01", (String)"EbShareDimensionTreef7Plugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            String returnDataJson = JSON.toJSONString((Object)selectedRowCollection);
            this.writeLogInfo(ResManager.loadResFormat((String)"EbShareDimensionTreef7Plugin\u8fd4\u56de\u6210\u5458\uff1areturnData->%1", (String)"EbShareDimensionTreef7Plugin_42_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{returnDataJson}));
            this.getView().returnDataToParent((Object)selectedRowCollection);
            this.getView().close();
            return;
        } else {
            this.getView().close();
        }
    }

    private void checkNeedData(FormShowParameter formShowParameter) {
        String memberTree = (String)formShowParameter.getCustomParam("memberTree");
        if (StringUtils.isEmpty((String)memberTree)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201cmemberTree\u201d\u4e3a\u7a7a\u3002", (String)"EbShareDimensionTreef7Plugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String dimNumber = (String)formShowParameter.getCustomParam("dimNumber");
        if (StringUtils.isEmpty((String)dimNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201cdimNumber\u201d\u4e3a\u7a7a\u3002", (String)"EbShareDimensionTreef7Plugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String modelId = formShowParameter.getCustomParam("modelId").toString();
        if (StringUtils.isEmpty((String)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201cmodelId\u201d\u4e3a\u7a7a\u3002", (String)"EbShareDimensionTreef7Plugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void initNeedData(FormShowParameter formShowParameter, String billNumber, String fieldNumber) {
        QFilter billQf = new QFilter("bill.number", "=", (Object)billNumber);
        QFilter fieldQf = new QFilter("fieldnumber", "=", (Object)fieldNumber);
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_sharedimension", (String)"number,model,bizmodel,dimension.number,dimensionrangejson,filternonedata", (QFilter[])new QFilter[]{billQf, fieldQf, enableQf});
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7ef4\u5ea6\u5171\u4eab\u6570\u636e\u3002", (String)"EbShareDimensionTreef7Plugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String model = dynamicObject.getString("model");
        formShowParameter.setCustomParam("modelId", (Object)model);
        String bizmodel = dynamicObject.getString("bizmodel");
        formShowParameter.setCustomParam("bizmodel", (Object)bizmodel);
        String dimensionNumber = dynamicObject.getString("dimension.number");
        formShowParameter.setCustomParam("dimNumber", (Object)dimensionNumber);
        String dimensionrangejson_tag = dynamicObject.getString("dimensionrangejson");
        formShowParameter.setCustomParam("dimensionrang", (Object)dimensionrangejson_tag);
        log.info("dimensionNumber:" + dimensionNumber + ",dimensionrangejson_tag" + dimensionrangejson_tag);
        Boolean filterNoneData = dynamicObject.getBoolean("filternonedata");
        formShowParameter.setCustomParam("filternonedata", (Object)filterNoneData);
        String memberTreemodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimensionNumber);
        if (StringUtils.isEmpty((String)memberTreemodel)) {
            memberTreemodel = "epm_userdefinedmembertree";
        }
        formShowParameter.setCustomParam("memberTree", (Object)memberTreemodel);
    }

    private TreeNode getVirtualRoot() {
        String rootNode = this.getPageCache().get("rootNode");
        try {
            return (TreeNode)SerializationUtils.deSerializeFromBase64((String)rootNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set<String> getShareMems() {
        Set<String> memberList = new HashSet<String>(16);
        List<HashMap<String, Object>> memMaps = this.getShareMembers();
        if (memMaps != null && memMaps.size() > 0) {
            memberList = memMaps.stream().map(memMap -> memMap.get("number").toString()).collect(Collectors.toSet());
        }
        return memberList;
    }

    private List<HashMap<String, Object>> getShareMembersMap() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String dimensionrang = (String)formShowParameter.getCustomParam("dimensionrang");
        log.info("dimensionrang:" + dimensionrang);
        String dimmensionNumber = this.getDimmensionNumber();
        List ranges = new ArrayList(16);
        if (!StringUtils.isEmpty((String)dimensionrang)) {
            ranges = SerializationUtils.fromJsonStringToList((String)dimensionrang, HashMap.class);
        }
        Model model = ModelCacheContext.getOrCreate((Long)this.modelId).getModelobj();
        ArrayList<HashMap<String, Object>> memberList = new ArrayList<HashMap<String, Object>>(16);
        HashSet<Long> viewIdSet = new HashSet<Long>(ranges.size());
        for (HashMap map : ranges) {
            int range = 0;
            if (map.get("scope") instanceof String) {
                range = Integer.parseInt((String)map.get("scope"));
            } else if (map.get("scope") instanceof Integer) {
                range = (Integer)map.get("scope");
            }
            long viewId = 0L;
            if (map.get("view") != null) {
                viewId = IDUtils.toLong(map.get("view"));
            }
            viewIdSet.add(viewId);
            List members = ModelCacheServiceHelper.getMember((Model)model, (String)dimmensionNumber, (Long)viewId, (String)((String)map.get("number")), (int)range);
            for (Member member : members) {
                HashMap<String, Object> dim = new HashMap<String, Object>(16);
                dim.put("name", member.getName());
                dim.put("id", member.getId());
                dim.put("parent", member.getParentId());
                dim.put("isleaf", member.isLeaf());
                dim.put("longnumber", member.getLongNumber());
                dim.put("number", member.getNumber());
                memberList.add(dim);
            }
        }
        formShowParameter.setCustomParam("view", viewIdSet.iterator().next());
        return memberList;
    }

    private List<HashMap<String, Object>> getShareMembers() {
        if (this.shareMems != null && this.shareMems.size() != 0) {
            return this.shareMems;
        }
        String memsCache = this.getPageCache().get(CACHEKEY_SHAREMEMS);
        if (!StringUtils.isEmpty((String)memsCache)) {
            this.shareMems = (List)SerializationUtils.fromJsonString((String)memsCache, List.class);
            return this.shareMems;
        }
        List<HashMap<String, Object>> result = this.getShareMembersMap();
        if (result.size() != 0) {
            this.shareMems = result;
            this.getPageCache().put(CACHEKEY_SHAREMEMS, SerializationUtils.toJsonString(this.shareMems));
        }
        return result;
    }

    List<String> getRelationMems() {
        if (this.relationMems != null && this.relationMems.size() != 0) {
            return this.relationMems;
        }
        String memsCache = this.getPageCache().get(CACHEKEY_RELATIONMEM);
        if (!StringUtils.isEmpty((String)memsCache)) {
            this.relationMems = (List)SerializationUtils.fromJsonString((String)memsCache, List.class);
            return this.relationMems;
        }
        MemDataEntry memDataEntry = this.getRelationMem();
        if (memDataEntry != null) {
            this.relationMems = memDataEntry.data;
            this.getPageCache().put(CACHEKEY_RELATIONMEM, SerializationUtils.toJsonString((Object)memDataEntry.data));
            this.getPageCache().put(CACHEKEY_RELATIONFLAG, memDataEntry.flag);
        } else {
            this.relationMems = new ArrayList<String>(0);
            this.getPageCache().put(CACHEKEY_RELATIONMEM, "");
            this.getPageCache().put(CACHEKEY_RELATIONFLAG, "0");
        }
        return this.relationMems;
    }

    private MemDataEntry getRelationMem() {
        MemDataEntry result = new MemDataEntry();
        result.flag = "0";
        result.data = new ArrayList(0);
        String dim = this.getDimmensionNumber();
        List<Map<String, String>> fieldMaps = this.getCustomRelationMaps();
        String billNum = this.getBillNumber();
        Map<String, String> dim2MemMap = this.getBudgetDim2MemMap(billNum, fieldMaps);
        this.writeLogInfo(ResManager.loadResFormat((String)"EbShareDimensionTreef7Plugin\u4f20\u5165\u53c2\u6570\uff1adim2MemMap->%1 dim->%2 billNum->%3", (String)"EbShareDimensionTreef7Plugin_21_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{SerializationUtils.toJsonString(dim2MemMap), dim, billNum}));
        if (dim2MemMap == null || dim2MemMap.size() == 0) {
            this.getPageCache().put(CACHEKEY_DIM2MEM, "");
            this.writeLogInfo(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin\u83b7\u53d6\u6210\u5458\uff1adim2MemMap->\u4e3a\u7a7a", (String)"EbShareDimensionTreef7Plugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        this.getPageCache().put(CACHEKEY_DIM2MEM, SerializationUtils.toJsonString(dim2MemMap));
        result = this.getRelationMem(dim, dim2MemMap);
        String logParamStr = result.data == null ? ResManager.loadKDString((String)"\u201cRelationMem\u201d\u4e3a\u7a7a\u3002", (String)"EbShareDimensionTreef7Plugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]) : SerializationUtils.toJsonString((Object)result.data);
        this.writeLogInfo(ResManager.loadResFormat((String)"EbShareDimensionTreef7Plugin\u83b7\u53d6\u6210\u5458\uff1agetRelationMem->%1", (String)"EbShareDimensionTreef7Plugin_24_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{logParamStr}));
        return result;
    }

    private MemDataEntry getRelationMem(String dim, Map<String, String> dim2MemMap) {
        MemDataEntry result = new MemDataEntry();
        if (dim2MemMap == null || dim2MemMap.size() == 0) {
            result.flag = "0";
            result.data = new ArrayList(0);
            return result;
        }
        result = this.getDimRelationMems(dim, dim2MemMap);
        return result;
    }

    public MemDataEntry getDimRelationMems(String dim, Map<String, String> dimMemberMap) {
        MemDataEntry result = new MemDataEntry();
        result.flag = "0";
        result.data = new ArrayList(0);
        List dimRelationList = DimensionRelationUtils.getRelationList((Long)this.getModelId(), null);
        Map dimRelationMap = DimensionRelationUtils.getRelationMap((Long)this.getModelId(), null, (List)dimRelationList);
        log.info("EbShareDimensionTreef7Plugin_getDimRelationMems dim " + dim + " dimMemberMap " + JSON.toJSONString(dimMemberMap));
        log.info("EbShareDimensionTreef7Plugin_getDimRelationMems dimRelationMap " + JSON.toJSONString((Object)dimRelationMap) + " dimRelationList " + dimRelationList);
        for (Map.Entry<String, String> relationDim : dimMemberMap.entrySet()) {
            String curKey = relationDim.getKey();
            if (!dimRelationMap.containsKey(curKey) || !((Set)dimRelationMap.get(curKey)).contains(dim)) continue;
            result.flag = "1";
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Set relationMemNum = DimensionRelationUtils.getRelationMemNum((IModelCacheHelper)modelCache, (Long)0L, (String)dim, (Long)0L, dimMemberMap, (Map)dimRelationMap, (List)dimRelationList);
        log.info("EbShareDimensionTreef7Plugin_getDimRelationMems curMembers " + JSON.toJSONString((Object)relationMemNum));
        if (CollectionUtils.isNotEmpty((Collection)relationMemNum)) {
            result.data = new ArrayList(relationMemNum);
            result.data = DimensionUtil.getAllChildMemeber(this.getModelId(), dim, null, result.data);
        }
        return result;
    }

    private Map<String, String> getBudgetDim2MemMap(String billNumber, List<Map<String, String>> fieldMaps) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        long bizmodel = this.getBizModelId();
        String billNum = this.getBillNumber();
        if (fieldMaps == null || fieldMaps.size() == 0) {
            return result;
        }
        Map<String, String> shareFieldMap = fieldMaps.stream().filter(tem -> DimShareType.BUDGETDIM.getIndex().equals(tem.get("type"))).collect(Collectors.toMap(tem -> (String)tem.get("key"), tem -> (String)tem.get("value")));
        Map<String, String> shareDim = this.getShareRelation(bizmodel, billNum, shareFieldMap);
        this.writeLogInfo(String.format(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin_getBudgetDim2MemMap\u83b7\u53d6\u7ef4\u5ea6\u5171\u4eab\u6210\u5458shareDim[%s]", (String)"EbShareDimensionTreef7Plugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(shareDim)));
        Map<String, String> dimShareMap = fieldMaps.stream().filter(tem -> !StringUtils.isEmpty((String)((String)tem.get("value"))) && DimShareType.BASEDATA.getIndex().equals(tem.get("type")) && tem.get("dimtype") != null && DimShareType.BUDGETDIM.getIndex().equals(tem.get("dimtype"))).collect(Collectors.toMap(tem -> (String)tem.get("key"), tem -> (String)tem.get("value")));
        Map<String, String> dimShareDim = this.getBudgetControlMapByDim(billNum, dimShareMap);
        String number = dimShareDim.get(SysDimensionEnum.Entity.getNumber());
        if (StringUtils.isBlank((String)number)) {
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.modelId);
            Map viewIds = orCreate.getViewsByBusModel(Long.valueOf(bizmodel));
            Long viewId = (Long)viewIds.get(SysDimensionEnum.Entity.getNumber());
            Member member = null;
            for (Map.Entry<String, String> entry : dimShareMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!"org".equals(key)) continue;
                member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), viewId, value);
                break;
            }
            if (member != null) {
                dimShareDim.put(SysDimensionEnum.Entity.getNumber(), member.getNumber());
            }
        }
        this.writeLogInfo(String.format(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin_getBudgetDim2MemMap\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u6210\u5458dimShareDim[%s]", (String)"EbShareDimensionTreef7Plugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(dimShareDim)));
        Map<String, String> dimMapRuleMap = fieldMaps.stream().filter(tem -> !StringUtils.isEmpty((String)((String)tem.get("value"))) && DimShareType.BASEDATA.getIndex().equals(tem.get("type")) && (tem.get("dimtype") == null || DimShareType.BASEDATA.getIndex().equals(tem.get("dimtype")))).collect(Collectors.toMap(tem -> (String)tem.get("key"), tem -> (String)tem.get("value")));
        Map<String, String> dimMapRuleDim = this.getControlMap(billNum, dimMapRuleMap);
        this.writeLogInfo(String.format(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin_getBudgetDim2MemMap\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u6210\u5458dimMapRuleDim[%s]", (String)"EbShareDimensionTreef7Plugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(dimMapRuleDim)));
        result.putAll(shareDim);
        result.putAll(dimShareDim);
        result.putAll(dimMapRuleDim);
        return result;
    }

    private Map<String, String> getBudgetControlMapByDim(String billNumber, Map<String, String> field2ValueMap) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        if (field2ValueMap == null || field2ValueMap.size() == 0) {
            return result;
        }
        Map<String, String> dim2FieldValueMap = this.getShareRelation(this.getBizModelId(), billNumber, field2ValueMap);
        List<DynamicObject> dimMapRuleDys = this.getDimMapRuleDys(billNumber);
        if (dimMapRuleDys != null && dimMapRuleDys.size() > 0) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
            Map viewIds = modelCacheHelper.getViewsByBusModel(Long.valueOf(this.getBizModelId()));
            for (DynamicObject subFieldDy : dimMapRuleDys) {
                Map<String, String> dimMemMapping = this.getBudgetDimMemMapping(subFieldDy, dim2FieldValueMap, modelCacheHelper, viewIds);
                result.putAll(dimMemMapping);
            }
        }
        return result;
    }

    private Map<String, String> getBudgetDimMemMapping(DynamicObject subFieldDy, Map<String, String> dim2FieldValueMap, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        HashMap<String, String> dim2MemMap = new HashMap<String, String>(16);
        if (dim2FieldValueMap == null || dim2FieldValueMap.size() == 0) {
            return dim2MemMap;
        }
        this.writeLogInfo(ResManager.loadResFormat((String)"EbShareDimensionTreef7Plugin\u4f20\u5165\u53c2\u6570\uff1agetBudgetDimMemMapping->%1", (String)"EbShareDimensionTreef7Plugin_30_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{SerializationUtils.toJsonString(dim2FieldValueMap)}));
        String dim = "";
        String fieldValue = "";
        String memMapKey = "";
        String mem = "";
        for (Map.Entry<String, String> entry : dim2FieldValueMap.entrySet()) {
            fieldValue = entry.getValue();
            dim = entry.getKey();
            memMapKey = this.getMemMapKeyByDim(subFieldDy, dim, modelCacheHelper);
            if (StringUtils.isEmpty((String)memMapKey) || StringUtils.isEmpty((String)fieldValue)) continue;
            Long memMappingId = subFieldDy.getLong(memMapKey + "_id");
            mem = memMappingId == 0L ? fieldValue : this.getMemMapping(memMappingId, fieldValue, modelCacheHelper, viewIds);
            dim2MemMap.put(dim, mem);
        }
        return dim2MemMap;
    }

    private String getMemMapKeyByDim(DynamicObject subFieldDy, String dimNum, IModelCacheHelper modelCacheHelper) {
        String memMapKey = "";
        Map<String, String> dim2MemMapKeyMap = this.getDim2MemMapKeyMap();
        if (dim2MemMapKeyMap.containsKey(dimNum)) {
            memMapKey = dim2MemMapKeyMap.get(dimNum);
        } else {
            String dimIdKey = "";
            Long dimId = 0L;
            for (int i = 1; i <= 6; ++i) {
                Dimension dimension;
                dimIdKey = "userdefineddimid" + i;
                dimId = subFieldDy.getLong(dimIdKey);
                if (dimId == 0L || (dimension = modelCacheHelper.getDimension(dimId)) == null || !dimNum.equals(dimension.getNumber())) continue;
                memMapKey = "userdefined" + i + "dimsionmap";
            }
        }
        return memMapKey;
    }

    private Map<String, String> getDim2MemMapKeyMap() {
        HashMap<String, String> dim2MemMapKeyMap = new HashMap<String, String>(16);
        dim2MemMapKeyMap.put(SysDimensionEnum.Entity.getNumber(), "entrydimsionmap");
        dim2MemMapKeyMap.put(SysDimensionEnum.Account.getNumber(), "accountdimsionmap");
        dim2MemMapKeyMap.put(SysDimensionEnum.Period.getNumber(), "yeardimsionmap");
        dim2MemMapKeyMap.put(SysDimensionEnum.Currency.getNumber(), "currencydimsionmap");
        dim2MemMapKeyMap.put(SysDimensionEnum.Project.getNumber(), "projectdimsionmap");
        return dim2MemMapKeyMap;
    }

    private Map<String, String> getShareRelation(long bizModel, String billNumber, Map<String, String> fieldMap) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        if (fieldMap == null || fieldMap.size() == 0) {
            return result;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("bill.number", "=", (Object)billNumber));
        filters.add(new QFilter("fieldnumber", "in", fieldMap.keySet()));
        filters.add(new QFilter("bizmodel", "=", (Object)bizModel));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_sharedimension", (String)"fieldnumber,dimension.number dimension", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        log.info("EbShareDimensionTreef7Plugin_getShareRelation dynamicObjects " + SerializationUtils.toJsonString((Object)dynamicObjects) + " fieldMap " + JSON.toJSONString(fieldMap));
        String fieldnumber = "";
        String dimension = "";
        for (DynamicObject dy : dynamicObjects) {
            fieldnumber = dy.getString("fieldnumber");
            dimension = dy.getString("dimension");
            if (!fieldMap.containsKey(fieldnumber)) continue;
            result.put(dimension, fieldMap.get(fieldnumber));
        }
        return result;
    }

    private Map<String, String> getControlMap(String billNumber, Map<String, String> field2ValueMap) {
        log.info("EbShareDimensionTreef7Plugin_getControlMap billNumber " + billNumber + " field2ValueMap " + JSON.toJSONString(field2ValueMap));
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        if (field2ValueMap == null || field2ValueMap.size() == 0) {
            return result;
        }
        List<DynamicObject> dimMapRuleDys = this.getDimMapRuleDys(billNumber);
        log.info("EbShareDimensionTreef7Plugin_getControlMap dimMapRuleDys " + SerializationUtils.toJsonString(dimMapRuleDys));
        if (dimMapRuleDys != null && dimMapRuleDys.size() > 0) {
            for (DynamicObject dimMapRuleDy : dimMapRuleDys) {
                result.putAll(this.getDim2MemMapByField(dimMapRuleDy, field2ValueMap));
            }
        }
        return result;
    }

    private List<DynamicObject> getDimMapRuleDys(String billNumber) {
        if (this.dimMapRuleDys != null && this.dimMapRuleDys.size() > 0) {
            return this.dimMapRuleDys;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        Date effectDate = null;
        DynamicObject controlDefaultDy = null;
        DynamicObject struct = QueryServiceHelper.queryOne((String)EB_STRUCTOFBILL, (String)"id,name,number", (QFilter[])new QFilter("number", "=", (Object)billNumber).toArray());
        if (struct == null) {
            this.writeLogInfo(String.format(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin_getControlMap\u83b7\u53d6[%s]\u6ce8\u518c\u5355\u636e\u4e3a\u7a7a", (String)"EbShareDimensionTreef7Plugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]), billNumber));
            return result;
        }
        controlDefaultDy = QueryServiceHelper.queryOne((String)EB_BGCONTROLDEFAULT, (String)"periodfield.name,periodfield.number periodfield", (QFilter[])new QFilter[]{new QFilter("bill", "=", (Object)struct.getLong("id")), new QFilter("fieldtable", "=", (Object)billNumber)});
        if (controlDefaultDy == null) {
            this.writeLogInfo(String.format(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin_getControlMap\u83b7\u53d6[%s]\u9ed8\u8ba4\u8d22\u5e74\u671f\u95f4\u5339\u914d\u5b57\u6bb5(periodfield)\u4e3a\u7a7a", (String)"EbShareDimensionTreef7Plugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]), billNumber));
            return result;
        }
        String dataField = controlDefaultDy.getString("periodfield");
        DynamicObject dy = this.getDynamicObject();
        effectDate = dy.getDate(dataField);
        if (effectDate == null) {
            this.writeLogInfo(String.format(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin_getControlMap\u83b7\u53d6[%s]\u65f6\u95f4\u503ceffectDate\u4e3a\u7a7a", (String)"EbShareDimensionTreef7Plugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]), dataField));
            return result;
        }
        DynamicObjectCollection dimRuleIdDys = QueryServiceHelper.query((String)EB_DIMMATERULE, (String)"id", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).toArray());
        if (dimRuleIdDys.size() == 0) {
            this.writeLogInfo(ResManager.loadKDString((String)"EbShareDimensionTreef7Plugin_getControlMap\u83b7\u53d6\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u4e3a\u7a7a", (String)"EbShareDimensionTreef7Plugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        Object[] pkArr = dimRuleIdDys.stream().map(idDy -> idDy.get("id")).collect(Collectors.toList()).toArray();
        MainEntityType dimRuleType = EntityMetadataCache.getDataEntityType((String)EB_DIMMATERULE);
        DynamicObject[] dimRuleDyArr = BusinessDataServiceHelper.load((Object[])pkArr, (DynamicObjectType)dimRuleType);
        ArrayList<DynamicObject> dimRuleIdDyList = new ArrayList<DynamicObject>(Arrays.asList(dimRuleDyArr));
        for (DynamicObject dynamicObject : dimRuleIdDyList) {
            DynamicObjectCollection entityDys = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entityDy : entityDys) {
                DynamicObjectCollection subEntityDys = entityDy.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntityDy : subEntityDys) {
                    String billStr;
                    DynamicObject subFieldDy = null;
                    if ((DynamicObject)subEntityDy.get("bill") != null && (billStr = ((DynamicObject)subEntityDy.get("bill")).getString("id")).equals(struct.getString("id"))) {
                        Date eff = (Date)subEntityDy.get("effectivetime");
                        Date inv = (Date)subEntityDy.get("invalidtime");
                        if (inv != null) {
                            if (effectDate.compareTo(eff) >= 0 && inv.compareTo(effectDate) >= 0) {
                                subFieldDy = subEntityDy;
                            }
                        } else if (effectDate.compareTo(eff) >= 0) {
                            subFieldDy = subEntityDy;
                        }
                    }
                    if (subFieldDy == null) continue;
                    result.add(subFieldDy);
                }
            }
        }
        return result;
    }

    private Map<String, String> getDim2MemMapByField(DynamicObject subFieldDy, Map<String, String> field2ValueMap) {
        HashSet<Long> controlBizRegIds = new HashSet<Long>(16);
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "entryfield"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "accountfield"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "yearfield"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "currencyfield"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "userdefined1field"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "userdefined2field"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "userdefined3field"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "userdefined4field"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "userdefined5field"));
        controlBizRegIds.add(this.getControlBizRegId(subFieldDy, "userdefined6field"));
        DynamicObjectCollection fieldRegDys = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)"id,fieldalias", (QFilter[])new QFilter("id", "in", controlBizRegIds).toArray());
        HashMap<Long, String> fieldRegMap = new HashMap<Long, String>(16);
        for (DynamicObject fieldRegDy : fieldRegDys) {
            fieldRegMap.put(fieldRegDy.getLong("id"), fieldRegDy.getString("fieldalias"));
        }
        HashMap<String, String> dim2MemMap = new HashMap<String, String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map viewIds = modelCacheHelper.getViewsByBusModel(Long.valueOf(this.getBizModelId()));
        String memNum = this.getControlDimMemMapping(subFieldDy, "entryfield", "entrydimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper, viewIds);
        this.addFieldDimMap(SysDimensionEnum.Entity.getNumber(), memNum, dim2MemMap);
        memNum = this.getControlDimMemMapping(subFieldDy, "accountfield", "accountdimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper, viewIds);
        this.addFieldDimMap(SysDimensionEnum.Account.getNumber(), memNum, dim2MemMap);
        memNum = this.getControlDimMemMapping(subFieldDy, "yearfield", "yeardimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper, viewIds);
        this.addFieldDimMap(SysDimensionEnum.Period.getNumber(), memNum, dim2MemMap);
        memNum = this.getControlDimMemMapping(subFieldDy, "currencyfield", "currencydimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper, viewIds);
        this.addFieldDimMap(SysDimensionEnum.Currency.getNumber(), memNum, dim2MemMap);
        dim2MemMap.putAll(this.getFieldUserdefinedDimMap(subFieldDy, "userdefined1field", "userdefineddimid1", "userdefined1dimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper));
        dim2MemMap.putAll(this.getFieldUserdefinedDimMap(subFieldDy, "userdefined2field", "userdefineddimid2", "userdefined2dimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper));
        dim2MemMap.putAll(this.getFieldUserdefinedDimMap(subFieldDy, "userdefined3field", "userdefineddimid3", "userdefined3dimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper));
        dim2MemMap.putAll(this.getFieldUserdefinedDimMap(subFieldDy, "userdefined4field", "userdefineddimid4", "userdefined4dimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper));
        dim2MemMap.putAll(this.getFieldUserdefinedDimMap(subFieldDy, "userdefined5field", "userdefineddimid5", "userdefined5dimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper));
        dim2MemMap.putAll(this.getFieldUserdefinedDimMap(subFieldDy, "userdefined6field", "userdefineddimid6", "userdefined6dimsionmap", fieldRegMap, field2ValueMap, modelCacheHelper));
        log.info("EbShareDimensionTreef7Plugin_getControlMap getDim2MemMapByField " + JSON.toJSONString(dim2MemMap));
        return dim2MemMap;
    }

    private void addFieldDimMap(String dim, String field, Map<String, String> fieldDimMap) {
        if (!StringUtils.isEmpty((String)field) && !StringUtils.isEmpty((String)dim)) {
            fieldDimMap.put(dim, field);
        }
    }

    private String getControlDimMemMapping(DynamicObject subFieldDy, String fieldkey, String memMapKey, Map<Long, String> fieldRegMap, Map<String, String> field2ValueMap, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        String memNum = "";
        String field = this.getFieldNum(subFieldDy, fieldkey, fieldRegMap);
        if (StringUtils.isEmpty((String)field)) {
            return memNum;
        }
        String fieldValue = field2ValueMap.get(field);
        if (StringUtils.isEmpty((String)fieldValue)) {
            return memNum;
        }
        Long memMappingId = subFieldDy.getLong(memMapKey + "_id");
        if (memMappingId == 0L) {
            if (field2ValueMap.containsKey(field)) {
                memNum = field2ValueMap.get(field);
            }
        } else {
            memNum = this.getMemMapping(memMappingId, fieldValue, modelCacheHelper, viewIds);
        }
        return memNum;
    }

    private String getMemMapping(Long mappingId, String field2Value, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        String memNum = "";
        if (mappingId == 0L || StringUtils.isEmpty((String)field2Value)) {
            return memNum;
        }
        Set<Long> mappingIdSet = Collections.singleton(mappingId);
        Map dimMemMapping = BgMemMappingServiceHelper.loadMapping(mappingIdSet);
        if (dimMemMapping.containsKey(mappingId)) {
            BgItemMapping curItemMapping = (BgItemMapping)dimMemMapping.get(mappingId);
            String dim = curItemMapping.getDim();
            for (Map onlyMap : curItemMapping.getOnlyEntry().values()) {
                String bizNum = (String)onlyMap.get("binu");
                if (!bizNum.equals(field2Value)) continue;
                memNum = this.getMemByMapping(onlyMap, dim, modelCacheHelper, viewIds);
                return memNum;
            }
            String entityId = this.getMappingBizForm(mappingId);
            List<DynamicObject> allBaseDataIds = DimensionUtil.getAllBaseDataIds(entityId);
            for (Map childMap : curItemMapping.getChild().values()) {
                String bizNum = (String)childMap.get("binu");
                Set<String> allChilds = DimensionUtil.getBaseDataScopeNums(entityId, bizNum, allBaseDataIds);
                if (!allChilds.contains(field2Value)) continue;
                memNum = this.getMemByMapping(childMap, dim, modelCacheHelper, viewIds);
                return memNum;
            }
        }
        return memNum;
    }

    private String getMappingBizForm(long id) {
        String formId = "";
        DynamicObject fromIdDy = QueryServiceHelper.queryOne((String)"eb_dimmembermapping", (String)"businessbasedata", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (fromIdDy != null) {
            formId = fromIdDy.getString("businessbasedata");
        }
        return formId;
    }

    private String getMemByMapping(Map<String, String> mapping, String dim, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        String memNum = "";
        memNum = mapping.get("bgbunu");
        if (StringUtils.isEmpty((String)memNum)) {
            memNum = mapping.get("bginu");
        } else {
            Member member = modelCacheHelper.getMember(dim, viewIds.get(dim), memNum);
            if (member != null && !member.isLeaf()) {
                memNum = mapping.get("bginu");
            }
        }
        return memNum;
    }

    private String getFieldNum(DynamicObject subFieldDy, String fieldkey, Map<Long, String> fieldRegMap) {
        String field = "";
        if (subFieldDy.getDynamicObject(fieldkey) == null) {
            return field;
        }
        long fieldDyPk = subFieldDy.getDynamicObject(fieldkey).getLong("id");
        if (!fieldRegMap.containsKey(fieldDyPk)) {
            return field;
        }
        field = fieldRegMap.get(fieldDyPk);
        return field;
    }

    private Map<String, String> getFieldUserdefinedDimMap(DynamicObject subFieldDy, String fieldKey, String dimIdKey, String memMapKey, Map<Long, String> regFieldMap, Map<String, String> field2ValueMap, IModelCacheHelper modelCacheHelper) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (StringUtils.isEmpty((String)fieldKey) || subFieldDy.getDynamicObject(fieldKey) == null || subFieldDy.getLong(dimIdKey) == 0L) {
            return result;
        }
        long fieldDyPk = subFieldDy.getDynamicObject(fieldKey).getLong("id");
        if (!regFieldMap.containsKey(fieldDyPk)) {
            return result;
        }
        String field = regFieldMap.get(fieldDyPk);
        String fieldValue = field2ValueMap.get(field);
        if (StringUtils.isEmpty((String)fieldValue)) {
            return result;
        }
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(subFieldDy.getLong(dimIdKey)));
        Map viewIds = modelCacheHelper.getViewsByBusModel(Long.valueOf(this.getBizModelId()));
        if (dimension == null) {
            return result;
        }
        String dimNum = dimension.getNumber();
        String memNum = "";
        Long memMappingId = subFieldDy.getLong(memMapKey + "_id");
        if (memMappingId == 0L) {
            if (field2ValueMap.containsKey(field)) {
                memNum = field2ValueMap.get(field);
            }
        } else {
            memNum = this.getMemMapping(memMappingId, fieldValue, modelCacheHelper, viewIds);
        }
        if (!StringUtils.isEmpty((String)memNum)) {
            result.put(dimNum, memNum);
        }
        return result;
    }

    private long getControlBizRegId(DynamicObject subFieldDy, String key) {
        long id = 0L;
        if (subFieldDy.getDynamicObject(key) != null) {
            id = subFieldDy.getDynamicObject(key).getLong("id");
        }
        return id;
    }

    private String getRelation() {
        return (String)this.getView().getFormShowParameter().getCustomParam("relation");
    }

    public String getDimmensionNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("dimNumber");
    }

    Long getModelId() {
        if (IDUtils.isNotEmptyLong((Long)this.modelId).booleanValue()) {
            return this.modelId;
        }
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
    }

    public long getBizModelId() {
        long bizModelId = 0L;
        Object bizModeParam = this.getView().getFormShowParameter().getCustomParam("bizmodel");
        if (bizModeParam != null && !StringUtils.isEmpty((String)bizModeParam.toString())) {
            bizModelId = Long.parseLong(bizModeParam.toString());
        }
        return bizModelId;
    }

    public String getBillNumber() {
        String billNumber = (String)this.getView().getFormShowParameter().getCustomParam(BILLNUMBER);
        return billNumber;
    }

    private DynamicObject getDynamicObject() {
        DynamicObject dy = null;
        if (this.getView().getFormShowParameter().getCustomParam(DYNAMICOBJECT) != null) {
            dy = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)((String)this.getView().getFormShowParameter().getCustomParam(BILLNUMBER)), (String)((String)this.getView().getFormShowParameter().getCustomParam(DYNAMICOBJECT)));
        } else if (this.getView().getParentView() != null) {
            dy = this.getView().getParentView().getModel().getDataEntity();
        }
        if (dy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9875\u9762\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EbShareDimensionTreef7Plugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return dy;
    }

    private List<Map<String, String>> getCustomRelationMaps() {
        List<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        String relationJson = this.getRelation();
        this.writeLogInfo(ResManager.loadResFormat((String)"EbShareDimensionTreef7Plugin\u53c2\u6570\uff1agetCustomRelationMaps->%1", (String)"EbShareDimensionTreef7Plugin_39_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{relationJson}));
        if (!StringUtils.isEmpty((String)relationJson)) {
            result = (List)SerializationUtils.fromJsonString((String)relationJson, List.class);
        }
        return result;
    }

    private void writeLogInfo(String msg) {
        if (writelog.booleanValue()) {
            log.info(msg);
        }
    }

    static class MemDataEntry {
        private List<String> data;
        private String flag;

        MemDataEntry() {
        }
    }
}

