/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.dataintegration.GLField;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.GLMapCondition;
import kd.epm.eb.business.dataintegration.entity.GlBizFieldType;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dataintegration.CompareSign;
import kd.epm.eb.common.dataintegration.DataIntegrationGetDataType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.LogicSign;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataintegration.plugin.DataIntegrationBasePlugin;

public class GLDataIntegrationPlugin
extends DataIntegrationBasePlugin
implements RowClickEventListener {
    private static final String MAP_SCHEME_ENTRY = "dimmapscheme_entry";
    private static final String MAP_CONDITION_ENTRY = "mapcondition_entry";
    private static final String CURRENCY_KEY = "currency";

    @Override
    public void initialize() {
        super.initialize();
        EntryGrid glMapEntryGrid = (EntryGrid)this.getControl("gldimmapentity");
        glMapEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        EntryGrid mapConditionEntryGrid = (EntryGrid)this.getControl(MAP_CONDITION_ENTRY);
        mapConditionEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"calculatemodel", "calculateview", "calculateorgmem", "accounttable", "accountbooktype", "calculateperiodtype"});
        this.addClickListeners(new String[]{"c_valueshow", "glsrcfieldname", "calculateorgmem"});
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCurrencyList();
        this.setGetDataComboItems(true);
        this.setDefaultCalculateModel();
        this.setDefaultCalculateView();
        this.setDefaultAccountBookType();
        this.setDefaultCalculatePeriodType();
        this.setConditionFieldComboItems();
        this.reloadPageMapSchemeAndRangeData();
    }

    private void initCurrencyList() {
        DynamicObjectCollection bd_currency = QueryServiceHelper.query((String)"bd_currency", (String)"id,number,name", null, (String)"sortcode");
        ComboEdit comboEdit = (ComboEdit)this.getControl(CURRENCY_KEY);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(bd_currency.size() + 1);
        ComboItem allSum = new ComboItem();
        allSum.setValue("-1");
        allSum.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"GLDataIntegrationPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        items.add(allSum);
        bd_currency.forEach(obj -> {
            ComboItem item = new ComboItem();
            item.setValue(obj.getString("id"));
            item.setCaption(new LocaleString(obj.getString("name") + "(" + obj.getString("number") + ")"));
            items.add(item);
        });
        comboEdit.setComboItems(items);
    }

    protected void reloadPageMapSchemeAndRangeData() {
        this.setDefaultDimMapScheme();
        this.updateIntegrationRangeEntry(true);
    }

    private void setGetDataComboItems(boolean isAdd) {
        DataIntegrationGetDataType[] values = DataIntegrationGetDataType.values();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(values.length);
        for (DataIntegrationGetDataType value : values) {
            items.add(new ComboItem(new LocaleString(value.getEbTitle()), value.getVal()));
        }
        ComboEdit comboItem = (ComboEdit)this.getControl("getdatatype");
        comboItem.setComboItems(items);
        if (isAdd) {
            this.getModel().setValue("getdatatype", (Object)DataIntegrationGetDataType.PERIOD_OCCUR_FOR.getVal());
        }
    }

    private void setDefaultCalculatePeriodType() {
        DynamicObject object = QueryServiceHelper.queryOne((String)"bd_period_type", (String)"id", (QFilter[])new QFilter("1", "=", (Object)1).toArray());
        if (object != null) {
            this.getModel().setValue("calculateperiodtype", (Object)object.getLong("id"));
        }
    }

    private void setDefaultAccountBookType() {
        DynamicObject object = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter("accounttype", "=", (Object)"1").toArray());
        if (object != null) {
            this.getModel().setValue("accountbooktype", (Object)object.getLong("id"));
        }
    }

    private void setDefaultCalculateView() {
        Long viewId = this.getDefaultCalculateViewId();
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            this.getModel().setValue("calculateview", (Object)viewId);
        }
    }

    private Long getDefaultCalculateViewId() {
        DynamicObject calculateModel = (DynamicObject)this.getModel().getValue("calculatemodel");
        if (calculateModel == null) {
            return 0L;
        }
        Long calculateModelId = calculateModel.getLong("id");
        QFilter qFilter = new QFilter("accountingsys", "=", (Object)calculateModelId).and("ismainview", "=", (Object)true);
        DynamicObject object = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])qFilter.toArray());
        if (object != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    private void setDefaultCalculateModel() {
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bd_accountingsys", (String)"id", (QFilter[])new QFilter("1", "=", (Object)1).toArray(), (String)"number");
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            this.getModel().setValue("calculatemodel", (Object)((DynamicObject)objects.get(0)).getLong("id"));
        }
    }

    private void setDefaultDimMapScheme() {
        this.getModel().deleteEntryData(MAP_SCHEME_ENTRY);
        this.getModel().deleteEntryData(MAP_CONDITION_ENTRY);
        this.getModel().deleteEntryData("gldimmapentity");
        if (IDUtils.isNotEmptyLong((Long)this.getDatasetId()).booleanValue()) {
            int newEntryRow = this.getModel().createNewEntryRow(MAP_SCHEME_ENTRY);
            String defaultTitle = ResManager.loadKDString((String)"\u603b\u8d26\u96c6\u6210\u65b9\u6848", (String)"GLDataIntegrationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getModel().setValue("mapschemetitle", (Object)defaultTitle, newEntryRow);
            this.getModel().setValue("mapschemelevel", (Object)(newEntryRow + 1), newEntryRow);
            CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
            cardEntry.selectCard(Integer.valueOf(0));
            this.entryRowClick(new RowClickEvent((Object)this.getControl(MAP_SCHEME_ENTRY), 0));
        }
    }

    private void setConditionFieldComboItems() {
        HashMap<String, String> fieldToTitleMap = new HashMap<String, String>(16);
        GlBizFieldType[] fieldTypes = GlBizFieldType.values();
        ArrayList<ComboItem> fieldItems = new ArrayList<ComboItem>(fieldTypes.length);
        List calDimensions = DataIntegrationQueryService.getInstance().getCalDimensions();
        for (GlBizFieldType glBizFieldType : fieldTypes) {
            if (glBizFieldType == GlBizFieldType.DIMENSION && CollectionUtils.isNotEmpty((Collection)calDimensions)) {
                for (SimpleObject calDimension : calDimensions) {
                    String string = calDimension.getName();
                    String number = calDimension.getNumber();
                    fieldItems.add(new ComboItem(new LocaleString(string), number));
                    fieldToTitleMap.put(number, string);
                }
                continue;
            }
            String val = glBizFieldType.getNumber();
            String caption = GlBizFieldType.getEntityTextByType((GlBizFieldType)glBizFieldType);
            fieldItems.add(new ComboItem(new LocaleString(caption), val));
            fieldToTitleMap.put(val, caption);
        }
        ComboEdit fieldEdit = (ComboEdit)this.getControl("c_field");
        fieldEdit.setComboItems(fieldItems);
        ComboEdit fgSrcFieldNameEdit = (ComboEdit)this.getControl("glsrcfield");
        fgSrcFieldNameEdit.setComboItems(fieldItems);
        ArrayList<ComboItem> fieldTypeItems = new ArrayList<ComboItem>(fieldTypes.length);
        for (GlBizFieldType glBizFieldType : fieldTypes) {
            String val = glBizFieldType.getNumber();
            String caption = GlBizFieldType.getEntityTextByType((GlBizFieldType)glBizFieldType);
            fieldTypeItems.add(new ComboItem(new LocaleString(caption), val));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("c_fieldtype");
        comboEdit.setComboItems(fieldTypeItems);
        CompareSign[] compareSigns = CompareSign.values();
        ArrayList<ComboItem> compareSignItems = new ArrayList<ComboItem>(compareSigns.length);
        for (CompareSign compareSign : compareSigns) {
            compareSignItems.add(new ComboItem(new LocaleString(compareSign.getText()), compareSign.getVal()));
        }
        ComboEdit comboEdit2 = (ComboEdit)this.getControl("c_comparesign");
        comboEdit2.setComboItems(compareSignItems);
        this.getOrCacheFieldToTitleMap(fieldToTitleMap);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initCurrencyList();
        this.setGetDataComboItems(false);
        this.setConditionFieldComboItems();
        this.updateShowConditionText();
        this.updateIntegrationRangeEntry(false);
    }

    private void updateShowConditionText() {
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MAP_SCHEME_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                String conditionJson = object.getString("dimmapconditionjson");
                if (StringUtils.isEmpty((String)conditionJson)) continue;
                List conditions = (List)ObjectSerialUtil.parseObject((String)conditionJson, (TypeReference)new TypeReference<List<GLMapCondition>>(){}, (Feature[])new Feature[0]);
                object.set("mapschemesum", (Object)this.glMapConditionsToString(conditions));
            }
        }
        this.getModel().endInit();
        this.getView().updateView(MAP_SCHEME_ENTRY);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap21"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{CURRENCY_KEY, "getdatatype", "calculatemodel", "calculateview", "calculateorgmem", "accounttable", "accountbooktype", "calculateperiodtype"});
        this.getView().setVisible(Boolean.valueOf(!this.isNewEbForm()), new String[]{"flexpanelap3"});
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        cardEntry.selectCard(Integer.valueOf(0));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"includecepl"});
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryKey = entryGrid.getEntryKey();
        if ("gldimmapentity".equals(entryKey)) {
            this.dimMappingEntryBindData();
        } else if (MAP_CONDITION_ENTRY.equals(entryKey)) {
            this.mapConditionEntryBindData();
        }
    }

    private void mapConditionEntryBindData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MAP_CONDITION_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            int row = 0;
            for (DynamicObject object : entryEntity) {
                CompareSign compareSign = CompareSign.getEnum((String)object.getString("c_comparesign"));
                boolean isEnable = compareSign != CompareSign.is_notnull && compareSign != CompareSign.is_null;
                this.getView().setEnable(Boolean.valueOf(isEnable), row, new String[]{"c_valueshow"});
                ++row;
            }
        }
    }

    private void dimMappingEntryBindData() {
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("gldimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            int row = 0;
            for (DynamicObject object : entryEntity) {
                String dimNumber = object.getString("gltardimnumber");
                Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                if (dimension == null) continue;
                this.getView().setEnable(Boolean.valueOf(this.isEnableSetSourceField(dimension)), row, new String[]{"glsrcfieldname"});
                this.getView().setEnable(Boolean.valueOf(this.isEnableSetDimMemMapping(dimension)), row, new String[]{"gldimmembmap"});
                this.getView().setEnable(Boolean.valueOf(this.isEnableSetPointTarDimMem(dimension)), row, new String[]{"gldimmembnumshow"});
                ++row;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("c_valueshow".equals(sourceKey)) {
            this.conditionValueSelect();
        } else if ("glsrcfieldname".equals(sourceKey)) {
            this.sourceFieldSelect();
        }
    }

    private void sourceFieldSelect() {
        String dimNumber = (String)this.getModel().getValue("gltardimnumber");
        if (StringUtils.isEmpty((String)dimNumber)) {
            return;
        }
        ArrayList<GlBizFieldType> needShowFieldType = new ArrayList<GlBizFieldType>(10);
        if (!SysDimensionEnum.include((String)dimNumber, (Boolean)true) || SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber)) {
            needShowFieldType.add(GlBizFieldType.DIMENSION);
        } else if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            needShowFieldType.add(GlBizFieldType.ORG);
            needShowFieldType.add(GlBizFieldType.DIMENSION);
        }
        Set<String> selectedSourceFiled = this.getSelectedSourceFiled();
        selectedSourceFiled.remove(dimNumber);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_datainterfieldselect");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "sourceFieldSelect");
        showParameter.setCustomParam("needShowFieldType", (Object)SerializationUtils.serializeToBase64(needShowFieldType));
        showParameter.setCustomParam("selectedSourceFiled", (Object)SerializationUtils.serializeToBase64(selectedSourceFiled));
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5b57\u6bb5\u9009\u62e9", (String)"GLDataIntegrationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private Set<String> getSelectedSourceFiled() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("gldimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            HashSet<String> fields = new HashSet<String>(16);
            for (DynamicObject object : entryEntity) {
                String srcField = object.getString("glsrcfield");
                if (!StringUtils.isNotEmpty((String)srcField)) continue;
                fields.add(srcField);
            }
            return fields;
        }
        return new HashSet<String>(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void conditionValueSelect() {
        String entityName;
        String field = (String)this.getModel().getValue("c_field");
        if (StringUtils.isEmpty((String)field)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b57\u6bb5\u3002", (String)"GLDataIntegrationPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        CompareSign compareSign = CompareSign.getEnum((String)((String)this.getModel().getValue("c_comparesign")));
        if (compareSign == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6761\u4ef6\u3002", (String)"GLDataIntegrationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (compareSign == CompareSign.is_null || compareSign == CompareSign.is_notnull) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u662f\u4e3a\u7a7a\u6216\u8005\u4e0d\u4e3a\u7a7a\u65f6\u4e0d\u7528\u9009\u62e9\u503c\u3002", (String)"GLDataIntegrationPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String fieldType = (String)this.getModel().getValue("c_fieldtype");
        GlBizFieldType conditionFieldType = GlBizFieldType.getTypeByNumber((String)fieldType);
        if (conditionFieldType == null) {
            return;
        }
        Long calViewId = this.getCalViewId();
        Long accountTableId = this.getAccountTableId();
        Long accountPeriodTypeId = this.getAccountPeriodTypeId();
        if (conditionFieldType == GlBizFieldType.ORG && IDUtils.isEmptyLong((Long)calViewId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u89c6\u56fe\u3002", (String)"GLDataIntegrationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (conditionFieldType == GlBizFieldType.ACCOUNT && IDUtils.isEmptyLong((Long)accountTableId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u7cfb\u7edf\u9762\u677f\u4e2d\u79d1\u76ee\u8868\u3002", (String)"GLDataIntegrationPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (conditionFieldType == GlBizFieldType.PERIOD && IDUtils.isEmptyLong((Long)accountPeriodTypeId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u7cfb\u7edf\u9762\u677f\u4e2d\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u3002", (String)"GLDataIntegrationPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (conditionFieldType == GlBizFieldType.ORG) {
            entityName = "bos_org";
        } else if (conditionFieldType == GlBizFieldType.DIMENSION) {
            DynamicObject object = QueryServiceHelper.queryOne((String)GlBizFieldType.DIMENSION.getFieldFormKey(), (String)"valuesource", (QFilter[])new QFilter("number", "=", (Object)field).and("valuesource", "is not null", (Object)"").toArray());
            if (object == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5f53\u524d\u5b57\u6bb5\u5b9e\u4f53\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"GLDataIntegrationPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            entityName = object.getString("valuesource");
        } else {
            entityName = conditionFieldType.getFieldFormKey();
        }
        boolean isMultiSelect = compareSign == CompareSign.in || compareSign == CompareSign.not_in;
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityName, (boolean)isMultiSelect);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditionValueSelect"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        if (conditionFieldType == GlBizFieldType.ORG) {
            DataIntegrationQueryService.getInstance().setViewNumberParamBeforeSelCalOrg((FormShowParameter)listShowParameter, calViewId);
        } else if (conditionFieldType == GlBizFieldType.ACCOUNT) {
            qFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        } else if (conditionFieldType == GlBizFieldType.PERIOD) {
            qFilters.add(new QFilter("periodtype", "=", (Object)accountPeriodTypeId));
        }
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        String valueRecord = (String)this.getModel().getValue("c_value");
        if (StringUtils.isNotEmpty((String)valueRecord)) {
            List members = (List)ObjectSerialUtil.parseObject((String)valueRecord, (TypeReference)new TypeReference<List<SimpleObject>>(){}, (Feature[])new Feature[0]);
            Object[] selectIds = members.stream().map(SimpleObject::getId).toArray();
            listShowParameter.setSelectedRows(selectIds);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if ("conditionValueSelect".equals(actionId)) {
            this.conditionValueSelectCallBack(returnData);
        } else if ("sourceFieldSelect".equals(actionId)) {
            this.sourceFieldSelectCallBack(returnData);
        }
    }

    @Override
    protected void pointDimMemberSelectCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            this.getModel().beginInit();
            ListSelectedRow selectedRow = ((ListSelectedRowCollection)returnData).get(0);
            String number = selectedRow.getNumber();
            String name = selectedRow.getName();
            this.getModel().setValue(this.getPointTarMemShowFieldKey(), (Object)name);
            this.getModel().setValue(this.getPointTarMemFieldKey(), (Object)number);
            this.getModel().setValue(this.getDimMappingFieldKey(), null);
            this.getModel().setValue("glsrcfieldname", null);
            this.getModel().setValue("glsrcfield", null);
            if (selectedRow.getDataMap() != null) {
                this.getModel().setValue("gldimmembviewid", (Object)selectedRow.getDataMap().getOrDefault("viewid", 0L));
            }
            this.getModel().endInit();
            this.getView().updateView(this.getDimMappingEntryKey());
            this.storeDimMapSchemeJson();
            this.updateIntegrationRangeEntry(false);
        }
    }

    private void sourceFieldSelectCallBack(Object returnData) {
        if (returnData instanceof GLField) {
            this.getModel().beginInit();
            GLField glField = (GLField)returnData;
            this.getModel().setValue("glsrcfieldname", (Object)glField.getName());
            this.getModel().setValue("glsrcfield", (Object)glField.getNumber());
            this.getModel().setValue(this.getDimMappingFieldKey(), null);
            this.getModel().setValue(this.getPointTarMemFieldKey(), null);
            this.getModel().setValue(this.getPointTarMemShowFieldKey(), null);
            this.getModel().endInit();
            this.getView().updateView("gldimmapentity");
            this.storeDimMapSchemeJson();
        }
    }

    private void conditionValueSelectCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            this.getModel().beginInit();
            ListSelectedRowCollection values = (ListSelectedRowCollection)returnData;
            ArrayList<SimpleObject> members = new ArrayList<SimpleObject>(values.size());
            for (ListSelectedRow value : values) {
                members.add(new SimpleObject(IDUtils.toLong((Object)value.getPrimaryKeyValue()), value.getName(), value.getNumber()));
            }
            this.getModel().setValue("c_value", (Object)SerializationUtils.toJsonString(members));
            this.getModel().setValue("c_valueshow", members.isEmpty() ? null : Arrays.toString(members.stream().map(SimpleObject::getName).toArray()));
            this.getModel().endInit();
            this.getView().updateView(MAP_CONDITION_ENTRY);
            this.storeConditionFilterJson();
        }
    }

    @Override
    protected void updateIntegrationRangeEntry(boolean dataSetChanged) {
        super.updateIntegrationRangeEntry(dataSetChanged);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        String parentName = e.getProperty().getParent().getName();
        if ("calculatemodel".equals(name)) {
            this.calculateModelChanged();
        } else if ("datasetid".equals(name)) {
            this.reloadPageMapSchemeAndRangeData();
        } else if ("calculateview".equals(name)) {
            this.calculateViewChanged();
        } else if ("accounttable".equals(name)) {
            this.dealMapEntryDimMemMap(GlBizFieldType.ACCOUNT);
        } else if ("calculateperiodtype".equals(name)) {
            this.dealMapEntryDimMemMap(GlBizFieldType.PERIOD);
        } else if ("calculateorgmem".equals(name)) {
            this.calculateOrgMemChanged();
        } else if (MAP_CONDITION_ENTRY.equals(parentName)) {
            this.mapConditionEntryDataChanged(name);
        } else if ("gldimmapentity".equals(parentName)) {
            this.dimMapEntryDataChanged(name, e);
        } else if ("getdatatype".equals(name)) {
            this.dealDataTypeChange((String)e.getChangeSet()[0].getNewValue());
        } else if (CURRENCY_KEY.equals(name)) {
            this.dealCurrencyChange(e.getChangeSet()[0]);
        }
    }

    private void dealCurrencyChange(ChangeData changeData) {
        DataIntegrationGetDataType dataType;
        String newCurrency = (String)changeData.getNewValue();
        if ("-1".equals(newCurrency) && ((dataType = DataIntegrationGetDataType.getEnum((String)((String)this.getValue("getdatatype", null)))) == null || !dataType.isBaseCurrency())) {
            String oldCurrency = (String)changeData.getOldValue();
            this.getModel().setValue(CURRENCY_KEY, (Object)oldCurrency);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u6570\u7c7b\u578b\u4e0d\u53ef\u9009\u62e9\u7efc\u5408\u672c\u4f4d\u5e01\u3002", (String)"GLDataIntegrationPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void dealDataTypeChange(String newVal) {
        DataIntegrationGetDataType dataType = DataIntegrationGetDataType.getEnum((String)newVal);
        if ((dataType == null || !dataType.isBaseCurrency()) && "-1".equals(this.getValue(CURRENCY_KEY, null))) {
            this.getModel().setValue(CURRENCY_KEY, null);
        }
    }

    private void calculateOrgMemChanged() {
        List ids;
        DynamicObject object;
        DynamicObjectCollection calOrgMems = (DynamicObjectCollection)this.getModel().getValue("calculateorgmem");
        if (CollectionUtils.isNotEmpty((Collection)calOrgMems) && (object = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable, basecurrency", (QFilter[])new QFilter("org", "in", ids = calOrgMems.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList())).toArray())) != null) {
            this.getModel().setValue("accounttable", (Object)object.getLong("accounttable"));
            this.getModel().setValue(CURRENCY_KEY, (Object)object.getString("basecurrency"));
        }
    }

    private void dealMapEntryDimMemMap(GlBizFieldType glBizFieldType) {
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MAP_SCHEME_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            this.getModel().beginInit();
            for (DynamicObject dimMapScheme : entryEntity) {
                String dimMapJson;
                String conditionJson = dimMapScheme.getString("dimmapconditionjson");
                if (StringUtils.isNotEmpty((String)conditionJson)) {
                    List conditions = (List)ObjectSerialUtil.parseObject((String)conditionJson, (TypeReference)new TypeReference<List<GLMapCondition>>(){}, (Feature[])new Feature[0]);
                    for (GLMapCondition condition : conditions) {
                        GlBizFieldType fieldType = condition.getFieldType();
                        if (fieldType != glBizFieldType) continue;
                        condition.setMemValues(null);
                    }
                    dimMapScheme.set("dimmapconditionjson", (Object)SerializationUtils.toJsonString((Object)conditions));
                }
                if (!StringUtils.isNotEmpty((String)(dimMapJson = dimMapScheme.getString("dimmemmapjson")))) continue;
                List dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                for (DataIntegrationDimMap dataIntegrationDimMap : dimMapList) {
                    GlBizFieldType typeByNumber;
                    String dimSource = dataIntegrationDimMap.getDimsource();
                    if (StringUtils.isEmpty((String)dimSource) || glBizFieldType != (typeByNumber = GlBizFieldType.getTypeByNumber((String)dimSource))) continue;
                    dataIntegrationDimMap.setDimmembmapid(Long.valueOf(0L));
                }
                dimMapScheme.set("dimmemmapjson", (Object)SerializationUtils.toJsonString((Object)dimMapList));
            }
            this.getModel().endInit();
            this.getView().updateView(MAP_SCHEME_ENTRY);
            cardEntry.selectCard(Integer.valueOf(focusRow));
            this.entryRowClick(new RowClickEvent((Object)this.getControl(MAP_SCHEME_ENTRY), 0));
        }
    }

    private void dimMapEntryDataChanged(String propName, PropertyChangedArgs e) {
        if ("gldimmembmap".equals(propName)) {
            this.dimMemberMapChanged(e);
        } else if ("gldimmembnumshow".equals(propName)) {
            this.pointDimMemberChanged();
        } else if ("glsrcfieldname".equals(propName)) {
            this.sourceFieldChanged();
        }
        this.storeDimMapSchemeJson();
        this.updateIntegrationRangeEntry(false);
    }

    private void sourceFieldChanged() {
        String value = (String)this.getModel().getValue("glsrcfieldname");
        if (StringUtils.isEmpty((String)value)) {
            this.getModel().beginInit();
            this.getModel().setValue("glsrcfield", null);
            this.getModel().setValue(this.getDimMappingFieldKey(), null);
            this.getModel().endInit();
            this.getView().updateView("gldimmapentity");
        }
    }

    private void pointDimMemberChanged() {
        String value = (String)this.getModel().getValue("gldimmembnumshow");
        if (StringUtils.isEmpty((String)value)) {
            this.getModel().beginInit();
            this.getModel().setValue("gldimmembnum", null);
            this.getModel().endInit();
            this.getView().updateView(MAP_CONDITION_ENTRY);
        }
    }

    private void dimMemberMapChanged(PropertyChangedArgs e) {
        this.getModel().beginInit();
        this.getModel().setValue("gldimmembnumshow", null);
        this.getModel().setValue("gldimmembnum", null);
        this.getModel().setValue("gldimmembviewid", null);
        this.getModel().endInit();
        this.getView().updateView("gldimmapentity");
        DynamicObject dynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
        String dimNum = null;
        Long viewId = 0L;
        if (dynamicObject != null) {
            Map map;
            dimNum = e.getChangeSet()[0].getDataEntity().getString("gltardimnumber");
            String targetsysinfo = dynamicObject.getString("targetsysinfo");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)targetsysinfo) && (map = (Map)JSON.parseObject((String)targetsysinfo, Map.class)).containsKey("view")) {
                viewId = IDUtils.toLong(map.get("view"));
            }
        }
        this.clearIntegrationRangeEntryWhenViewChange(dimNum, viewId);
    }

    private void mapConditionEntryDataChanged(String propName) {
        this.getModel().beginInit();
        if ("c_field".equals(propName)) {
            this.conditionFieldChanged();
        } else if ("c_comparesign".equals(propName)) {
            this.conditionCompareSignChanged();
        } else if ("c_valueshow".equals(propName)) {
            this.conditionValueChanged();
        }
        this.getModel().endInit();
        this.getView().updateView(MAP_CONDITION_ENTRY);
        this.storeConditionFilterJson();
    }

    private void storeConditionFilterJson() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MAP_CONDITION_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            ArrayList<GLMapCondition> glMapConditions = new ArrayList<GLMapCondition>(entryEntity.size());
            for (DynamicObject object : entryEntity) {
                int leftB = object.getInt("c_leftb");
                String field = object.getString("c_field");
                String fieldType = object.getString("c_fieldtype");
                String compareSign = object.getString("c_comparesign");
                String value = object.getString("c_value");
                int rightB = object.getInt("c_rightb");
                String logic = object.getString("c_logic");
                GLMapCondition glMapCondition = new GLMapCondition();
                glMapCondition.setLeftB(leftB);
                glMapCondition.setField(field);
                glMapCondition.setFieldType(GlBizFieldType.getTypeByNumber((String)fieldType));
                glMapCondition.setCompareSign(CompareSign.getEnum((String)compareSign));
                if (StringUtils.isNotEmpty((String)value)) {
                    List members = (List)ObjectSerialUtil.parseObject((String)value, (TypeReference)new TypeReference<List<SimpleObject>>(){}, (Feature[])new Feature[0]);
                    glMapCondition.setMemValues(members);
                }
                glMapCondition.setRightB(rightB);
                glMapCondition.setConnectSign(logic);
                glMapConditions.add(glMapCondition);
            }
            this.getModel().setValue("mapschemesum", (Object)this.glMapConditionsToString(glMapConditions));
            this.getModel().setValue("dimmapconditionjson", (Object)SerializationUtils.toJsonString(glMapConditions));
        } else {
            this.getModel().setValue("mapschemesum", null);
            this.getModel().setValue("dimmapconditionjson", null);
        }
    }

    private String glMapConditionsToString(List<GLMapCondition> glMapConditions) {
        Map<String, String> fieldToTitleMap = this.getOrCacheFieldToTitleMap(null);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < glMapConditions.size(); ++i) {
            int j;
            GLMapCondition glMapCondition = glMapConditions.get(i);
            int leftB = glMapCondition.getLeftB();
            String field = glMapCondition.getField();
            CompareSign compareSign = glMapCondition.getCompareSign();
            List valueNames = glMapCondition.getMemValueNames();
            int rightB = glMapCondition.getRightB();
            String connectSign = glMapCondition.getConnectSign();
            if (StringUtils.isEmpty((String)field) || CollectionUtils.isEmpty((Collection)valueNames) && compareSign != CompareSign.is_notnull && compareSign != CompareSign.is_null) continue;
            for (j = 0; j < leftB; ++j) {
                str.append("( ");
            }
            str.append(fieldToTitleMap.get(field));
            if (compareSign == CompareSign.in || compareSign == CompareSign.not_in) {
                String sq = compareSign.getText().replace("...", Arrays.toString(valueNames.toArray()));
                str.append(" ").append(sq).append(" ");
            } else if (compareSign == CompareSign.is_null || compareSign == CompareSign.is_notnull) {
                str.append(" ").append(compareSign.getText()).append(" ");
            } else {
                str.append(" ").append(compareSign.getText()).append(" ");
                str.append(Arrays.toString(valueNames.toArray()));
            }
            for (j = 0; j < rightB; ++j) {
                str.append(" )");
            }
            if (i < glMapConditions.size() - 1) {
                str.append(" ").append(LogicSign.getEnum((String)connectSign).getTitle().loadKDString());
            }
            str.append("\n");
        }
        return str.toString();
    }

    private void storeDimMapSchemeJson() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("gldimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            ArrayList<DataIntegrationDimMap> dataIntegrationDimMaps = new ArrayList<DataIntegrationDimMap>(entryEntity.size());
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)entryEntity.size());
            int i = 0;
            for (DynamicObject object : entryEntity) {
                DataIntegrationDimMap dataIntegrationDimMap = new DataIntegrationDimMap();
                dataIntegrationDimMaps.add(dataIntegrationDimMap);
                long id = object.getLong("id");
                if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
                    id = ids[i++];
                }
                dataIntegrationDimMap.setId(Long.valueOf(id));
                dataIntegrationDimMap.setDimsource(object.getString("glsrcfield"));
                dataIntegrationDimMap.setDimtarget(object.getString("gltardimnumber"));
                dataIntegrationDimMap.setDimmembmapid(Long.valueOf(object.getLong("gldimmembmap.id")));
                dataIntegrationDimMap.setDimmembnum(object.getString("gldimmembnum"));
                Object gldimmembviewid = object.get("gldimmembviewid");
                if (gldimmembviewid instanceof Long) {
                    dataIntegrationDimMap.setDimmembviewid(IDUtils.toLong((Object)gldimmembviewid));
                    continue;
                }
                if (!(gldimmembviewid instanceof DynamicObject)) continue;
                dataIntegrationDimMap.setDimmembviewid(Long.valueOf(((DynamicObject)gldimmembviewid).getLong("id")));
            }
            this.getModel().setValue("dimmemmapjson", (Object)SerializationUtils.toJsonString(dataIntegrationDimMaps));
        } else {
            this.getModel().setValue("dimmemmapjson", null);
        }
    }

    private void conditionValueChanged() {
        String value = (String)this.getModel().getValue("c_valueshow");
        if (StringUtils.isEmpty((String)value)) {
            this.getModel().setValue("c_value", null);
        }
    }

    private void conditionCompareSignChanged() {
        this.getModel().setValue("c_valueshow", null);
        this.getModel().setValue("c_value", null);
    }

    private void conditionFieldChanged() {
        this.getModel().setValue("c_valueshow", null);
        this.getModel().setValue("c_value", null);
        String field = (String)this.getModel().getValue("c_field");
        if (StringUtils.isEmpty((String)field)) {
            return;
        }
        GlBizFieldType fieldType = GlBizFieldType.getTypeByNumber((String)field);
        this.getModel().setValue("c_fieldtype", (Object)fieldType.getNumber());
    }

    private void calculateViewChanged() {
        this.getModel().setValue("calculateorgmem", null);
        this.dealMapEntryDimMemMap(GlBizFieldType.ORG);
        this.storeDimMapSchemeJson();
        this.updateIntegrationRangeEntry(false);
    }

    private void calculateModelChanged() {
        Long viewId = this.getDefaultCalculateViewId();
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            this.getModel().setValue("calculateview", (Object)viewId);
        } else {
            this.getModel().setValue("calculateview", null);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getModel().deleteEntryData(MAP_SCHEME_ENTRY);
            this.getModel().deleteEntryData(MAP_CONDITION_ENTRY);
        } else {
            int row = evt.getRow();
            String dimMapConditionJson = (String)this.getModel().getValue("dimmapconditionjson", row);
            String dimMemMapJson = (String)this.getModel().getValue("dimmemmapjson", row);
            this.loadCurDimMapScheme(dimMapConditionJson, dimMemMapJson);
        }
    }

    private void loadCurDimMapScheme(String dimMapConditionJson, String dimMemMapJson) {
        List<Object> mapConditions = new ArrayList<GLMapCondition>();
        if (StringUtils.isNotEmpty((String)dimMapConditionJson)) {
            mapConditions = (List)ObjectSerialUtil.parseObject((String)dimMapConditionJson, (TypeReference)new TypeReference<List<GLMapCondition>>(){}, (Feature[])new Feature[0]);
        }
        this.loadMapConditionEntry(mapConditions);
        List<Object> dimMapList = new ArrayList<DataIntegrationDimMap>();
        if (StringUtils.isNotEmpty((String)dimMemMapJson)) {
            dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
        }
        this.loadDimMappingEntry(dimMapList);
    }

    private void loadDimMappingEntry(List<DataIntegrationDimMap> dimMapList) {
        this.getModel().deleteEntryData("gldimmapentity");
        Long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            return;
        }
        HashMap dimToDataIntegrationDimMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty(dimMapList)) {
            dimMapList.forEach(e -> dimToDataIntegrationDimMap.put(e.getDimtarget(), e));
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        List dimensions = modelCacheHelper.getDimensionList(datasetId);
        Map viewMap = modelCacheHelper.getViewsByDataSetIncludeBase(datasetId);
        Map<String, String> fieldToTitleMap = this.getOrCacheFieldToTitleMap(null);
        this.getModel().beginInit();
        int[] index = this.getModel().batchCreateNewEntryRow("gldimmapentity", dimensions.size());
        int i = 0;
        boolean needSetDefault = false;
        Long[] view = new Long[dimensions.size()];
        for (Dimension dimension : dimensions) {
            Member defaultPointDimMem;
            String dimNumber = dimension.getNumber();
            int row = index[i++];
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("gldimmapentity", row);
            rowEntity.set("gltardimname", (Object)dimension.getName());
            rowEntity.set("gltardimnumber", (Object)dimNumber);
            DataIntegrationDimMap dataIntegrationDimMap = (DataIntegrationDimMap)dimToDataIntegrationDimMap.get(dimNumber);
            if (dataIntegrationDimMap != null) {
                Member member;
                rowEntity.set("glsrcfieldname", (Object)fieldToTitleMap.get(dataIntegrationDimMap.getDimsource()));
                rowEntity.set("glsrcfield", (Object)dataIntegrationDimMap.getDimsource());
                rowEntity.set("gldimmembmap_id", (Object)dataIntegrationDimMap.getDimmembmapid());
                Long viewId = modelCacheHelper.getViewByDataSetAndDimNumber(datasetId, dimNumber);
                if (IDUtils.isNotNull((Long)dataIntegrationDimMap.getDimmembviewid())) {
                    viewId = dataIntegrationDimMap.getDimmembviewid();
                }
                if ((member = modelCacheHelper.getMember(dimNumber, viewId, dataIntegrationDimMap.getDimmembnum())) == null) continue;
                rowEntity.set("gldimmembnumshow", (Object)member.getName());
                rowEntity.set("gldimmembnum", (Object)member.getNumber());
                rowEntity.set("gldimmembviewid", (Object)viewId);
                view[row] = viewId;
                continue;
            }
            needSetDefault = true;
            GlBizFieldType fieldType = this.getDimensionDefaultSourceField(dimension);
            if (fieldType != null) {
                rowEntity.set("glsrcfieldname", (Object)fieldToTitleMap.get(fieldType.getNumber()));
                rowEntity.set("glsrcfield", (Object)fieldType.getNumber());
            }
            if ((defaultPointDimMem = this.getDefaultPointTarDimMem(dimension, viewMap)) == null) continue;
            rowEntity.set("gldimmembnumshow", (Object)defaultPointDimMem.getName());
            rowEntity.set("gldimmembnum", (Object)defaultPointDimMem.getNumber());
            rowEntity.set("gldimmembviewid", (Object)viewMap.getOrDefault(dimension.getNumber(), 0L));
        }
        this.getModel().endInit();
        this.getView().updateView("gldimmapentity");
        for (int i1 = 0; i1 < view.length; ++i1) {
            Long o = view[i1];
            if (o == null) continue;
            this.getModel().setValue("gldimmembviewid", (Object)o, i1);
        }
        if (needSetDefault) {
            this.storeDimMapSchemeJson();
            this.updateIntegrationRangeEntry(false);
        }
    }

    private void loadMapConditionEntry(List<GLMapCondition> mapConditions) {
        this.getModel().deleteEntryData(MAP_CONDITION_ENTRY);
        if (CollectionUtils.isNotEmpty(mapConditions)) {
            this.getModel().beginInit();
            int[] index = this.getModel().batchCreateNewEntryRow(MAP_CONDITION_ENTRY, mapConditions.size());
            int i = 0;
            for (GLMapCondition mapCondition : mapConditions) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(MAP_CONDITION_ENTRY, index[i++]);
                rowEntity.set("c_leftb", mapCondition.getLeftB() == 0 ? null : Integer.valueOf(mapCondition.getLeftB()));
                rowEntity.set("c_field", (Object)mapCondition.getField());
                if (mapCondition.getFieldType() != null) {
                    rowEntity.set("c_fieldtype", (Object)mapCondition.getFieldType().getNumber());
                }
                rowEntity.set("c_comparesign", (Object)mapCondition.getCompareSign().getVal());
                List valueNames = mapCondition.getMemValueNames();
                rowEntity.set("c_valueshow", valueNames.isEmpty() ? null : Arrays.toString(valueNames.toArray()));
                List memValues = mapCondition.getMemValues();
                rowEntity.set("c_value", (Object)(CollectionUtils.isEmpty((Collection)memValues) ? null : SerializationUtils.toJsonString((Object)memValues)));
                rowEntity.set("c_rightb", mapCondition.getRightB() == 0 ? null : Integer.valueOf(mapCondition.getRightB()));
                rowEntity.set("c_logic", (Object)mapCondition.getConnectSign());
            }
            this.getModel().endInit();
        }
        this.getView().updateView(MAP_CONDITION_ENTRY);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate operate = (FormOperate)args.getSource();
            String key = operate.getOperateKey();
            String entryId = (String)operate.getParameter().get("entryId");
            if (MAP_SCHEME_ENTRY.equals(entryId)) {
                this.mapSchemeBeforeDoOperation(args);
            } else if ("addfilter".equals(key)) {
                this.checkSelectMapScheme(args);
            }
        }
    }

    private void mapSchemeBeforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("addmapscheme".equals(key)) {
            this.beforeCopyOrAndMapScheme(args);
        } else if ("copymapscheme".equals(key)) {
            this.beforeCopyOrAndMapScheme(args);
        } else if ("delmapscheme".equals(key)) {
            this.beforeDelMapScheme(args);
        } else if ("mapschemeup".equals(key) || "mapschemedown".equals(key)) {
            this.beforeMoveMapScheme(args);
        }
    }

    private void beforeMoveMapScheme(BeforeDoOperationEventArgs args) {
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        this.getOrCacheOperationMapSchemeRow(focusRow);
    }

    @Override
    protected void beforeDoSave() {
        super.beforeDoSave();
        this.checkSourceTargetFlexInfo();
        this.checkMapSchemeInfoBeforeSave();
        this.checkInterRangeInfo();
        this.checkDimView();
    }

    private void checkSourceTargetFlexInfo() {
    }

    private void checkMapSchemeInfoBeforeSave() {
        DynamicObjectCollection dimMapSchemes = this.getModel().getEntryEntity(MAP_SCHEME_ENTRY);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        HashSet<String> mapSchemeTitles = new HashSet<String>(16);
        for (DynamicObject dimMapScheme : dimMapSchemes) {
            List mapConditions;
            String conditionJson = dimMapScheme.getString("dimmapconditionjson");
            String dimMemMapJson = dimMapScheme.getString("dimmemmapjson");
            String mapSchemeTitle = dimMapScheme.getString("mapschemetitle");
            if (StringUtils.isEmpty((String)mapSchemeTitle)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u65b9\u6848\u6807\u9898\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GLDataIntegrationPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (mapSchemeTitles.contains(mapSchemeTitle)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u65b9\u6848\u6807\u9898\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GLDataIntegrationPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            mapSchemeTitles.add(mapSchemeTitle);
            if (StringUtils.isNotEmpty((String)conditionJson) && this.checkMapConditions(mapConditions = (List)ObjectSerialUtil.parseObject((String)conditionJson, (TypeReference)new TypeReference<List<GLMapCondition>>(){}, (Feature[])new Feature[0]))) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6620\u5c04\u65b9\u6848\u201c%1\u201d\u9002\u7528\u6761\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GLDataIntegrationPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{mapSchemeTitle}));
            }
            if (!StringUtils.isNotEmpty((String)dimMemMapJson)) continue;
            List dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
            for (DataIntegrationDimMap dataIntegrationDimMap : dimMapList) {
                String dimNum = dataIntegrationDimMap.getDimtarget();
                Dimension dimension = modelCacheHelper.getDimension(dimNum);
                if (dimension == null) continue;
                String dimSource = dataIntegrationDimMap.getDimsource();
                String dimMemNum = dataIntegrationDimMap.getDimmembnum();
                if ("Entity".equals(dimNum) && StringUtils.isEmpty((String)dimSource)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u76ee\u6807\u7ef4\u5ea6-\u7ec4\u7ec7\u7684\u6e90\u5b57\u6bb5\u540d\u79f0\u3002", (String)"GLDataIntegrationPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Long dimMemMapId = dataIntegrationDimMap.getDimmembmapid();
                if ("Account".equals(dimNum) && IDUtils.isEmptyLong((Long)dimMemMapId).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u603b\u8d26\u79d1\u76ee\u8868\u4e0e\u9884\u7b97\u79d1\u76ee\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u3002", (String)"GLDataIntegrationPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if ((!dimension.isPreset() || "InternalCompany".equals(dimNum)) && StringUtils.isEmpty((String)dimSource) && StringUtils.isEmpty((String)dimMemNum)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u76ee\u6807\u7ef4\u5ea6-%1\u7684\u5339\u914d\u5173\u7cfb\u3002", (String)"GLDataIntegrationPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
                }
                if (("DataType".equals(dimNum) || "AuditTrail".equals(dimNum) || "Version".equals(dimNum) || "ChangeType".equals(dimNum) || "Metric".equals(dimNum)) && StringUtils.isEmpty((String)dimMemNum)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u76ee\u6807\u7ef4\u5ea6-%1\u7684\u5339\u914d\u5173\u7cfb\u3002", (String)"GLDataIntegrationPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
                }
                if (View.NoViewDimNums.contains(dimNum) || !IDUtils.isNotEmptyLong((Long)dimMemMapId).booleanValue()) continue;
                this.dimToDimMappingIdMap.computeIfAbsent(dimNum, e -> new HashSet(16)).add(dimMemMapId);
            }
        }
    }

    private boolean checkMapConditions(List<GLMapCondition> mapConditions) {
        if (CollectionUtils.isNotEmpty(mapConditions)) {
            ArrayList<Character> leftRightBracket = new ArrayList<Character>(0);
            for (GLMapCondition mapCondition : mapConditions) {
                int i;
                int leftB = mapCondition.getLeftB();
                int rightB = mapCondition.getRightB();
                for (i = 0; i < leftB; ++i) {
                    leftRightBracket.add(Character.valueOf('('));
                }
                for (i = 0; i < rightB; ++i) {
                    leftRightBracket.add(Character.valueOf(')'));
                }
                CompareSign compareSign = mapCondition.getCompareSign();
                String field = mapCondition.getField();
                List values = mapCondition.getMemValues();
                if (StringUtils.isEmpty((String)field)) {
                    return true;
                }
                if (compareSign != CompareSign.in && compareSign != CompareSign.not_in && compareSign != CompareSign.equals && compareSign != CompareSign.not_equals || !CollectionUtils.isEmpty((Collection)values)) continue;
                return true;
            }
            return this.checkLeftRightBracket(leftRightBracket);
        }
        return false;
    }

    private boolean checkLeftRightBracket(List<Character> leftRightBracket) {
        Stack<Character> stack = new Stack<Character>();
        for (char ch : leftRightBracket) {
            if (ch == '(') {
                stack.push(Character.valueOf(')'));
                continue;
            }
            if (!stack.isEmpty() && ch == ((Character)stack.pop()).charValue()) continue;
            return true;
        }
        return !stack.isEmpty();
    }

    private void checkSelectMapScheme(BeforeDoOperationEventArgs args) {
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u6620\u5c04\u65b9\u6848\u3002", (String)"GLDataIntegrationPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void beforeDelMapScheme(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        int rowCount = this.getModel().getEntryRowCount(MAP_SCHEME_ENTRY);
        if (rowCount <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u7ef4\u5ea6\u6620\u5c04\u65b9\u6848\u3002", (String)"GLDataIntegrationPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u7684\u7ef4\u5ea6\u6620\u5c04\u65b9\u6848\uff1f", (String)"GLDataIntegrationPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delMapScheme", (IFormPlugin)this));
        }
    }

    private void beforeCopyOrAndMapScheme(BeforeDoOperationEventArgs args) {
        int rowCount = this.getModel().getEntryRowCount(MAP_SCHEME_ENTRY);
        if (rowCount >= 4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc7\u65b9\u6848\u6700\u5927\u6570\u91cf\u3002", (String)"GLDataIntegrationPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("delMapScheme".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.doDelMapScheme();
        }
    }

    private void doDelMapScheme() {
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        this.getModel().deleteEntryRow(MAP_SCHEME_ENTRY, focusRow);
        this.mapSchemeAfterDoOperation("delmapscheme");
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate operate = (FormOperate)args.getSource();
            String key = operate.getOperateKey();
            String entryId = (String)operate.getParameter().get("entryId");
            if (MAP_SCHEME_ENTRY.equals(entryId)) {
                this.mapSchemeAfterDoOperation(key);
            } else if (MAP_CONDITION_ENTRY.equals(entryId)) {
                this.mapConditionAfterDoOperation(key);
            }
        }
    }

    private void mapConditionAfterDoOperation(String key) {
        if ("addfilter".equals(key)) {
            this.getModel().beginInit();
            this.getModel().setValue("c_comparesign", (Object)CompareSign.in.getVal());
            this.getModel().endInit();
            this.getView().updateView(MAP_CONDITION_ENTRY);
        }
        this.storeConditionFilterJson();
    }

    private void mapSchemeAfterDoOperation(String key) {
        this.updateMapSchemeLevel();
        CardEntry cardEntry = (CardEntry)this.getControl(MAP_SCHEME_ENTRY);
        if ("addmapscheme".equals(key) || "copymapscheme".equals(key)) {
            this.updateIntegrationRangeEntry(false);
            int rowCount = this.getModel().getEntryRowCount(MAP_SCHEME_ENTRY);
            boolean isNew = "addmapscheme".equals(key);
            String value = (String)this.getModel().getValue("mapschemetitle", rowCount - 1);
            String title = this.getNewSchemeTitle(isNew, rowCount, value);
            this.getModel().setValue("mapschemetitle", (Object)title, rowCount - 1);
            this.getView().updateView(MAP_SCHEME_ENTRY);
            cardEntry.selectCard(Integer.valueOf(rowCount - 1));
        } else if ("delmapscheme".equals(key)) {
            this.updateIntegrationRangeEntry(false);
            int rowCount = this.getModel().getEntryRowCount(MAP_SCHEME_ENTRY);
            cardEntry.selectCard(Integer.valueOf(rowCount - 1));
        } else if ("mapschemeup".equals(key)) {
            int mapSchemeRow = this.getOrCacheOperationMapSchemeRow(-1);
            cardEntry.selectCard(Integer.valueOf(mapSchemeRow - 1));
        } else if ("mapschemedown".equals(key)) {
            int mapSchemeRow = this.getOrCacheOperationMapSchemeRow(-1);
            cardEntry.selectCard(Integer.valueOf(mapSchemeRow + 1));
        }
    }

    private String getNewSchemeTitle(boolean isNew, int rowCount, String value) {
        if (isNew) {
            return ResManager.loadResFormat((String)"\u603b\u8d26\u96c6\u6210\u65b9\u6848%1", (String)"GLDataIntegrationPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{rowCount});
        }
        if (value != null && value.length() > 46) {
            return value.substring(0, 46) + "copy";
        }
        return value + "copy";
    }

    private void updateMapSchemeLevel() {
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MAP_SCHEME_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                object.set("mapschemelevel", (Object)object.getInt("seq"));
            }
        }
        this.getModel().endInit();
        this.getView().updateView(MAP_SCHEME_ENTRY);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String name = event.getProperty().getName();
        if ("calculateview".equals(name)) {
            this.calculateViewBeforeF7(event);
        } else if ("calculateorgmem".equals(name)) {
            this.calculateOrgBeforeF7(event);
        }
    }

    private void calculateOrgBeforeF7(BeforeF7SelectEvent event) {
        Long calViewId = this.getCalViewId();
        if (IDUtils.isEmptyLong((Long)calViewId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u89c6\u56fe\u3002", (String)"GLDataIntegrationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        DataIntegrationQueryService.getInstance().setViewNumberParamBeforeSelCalOrg((FormShowParameter)showParameter, calViewId);
    }

    @Override
    protected QFilter getDimMappingFilter() {
        long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            return null;
        }
        String glSrcField = (String)this.getModel().getValue("glsrcfield");
        if (StringUtils.isEmpty((String)glSrcField)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u6e90\u5b57\u6bb5\u540d\u79f0\u3002", (String)"GLDataIntegrationPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        GlBizFieldType fieldType = GlBizFieldType.getTypeByNumber((String)glSrcField);
        Long calViewId = null;
        if (fieldType == GlBizFieldType.ORG && IDUtils.isEmptyLong((Long)(calViewId = this.getCalViewId())).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u89c6\u56fe\u3002", (String)"GLDataIntegrationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        Long glObjId = this.getGlObjId(fieldType);
        if (IDUtils.isEmptyLong((Long)glObjId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9%1\u3002", (String)"GLDataIntegrationPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{GlBizFieldType.getEntityTextByType((GlBizFieldType)fieldType)}));
            return null;
        }
        Long modelId = this.getModelId();
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        String dimNumber = (String)this.getModel().getValue("gltardimnumber");
        List viewId = iModelCacheHelper.getViewGroupViewsByDataSetAndDimNumber(Long.valueOf(datasetId), dimNumber);
        Long dimensionId = iModelCacheHelper.getDimension(dimNumber).getId();
        return EASDataIntegrationUtil.getGlDimMemberMapFilter((DataIntegrationType)DataIntegrationType.INPUT, (GlBizFieldType)fieldType, (Long)glObjId, (Long)calViewId, (Long)modelId, (Long)datasetId, (Long)dimensionId, (List)viewId);
    }

    private Long getGlObjId(GlBizFieldType fieldType) {
        Long glObjId = 0L;
        if (fieldType == GlBizFieldType.DIMENSION) {
            glObjId = this.getCalDimensionId();
        } else if (fieldType == GlBizFieldType.ORG) {
            glObjId = this.getCalModelId();
        } else if (fieldType == GlBizFieldType.ACCOUNT) {
            glObjId = this.getAccountTableId();
        } else if (fieldType == GlBizFieldType.PERIOD) {
            glObjId = this.getAccountPeriodTypeId();
        }
        return glObjId;
    }

    private Long getCalDimensionId() {
        String glSrcField = (String)this.getModel().getValue("glsrcfield");
        DynamicObject object = QueryServiceHelper.queryOne((String)GlBizFieldType.DIMENSION.getFieldFormKey(), (String)"id", (QFilter[])new QFilter("number", "=", (Object)glSrcField).toArray());
        if (object != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    private void calculateViewBeforeF7(BeforeF7SelectEvent event) {
        DynamicObject calculateModel = (DynamicObject)this.getModel().getValue("calculatemodel");
        if (calculateModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u4f53\u7cfb\u3002", (String)"GLDataIntegrationPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> qFilters = ((BasedataEdit)this.getControl("calculateview")).getQFilters();
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(16);
        }
        qFilters.add(new QFilter("accountingsys", "=", (Object)calculateModel.getLong("id")));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        showParameter.setFormId("bos_listf7");
    }

    private Map<String, String> getOrCacheFieldToTitleMap(Map<String, String> fieldToTitleMap) {
        if (fieldToTitleMap == null) {
            String fieldToTitleMapCache = this.getPageCache().get("fieldToTitleMapCache");
            if (StringUtils.isNotEmpty((String)fieldToTitleMapCache)) {
                return (Map)SerializationUtils.deSerializeFromBase64((String)fieldToTitleMapCache);
            }
            return new HashMap<String, String>(0);
        }
        this.getPageCache().put("fieldToTitleMapCache", SerializationUtils.serializeToBase64(fieldToTitleMap));
        return new HashMap<String, String>(0);
    }

    @Override
    protected Set<String> getDimMapNoSetMembersDimNums() {
        HashSet<String> numbers = new HashSet<String>(16);
        DynamicObjectCollection schemeEntry = this.getModel().getEntryEntity(MAP_SCHEME_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)schemeEntry)) {
            for (DynamicObject object : schemeEntry) {
                String dimMemMapJson = object.getString("dimmemmapjson");
                if (StringUtils.isEmpty((String)dimMemMapJson)) continue;
                List dataIntegrationDimMaps = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                for (DataIntegrationDimMap dataIntegrationDimMap : dataIntegrationDimMaps) {
                    String dimTarget = dataIntegrationDimMap.getDimtarget();
                    String dimMember = dataIntegrationDimMap.getDimmembnum();
                    if (!StringUtils.isNotEmpty((String)dimTarget) || !StringUtils.isEmpty((String)dimMember)) continue;
                    numbers.add(dimTarget);
                }
            }
        }
        return numbers;
    }

    private int getOrCacheOperationMapSchemeRow(int row) {
        if (row >= 0) {
            this.getPageCache().put("OperationMapSchemeRow", String.valueOf(row));
        } else {
            String operationMapSchemeRow = this.getPageCache().get("OperationMapSchemeRow");
            if (StringUtils.isNotEmpty((String)operationMapSchemeRow)) {
                return Integer.parseInt(operationMapSchemeRow);
            }
        }
        return 0;
    }

    private boolean isEnableSetSourceField(Dimension dimension) {
        String dimensionNumber = dimension.getNumber();
        if (!dimension.isPreset() || SysDimensionEnum.Project.getNumber().equals(dimensionNumber)) {
            return true;
        }
        return SysDimensionEnum.Entity.getNumber().equals(dimensionNumber) || SysDimensionEnum.InternalCompany.getNumber().equals(dimensionNumber);
    }

    private boolean isEnableSetDimMemMapping(Dimension dimension) {
        if (dimension == null) {
            return false;
        }
        String dimensionNumber = dimension.getNumber();
        if (!dimension.isPreset() || SysDimensionEnum.Project.getNumber().equals(dimensionNumber)) {
            return true;
        }
        return SysDimensionEnum.Entity.getNumber().equals(dimensionNumber) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNumber) || SysDimensionEnum.InternalCompany.getNumber().equals(dimensionNumber) || SysDimensionEnum.Account.getNumber().equals(dimensionNumber);
    }

    private GlBizFieldType getDimensionDefaultSourceField(Dimension dimension) {
        String dimensionNumber = dimension.getNumber();
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            return GlBizFieldType.ACCOUNT;
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNumber)) {
            return GlBizFieldType.PERIOD;
        }
        return null;
    }

    private Long getCalViewId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("calculateview");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    private Long getCalModelId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("calculatemodel");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    private Long getAccountTableId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("accounttable");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    private Long getAccountPeriodTypeId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("calculateperiodtype");
        if (value != null) {
            return value.getLong("id");
        }
        return 0L;
    }

    @Override
    String getTarDimNumberFieldKey() {
        return "gltardimnumber";
    }

    @Override
    String getDimMappingFieldKey() {
        return "gldimmembmap";
    }

    @Override
    String getPointTarMemFieldKey() {
        return "gldimmembnum";
    }

    @Override
    String getPointTarMemShowFieldKey() {
        return "gldimmembnumshow";
    }

    @Override
    String getDimMappingEntryKey() {
        return "gldimmapentity";
    }

    @Override
    Long getDimMappingEntryView(String dimnumber) {
        DynamicObjectCollection dimMapSchemes = this.getModel().getEntryEntity(MAP_SCHEME_ENTRY);
        for (DynamicObject dimMapScheme : dimMapSchemes) {
            List dimMapList;
            Optional<DataIntegrationDimMap> first;
            String dimMemMapJson = dimMapScheme.getString("dimmemmapjson");
            if (!StringUtils.isNotEmpty((String)dimMemMapJson) || !(first = (dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0])).stream().filter(x -> dimnumber.equals(x.getDimtarget())).findFirst()).isPresent() || !IDUtils.isNotEmptyLong((Long)first.get().getDimmembmapid()).booleanValue()) continue;
            return DataIntegrationQueryService.getInstance().getDimMappingViewId(first.get().getDimmembmapid());
        }
        return 0L;
    }

    @Override
    Long getpointTarEntryView(String dimnumber) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("gldimmapentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return 0L;
        }
        Optional<DynamicObject> bcmdimtarnumber = entryEntity.stream().filter(x -> dimnumber.equals(x.getString("gltardimnumber"))).findFirst();
        if (bcmdimtarnumber.isPresent()) {
            DynamicObject dynamicObject = bcmdimtarnumber.get();
            return dynamicObject.getLong("gldimmembviewid.id");
        }
        return 0L;
    }
}

