/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.dataintegration.entity.syssetting.BcmSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pojo.MemberMapF7ValPojo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.PCPage.event.PCPageEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.CellClickEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.EntryExpEvent;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.IntegrationSysFormBasePlugin;

public class IntegrationBcmSysFormPlugin
extends IntegrationSysFormBasePlugin {
    private static final String dimKey = "bcmdim";
    private static final String viewKey = "bcmview";
    private static final String refDimKey = "refbcmdim";
    private static final String refViewKey = "refbcmview";
    private static final String modelKey = "bcmmodel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{modelKey, dimKey, viewKey, refDimKey, refViewKey});
    }

    @Override
    void fillBackData(SysSettingInfo settingInfo) {
        BcmSysSetting sysSetting = (BcmSysSetting)settingInfo;
        IDataModel dataModel = this.getModel();
        dataModel.setValue(modelKey, (Object)sysSetting.getModel());
        dataModel.setValue(dimKey, (Object)sysSetting.getDim());
        dataModel.setValue(viewKey, (Object)sysSetting.getView());
        if (sysSetting.isUseRefField()) {
            dataModel.setValue(refDimKey, (Object)sysSetting.getRefDim());
            dataModel.setValue(refViewKey, (Object)sysSetting.getRefView());
        }
    }

    @Override
    SysSettingInfo selSettingInfo() {
        BcmSysSetting setting = new BcmSysSetting();
        DynamicObject modelObj = (DynamicObject)this.getValue(modelKey, null);
        if (modelObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u4f53\u7cfb", (String)"IntegrationBcmSysFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        setting.setModel(Long.valueOf(modelObj.getLong("id")));
        this.selectVal(setting, false);
        if (this.isUseAssistField()) {
            this.selectVal(setting, true);
        }
        return setting;
    }

    private void selectVal(BcmSysSetting setting, boolean isRef) {
        String dimKey = this.getDimKey(isRef);
        String preSign1 = this.getPreSign(isRef);
        String viewKey = this.getViewKey(isRef);
        DynamicObject dimObj = (DynamicObject)this.getValue(dimKey, null);
        if (dimObj == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u7ef4\u5ea6", (String)"IntegrationBcmSysFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign1}));
        }
        String dimNum = dimObj.getString("number");
        Long viewId = null;
        if (SysDimensionEnum.Entity.getNumber().equals(dimNum)) {
            DynamicObject viewObj = (DynamicObject)this.getValue(viewKey, null);
            if (viewObj == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u7ec4\u7ec7\u89c6\u56fe", (String)"IntegrationBcmSysFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign1}));
            }
            viewId = viewObj.getLong("id");
        }
        if (isRef) {
            setting.setRefDim(Long.valueOf(dimObj.getLong("id")));
            setting.setRefDimNum(dimObj.getString("number"));
            setting.setRefView(viewId);
        } else {
            setting.setDim(Long.valueOf(dimObj.getLong("id")));
            setting.setView(viewId);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (this.isEmpty(propName)) {
            return;
        }
        if (propName.endsWith(dimKey)) {
            this.dealDimChange(propName, false);
        } else if (propName.endsWith(viewKey)) {
            this.dealViewChange(propName);
        } else if (propName.endsWith(modelKey)) {
            this.dealModelChange();
        }
    }

    @Override
    public List<String> getRefFieldKeys4Hide(boolean isOpen, boolean isInit) {
        if (isInit || !isOpen) {
            return super.getRefFieldKeys4Hide(isOpen, isInit);
        }
        return Collections.singletonList(refDimKey);
    }

    @Override
    protected void initItemStatus() {
        super.initItemStatus();
        this.dealDimChange(dimKey, true);
        this.dealDimChange(refDimKey, true);
    }

    private void dealDimChange(String dimKey, boolean isInit) {
        boolean isRef = this.isRef(dimKey);
        String viewKey = this.getViewKey(isRef);
        String dimNumber = (String)this.getValue(dimKey, "number");
        boolean showView = SysDimensionEnum.Entity.getNumber().equals(dimNumber);
        this.getView().setVisible(Boolean.valueOf(showView), new String[]{viewKey});
        if (!isInit) {
            if (this.getValue(viewKey, null) != null) {
                this.getModel().setValue(viewKey, null);
            } else {
                this.clearEntryMemberVal(isRef);
            }
        }
        if (!isRef) {
            if (SysDimensionEnum.Year.getNumber().equals(dimNumber)) {
                this.getModel().setValue("useassistfield", (Object)true);
                if (!isInit) {
                    Long periodDimId = (Long)CommonServiceHelper.getValueFromDB((String)"bcm_dimension", (String)"id", (String)"model,number", (Object[])new Object[]{this.getValue(modelKey, "id"), SysDimensionEnum.Period.getNumber()});
                    this.getModel().setValue(refDimKey, (Object)periodDimId);
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"useassistfield", refDimKey});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"useassistfield", refDimKey});
            }
        }
    }

    private void dealModelChange() {
        this.getModel().setValue(dimKey, null);
        if (this.isUseAssistField()) {
            this.getModel().setValue(refDimKey, null);
        }
    }

    private void dealViewChange(String viewKey) {
        boolean isRef = this.isRef(viewKey);
        this.clearEntryMemberVal(isRef);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String f7Key = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        List filters = showParameter.getListFilterParameter().getQFilters();
        if (modelKey.equals(f7Key)) {
            event.getFormShowParameter().setCustomParam("noNeedDefaultQFilter", (Object)"true");
            this.addModelFilter(filters);
        } else if (f7Key.endsWith(dimKey)) {
            this.addDimFilter(filters, f7Key);
        } else if (f7Key.endsWith(viewKey)) {
            this.addViewFilter(filters);
            showParameter.setCustomParam("custom", (Object)1);
        }
    }

    private void addModelFilter(List<QFilter> filters) {
        Map permModelInfo = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"BIModelService", (String)"getModels", (Object[])new Object[0]);
        HashSet modelNumbers = new HashSet(16);
        if (permModelInfo != null) {
            modelNumbers.addAll(permModelInfo.keySet());
        }
        filters.add(new QFilter("number", "in", modelNumbers));
    }

    private void addDimFilter(List<QFilter> filters, String fieldKey) {
        Long modelId = (Long)this.getValue(modelKey, "id");
        if (fieldKey.equals(refDimKey)) {
            String sourceDim = (String)this.getValue(dimKey, "number");
            if (this.isEmpty(sourceDim)) {
                filters.add(new QFilter("1", "=", (Object)-1));
            } else {
                filters.add(new QFilter("number", "!=", (Object)sourceDim));
            }
        }
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("number", "!=", (Object)SysDimensionEnum.Period.getNumber()));
    }

    private void addViewFilter(List<QFilter> filters) {
        Long modelId = (Long)this.getValue(modelKey, "id");
        filters.add(new QFilter("model", "=", (Object)modelId));
    }

    @Override
    public void onCall(PCPageEvent event) {
        super.onCall(event);
    }

    @Override
    protected void doOpenF7(CellClickEvent event) {
        super.doOpenF7(event);
        boolean isRef = event.isRef();
        String dimKey = this.getDimKey(isRef);
        Long dimId = (Long)this.getValue(dimKey, "id");
        String dimNum = (String)this.getValue(dimKey, "number");
        ILocaleString dimName = (ILocaleString)this.getValue(dimKey, "name");
        if (this.isEmpty(dimId)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u7ef4\u5ea6", (String)"IntegrationBcmSysFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getPreSign(isRef)}));
            return;
        }
        String memberFormByDim = this.getMemberFormByDim(dimId);
        Long modelId = (Long)this.getValue(modelKey, "id");
        DynamicObject bcmModel = this.getBCMModel(modelId);
        String modelNumber = bcmModel.getString("number");
        Long viewId = null;
        String viewNumber = null;
        if (SysDimensionEnum.Entity.getNumber().equals(dimNum)) {
            String viewKey = this.getViewKey(isRef);
            viewId = (Long)this.getValue(viewKey, "id");
            if (this.isEmpty(viewId)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u7ec4\u7ec7\u89c6\u56fe", (String)"IntegrationBcmSysFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getPreSign(isRef)}));
                return;
            }
            viewNumber = (String)this.getValue(viewKey, "number");
        }
        MemberF7Parameter f7Param = new MemberF7Parameter();
        f7Param.setModelId(modelId);
        f7Param.setModelNumber(modelNumber);
        f7Param.setDimensionId(dimId);
        f7Param.setDimensionNumber(dimNum);
        f7Param.setDimensionName(dimName.getLocaleValue());
        f7Param.setEntityNumber(memberFormByDim);
        f7Param.setSchemaNumber(viewNumber);
        f7Param.setReturnClassName(ListSelectedRowCollection.class.getName());
        f7Param.setMultiSelect(false);
        if (StringUtils.isNotEmpty((String)event.getCurrentNumbVal())) {
            ArrayList<String[]> members = new ArrayList<String[]>();
            members.add(new String[]{null, event.getCurrentNumbVal(), null});
            f7Param.setSelectedVirtualMember(members);
            f7Param.setBackFillVirtualMember(true);
        }
        f7Param.setEbModelId(this.getModelId());
        this.openF7(f7Param, event.getColKey());
    }

    @Override
    protected void dealMapEntryExp(EntryExpEvent expEvent) {
        super.dealMapEntryExp(expEvent);
        if (this.isSourceSysForm()) {
            expEvent.setShowRangeCol(true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private String getMemberFormByDim(Long dimId) {
        String formKey = null;
        if (this.notEmpty(dimId)) {
            formKey = (String)CommonServiceHelper.getValueFromDB((String)"bcm_dimension", (String)"memberform", (String)"id", (Object[])new Object[]{dimId});
        }
        return formKey;
    }

    private String getDimKey(boolean isRef) {
        return isRef ? refDimKey : dimKey;
    }

    private String getViewKey(boolean isRef) {
        return isRef ? refViewKey : viewKey;
    }

    @Override
    protected String getMainFieldKey() {
        return dimKey;
    }

    @Override
    protected void b4F7ValBack(MemberMapF7ValPojo pojo, CellClickEvent cellClickEvent) {
        pojo.setLeaf(true);
    }
}

