/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboEdit;
import kd.epm.eb.business.dataintegration.entity.syssetting.EasSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.formplugin.PCPage.event.PCPageEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.CheckRefBizFieldEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.EmptyRowEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.EntryExpEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.EntryNewRowEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.GetBizFieldKeysEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.MulBizFieldBoxChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.UpBizFieldListEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.UpBizFieldValEvent;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.IntegrationSysFormBasePlugin;

public class IntegrationEasSysFormPlugin
extends IntegrationSysFormBasePlugin {
    private static final String refBizFieldKey = "refbizfield";
    private static final String bizFieldKey = "bizfield";
    private static final String objKey = "obj";
    private static final String useMulBizFieldKey = "usemultbizfield";

    @Override
    void fillBackData(SysSettingInfo settingInfo) {
        EasSysSetting setting = (EasSysSetting)settingInfo;
        IDataModel dataModel = this.getModel();
        dataModel.setValue(objKey, (Object)setting.getObj());
        this.onSourceObjChange((DynamicObject)this.getValue(objKey, null), true);
        dataModel.setValue(bizFieldKey, (Object)setting.getBizField());
        dataModel.setValue(useMulBizFieldKey, (Object)setting.isUseMulBizField());
        if (setting.isUseRefField()) {
            dataModel.setValue(refBizFieldKey, (Object)setting.getRefBizField());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (this.notEmpty(name)) {
            if (name.equals(objKey)) {
                this.onSourceObjChange((DynamicObject)e.getChangeSet()[0].getNewValue(), false);
            } else if (name.equals(useMulBizFieldKey)) {
                this.onMulBizFieldChange((Boolean)e.getChangeSet()[0].getNewValue(), false);
            } else if (name.endsWith(bizFieldKey)) {
                this.dealBizFieldChange(name);
            }
        }
    }

    @Override
    protected void onUseAssistFieldChange(boolean isOpen, boolean isInit) {
        if (!this.checkSourceObjAndBackVal("useassistfield", isOpen, isInit)) {
            super.onUseAssistFieldChange(isOpen, isInit);
        }
    }

    @Override
    public void onCall(PCPageEvent event) {
        super.onCall(event);
        if (event instanceof CheckRefBizFieldEvent) {
            this.delCheckRefBizField((CheckRefBizFieldEvent)event);
        } else if (event instanceof EmptyRowEvent) {
            if (this.isUsemMultBizField()) {
                this.delCheckRefBizField(new CheckRefBizFieldEvent());
            }
        } else if (event instanceof EntryNewRowEvent && !this.isUsemMultBizField()) {
            String fieldVal = (String)this.getValue(bizFieldKey, null);
            UpBizFieldValEvent valEvent = new UpBizFieldValEvent(fieldVal);
            valEvent.setRowIndex(((EntryNewRowEvent)event).getRowIndex());
            this.callParent(valEvent);
        }
    }

    private void delCheckRefBizField(CheckRefBizFieldEvent event) {
        String refFieldVal = (String)this.getValue(refBizFieldKey, null);
        if (event.getBizFieldsVal().contains(refFieldVal) || event.getBizFieldsVal().isEmpty()) {
            this.getModel().setValue(refBizFieldKey, null);
        }
    }

    private void dealBizFieldChange(String key) {
        boolean isRef = this.isRef(key);
        String fieldVal = (String)this.getValue(key, null);
        if (!isRef) {
            UpBizFieldValEvent valEvent = new UpBizFieldValEvent(fieldVal);
            this.callParent(valEvent);
        } else if (this.notEmpty(fieldVal)) {
            GetBizFieldKeysEvent event = new GetBizFieldKeysEvent();
            if (!this.isUsemMultBizField()) {
                String sourceFieldVal = (String)this.getValue(bizFieldKey, null);
                if (this.notEmpty(sourceFieldVal)) {
                    event.getBizFieldKeys().add(sourceFieldVal);
                }
            } else {
                this.callParent(event);
            }
            if (event.getBizFieldKeys().contains(fieldVal)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u53ef\u4e0e\u4e1a\u52a1\u5b57\u6bb5\u7684\u503c\u76f8\u540c", (String)"IntegrationEasSysFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(key, null);
            } else if (event.getBizFieldKeys().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5b57\u6bb5", (String)"IntegrationEasSysFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(key, null);
            }
        }
    }

    @Override
    SysSettingInfo selSettingInfo() {
        EasSysSetting setting = new EasSysSetting();
        DynamicObject obj = (DynamicObject)this.getValue(objKey, null);
        if (obj != null) {
            setting.setObj(Long.valueOf(obj.getLong("id")));
        }
        setting.setUseMulBizField(((Boolean)this.getValue(useMulBizFieldKey, null)).booleanValue());
        String bizField = (String)this.getValue(bizFieldKey, null);
        if (obj != null && !setting.isUseMulBizField() && this.isEmpty(bizField)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5b57\u6bb5", (String)"IntegrationEasSysFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        setting.setBizField(bizField);
        if (this.isUseAssistField()) {
            String refBizField = (String)this.getValue(refBizFieldKey, null);
            if (this.isEmpty(refBizField) && obj != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f85\u52a9\u4e1a\u52a1\u5b57\u6bb5", (String)"IntegrationEasSysFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            setting.setRefBizField(refBizField);
        }
        return setting;
    }

    private void onSourceObjChange(DynamicObject newSourceObj, boolean isInit) {
        List itemList = EASDataIntegrationUtil.buildCombListOfSourceObj((DynamicObject)newSourceObj, null);
        ComboEdit comboEdit1 = (ComboEdit)this.getControl(bizFieldKey);
        ComboEdit comboEdit3 = (ComboEdit)this.getControl(refBizFieldKey);
        comboEdit1.setComboItems(itemList);
        comboEdit3.setComboItems(itemList);
        if (newSourceObj == null) {
            this.getModel().setValue(useMulBizFieldKey, (Object)false);
            this.getModel().setValue("useassistfield", (Object)false);
        }
        this.getModel().setValue(refBizFieldKey, null);
        this.getModel().setValue(bizFieldKey, null);
        UpBizFieldListEvent upBizFieldListEvent = new UpBizFieldListEvent(itemList);
        upBizFieldListEvent.setInit(isInit);
        this.callParent(upBizFieldListEvent);
    }

    @Override
    protected void dealMapEntryExp(EntryExpEvent expEvent) {
        super.dealMapEntryExp(expEvent);
        if (this.isSourceSysForm()) {
            expEvent.setShowBizFieldCol(this.isUsemMultBizField());
        }
    }

    @Override
    protected void initItemStatus() {
        super.initItemStatus();
        this.onMulBizFieldChange((Boolean)this.getValue(useMulBizFieldKey, null), true);
    }

    protected void onMulBizFieldChange(boolean isOpen, boolean isInit) {
        if (!this.checkSourceObjAndBackVal(useMulBizFieldKey, isOpen, isInit)) {
            this.getView().setVisible(Boolean.valueOf(!isOpen), new String[]{bizFieldKey});
            if (!isInit) {
                this.getModel().setValue(bizFieldKey, null);
            }
            this.callParent(new MulBizFieldBoxChangeEvent(isOpen, isInit));
        }
    }

    private boolean checkSourceObjAndBackVal(String fieldKey, boolean isOpen, boolean isInit) {
        if (isOpen && !isInit && this.getValue(objKey, null) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u96c6\u6210\u5bf9\u8c61", (String)"IntegrationEasSysFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getModel().getDataEntity().set(fieldKey, (Object)false);
            this.getView().updateView(fieldKey);
            return true;
        }
        return false;
    }

    @Override
    protected String getMainFieldKey() {
        return bizFieldKey;
    }

    private boolean isUsemMultBizField() {
        return (Boolean)this.getValue(useMulBizFieldKey, null);
    }
}

