/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.dataintegration.entity.syssetting.EbSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.PCPage.event.PCPageEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.CellClickEvent;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.IntegrationSysFormBasePlugin;

public class IntegrationEbSysFormPlugin
extends IntegrationSysFormBasePlugin {
    private static final String dimKey = "ebdim";
    private static final String viewKey = "ebdimview";
    private static final String dataSetKey = "ebdataset";
    private static final String refDimKey = "refebdim";
    private static final String refViewKey = "refebdimview";
    private static final String refDataSetKey = "refebdataset";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{dimKey, viewKey, dataSetKey, refDataSetKey, refViewKey, refDimKey});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (this.isEmpty(propName)) {
            return;
        }
        if (propName.endsWith(viewKey)) {
            this.dealViewChange(propName);
        } else if (propName.endsWith(dimKey)) {
            this.dealDimChange(propName, false);
        } else if (propName.endsWith(dataSetKey)) {
            this.dealDataSetChange(propName);
        }
    }

    private void dealDimChange(String key, boolean isInit) {
        boolean isRef = this.isRef(key);
        String dimNumber = (String)this.getValue(key, "number");
        boolean isNewEbForm = this.isNewEbForm();
        boolean hasView = this.notEmpty(dimNumber) && DimensionViewServiceHelper.hasView((String)dimNumber, (boolean)true);
        boolean hasDataset = SysDimensionEnum.Account.getNumber().equals(dimNumber);
        boolean isEntity = SysDimensionEnum.Entity.getNumber().equals(dimNumber);
        String viewKey = this.getViewKey(isRef);
        String datasetKey = this.getDataSetKey(isRef);
        this.getView().setVisible(Boolean.valueOf(hasView && (!isNewEbForm || isEntity)), new String[]{viewKey});
        this.getView().setVisible(Boolean.valueOf(hasDataset && !isNewEbForm), new String[]{datasetKey});
        if (!isInit) {
            if (isNewEbForm && hasDataset) {
                Long defaultDatasetId = NewEbAppUtil.getDefaultDatasetId((Long)this.getModelId());
                this.getModel().setValue(viewKey, null);
                this.getModel().setValue(datasetKey, (Object)defaultDatasetId);
            } else {
                boolean viewIsNull;
                boolean bl = viewIsNull = this.getValue(viewKey, null) == null;
                if (viewIsNull) {
                    boolean datasetIsNull;
                    boolean bl2 = datasetIsNull = this.getValue(datasetKey, null) == null;
                    if (datasetIsNull) {
                        this.clearEntryMemberVal(isRef);
                    } else {
                        this.getModel().setValue(datasetKey, null);
                    }
                } else {
                    this.getModel().setValue(viewKey, null);
                }
            }
        }
        if (hasView) {
            this.updateDimViewTitle(isRef);
        }
    }

    private void dealViewChange(String key) {
        this.clearEntryMemberVal(this.isRef(key));
    }

    private void dealDataSetChange(String key) {
        this.clearEntryMemberVal(this.isRef(key));
    }

    @Override
    void fillBackData(SysSettingInfo settingInfo) {
        EbSysSetting setting = (EbSysSetting)settingInfo;
        IDataModel dataModel = this.getModel();
        dataModel.setValue(dimKey, (Object)setting.getDim());
        dataModel.setValue(viewKey, (Object)setting.getView());
        dataModel.setValue(dataSetKey, (Object)setting.getDataset());
        if (setting.isUseRefField()) {
            dataModel.setValue(refDimKey, (Object)setting.getRefDim());
            dataModel.setValue(refViewKey, (Object)setting.getRefView());
            dataModel.setValue(refDataSetKey, (Object)setting.getRefDataset());
        }
    }

    @Override
    SysSettingInfo selSettingInfo() {
        EbSysSetting setting = new EbSysSetting();
        this.selectVal(setting, false);
        if (this.isUseAssistField()) {
            this.selectVal(setting, true);
        }
        return setting;
    }

    private void selectVal(EbSysSetting setting, boolean isRef) {
        String preSign2;
        DynamicObject dimObj = (DynamicObject)this.getValue(isRef ? refDimKey : dimKey, null);
        String preSign1 = this.getPreSign(isRef);
        if (dimObj == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u7ef4\u5ea6", (String)"IntegrationEbSysFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign1}));
        }
        if (isRef) {
            setting.setRefDim(Long.valueOf(dimObj.getLong("id")));
            setting.setRefDimNumb(dimObj.getString("number"));
            preSign2 = ResManager.loadKDString((String)"\u8f85\u52a9", (String)"IntegrationEbSysFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            setting.setDim(Long.valueOf(dimObj.getLong("id")));
            preSign2 = "";
        }
        String dimName = dimObj.getString("name");
        String dimNumber = dimObj.getString("number");
        if (DimensionViewServiceHelper.hasView((String)dimNumber, (boolean)true) && (!this.isNewEbForm() || SysDimensionEnum.Entity.getNumber().equals(dimNumber))) {
            DynamicObject viewObj = (DynamicObject)this.getValue(isRef ? refViewKey : viewKey, null);
            if (viewObj == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u89c6\u56fe", (String)"IntegrationEbSysFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign2 + dimName}));
            }
            if (isRef) {
                setting.setRefView(Long.valueOf(viewObj.getLong("id")));
            } else {
                setting.setView(Long.valueOf(viewObj.getLong("id")));
            }
        }
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            DynamicObject datasetObj = (DynamicObject)this.getValue(isRef ? refDataSetKey : dataSetKey, null);
            if (datasetObj == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u79d1\u76ee\u6570\u636e\u96c6", (String)"IntegrationEbSysFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign2}));
            }
            if (isRef) {
                setting.setRefDataset(Long.valueOf(datasetObj.getLong("id")));
            } else {
                setting.setDataset(Long.valueOf(datasetObj.getLong("id")));
            }
        }
    }

    @Override
    protected void initItemStatus() {
        super.initItemStatus();
        String preSign = this.getPreSign(false);
        this.updateBaseDataTitle(dimKey, ResManager.loadResFormat((String)"%1\u7ef4\u5ea6", (String)"IntegrationEbSysFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign}));
        this.dealDimChange(dimKey, true);
        this.dealDimChange(refDimKey, true);
    }

    private void updateDimViewTitle(boolean isRef) {
        OrmLocaleValue dimName = (OrmLocaleValue)this.getValue(this.getDimKey(isRef), "name");
        if (this.notEmpty(dimName)) {
            String preSign = this.getPreSign(isRef, false);
            this.updateBaseDataTitle(this.getViewKey(isRef), ResManager.loadResFormat((String)"%1\u89c6\u56fe", (String)"IntegrationEbSysFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign + dimName}));
        }
    }

    @Override
    protected void doOpenF7(CellClickEvent clickEvent) {
        Member member;
        super.doOpenF7(clickEvent);
        boolean isRef = clickEvent.isRef();
        DynamicObject dimObj = (DynamicObject)this.getValue(this.getDimKey(isRef), null);
        if (dimObj == null) {
            String preSign = this.getPreSign(isRef);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u7ef4\u5ea6", (String)"IntegrationBcmSysFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign}));
            return;
        }
        String dimNumber = dimObj.getString("number");
        String dimName = dimObj.getString("name");
        String memberNum = clickEvent.getCurrentNumbVal();
        Long modelId = this.getModelId();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "memberSelect_" + clickEvent.getColKey());
        long viewId = 0L;
        long datasetId = 0L;
        String preSign = this.getPreSign(isRef, false);
        if (DimensionViewServiceHelper.hasView((String)dimNumber, (boolean)true) && !this.isNewEbForm() || SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            DynamicObject dimViewObj = (DynamicObject)this.getModel().getValue(this.getViewKey(isRef));
            if (dimViewObj == null) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u89c6\u56fe", (String)"IntegrationEbSysFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign + dimName}));
                return;
            }
            viewId = dimViewObj.getLong("id");
        } else if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            DynamicObject datasetObj = (DynamicObject)this.getModel().getValue(this.getDataSetKey(isRef));
            if (datasetObj == null) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1\u79d1\u76ee\u6570\u636e\u96c6", (String)"IntegrationEbSysFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{preSign}));
                return;
            }
            datasetId = datasetObj.getLong("id");
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setViewId(Long.valueOf(viewId));
        if (IDUtils.isNotNull((long)datasetId)) {
            f7Param.setDatasetId(Long.valueOf(datasetId));
            f7Param.setBusModelId(DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId));
        }
        if (StringUtils.isNotEmpty((String)memberNum) && (member = this.getIModelCacheHelper().getMember(dimNumber, Long.valueOf(viewId), memberNum)) != null) {
            f7Param.setSelectId(member.getId());
        }
        f7Param.setEnableView(false);
        f7Param.setOnlySelLeaf(true);
        f7Param.setCutTree(false);
        if (this.isInputScheme()) {
            f7Param.setPermType(DimMembPermType.WRITE);
        } else {
            f7Param.setPermType(DimMembPermType.READ);
        }
        EASDataIntegrationUtil.setF7PermParam((MemberF7Parameter)f7Param, (Long)modelId, (boolean)this.isInputScheme());
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    @Override
    public void onCall(PCPageEvent event) {
        super.onCall(event);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        String key = arg0.getProperty().getName();
        Long modelId = this.getModelId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        boolean cancel = false;
        switch (key) {
            case "ebdim": 
            case "refebdim": {
                cancel = this.addDimFilter(qFilters, modelId, key);
                break;
            }
            case "ebdimview": 
            case "refebdimview": {
                cancel = this.addViewFilter(qFilters, modelId, key);
                break;
            }
            case "ebdataset": 
            case "refebdataset": {
                cancel = this.addDataSetFilter(qFilters, modelId, key);
                break;
            }
        }
        if (cancel) {
            arg0.setCancel(true);
        } else if (this.notEmpty(qFilters)) {
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        }
    }

    private boolean addDimFilter(List<QFilter> qFilters, Long modelId, String key) {
        if (key.equals(refDimKey)) {
            String sourceDim = (String)this.getValue(dimKey, "number");
            if (this.isEmpty(sourceDim)) {
                qFilters.add(new QFilter("1", "=", (Object)-1));
            } else {
                qFilters.add(new QFilter("number", "!=", (Object)sourceDim));
            }
        }
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (this.isNewEbForm()) {
            qFilters.add(new QFilter("number", "!=", (Object)SysDimensionEnum.InternalCompany.getNumber()));
        }
        return false;
    }

    private boolean addViewFilter(List<QFilter> qFilters, Long modelId, String key) {
        DynamicObject dimObj = (DynamicObject)this.getValue(this.getDimKey(this.isRef(key)), null);
        Long dimId = dimObj == null ? 0L : dimObj.getLong("id");
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("dimension", "=", (Object)dimId));
        return false;
    }

    private boolean addDataSetFilter(List<QFilter> qFilters, Long modelId, String key) {
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        return false;
    }

    private String getDimKey(boolean isRef) {
        return isRef ? refDimKey : dimKey;
    }

    private String getViewKey(boolean isRef) {
        return isRef ? refViewKey : viewKey;
    }

    private String getDataSetKey(boolean isRef) {
        return isRef ? refDataSetKey : dataSetKey;
    }

    @Override
    protected String getMainFieldKey() {
        return dimKey;
    }

    @Override
    public List<String> getRefFieldKeys4Hide(boolean isOpen, boolean isInit) {
        if (isInit || !isOpen) {
            return super.getRefFieldKeys4Hide(isOpen, isInit);
        }
        return Collections.singletonList(refDimKey);
    }
}

