/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.dataintegration.entity.EntryFieldType;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pojo.MemberMapF7ValPojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.PCPage.ChildPageHandler;
import kd.epm.eb.formplugin.PCPage.event.PCPageEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.CellClickEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.DataChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.EntryExpEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.F7ClickCallBackEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.RefBizFieldBoxChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.SysSettingChangeEvent;
import kd.epm.eb.formplugin.PCPage.event.dataintegration.SysSettingSelEvent;

public abstract class IntegrationSysFormBasePlugin
extends AbstractFormPlugin
implements ChildPageHandler,
BeforeF7SelectListener {
    private List<String> refFieldKeys;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initItemStatus();
    }

    private void initData() {
        boolean isSourceSystem = Boolean.parseBoolean((String)this.getCustomFormParam("isSourceSystem"));
        boolean isInputScheme = Boolean.parseBoolean((String)this.getCustomFormParam("isInputScheme"));
        IntegrationSchemeType schemeType = IntegrationSchemeType.getTypeByVal((String)((String)this.getCustomFormParam("SchemeType")));
        SysSettingInfo settingInfo = EASDataIntegrationUtil.desSysSetting((String)((String)this.getCustomFormParam("SystemSetting")), (IntegrationSchemeType)schemeType);
        if (settingInfo != null) {
            IDataModel dataModel = this.getModel();
            dataModel.setValue("useassistfield", (Object)settingInfo.isUseRefField());
            this.fillBackData(settingInfo);
        }
        if (isSourceSystem) {
            this.getPageCache().put("SourceSysFormMark", "true");
        }
        if (isInputScheme) {
            this.getPageCache().put("InputSchemeMark", "true");
        }
    }

    public List<String> getRefFieldKeys4Hide(boolean isOpen, boolean isInit) {
        if (this.refFieldKeys == null) {
            this.refFieldKeys = new ArrayList<String>(16);
            DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
            properties.forEach(prop -> {
                String name = prop.getName();
                if (this.notEmpty(name) && name.startsWith("ref")) {
                    this.refFieldKeys.add(name);
                }
            });
        }
        return this.refFieldKeys;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (this.notEmpty(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (name.equals("useassistfield")) {
                this.onUseAssistFieldChange((Boolean)newValue, false);
            } else {
                this.delBizFieldChange(name, newValue);
            }
            DataChangeEvent changeEvent = new DataChangeEvent(name);
            this.callParent(changeEvent);
        }
    }

    protected void onUseAssistFieldChange(boolean isOpen, boolean isInit) {
        List<String> refFieldKeys = this.getRefFieldKeys4Hide(isOpen, isInit);
        this.getView().setVisible(Boolean.valueOf(isOpen), refFieldKeys.toArray(new String[1]));
        if (!isOpen && !isInit) {
            IDataModel dataModel = this.getModel();
            refFieldKeys.forEach(key -> dataModel.setValue(key, null));
        }
        this.callParent(new RefBizFieldBoxChangeEvent(isOpen, isInit));
    }

    protected void initItemStatus() {
        if (!this.isSourceSysForm()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"useassistfield"});
            List<String> refFieldKeys = this.getRefFieldKeys4Hide(false, true);
            this.getView().setVisible(Boolean.valueOf(false), refFieldKeys.toArray(new String[1]));
        } else {
            this.onUseAssistFieldChange(this.isUseAssistField(), true);
        }
        this.checkAndLockAll();
    }

    protected void checkAndLockAll() {
        String paramVal = (String)this.getCustomFormParam("lockAll");
        if ("true".equals(paramVal)) {
            String[] allFieldKeys = (String[])this.getModel().getDataEntityType().getProperties().stream().filter(item -> item.getName() != null && !item.getName().startsWith("ref")).map(IMetadata::getName).toArray(String[]::new);
            this.getView().setEnable(Boolean.valueOf(false), allFieldKeys);
        }
    }

    protected boolean isInputScheme() {
        return StringUtils.isNotEmpty((String)this.getPageCache().get("InputSchemeMark"));
    }

    protected boolean isSourceSysForm() {
        return StringUtils.isNotEmpty((String)this.getPageCache().get("SourceSysFormMark"));
    }

    abstract void fillBackData(SysSettingInfo var1);

    abstract SysSettingInfo selSettingInfo();

    @Override
    public void onCall(PCPageEvent event) {
        if (event instanceof SysSettingSelEvent) {
            SysSettingSelEvent sysSettingSelEvent = (SysSettingSelEvent)event;
            SysSettingInfo settingInfo = this.selSettingInfo();
            if (settingInfo != null && this.isSourceSysForm()) {
                settingInfo.setUseRefField(this.isUseAssistField());
            }
            sysSettingSelEvent.setResult(settingInfo);
        } else if (event instanceof EntryExpEvent) {
            this.dealMapEntryExp((EntryExpEvent)event);
        } else if (event instanceof CellClickEvent) {
            this.doOpenF7((CellClickEvent)event);
        }
    }

    protected void dealMapEntryExp(EntryExpEvent expEvent) {
        if (this.isSourceSysForm()) {
            expEvent.setShowRefField(this.isUseAssistField());
        }
    }

    protected void clearEntryMemberVal(boolean isRef) {
        boolean isSource = this.isSourceSysForm();
        EntryFieldType fieldType = isRef ? EntryFieldType.ASSIST : (isSource ? EntryFieldType.SOURCE : EntryFieldType.TARGET);
        SysSettingChangeEvent event = new SysSettingChangeEvent(fieldType);
        this.callParent(event);
    }

    protected boolean isUseAssistField() {
        return (Boolean)this.getValue("useassistfield", null);
    }

    protected void updateBaseDataTitle(String key, String title) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
        if (basedataEdit != null) {
            basedataEdit.setCaption(new LocaleString(title));
        }
    }

    @Override
    public Long getModelId() {
        return Long.valueOf((String)this.getCustomFormParam("ModelId"));
    }

    protected String getPreSign(boolean isRef, boolean needSourceOrTarget) {
        String preSign = this.isSourceSysForm() ? (isRef ? ResManager.loadKDString((String)"\u8f85\u52a9", (String)"IntegrationSysFormBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]) : (needSourceOrTarget ? ResManager.loadKDString((String)"\u6e90", (String)"IntegrationSysFormBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]) : "")) : (needSourceOrTarget ? ResManager.loadKDString((String)"\u76ee\u6807", (String)"IntegrationSysFormBasePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]) : "");
        return preSign;
    }

    protected String getPreSign(boolean isRef) {
        return this.getPreSign(isRef, true);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData == null || this.isEmpty(actionId)) {
            return;
        }
        if (actionId.startsWith("memberSelect_")) {
            this.dealMemberF7CallBack(returnData);
        }
    }

    protected void dealMemberF7CallBack(Object returnData) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
        if (rows.isEmpty()) {
            return;
        }
        ListSelectedRow row = rows.get(0);
        MemberMapF7ValPojo pojo = new MemberMapF7ValPojo();
        pojo.setId((Long)row.getPrimaryKeyValue());
        pojo.setName(row.getName());
        pojo.setNumber(row.getNumber());
        CellClickEvent cellClickEvent = this.getOrCacheF7Param(null);
        this.b4F7ValBack(pojo, cellClickEvent);
        String name = pojo.getName();
        String number = pojo.getNumber();
        if (this.notEmpty(number) && number.length() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7100\u5b57\u7b26", (String)"IntegrationSysFormBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.notEmpty(name) && name.length() > 200) {
            pojo.setName(name.substring(0, 200));
        }
        this.callParent(new F7ClickCallBackEvent(pojo, cellClickEvent.getColKey()));
    }

    protected void b4F7ValBack(MemberMapF7ValPojo pojo, CellClickEvent cellClickEvent) {
    }

    protected void doOpenF7(CellClickEvent clickEvent) {
        this.getOrCacheF7Param(clickEvent);
    }

    protected CellClickEvent getOrCacheF7Param(CellClickEvent clickEvent) {
        return (CellClickEvent)this.getOrCacheObj(clickEvent, null, "CellClickEvent", true, CellClickEvent.class, false);
    }

    protected void openF7(String formKey, String colKey, List<QFilter> filters, Map<String, Object> formParam) {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)formKey, (boolean)false);
        if (this.notEmpty(filters)) {
            List qFilters = showListForm.getListFilterParameter().getQFilters();
            qFilters.addAll(filters);
        }
        if (formParam != null) {
            showListForm.getCustomParams().putAll(formParam);
        }
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "memberSelect_" + colKey));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    protected void openF7(MemberF7Parameter f7Param, String colKey) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "memberSelect_" + colKey);
        NewF7Utils.openVirtualF74JC((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    protected DynamicObject getBCMModel(Long modelId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"bcm_model", (String)"id,number,shownumber");
    }

    protected void openF7(String formKey, String colKey, List<QFilter> filters) {
        this.openF7(formKey, colKey, filters, null);
    }

    protected boolean isRef(String key) {
        return this.notEmpty(key) && key.startsWith("ref");
    }

    protected void delBizFieldChange(String fieldKey, Object newVal) {
        String refFieldKey;
        if (!this.isRef(fieldKey) && (refFieldKey = this.getRefFieldKey(fieldKey)) != null) {
            Object refFieldVal = this.getModel().getValue(refFieldKey);
            if (this.isEmpty(newVal) || this.checkFieldValSame(newVal, refFieldVal)) {
                this.getModel().setValue(refFieldKey, null);
            }
        }
    }

    protected String getRefFieldKey(String mainFieldKey) {
        String mainFieldKey1 = this.getMainFieldKey();
        return this.notEmpty(mainFieldKey1) && mainFieldKey1.equals(mainFieldKey) ? "ref" + mainFieldKey : null;
    }

    protected String getMainFieldKey() {
        return null;
    }

    protected boolean checkFieldValSame(Object sourceVal, Object targetVal) {
        if (sourceVal != null && targetVal != null) {
            if (sourceVal instanceof DynamicObject && targetVal instanceof DynamicObject) {
                return IDUtils.equals((Object)((DynamicObject)sourceVal).getLong("id"), (Object)((DynamicObject)targetVal).getLong("id"));
            }
            return sourceVal.equals(targetVal);
        }
        return false;
    }
}

