/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.ImportContext;
import kd.epm.eb.business.dataintegration.entity.syssetting.EasSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillImportHandler;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.BcmMemberMapImpValidator;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.EasMemberMapImpValidator;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.EbMemberMapImpValidator;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.GlMemberMapImpValidator;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.MemberMapImpExpHandler;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.MemberMapImpValidator;
import org.apache.poi.ss.usermodel.Workbook;

public class MemberMapImportHandler
extends AbstractBillImportHandler
implements MemberMapImpExpHandler {
    private IFormView currentFormView;
    private SysSettingInfo sourceSysSetting;
    private SysSettingInfo targetSysSetting;
    private DataIntegrationType integrationType;
    private IntegrationSchemeType schemeType;
    private boolean checkBizFieldCol = false;
    private boolean checkRangeCol = false;

    @Override
    public void addBillColsInfo(BillColGroup colConfig) {
        this.updateEntryConfig(colConfig);
    }

    @Override
    public void init(IFormView formView, Map<String, Object> params, String entityKey) {
        this.initConfig(formView, params);
        SysSettingInfo sourceSysSetting = this.getSourceSysSetting();
        if (sourceSysSetting instanceof EasSysSetting) {
            this.checkBizFieldCol = ((EasSysSetting)sourceSysSetting).isUseMulBizField();
        }
        this.checkRangeCol = EASDataIntegrationUtil.showRangeCol((DataIntegrationType)this.getIntegrationType(), (IntegrationSchemeType)this.getSchemeType());
    }

    @Override
    public void beforeSaveData(Map<Integer, DynamicObject> billObjs, Workbook book, Map<String, Object> args) {
        super.beforeSaveData(billObjs, book, args);
        if (billObjs.size() > 0) {
            IntegrationSchemeType targetType;
            IntegrationSchemeType sourceType;
            if (this.getIntegrationType() == DataIntegrationType.INPUT) {
                sourceType = this.getSchemeType();
                targetType = IntegrationSchemeType.EB;
            } else {
                sourceType = IntegrationSchemeType.EB;
                targetType = IntegrationSchemeType.CUSTOM;
            }
            MemberMapImpValidator sourceValidator = this.getValidator(args, sourceType, this.getSourceSysSetting(), true);
            MemberMapImpValidator targetValidator = this.getValidator(args, targetType, this.getTargetSysSetting(), false);
            DynamicObjectCollection entryRowsOnPage = this.getEntryRowsOnPage();
            HashSet<Integer> errorRows = new HashSet<Integer>(16);
            this.validRowRep(billObjs, entryRowsOnPage, errorRows);
            if (sourceValidator != null) {
                sourceValidator.validRow(billObjs);
                errorRows.addAll(sourceValidator.getErrorRowsSeq());
            }
            if (targetValidator != null) {
                targetValidator.validRow(billObjs);
                errorRows.addAll(targetValidator.getErrorRowsSeq());
            }
            errorRows.forEach(billObjs::remove);
        }
    }

    public void validRowRep(Map<Integer, DynamicObject> rowFromFile, DynamicObjectCollection rowFromPage, Set<Integer> errorRowInfo) {
        if (CollectionUtils.isNotEmpty(rowFromFile)) {
            HashMap<String, Integer> rowsStrOnPage = new HashMap<String, Integer>(rowFromPage.size());
            int rowIndex = 1;
            for (DynamicObject row : rowFromPage) {
                rowsStrOnPage.put(this.getRowStr(row), rowIndex);
                ++rowIndex;
            }
            HashMap rowsStrOnFile = new HashMap(rowFromFile.size());
            rowFromFile.entrySet().removeIf(entry -> {
                String rowStr = this.getRowStr((DynamicObject)entry.getValue());
                Integer indexOnFile = (Integer)rowsStrOnFile.get(rowStr);
                Integer index = (Integer)this.getImportContext().getRowIndexIdMap().get(((DynamicObject)entry.getValue()).getLong("id"));
                if (indexOnFile != null) {
                    this.addErrorLog(index, ResManager.loadResFormat((String)"\u4e0e\u7b2c%1\u884c\u5185\u5bb9\u91cd\u590d", (String)"MemberMapImportHandler_1", (String)"epm-eb-formplugin", (Object[])new Object[]{indexOnFile + 1}));
                    return true;
                }
                rowsStrOnFile.put(rowStr, index);
                Integer indexOnPage = (Integer)rowsStrOnPage.get(rowStr);
                if (indexOnPage != null) {
                    errorRowInfo.add((Integer)entry.getKey());
                    this.addErrorLog((DynamicObject)entry.getValue(), ResManager.loadResFormat((String)"\u4e0e\u9875\u9762\u4e0a\u5206\u5f55\u7b2c%1\u884c\u5185\u5bb9\u91cd\u590d", (String)"MemberMapImportHandler_2", (String)"epm-eb-formplugin", (Object[])new Object[]{indexOnPage}));
                }
                return false;
            });
        }
    }

    private String getRowStr(DynamicObject row) {
        StringBuilder sb = new StringBuilder();
        if (this.checkBizFieldCol) {
            sb.append(this.getFieldStrOnRow(row, "bizfieldcol")).append(",");
        }
        sb.append(this.getFieldStrOnRow(row, "sourcenumber")).append(",");
        if (this.checkRangeCol) {
            sb.append(this.getFieldStrOnRow(row, "scope")).append(",");
        }
        sb.append(this.getFieldStrOnRow(row, "acctorgnumber")).append(",");
        sb.append(this.getFieldStrOnRow(row, "assistnumber"));
        return sb.toString();
    }

    private String getFieldStrOnRow(DynamicObject row, String field) {
        String str = row.getString(field);
        return str == null ? "" : str;
    }

    protected MemberMapImpValidator getValidator(Map<String, Object> args, IntegrationSchemeType schemeType, SysSettingInfo settingInfo, boolean isSource) {
        switch (schemeType) {
            case CUSTOM: {
                return new EasMemberMapImpValidator(settingInfo, this.getImportContext(), isSource);
            }
            case EB: {
                return new EbMemberMapImpValidator(settingInfo, this.getImportContext(), isSource, (Long)args.get("model"));
            }
            case GL: {
                return new GlMemberMapImpValidator(settingInfo, this.getImportContext(), isSource);
            }
            case BCM: {
                return new BcmMemberMapImpValidator(settingInfo, this.getImportContext(), isSource, (Long)args.get("model"));
            }
        }
        return null;
    }

    private DynamicObjectCollection getEntryRowsOnPage() {
        IFormView parentView;
        DynamicObjectCollection rows = null;
        IFormView currentFormView = this.getCurrentFormView();
        if (currentFormView != null && (parentView = currentFormView.getParentView()) != null) {
            rows = parentView.getModel().getEntryEntity(this.getEntryKey());
        }
        return rows;
    }

    private String getEntryKey() {
        ImportContext importContext = this.getImportContext();
        if (importContext != null) {
            return importContext.getColGroup().getGroupKey();
        }
        return "entryentity";
    }

    @Override
    public IFormView getCurrentFormView() {
        return this.currentFormView;
    }

    @Override
    public void setCurrentFormView(IFormView currentFormView) {
        this.currentFormView = currentFormView;
    }

    @Override
    public SysSettingInfo getSourceSysSetting() {
        return this.sourceSysSetting;
    }

    @Override
    public void setSourceSysSetting(SysSettingInfo sourceSysSetting) {
        this.sourceSysSetting = sourceSysSetting;
    }

    @Override
    public SysSettingInfo getTargetSysSetting() {
        return this.targetSysSetting;
    }

    @Override
    public void setTargetSysSetting(SysSettingInfo targetSysSetting) {
        this.targetSysSetting = targetSysSetting;
    }

    @Override
    public DataIntegrationType getIntegrationType() {
        return this.integrationType;
    }

    @Override
    public void setIntegrationType(DataIntegrationType integrationType) {
        this.integrationType = integrationType;
    }

    @Override
    public IntegrationSchemeType getSchemeType() {
        return this.schemeType;
    }

    @Override
    public void setSchemeType(IntegrationSchemeType schemeType) {
        this.schemeType = schemeType;
    }
}

