/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.billimpexp.ImportContext;
import kd.epm.eb.business.dataintegration.entity.syssetting.BcmSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.MemberMapImpValidator;

public class BcmMemberMapImpValidator
extends MemberMapImpValidator {
    private Long ebModelId;

    public BcmMemberMapImpValidator(SysSettingInfo sysSettingInfo, ImportContext importContext, boolean sourceSystem, Long ebModelId) {
        super(sysSettingInfo, importContext, sourceSystem);
        this.ebModelId = ebModelId;
    }

    @Override
    public void validRow(Map<Integer, DynamicObject> rowFromFile) {
        BcmSysSetting sysSettingInfo = (BcmSysSetting)this.getSysSettingInfo();
        if (sysSettingInfo == null) {
            return;
        }
        Long modelId = sysSettingInfo.getModel();
        String modelNumber = (String)CommonServiceHelper.getValueFromDB((String)"bcm_model", (String)"number", (String)"id", (Object[])new Object[]{modelId});
        this.validMember(false, rowFromFile, sysSettingInfo.getModel(), modelNumber, sysSettingInfo.getDim(), sysSettingInfo.getView());
        if (sysSettingInfo.isUseRefField()) {
            this.validMember(true, rowFromFile, sysSettingInfo.getModel(), modelNumber, sysSettingInfo.getRefDim(), sysSettingInfo.getRefView());
        }
    }

    private void validMember(boolean isRef, Map<Integer, DynamicObject> rowFromFile, Long modelId, String modelNumber, Long dimId, Long viewId) {
        String fieldKey = this.getFieldKey(isRef);
        HashMap<String, String> numberNameMap = new HashMap<String, String>(16);
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name,number,memberform", (QFilter[])new QFilter("id", "=", (Object)dimId).toArray());
        HashSet<String> permMemberNumbers = null;
        if (dimObj != null) {
            HashMap params = Maps.newHashMap();
            String dimNumber = dimObj.getString("number");
            params.put("modelNum", modelNumber);
            params.put("dimNum", dimNumber);
            params.put("permType", "R");
            params.put("userId", UserUtils.getUserId());
            HashSet numbers = new HashSet(rowFromFile.size());
            rowFromFile.forEach((rowIndex, rowObj) -> numbers.add(rowObj.getString(fieldKey)));
            QFBuilder qb = new QFBuilder();
            qb.add("model", "=", (Object)modelId);
            qb.add("dimension", "=", (Object)dimId);
            qb.add("number", "in", numbers);
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                qb.add("cslscheme", "=", (Object)viewId);
                params.put("schemeNum", CommonServiceHelper.getValueFromDB((String)"bcm_cslscheme", (String)"number", (String)"id", (Object[])new Object[]{viewId}));
            } else {
                params.put("schemeNum", null);
            }
            Set permMemberIds = null;
            if (CommonUtils.checkBcmJCDataPerm((Long)this.ebModelId, (boolean)true)) {
                permMemberIds = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"MemberQueryMsService", (String)"queryMembers", (Object[])new Object[]{SerializationUtils.toJsonString((Object)params)});
            }
            if (permMemberIds != null) {
                permMemberNumbers = new HashSet<String>(permMemberIds.size());
                log.info("bcmPermMemberSize:{}-{}", (Object)dimNumber, (Object)permMemberIds.size());
            }
            DynamicObjectCollection memberObjs = QueryServiceHelper.query((String)dimObj.getString("memberform"), (String)"number,name,id", (QFilter[])qb.toArrays());
            for (DynamicObject object : memberObjs) {
                numberNameMap.put(object.getString("number"), object.getString("name"));
                if (permMemberIds == null || !permMemberIds.contains(object.getLong("id"))) continue;
                permMemberNumbers.add(object.getString("number"));
            }
            if (permMemberNumbers != null && LogSignHelper.needLog((String)"MemberMapImpValidator", (String)"bcmPermMember")) {
                CommonServiceHelper.handleLog((Log)log, (String)("bcmPermMember-" + dimNumber), (String)SerializationUtils.toJsonString(permMemberNumbers));
            }
        }
        this.vailNumberAndFillName(rowFromFile, numberNameMap, permMemberNumbers, isRef);
    }
}

