/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.billimpexp.ImportContext;
import kd.epm.eb.business.dataintegration.entity.syssetting.EasSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.MemberMapImpValidator;

public class EasMemberMapImpValidator
extends MemberMapImpValidator {
    public EasMemberMapImpValidator(SysSettingInfo settingInfo, ImportContext importContext, boolean isSource) {
        super(settingInfo, importContext, isSource);
    }

    @Override
    public void validRow(Map<Integer, DynamicObject> rowFromFile) {
        EasSysSetting sysSettingInfo = (EasSysSetting)this.getSysSettingInfo();
        if (sysSettingInfo == null || !this.isSourceSystem()) {
            return;
        }
        if (!sysSettingInfo.isUseMulBizField()) {
            rowFromFile.values().forEach(rowObj -> rowObj.set("bizfieldcol", (Object)sysSettingInfo.getBizField()));
        } else {
            DynamicObject newSourceObj = BusinessDataServiceHelper.loadSingle((Object)sysSettingInfo.getObj(), (String)"isc_metadata_schema");
            List itemList = EASDataIntegrationUtil.buildCombListOfSourceObj((DynamicObject)newSourceObj, null);
            Set fields = itemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            rowFromFile.forEach((seq, rowObj) -> {
                String bizFieldKey = rowObj.getString("bizfieldcol");
                if (!fields.contains(bizFieldKey)) {
                    this.addFileNotExistErrorInfo((DynamicObject)rowObj, (int)seq, "bizfieldcol", bizFieldKey);
                }
            });
        }
    }
}

