/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.billimpexp.ImportContext;
import kd.epm.eb.business.dataintegration.entity.syssetting.EbSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.MemberMapImpValidator;

public class EbMemberMapImpValidator
extends MemberMapImpValidator {
    private Long modelId;

    public EbMemberMapImpValidator(SysSettingInfo sysSettingInfo, ImportContext importContext, boolean sourceSystem, Long modelId) {
        super(sysSettingInfo, importContext, sourceSystem);
        this.modelId = modelId;
    }

    @Override
    public void validRow(Map<Integer, DynamicObject> rowFromFile) {
        EbSysSetting sysSettingInfo = (EbSysSetting)this.getSysSettingInfo();
        if (sysSettingInfo == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        this.validMember(false, rowFromFile, modelCacheHelper, sysSettingInfo.getDim(), sysSettingInfo.getView());
        if (sysSettingInfo.isUseRefField()) {
            this.validMember(true, rowFromFile, modelCacheHelper, sysSettingInfo.getRefDim(), sysSettingInfo.getRefView());
        }
    }

    private void validMember(boolean isRef, Map<Integer, DynamicObject> rowFromFile, IModelCacheHelper modelCacheHelper, Long dimId, Long viewId) {
        String fieldKey = this.getFieldKey(isRef);
        String nameFieldKey = this.getNameFieldKey(isRef);
        Dimension dimension = modelCacheHelper.getDimension(dimId);
        View dimView = dimension.getView(viewId);
        if (dimView == null) {
            dimView = dimension;
        }
        for (Map.Entry<Integer, DynamicObject> entry : rowFromFile.entrySet()) {
            String memberNum = entry.getValue().getString(fieldKey);
            Member member = dimView.getMember(memberNum);
            if (member == null) {
                this.addFileNotExistErrorInfo(entry.getValue(), entry.getKey(), fieldKey, memberNum);
                continue;
            }
            if (!member.isLeaf()) {
                this.addRowErrorInfo(entry.getValue(), entry.getKey(), fieldKey, ResManager.loadResFormat((String)"\u6210\u5458%1\u4e0d\u662f\u660e\u7ec6\u6210\u5458", (String)"EbMemberMapImpValidator_1", (String)"epm-eb-formplugin", (Object[])new Object[]{memberNum}));
                continue;
            }
            entry.getValue().set(nameFieldKey, (Object)member.getName());
        }
    }

    public Long getModelId() {
        return this.modelId;
    }
}

