/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.billimpexp.ImportContext;
import kd.epm.eb.business.dataintegration.entity.GlBizFieldType;
import kd.epm.eb.business.dataintegration.entity.syssetting.GlSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.common.pojo.FiAccountObj;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate.MemberMapImpValidator;

public class GlMemberMapImpValidator
extends MemberMapImpValidator {
    public GlMemberMapImpValidator(SysSettingInfo sysSettingInfo, ImportContext importContext, boolean sourceSystem) {
        super(sysSettingInfo, importContext, sourceSystem);
    }

    @Override
    public void validRow(Map<Integer, DynamicObject> rowFromFile) {
        GlSysSetting sysSettingInfo = (GlSysSetting)this.getSysSettingInfo();
        if (sysSettingInfo == null) {
            return;
        }
        this.validMember(false, rowFromFile, sysSettingInfo.getBizField(), sysSettingInfo.getGlObj(), sysSettingInfo.getCostView());
        if (sysSettingInfo.isUseRefField()) {
            this.validMember(true, rowFromFile, sysSettingInfo.getRefBizField(), sysSettingInfo.getRefGlObj(), sysSettingInfo.getRefCostView());
        }
    }

    private void validMember(boolean isRef, Map<Integer, DynamicObject> rowFromFile, String bizFieldKey, Long glObjId, Long costViewId) {
        String colFieldKey = this.getFieldKey(isRef);
        GlBizFieldType fieldType = GlBizFieldType.getTypeByFieldKey((String)bizFieldKey);
        String entityName = null;
        QFBuilder qb = new QFBuilder();
        String numberField = "number";
        String nameField = "name";
        if (fieldType != null) {
            if (fieldType == GlBizFieldType.DIMENSION) {
                DynamicObject asstactType = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"valuetype,assistanttype,valuesource.id", (QFilter[])new QFilter("id", "=", (Object)glObjId).toArray());
                if (asstactType != null) {
                    String dimValueType = asstactType.getString("valuetype");
                    if ("2".equals(dimValueType)) {
                        entityName = "bos_assistantdata_detail";
                        qb.add("group", "=", (Object)asstactType.getLong("assistanttype"));
                    } else if ("1".equals(dimValueType)) {
                        entityName = asstactType.getString("valuesource.id");
                    }
                }
            } else {
                entityName = fieldType.getFieldFormKey();
                switch (fieldType) {
                    case ORG: {
                        qb.add("view", "=", (Object)costViewId);
                        numberField = "org.number";
                        nameField = "org.name";
                        break;
                    }
                    case ACCOUNT: {
                        qb.add("accounttable", "=", (Object)glObjId);
                        break;
                    }
                    case PERIOD: {
                        qb.add("periodtype", "=", (Object)glObjId);
                    }
                }
            }
        }
        HashMap<String, String> numberName = new HashMap<String, String>(16);
        HashMap<String, List<FiAccountObj>> allAccountInfo = new HashMap<String, List<FiAccountObj>>(16);
        if (StringUtils.isNotEmpty((String)entityName)) {
            HashSet numbers = new HashSet(rowFromFile.size());
            rowFromFile.forEach((rowIndex, rowObj) -> numbers.add(rowObj.getString(colFieldKey)));
            qb.add(numberField, "in", numbers);
            if (fieldType == GlBizFieldType.ACCOUNT) {
                DynamicObjectCollection memberObjs = QueryServiceHelper.query((String)entityName, (String)"id,number,name,createorg.number as orgnumber,createorg.name as orgname", (QFilter[])qb.toArrays());
                for (DynamicObject obj : memberObjs) {
                    String name = obj.getString("name");
                    String orgName = obj.getString("orgname");
                    String orgNumber = obj.getString("orgnumber");
                    Long id = obj.getLong("id");
                    allAccountInfo.computeIfAbsent(obj.getString("number"), key -> new LinkedList()).add(new FiAccountObj(id, name, orgName, orgNumber));
                }
            } else {
                DynamicObjectCollection memberObjs = QueryServiceHelper.query((String)entityName, (String)("id," + numberField + "," + nameField + ""), (QFilter[])qb.toArrays());
                for (DynamicObject obj : memberObjs) {
                    numberName.put(obj.getString(numberField), obj.getString(nameField));
                }
            }
        }
        if (allAccountInfo.size() > 0) {
            this.vailAcctNumberAndFillName(rowFromFile, allAccountInfo, isRef);
        } else {
            this.vailNumberAndFillName(rowFromFile, numberName, null, isRef);
        }
    }

    private void vailAcctNumberAndFillName(Map<Integer, DynamicObject> rowFromFile, Map<String, List<FiAccountObj>> allAccountInfo, boolean isRef) {
        String colFieldKey = this.getFieldKey(isRef);
        String nameFieldKey = this.getNameFieldKey(isRef);
        String orgNumberKey = this.getAcctOrgFieldKey(isRef, false);
        String orgNameKey = this.getAcctOrgFieldKey(isRef, true);
        String idKey = this.getIdFieldKey(isRef);
        rowFromFile.forEach((seq, rowObj) -> {
            String accountNum = rowObj.getString(colFieldKey);
            List infoList = (List)allAccountInfo.get(accountNum);
            if (infoList == null && StringUtils.isNotEmpty((String)accountNum)) {
                this.addFileNotExistErrorInfo((DynamicObject)rowObj, (int)seq, colFieldKey, accountNum);
            } else if (infoList != null) {
                String orgNumber = rowObj.getString(orgNumberKey);
                FiAccountObj matchObj = null;
                for (FiAccountObj obj : infoList) {
                    if (!StringUtils.equals((String)orgNumber, (String)obj.getCreateOrgNumber())) continue;
                    matchObj = obj;
                    break;
                }
                if (matchObj != null) {
                    rowObj.set(nameFieldKey, (Object)this.checkNameLength(matchObj.getName()));
                    rowObj.set(orgNameKey, (Object)this.checkNameLength(matchObj.getCreateOrgName()));
                    rowObj.set(idKey, (Object)matchObj.getId());
                } else {
                    this.addRowErrorInfo((DynamicObject)rowObj, (int)seq, null, ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e0e\u521b\u5efa\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5339\u914d", (String)"GlMemberMapImpValidator_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private String getAcctOrgFieldKey(boolean isRef, boolean isName) {
        String pre = isRef ? "ref" : "";
        String end = isName ? "acctorgname" : "acctorgnumber";
        return pre + end;
    }
}

