/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin.syssetting.validate;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.billimpexp.ImportContext;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.common.utils.StringUtils;

public abstract class MemberMapImpValidator {
    protected static final Log log = LogFactory.getLog(MemberMapImpValidator.class);
    private ImportContext importContext;
    private SysSettingInfo sysSettingInfo;
    private boolean sourceSystem;
    private Set<Integer> errorRowsSeq = new HashSet<Integer>(16);

    public MemberMapImpValidator(SysSettingInfo sysSettingInfo, ImportContext importContext, boolean sourceSystem) {
        this.importContext = importContext;
        this.sysSettingInfo = sysSettingInfo;
        this.sourceSystem = sourceSystem;
    }

    public void validRow(Map<Integer, DynamicObject> rowFromFile) {
    }

    public SysSettingInfo getSysSettingInfo() {
        return this.sysSettingInfo;
    }

    public Set<Integer> getErrorRowsSeq() {
        return this.errorRowsSeq;
    }

    protected void addFileNotExistErrorInfo(DynamicObject rowObj, int rowSeq, String colKey, String fieldVal) {
        this.addRowErrorInfo(rowObj, rowSeq, colKey, ResManager.loadResFormat((String)"%1\u4e0d\u5b58\u5728", (String)"MemberMapImpValidator_1", (String)"epm-eb-formplugin", (Object[])new Object[]{fieldVal}));
    }

    protected void addRowErrorInfo(DynamicObject rowObj, int rowSeq, String colKey, String errorInfo) {
        this.errorRowsSeq.add(rowSeq);
        this.importContext.addErrorInfo(colKey, errorInfo, Long.valueOf(rowObj.getLong("id")));
    }

    public boolean isSourceSystem() {
        return this.sourceSystem;
    }

    protected String getFieldKey(boolean isRef) {
        if (isRef) {
            return "assistnumber";
        }
        if (this.isSourceSystem()) {
            return "sourcenumber";
        }
        return "targetnumber";
    }

    protected String getNameFieldKey(boolean isRef) {
        if (isRef) {
            return "assistname";
        }
        if (this.isSourceSystem()) {
            return "sourcename";
        }
        return "targetname";
    }

    protected String getIdFieldKey(boolean isRef) {
        if (isRef) {
            return "assistid";
        }
        return "sourceid";
    }

    protected void vailNumberAndFillName(Map<Integer, DynamicObject> rowFromFile, Map<String, String> numberNameMap, Set<String> permMemberNumbers, boolean isRef) {
        String colFieldKey = this.getFieldKey(isRef);
        String nameFieldKey = this.getNameFieldKey(isRef);
        rowFromFile.forEach((seq, rowObj) -> {
            String memberNum = rowObj.getString(colFieldKey);
            String name = (String)numberNameMap.get(memberNum);
            if (name == null && StringUtils.isNotEmpty((String)memberNum)) {
                this.addFileNotExistErrorInfo((DynamicObject)rowObj, (int)seq, colFieldKey, memberNum);
            } else if (permMemberNumbers != null && !permMemberNumbers.contains(memberNum)) {
                this.addRowErrorInfo((DynamicObject)rowObj, (int)seq, colFieldKey, ResManager.loadResFormat((String)"\u6ca1\u6709%1\u6210\u5458\u7684\u6743\u9650", (String)"MemberMapImpValidator_2", (String)"epm-eb-formplugin", (Object[])new Object[]{memberNum}));
            } else {
                rowObj.set(nameFieldKey, (Object)this.checkNameLength(name));
            }
        });
    }

    protected String checkNameLength(String name) {
        if (name != null && name.length() > 200) {
            name = name.substring(0, 200);
        }
        return name;
    }
}

