/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.report.style.DataLockUtils;
import kd.epm.eb.budget.formplugin.util.UserSelectUtil;
import kd.epm.eb.business.dataperm.EbMembPerm;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.business.userselect.WholeUserSelect;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.datalock.DataLockKey;
import kd.epm.eb.common.datalock.DataLockService;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeContainer;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.common.lazytree.Matchable;
import kd.epm.eb.common.lazytree.SearchInfo;
import kd.epm.eb.common.lazytree.datalock.DataLockLazyTreeHandler;
import kd.epm.eb.common.lazytree.datalock.EntityTree;
import kd.epm.eb.common.lazytree.datalock.PeriodEnable;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractBaseListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DataLockListPlugin
extends AbstractBaseListPlugin
implements TreeNodeQueryListener,
HyperLinkClickListener,
BeforeF7SelectListener,
EbMembPerm,
RowClickEventListener {
    private static final Set<String> PRECAST_PERIOD = Sets.newHashSet((Object[])new String[]{"hf_yeartotal", "hf_hf1", "hf_hf2", "q_yeartotal", "q_hf1", "q_hf2", "q_q1", "q_q2", "q_q3", "q_q4", "m_yeartotal", "m_hf1", "m_hf2", "m_q1", "m_q2", "m_q3", "m_q4", "m_m01", "m_m02", "m_m03", "m_m04", "m_m05", "m_m06", "m_m07", "m_m08", "m_m09", "m_m10", "m_m11", "m_m12"});
    public static final String SEARCH_TEXT_CACHE = "searchTextCache";
    private static final Log log = LogFactory.getLog(DataLockListPlugin.class);
    private boolean dataChange = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid entry = (TreeEntryGrid)this.getControl("entryentity");
        entry.addCellClickListener((TreeNodeQueryListener)this);
        entry.addRowClickListener((RowClickEventListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl("searchap");
        if (search != null) {
            search.addEnterListener(event -> {
                String searchText = event.getText();
                if (searchText == null || searchText.trim().equals("")) {
                    this.refresh();
                    return;
                }
                String modelId = this.getPageCache().get("KEY_MODEL_ID");
                DataLockKey dataLockKey = this.fillPageWhileModelChange(modelId);
                if (dataLockKey != null) {
                    Map dataLockData = DataLockService.getInstance().getDataLockData(Long.valueOf(modelId), dataLockKey);
                    EntityTree treeRoot = DataLockUtils.buildPageTree((long)this.getModelId(), (Map)dataLockData, (QFilter)new QFilter("level", "!=", (Object)1).and(new QFilter("number", "like", (Object)("%" + searchText + "%")).or("name", "like", (Object)("%" + searchText + "%"))), null, (Boolean)true);
                    if (treeRoot.getChildren() == null || treeRoot.getChildren().isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"EbAdjustProjectPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DataLockLazyTreeHandler(), (ITreeNode)treeRoot).initTree();
                    List matchedNodes = LazyTreeUtils.searchMember((ITreeNode)treeRoot, (String)searchText, (Matchable)new DataLockLazyTreeHandler());
                    SearchInfo searchInfo = new SearchInfo(0, matchedNodes);
                    this.getView().getPageCache().put("searchInfo", SerializationUtils.serializeToBase64((Object)searchInfo));
                    this.getPageCache().put(SEARCH_TEXT_CACHE, searchText);
                    this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)treeRoot));
                }
            });
        }
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.isDataChanged() && this.isFirst()) {
                this.getPageCache().put("isfirst", "true");
                beforeF7SelectEvent.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u6539\u53d8\uff0c\u786e\u8ba4\u4fdd\u5b58\u6570\u636e\uff1f", (String)"DynamicReportProcess_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("savedata"));
            }
            List modelFilter = ModelUtil.getModelFilter((IFormView)this.getView());
            beforeF7SelectEvent.getCustomQFilters().addAll(modelFilter);
        });
        BasedataEdit yearEdit = (BasedataEdit)this.getControl("year");
        yearEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit versionEdit = (BasedataEdit)this.getControl("version");
        versionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl("currency");
        currencyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbar_main"});
    }

    public void afterCreateNewData(EventObject e) {
        long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (modelId == 0L) {
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        this.getModel().setValue("model", (Object)modelId);
        this.initPageWhileModelChange(String.valueOf(modelId));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbDataPermPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.saveData();
                break;
            }
            case "btn_showlog": {
                this.showLogPage();
                break;
            }
            case "bar_refresh": {
                this.refresh();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key)) {
            EntityTree treeRoot = (EntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DataLockLazyTreeHandler(), (ITreeNode)treeRoot).searchBefore();
        } else if ("searchnext".equals(key)) {
            EntityTree treeRoot = (EntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DataLockLazyTreeHandler(), (ITreeNode)treeRoot).searchNext();
        }
    }

    private void showLogPage() {
        IFormView toshowform;
        DataLockKey dataLockKey = this.getDataLockKey();
        if (dataLockKey == null) {
            return;
        }
        long modelId = this.getModelId();
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + modelId;
        IFormView iFormView = toshowform = mainPageView == null ? null : mainPageView.getView(pageId);
        if (toshowform == null) {
            IFormView parentview;
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setPageId(pageId);
            showParameter.setBillFormId("eb_datalocklog");
            showParameter.getListFilterParameter().setFilter(new QFilter("model", "=", (Object)this.getModelId()));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            if (modelId != 0L) {
                showParameter.setCustomParam("MODELID", (Object)modelId);
            }
            if ((parentview = this.getView().getParentView()) != null) {
                showParameter.setParentPageId(parentview.getPageId());
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            toshowform.activate();
            this.getView().sendFormAction(toshowform);
        }
    }

    private void refresh() {
        this.getPageCache().put(SEARCH_TEXT_CACHE, null);
        DataLockKey dataLockKey = this.getDataLockKey();
        if (dataLockKey == null) {
            return;
        }
        if (this.isDataChanged()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u518d\u6267\u884c\u5237\u65b0\u3002", (String)"BgTaskExecutePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.initPageWhileModelChange(String.valueOf(this.getModelId()));
        }
    }

    private void saveData() {
        long modelId = this.getModelId();
        DataLockKey dataLockKey = this.getDataLockKey();
        if (dataLockKey == null) {
            return;
        }
        if (!this.isDataChanged()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CentralControlAddVersion2_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        EntityTree treeRoot = (EntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        List needSaveList = DataLockUtils.getNeedSaveList((EntityTree)treeRoot, (IModelCacheHelper)modelCache);
        DataLockService.getInstance().saveDataLock(modelId, dataLockKey, needSaveList);
        this.dataChange(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MetricMemberEdit_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private IModelCacheHelper getModelCacheHelper() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    public void initPageWhileModelChange(String modelId) {
        DataLockKey dataLockKey = this.fillPageWhileModelChange(modelId);
        if (dataLockKey != null) {
            Map dataLockData = DataLockService.getInstance().getDataLockData(Long.valueOf(modelId), dataLockKey);
            this.initEntryEntity(dataLockData);
        } else {
            this.getPageCache().remove("cacheRoot");
        }
        this.hidePeriodRow();
        this.getView().updateView();
    }

    public void hidePeriodRow() {
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        List members = modelCache.getMembers(null, SysDimensionEnum.Period.getNumber());
        members = members.stream().filter(member -> !member.getNumber().equals(SysDimensionEnum.Period.getNumber())).collect(Collectors.toList());
        Set allMemberNumbers = members.stream().map(member -> member.getNumber().toLowerCase()).collect(Collectors.toSet());
        allMemberNumbers.removeAll(PRECAST_PERIOD);
        if (!allMemberNumbers.isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "btn_showlog", "bar_refresh"});
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u542b\u6709\u9519\u8bef\u671f\u95f4\uff1a%1,\u6570\u636e\u9501\u5b9a\u529f\u80fd\u4e0d\u53ef\u7528\u3002", (String)"DataLockListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{allMemberNumbers.toString()}));
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save", "btn_showlog", "bar_refresh"});
        List defaultPeriodEnables = DataLockUtils.getDefaultPeriodEnables(members);
        Set<String> collect = defaultPeriodEnables.stream().map(PeriodEnable::getPeriodNumber).collect(Collectors.toSet());
        this.getView().setVisible(Boolean.TRUE, collect.toArray(new String[0]));
        Collection strings = CollectionUtils.removeAll(PRECAST_PERIOD, collect);
        this.getView().setVisible(Boolean.FALSE, strings.toArray(new String[0]));
    }

    public DataLockKey fillPageWhileModelChange(String modelId) {
        if (StringUtils.isEmpty((String)modelId)) {
            return null;
        }
        WholeUserSelect wholeUserSelect = UserSelectUtils.getWholeUserSelect((IFormView)this.getView());
        DataLockKey dataLockKey = new DataLockKey();
        if (wholeUserSelect != null) {
            DynamicObject dynamicObject;
            this.getModel().beginInit();
            Long year = wholeUserSelect.getYear();
            Long currency = wholeUserSelect.getCurrency();
            Long version = wholeUserSelect.getVersion();
            if (year != null && year != 0L && QueryServiceHelper.exists((String)"epm_yearmembertree", (Object)year)) {
                dynamicObject = QueryServiceHelper.queryOne((String)"epm_yearmembertree", (String)"number", (QFilter[])new QFilter("id", "=", (Object)year).toArray());
                if (dynamicObject != null) {
                    this.getModel().setValue("year", (Object)year);
                    dataLockKey.setYear(dynamicObject.getString("number"));
                } else {
                    this.getModel().setValue("year", null);
                }
            }
            if (currency != null && currency != 0L) {
                dynamicObject = QueryServiceHelper.queryOne((String)"epm_currencymembertree", (String)"number", (QFilter[])new QFilter("id", "=", (Object)currency).toArray());
                if (dynamicObject != null) {
                    this.getModel().setValue("currency", (Object)currency);
                    dataLockKey.setCurrency(dynamicObject.getString("number"));
                } else {
                    this.getModel().setValue("currency", null);
                }
            }
            if (version != null && version != 0L) {
                DynamicObject versionDoj = QueryServiceHelper.queryOne((String)"epm_versionmembertree", (String)"number,isleaf", (QFilter[])new QFilter("id", "=", (Object)version).toArray());
                if (versionDoj != null && versionDoj.getBoolean("isleaf")) {
                    this.getModel().setValue("version", (Object)version);
                    dataLockKey.setVersion(versionDoj.getString("number"));
                } else {
                    this.getModel().setValue("version", null);
                }
            }
            this.getModel().endInit();
        }
        return dataLockKey;
    }

    private DataLockKey getDataLockKey() {
        DataLockKey dataLockKey = new DataLockKey();
        DynamicObject yearDoj = (DynamicObject)this.getModel().getValue("year");
        if (yearDoj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"DataLockListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        dataLockKey.setYear(yearDoj.getString("id"));
        DynamicObject currDoj = (DynamicObject)this.getModel().getValue("currency");
        if (currDoj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"DataLockListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        dataLockKey.setCurrency(currDoj.getString("id"));
        DynamicObject versionDoj = (DynamicObject)this.getModel().getValue("version");
        if (versionDoj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7248\u672c\u3002", (String)"DataLockListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        dataLockKey.setVersion(versionDoj.getString("id"));
        return dataLockKey;
    }

    private void initEntryEntity(Map<String, Set<String>> dataLockData) {
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        List periodMembers = modelCache.getMembers(null, SysDimensionEnum.Period.getNumber());
        List<String> collect = periodMembers.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Collection strings1 = CollectionUtils.removeAll(PRECAST_PERIOD, collect);
        this.getView().setVisible(Boolean.TRUE, strings1.toArray(new String[0]));
        this.getView().setVisible(Boolean.TRUE, collect.toArray(new String[0]));
        EntityTree treeRoot = DataLockUtils.buildPageTree((long)this.getModelId(), dataLockData, (QFilter)new QFilter("level", "=", (Object)2), null, (Boolean)false);
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DataLockLazyTreeHandler(), (ITreeNode)treeRoot).initTree();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.dataChange) {
            return;
        }
        this.propertyChangedTitle(e);
        this.propertyChangePeriod(e);
    }

    private void propertyChangePeriod(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        log.info("datalockpropchange" + propKey);
        if (!PRECAST_PERIOD.contains(propKey)) {
            return;
        }
        String entityKey = e.getProperty().getParent().getName();
        boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject currRow = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        Map periodMapping = DataLockUtils.getPeriodMapping((IModelCacheHelper)modelCache);
        Map period2ParentMapping = DataLockUtils.getPeriod2ParentMapping((IModelCacheHelper)modelCache);
        ArrayList<PeriodEnable> changePeriods = new ArrayList<PeriodEnable>(16);
        changePeriods.add(new PeriodEnable(propKey, newVal));
        if (periodMapping.containsKey(propKey)) {
            this.fillPeriodChildrenBox(propKey, newVal, currRow, periodMapping, changePeriods);
        }
        if (period2ParentMapping.containsKey(propKey)) {
            this.fillPeriodParentBox(propKey, newVal, currRow, periodMapping, period2ParentMapping, changePeriods);
        }
        this.fillEntityChildrenBox(this.getModel().getEntryRowCount(entityKey), this.getModel(), entityKey, rowIndex, changePeriods, periodMapping, period2ParentMapping);
        ArrayList<PeriodEnable> copyChangePeriods = new ArrayList<PeriodEnable>(16);
        for (PeriodEnable changePeriod : changePeriods) {
            copyChangePeriods.add(new PeriodEnable(changePeriod.getPeriodNumber(), changePeriod.isEnable()));
        }
        this.fillEntityParentBox(this.getModel().getEntryRowCount(entityKey), this.getModel(), entityKey, rowIndex, copyChangePeriods);
        EntityTree rootNode = (EntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
        EntityTree currentNode = (EntityTree)LazyTreeUtils.getChildNodeByNodeId((Long)currRow.getLong("id"), (ITreeNode)rootNode);
        List periods = DataLockUtils.getPeriods((IModelCacheHelper)modelCache, (boolean)true);
        currentNode.setPeriodEnables(DataLockUtils.getPeriodEnables((DynamicObject)currRow, (List)periods));
        Map<String, Boolean> collect = changePeriods.stream().collect(Collectors.toMap(PeriodEnable::getPeriodNumber, PeriodEnable::isEnable));
        this.fillChindren(currentNode, collect);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            Map<String, DynamicObject> memberEntryMap = entryEntity.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o, (n1, n2) -> n2));
            this.fillParent(currentNode, collect, periods, memberEntryMap);
            this.fillSameLevelLeaf(currentNode, periods, memberEntryMap);
        }
        this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)rootNode));
        this.dataChange(true);
        this.getView().updateView(entityKey);
    }

    private void fillSameLevelLeaf(EntityTree currentNode, List<String> periods, Map<String, DynamicObject> memberEntryMap) {
        if (currentNode == null || !currentNode.isLeaf() || CollectionUtils.isEmpty(periods) || memberEntryMap == null) {
            return;
        }
        EntityTree parent = currentNode.getParent();
        if (parent == null) {
            return;
        }
        List children = parent.getChildren();
        for (ITreeNode child : children) {
            EntityTree _child = (EntityTree)child;
            if (currentNode.getId().equals(_child.getId()) || _child.getPeriodEnables() != null) continue;
            DynamicObject dynamicObject = memberEntryMap.get(_child.getNumber());
            _child.setPeriodEnables(DataLockUtils.getPeriodEnables((DynamicObject)dynamicObject, periods));
        }
    }

    private void fillParent(EntityTree currentNode, Map<String, Boolean> changePeriods, List<String> periods, Map<String, DynamicObject> memberEntryMap) {
        if (currentNode == null || changePeriods == null || CollectionUtils.isEmpty(periods) || memberEntryMap == null) {
            return;
        }
        EntityTree parentNode = currentNode.getParent();
        if (parentNode != null) {
            DynamicObject parent = memberEntryMap.get(parentNode.getNumber());
            if (parent == null) {
                return;
            }
            List periodEnables = parentNode.getPeriodEnables();
            if (periodEnables != null) {
                for (PeriodEnable periodEnable : periodEnables) {
                    if (!changePeriods.containsKey(periodEnable.getPeriodNumber())) continue;
                    periodEnable.setEnable(parent.getBoolean(periodEnable.getPeriodNumber()));
                }
                parentNode.setPeriodEnables(periodEnables);
            } else {
                parentNode.setPeriodEnables(DataLockUtils.getPeriodEnables((DynamicObject)parent, periods));
            }
            this.fillParent(parentNode, changePeriods, periods, memberEntryMap);
        }
    }

    private void fillChindren(EntityTree currentNode, Map<String, Boolean> changePeriods) {
        List currentNodePeriodEnables = currentNode.getPeriodEnables();
        List children = currentNode.getChildren();
        if (children != null) {
            for (ITreeNode child : children) {
                EntityTree _child = (EntityTree)child;
                ArrayList<PeriodEnable> periodEnables = _child.getPeriodEnables();
                if (periodEnables != null) {
                    for (PeriodEnable periodEnable : periodEnables) {
                        if (!changePeriods.containsKey(periodEnable.getPeriodNumber())) continue;
                        periodEnable.setEnable(changePeriods.get(periodEnable.getPeriodNumber()).booleanValue());
                    }
                } else {
                    periodEnables = new ArrayList<PeriodEnable>(16);
                    for (PeriodEnable currentNodePeriodEnable : currentNodePeriodEnables) {
                        String curPeriodNumber = currentNodePeriodEnable.getPeriodNumber();
                        PeriodEnable newPeriodEnable = new PeriodEnable(curPeriodNumber, false);
                        if (changePeriods.containsKey(curPeriodNumber)) {
                            newPeriodEnable.setEnable(changePeriods.get(curPeriodNumber).booleanValue());
                        }
                        periodEnables.add(newPeriodEnable);
                    }
                }
                _child.setPeriodEnables(periodEnables);
                this.fillChindren(_child, changePeriods);
            }
        }
    }

    private void fillEntityParentBox(int allCount, IDataModel dataModel, String entryKey, int rowIndex, List<PeriodEnable> changePeriods) {
        Long perentId = dataModel.getEntryRowEntity(entryKey, rowIndex).getLong("pid");
        if (perentId == 0L) {
            return;
        }
        Long perentparentId = 0L;
        int index = rowIndex - 1;
        while (index >= 0 && index < allCount) {
            DynamicObject currRow = dataModel.getEntryRowEntity(entryKey, index);
            if (perentId.equals(currRow.get("pid"))) {
                Iterator<PeriodEnable> iterator = changePeriods.iterator();
                while (iterator.hasNext()) {
                    PeriodEnable changePeriod = iterator.next();
                    boolean startEnable = changePeriod.isEnable();
                    if (!startEnable || currRow.getBoolean(changePeriod.getPeriodNumber())) continue;
                    iterator.remove();
                }
            } else if (index < rowIndex) {
                if (perentId.equals(currRow.get("id")) || index <= 0) {
                    index = rowIndex + 1;
                    perentparentId = currRow.getLong("pid");
                    continue;
                }
            } else if (perentparentId.equals(currRow.get("pid"))) break;
            if (index < rowIndex) {
                --index;
                continue;
            }
            ++index;
        }
        if (CollectionUtils.isNotEmpty(changePeriods)) {
            for (int i = rowIndex - 1; i >= 0; --i) {
                DynamicObject parentRow = dataModel.getEntryRowEntity(entryKey, i);
                if (!parentRow.get("id").equals(perentId)) continue;
                for (PeriodEnable changePeriod : changePeriods) {
                    parentRow.set(changePeriod.getPeriodNumber(), (Object)changePeriod.isEnable());
                }
                this.fillEntityParentBox(allCount, dataModel, entryKey, i, changePeriods);
                break;
            }
        }
    }

    public int fillEntityChildrenBox(int allCount, IDataModel dataModel, String entryKey, int rowIndex, List<PeriodEnable> changePeriods, Map<String, Set<String>> periodMapping, Map<String, String> period2ParentMapping) {
        int endIndex = rowIndex;
        Long perentId = dataModel.getEntryRowEntity(entryKey, rowIndex).getLong("id");
        for (int i = rowIndex + 1; i < allCount; ++i) {
            DynamicObject childRow = dataModel.getEntryRowEntity(entryKey, i);
            if (childRow.get("pid").equals(perentId)) {
                for (PeriodEnable changePeriod : changePeriods) {
                    childRow.set(changePeriod.getPeriodNumber(), (Object)changePeriod.isEnable());
                    if (!changePeriod.isEnable()) continue;
                    String periodNumber = changePeriod.getPeriodNumber();
                    this.fillPeriodParentWhileEntityParentChange(periodMapping, period2ParentMapping, childRow, periodNumber);
                }
                if (!childRow.getBoolean("isGroupNode")) continue;
                i = this.fillEntityChildrenBox(allCount, dataModel, entryKey, i, changePeriods, periodMapping, period2ParentMapping);
                continue;
            }
            endIndex = i - 1;
            break;
        }
        return endIndex;
    }

    private void fillPeriodParentWhileEntityParentChange(Map<String, Set<String>> periodMapping, Map<String, String> period2ParentMapping, DynamicObject childRow, String periodNumber) {
        String parentPeriodNumber = period2ParentMapping.get(periodNumber);
        if (parentPeriodNumber == null) {
            return;
        }
        Set<String> childPeriodNumbers = periodMapping.get(parentPeriodNumber);
        boolean allTrue = true;
        for (String childPeriodNumber : childPeriodNumbers) {
            allTrue = allTrue && childRow.getBoolean(childPeriodNumber);
        }
        if (allTrue) {
            childRow.set(parentPeriodNumber, (Object)Boolean.TRUE);
            this.fillPeriodParentWhileEntityParentChange(periodMapping, period2ParentMapping, childRow, parentPeriodNumber);
        }
    }

    private void fillPeriodParentBox(String propKey, boolean newVal, DynamicObject currRow, Map<String, Set<String>> periodMapping, Map<String, String> period2ParentMapping, List<PeriodEnable> changePeriods) {
        String parentNumber = period2ParentMapping.get(propKey);
        if (StringUtils.isEmpty((String)parentNumber)) {
            return;
        }
        if (newVal) {
            Set<String> children = periodMapping.get(parentNumber);
            boolean parentStatus = true;
            for (String child : children) {
                parentStatus = parentStatus && currRow.getBoolean(child);
            }
            if (parentStatus) {
                currRow.set(parentNumber, (Object)newVal);
                changePeriods.add(new PeriodEnable(parentNumber, newVal));
                this.fillPeriodParentBox(parentNumber, newVal, currRow, periodMapping, period2ParentMapping, changePeriods);
            }
        } else {
            currRow.set(parentNumber, (Object)newVal);
            changePeriods.add(new PeriodEnable(parentNumber, newVal));
            this.fillPeriodParentBox(parentNumber, newVal, currRow, periodMapping, period2ParentMapping, changePeriods);
        }
    }

    private void fillPeriodChildrenBox(String propKey, boolean newVal, DynamicObject currRow, Map<String, Set<String>> periodMapping, List<PeriodEnable> changePeriods) {
        Set<String> children = periodMapping.get(propKey);
        if (children == null) {
            return;
        }
        for (String child : children) {
            changePeriods.add(new PeriodEnable(child, newVal));
            currRow.set(child, (Object)newVal);
            this.fillPeriodChildrenBox(child, newVal, currRow, periodMapping, changePeriods);
        }
    }

    public void propertyChangedTitle(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (!("model".equals(name) || "year".equals(name) || "currency".equals(name) || "version".equals(name))) {
            return;
        }
        WholeUserSelect wholeUserSelect = new WholeUserSelect();
        switch (name) {
            case "model": {
                if (!this.propertyChangeModel()) break;
                return;
            }
            case "year": 
            case "currency": 
            case "version": {
                this.fillUserSelect(wholeUserSelect, name);
                break;
            }
        }
        String modelId = String.valueOf(this.getModelId());
        this.initPageWhileModelChange(modelId);
    }

    private void fillUserSelect(WholeUserSelect wholeUserSelect, String key) {
        String selectId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)key);
        if (selectId == null) {
            wholeUserSelect = UserSelectUtils.getWholeUserSelect((IFormView)this.getView());
            this.dataChange = true;
            if (wholeUserSelect != null && IDUtils.isNotEmptyLong((Long)wholeUserSelect.getByPropertyName(key)).booleanValue()) {
                this.getModel().setValue(key, (Object)wholeUserSelect.getByPropertyName(key));
            }
        } else {
            wholeUserSelect.putByPropertyName("year", Convert.toLong((Object)UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"year")));
            wholeUserSelect.putByPropertyName("currency", Convert.toLong((Object)UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"currency")));
            wholeUserSelect.putByPropertyName("version", Convert.toLong((Object)UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"version")));
            this.saveUserSelect(wholeUserSelect);
        }
    }

    private boolean propertyChangeModel() {
        String modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
        this.dataChange = true;
        if (modelId == null) {
            this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            return true;
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)Long.parseLong(modelId));
        this.clearOtherField();
        return false;
    }

    private void clearOtherField() {
        this.getModel().beginInit();
        this.getModel().setValue("year", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("version", null);
        this.getModel().endInit();
    }

    public void saveUserSelect(WholeUserSelect wholeUserselect) {
        String modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
        if (StringUtils.isNotEmpty((String)modelId)) {
            wholeUserselect.setModel(Long.valueOf(modelId));
            UserSelectUtils.saveWholeUserSelect((IFormView)this.getView(), (WholeUserSelect)wholeUserselect);
        }
    }

    @Override
    public Long getModelId() {
        String f7SelectId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
        if (f7SelectId == null) {
            return 0L;
        }
        return Long.valueOf(f7SelectId);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        EntityTree treeRoot = (EntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        DataLockKey dataLockKey = this.fillPageWhileModelChange(modelId);
        if (dataLockKey != null) {
            Map dataLockData = DataLockService.getInstance().getDataLockData(Long.valueOf(modelId), dataLockKey);
            String entryKey = ((TreeEntryGrid)treeNodeEvent.getSource()).getEntryKey();
            int rowIndex = treeNodeEvent.getRowKey();
            DynamicObject row = this.getModel().getEntryRowEntity(entryKey, rowIndex);
            long nodeId = row.getLong("id");
            ITreeNode parentNode = LazyTreeUtils.getChildNodeByNodeId((Long)nodeId, (ITreeNode)treeRoot);
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DataLockLazyTreeHandler(), (ITreeNode)treeRoot).queryPageTreeNodeChildren(parentNode, rowIndex, dataLockData, modelId, new QFilter("parent", "=", (Object)parentNode.getId()), Boolean.valueOf(false));
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(entryKey);
            entryGrid.selectRows(rowIndex, false);
            this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)treeRoot));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DataLockKey dataLockKey = this.getDataLockKey();
        if (dataLockKey == null) {
            return;
        }
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String propKey = hyperLinkClickEvent.getFieldName();
        String entryKey = ((EntryGrid)hyperLinkClickEvent.getSource()).getEntryKey();
        DynamicObject clickRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        this.getModel().setValue(propKey, (Object)(!clickRow.getBoolean(propKey) ? 1 : 0));
        this.dataChange(true);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbDataPermPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        }
        LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
        leftTreeF7Parameter.setMultiple(false);
        leftTreeF7Parameter.setOnlyLeaf(true);
        this.switchLeftTreeF7(beforeF7SelectEvent, 0L, leftTreeF7Parameter);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        if (this.isDataChanged() && this.isFirst()) {
            this.getPageCache().put("isfirst", "true");
            beforeF7SelectEvent.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u6539\u53d8\uff0c\u786e\u8ba4\u4fdd\u5b58\u6570\u636e\uff1f", (String)"DynamicReportProcess_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("savedata"));
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        switch (controlKey) {
            case "currency": {
                return "Currency";
            }
            case "year": {
                return "Year";
            }
            case "version": {
                return "Version";
            }
        }
        return "";
    }

    private boolean isFirst() {
        String isfirst = this.getPageCache().get("isfirst");
        return StringUtils.isEmpty((String)isfirst);
    }

    private boolean isDataChanged() {
        String datachanged = this.getPageCache().get("datachanged");
        return !StringUtils.isEmpty((String)datachanged);
    }

    private void dataChange(boolean dataChange) {
        if (dataChange) {
            this.getPageCache().put("datachanged", "true");
        } else {
            this.getPageCache().remove("datachanged");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u6539\uff0c\u786e\u8ba4\u4fdd\u5b58\u5e76\u9000\u51fa\uff1f", (String)"ControlRuleGroupAddPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isClose"));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("savedata".equals(key)) {
            if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                int is = this.checkItemPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), "eb_datalocklist", "0=KX5+QVF5+R");
                if (is == 0 && !MemberPermHelper.ifUserHasRootPermByModel((Long)this.getUserId(), (Long)this.getModelId())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u9501\u5b9a\u7684\u4fdd\u5b58\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.saveData();
            }
            this.dataChange(false);
            this.getPageCache().remove("isfirst");
        } else if ("isClose".equals(key) && messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            int is = this.checkItemPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), "eb_datalocklist", "0=KX5+QVF5+R");
            if (is == 0 && !MemberPermHelper.ifUserHasRootPermByModel((Long)this.getUserId(), (Long)this.getModelId())) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u9501\u5b9a\u7684\u4fdd\u5b58\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            this.saveData();
            this.dataChange(false);
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", evt.getRow());
        String number = row.getString("number");
        if ("...loadMore...".equals(number)) {
            QFilter qFilter;
            EntityTree treeRoot = (EntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
            String modelId = this.getPageCache().get("KEY_MODEL_ID");
            DataLockKey dataLockKey = this.fillPageWhileModelChange(modelId);
            Map dataLockData = DataLockService.getInstance().getDataLockData(Long.valueOf(modelId), dataLockKey);
            int rowIndex = evt.getRow();
            long nodeId = row.getLong("id");
            ITreeNode currentNode = LazyTreeUtils.getChildNodeByNodeId((Long)nodeId, (ITreeNode)treeRoot);
            ITreeNode parentNode = LazyTreeUtils.getChildNodeByNodeId((Long)currentNode.getParentId(), (ITreeNode)treeRoot);
            parentNode.getChildren().remove(currentNode);
            this.getModel().deleteEntryRow("entryentity", rowIndex);
            String searchText = this.getPageCache().get(SEARCH_TEXT_CACHE);
            boolean isSearch = false;
            if (StringUtils.isEmpty((String)searchText)) {
                qFilter = new QFilter("parent", "=", (Object)parentNode.getId());
            } else {
                qFilter = new QFilter("level", "!=", (Object)1).and(new QFilter("number", "like", (Object)("%" + searchText + "%")).or("name", "like", (Object)("%" + searchText + "%")));
                isSearch = true;
            }
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DataLockLazyTreeHandler(), (ITreeNode)treeRoot).queryPageTreeNodeChildren(parentNode, rowIndex, dataLockData, modelId, qFilter, Boolean.valueOf(isSearch));
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl("entryentity");
            entryGrid.selectRows(rowIndex - 1, false);
            if (isSearch) {
                List matchedNodes = LazyTreeUtils.searchMember((ITreeNode)treeRoot, (String)searchText, (Matchable)new DataLockLazyTreeHandler());
                SearchInfo searchInfo = new SearchInfo(0, matchedNodes);
                this.getView().getPageCache().put("searchInfo", SerializationUtils.serializeToBase64((Object)searchInfo));
            }
            this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)treeRoot));
        }
    }
}

