/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class DataLockLogListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        if (modelid == null) {
            return;
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumns.stream().filter(c -> c.getFieldName().equals("model.name")).findFirst().get();
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>(16);
        Set permIds = ModelUtil.getModelIdsWithPerm((String)"eb_datalocklist", (ApplicationTypeEnum)ApplicationTypeEnum.EB);
        modelQFilters.add(new QFilter("id", "in", (Object)permIds));
        modelQFilters.add(new QFilter("reporttype", "=", (Object)"4"));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), (String)"modifytime desc");
        filterColumn.getComboItems().clear();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (DynamicObject e : col) {
            String modelId = e.getString("id");
            comboItems.add(new ComboItem(new LocaleString(e.getString("name")), modelId));
        }
        filterColumn.setComboItems(comboItems);
        filterColumn.setDefaultValue(modelid);
    }

    public void afterCreateNewData(EventObject e) {
        Object formCustomParam = this.getFormCustomParam("model");
        String model = null;
        if (formCustomParam != null) {
            model = formCustomParam.toString();
        }
        if (StringUtils.isEmpty(model)) {
            model = String.valueOf(UserSelectUtils.getUserSelectModelId((IFormView)this.getView()));
        }
        if (StringUtils.isNotEmpty((String)model)) {
            this.getPageCache().put("KEY_MODEL_ID", model);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("model.id".equals(args.getFieldName())) {
            args.setCustomQFilters(ModelUtil.getModelFilter((IFormView)this.getView()));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List qFilters = args.getFilterParameter().getQFilters();
        this.getPageCache().put("KEY_MODEL_ID", null);
        if (qFilters != null) {
            for (QFilter e : qFilters) {
                if (!e.getProperty().equals("model.id")) continue;
                if (!e.getValue().equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    this.getPageCache().put("KEY_MODEL_ID", e.getValue().toString());
                }
                return;
            }
            SearchClickEvent searchClickEvent = args.getSearchClickEvent();
            if (searchClickEvent.getSelectMainOrgIds() != null && searchClickEvent.getSelectMainOrgIds().size() > 0) {
                Long modelId = (Long)searchClickEvent.getSelectMainOrgIds().get(0);
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
            }
        }
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)strModelId)) {
            return Long.valueOf(strModelId);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"CurrencyConvertUpdateListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

