/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmdDataLock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.dataperm.EbMembPerm;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.bgmddatalock.DataLockPageUserSelect;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeContainer;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.common.lazytree.bgmdDatalock.BgmdDataLockLazyTreeHandler;
import kd.epm.eb.common.lazytree.bgmdDatalock.BgmdEntityTree;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBaseListPlugin;
import kd.epm.eb.formplugin.CommonMethod;
import kd.epm.eb.model.utils.ModelUtil;

public class BgmdDataLockListPlugin
extends AbstractBaseListPlugin
implements CommonMethod,
EbMembPerm,
BeforeF7SelectListener,
TreeNodeQueryListener,
HyperLinkClickListener {
    private static final String MODEL = "model";
    private static final String BUSINESSMODEL = "businessmodel";
    private static final String PERIOD = "period";
    private static final String VERSION = "version";
    private static final String DATATYPE = "datatype";
    private static final String AUDITTRAIL = "audittrail";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DIMENSIONVIEW = "dimensionview";
    private boolean dataChanged = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerBeforeF7SelectListener(MODEL, BUSINESSMODEL, PERIOD, VERSION, DATATYPE, AUDITTRAIL, DIMENSIONVIEW);
        Search search = (Search)this.getControl("searchap");
        if (search != null) {
            search.addEnterListener(event -> {
                BgmdEntityTree treeRoot = (BgmdEntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
                new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new BgmdDataLockLazyTreeHandler(), (ITreeNode)treeRoot).search(event);
            });
        }
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
        TreeEntryGrid entry = (TreeEntryGrid)this.getControl(ENTRYENTITY);
        entry.addCellClickListener((TreeNodeQueryListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbar_main"});
    }

    private void registerBeforeF7SelectListener(String ... f7keys) {
        for (String f7key : f7keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(f7key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            this.getModel().setValue(MODEL, (Object)modelId);
            long businessModelId = UserSelectUtils.getUserSelectBusinessModelId((IFormView)this.getView(), (long)modelId);
            if (IDUtils.isNotEmptyLong((Long)businessModelId).booleanValue()) {
                this.getModel().setValue(BUSINESSMODEL, (Object)businessModelId);
            }
            this.initPageSelectAndEntryEntity(modelId, businessModelId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbDataPermPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.saveData();
                break;
            }
            case "btn_showlog": {
                this.showLogPage();
                break;
            }
            case "bar_addapprover": {
                break;
            }
            case "bar_showapply": {
                break;
            }
            case "bar_refresh": {
                this.refresh();
                break;
            }
        }
    }

    private void saveData() {
        long modelId = this.getModelId();
        long businessModelId = this.getBusinessModelId();
        DataLockPageUserSelect dataLockPageUserSelect = this.getDataLockPageUserSelect();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataLockListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (IDUtils.isEmptyLong((Long)businessModelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DataLockListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkDataLockPageUserSelect(dataLockPageUserSelect)) {
            this.shoWdataLockPageUserSelectTips(dataLockPageUserSelect);
            return;
        }
        if (!this.isDataChanged()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u6570\u636e\u65e0\u53d8\u5316\u3002", (String)"DataLockListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BgmdEntityTree treeRoot = (BgmdEntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
        String usage = ((DynamicObject)this.getModel().getValue(DIMENSIONVIEW)).getString("usage");
        BgmdDataLockService.getInstance().saveDataLock(modelId, businessModelId, dataLockPageUserSelect, treeRoot, usage);
        this.dataChange(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MetricMemberEdit_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key)) {
            BgmdEntityTree treeRoot = (BgmdEntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new BgmdDataLockLazyTreeHandler(), (ITreeNode)treeRoot).searchBefore();
        } else if ("searchnext".equals(key)) {
            BgmdEntityTree treeRoot = (BgmdEntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new BgmdDataLockLazyTreeHandler(), (ITreeNode)treeRoot).searchNext();
        }
    }

    private void showLogPage() {
    }

    private void refresh() {
        DataLockPageUserSelect dataLockPageUserSelect = this.getDataLockPageUserSelect();
        if (!this.checkDataLockPageUserSelect(dataLockPageUserSelect)) {
            return;
        }
        if (this.isDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u518d\u6267\u884c\u5237\u65b0\u3002", (String)"BgTaskExecutePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.initEntryEntity((long)this.getModelId(), this.getBusinessModelId(), this.getDataLockPageUserSelect());
        }
    }

    private void initPageSelectAndEntryEntity(long modelId, long businessModelId) {
        DataLockPageUserSelect dataLockPageUserSelect = (DataLockPageUserSelect)UserSelectUtils.getWholeUserSelectByBusinessModelId((IFormView)this.getView(), (Long)businessModelId, DataLockPageUserSelect.class);
        HashSet<String> strings = new HashSet<String>(16);
        strings.add(PERIOD);
        strings.add(VERSION);
        strings.add(DATATYPE);
        strings.add(AUDITTRAIL);
        strings.add(DIMENSIONVIEW);
        this.getModel().beginInit();
        if (dataLockPageUserSelect != null) {
            if (IDUtils.isNotEmptyLong((Long)dataLockPageUserSelect.getPeriod()).booleanValue()) {
                this.getModel().setValue(PERIOD, (Object)dataLockPageUserSelect.getPeriod());
                strings.remove(PERIOD);
            }
            if (IDUtils.isNotEmptyLong((Long)dataLockPageUserSelect.getVersion()).booleanValue()) {
                this.getModel().setValue(VERSION, (Object)dataLockPageUserSelect.getVersion());
                strings.remove(VERSION);
            }
            if (IDUtils.isNotEmptyLong((Long)dataLockPageUserSelect.getDataType()).booleanValue()) {
                this.getModel().setValue(DATATYPE, (Object)dataLockPageUserSelect.getDataType());
                strings.remove(DATATYPE);
            }
            if (IDUtils.isNotEmptyLong((Long)dataLockPageUserSelect.getAuditTrail()).booleanValue()) {
                this.getModel().setValue(AUDITTRAIL, (Object)dataLockPageUserSelect.getAuditTrail());
                strings.remove(AUDITTRAIL);
            }
            if (IDUtils.isNotEmptyLong((Long)dataLockPageUserSelect.getViewId()).booleanValue()) {
                this.getModel().setValue(DIMENSIONVIEW, (Object)dataLockPageUserSelect.getViewId());
                strings.remove(DIMENSIONVIEW);
            }
        }
        for (String string : strings) {
            this.getModel().setValue(string, null);
        }
        this.getModel().endInit();
        this.getView().updateView();
        this.initEntryEntity(modelId, businessModelId, dataLockPageUserSelect);
    }

    private void initEntryEntity(long modelId, long businessModelId, DataLockPageUserSelect dataLockPageUserSelect) {
        Map dataLockData = null;
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue() && IDUtils.isNotEmptyLong((Long)businessModelId).booleanValue() && this.checkDataLockPageUserSelect(dataLockPageUserSelect)) {
            dataLockData = BgmdDataLockService.getInstance().getDataLockData(modelId, businessModelId, dataLockPageUserSelect);
        }
        this.initEntryEntity(modelId, businessModelId, dataLockData);
    }

    private void initEntryEntity(long modelId, long businessModelId, Map<String, Integer> dataLockData) {
        DataLockPageUserSelect dataLockPageUserSelect = this.getDataLockPageUserSelect();
        long viewId = dataLockPageUserSelect.getViewId();
        BgmdEntityTree treeRoot = BgmdDataLockUtils.buildTree((Long)modelId, (long)businessModelId, dataLockData, (Long)viewId);
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new BgmdDataLockLazyTreeHandler(), (ITreeNode)treeRoot).initTree();
        this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)treeRoot));
    }

    private boolean checkDataLockPageUserSelect(DataLockPageUserSelect dataLockPageUserSelect) {
        return dataLockPageUserSelect != null && IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getPeriod()) == false && IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getVersion()) == false && IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getDataType()) == false && IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getAuditTrail()) == false && IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getViewId()) == false;
    }

    private void shoWdataLockPageUserSelectTips(DataLockPageUserSelect dataLockPageUserSelect) {
        if (IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getViewId()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c6\u56fe\u3002", (String)"DataLockListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getPeriod()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"DataLockListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getVersion()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7248\u672c\u3002", (String)"DataLockListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getDataType()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b\u3002", (String)"DataLockListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (IDUtils.isEmptyLong((Long)dataLockPageUserSelect.getAuditTrail()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ebf\u7d22\u3002", (String)"DataLockListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            if (this.isDataChanged() && this.isFirst()) {
                this.getPageCache().put("isfirst", "true");
                e.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u6539\u53d8\uff0c\u786e\u8ba4\u4fdd\u5b58\u6570\u636e\uff1f", (String)"DynamicReportProcess_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("savedata"));
            }
            this.setFilter(e, MODEL);
            return;
        }
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbShareDimensionDataListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isDataChanged() && this.isFirst()) {
            this.getPageCache().put("isfirst", "true");
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u6539\u53d8\uff0c\u786e\u8ba4\u4fdd\u5b58\u6570\u636e\uff1f", (String)"DynamicReportProcess_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("savedata"));
        }
        switch (key) {
            case "businessmodel": 
            case "period": 
            case "version": 
            case "datatype": 
            case "audittrail": 
            case "dimensionview": {
                this.setFilter(e, key);
                break;
            }
        }
    }

    private void setFilter(BeforeF7SelectEvent e, String key) {
        if (this.getControl(key) != null) {
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumberIgnoreCase((String)key);
            if (PERIOD.equals(key)) {
                dimensionEnum = SysDimensionEnum.BudgetPeriod;
            }
            if (dimensionEnum != null) {
                Long modelId = this.getModelId();
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimensionEnum.getNumber()), (String)ListSelectedRow.class.getName());
                if (dimensionEnum == SysDimensionEnum.BudgetPeriod) {
                    f7Param.addCustomCommFilter(new QFilter("level", "<=", (Object)2));
                    f7Param.setCanSelectRoot(false);
                } else {
                    f7Param.addCustomFilter(this.getFilterByKey(key));
                }
                f7Param.setCutTree(false);
                NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
            } else {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.addAll(this.getFilterByKey(key));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        }
    }

    private List<QFilter> getFilterByKey(String key) {
        switch (key) {
            case "model": {
                return ModelUtil.getModelFilter((IFormView)this.getView());
            }
            case "businessmodel": {
                return Collections.singletonList(new QFilter(MODEL, "=", (Object)this.getModelId()));
            }
            case "dimensionview": {
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Map viewsByBusModelIncludeBase = modelCache.getViewsByBusModelIncludeBase(Long.valueOf(this.getBusinessModelId()));
                Long viewId = (Long)viewsByBusModelIncludeBase.get(SysDimensionEnum.Entity.getNumber());
                return Collections.singletonList(new QFilter(MODEL, "=", (Object)this.getModelId()).and(new QFilter("id", "=", (Object)viewId).or("parent", "=", (Object)viewId)));
            }
            case "period": {
                return Collections.singletonList(new QFilter(MODEL, "=", (Object)this.getModelId()).and("level", "=", (Object)2));
            }
            case "version": 
            case "datatype": 
            case "audittrail": {
                return Collections.singletonList(new QFilter(MODEL, "=", (Object)this.getModelId()).and("isleaf", "=", (Object)true));
            }
        }
        return Collections.emptyList();
    }

    private boolean isFirst() {
        String isfirst = this.getPageCache().get("isfirst");
        return StringUtils.isEmpty((String)isfirst);
    }

    private boolean isDataChanged() {
        String datachanged = this.getPageCache().get("datachanged");
        return !StringUtils.isEmpty((String)datachanged);
    }

    private void dataChange(boolean dataChange) {
        if (dataChange) {
            this.getPageCache().put("datachanged", "true");
        } else {
            this.getPageCache().remove("datachanged");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u6539\uff0c\u786e\u8ba4\u4fdd\u5b58\u5e76\u9000\u51fa\uff1f", (String)"ControlRuleGroupAddPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isClose"));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("savedata".equals(key)) {
            if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                this.saveData();
                this.dataChange(false);
                this.getPageCache().remove("isfirst");
            } else if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Cancel.getValue()) {
                this.dataChange(false);
                this.getPageCache().remove("isfirst");
                this.registerListener(new EventObject(this.getView()));
                this.refresh();
            }
        } else if ("isClose".equals(key) && messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.dataChange(false);
            this.getView().close();
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        switch (controlKey) {
            case "period": {
                return SysDimensionEnum.BudgetPeriod.getNumber();
            }
            case "version": {
                return SysDimensionEnum.Version.getNumber();
            }
            case "datatype": {
                return SysDimensionEnum.DataType.getNumber();
            }
            case "audittrail": {
                return SysDimensionEnum.AuditTrail.getNumber();
            }
        }
        return "";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.dataChanged) {
            return;
        }
        String name = e.getProperty().getName();
        if (MODEL.equals(name) || BUSINESSMODEL.equals(name) || PERIOD.equals(name) || VERSION.equals(name) || DATATYPE.equals(name) || AUDITTRAIL.equals(name) || DIMENSIONVIEW.equals(name)) {
            this.propertyChangedTitie(e);
        } else {
            this.propertyChangePeriod(e);
        }
    }

    private void propertyChangePeriod(PropertyChangedArgs e) {
        Object object = this.getModel().getValue(DIMENSIONVIEW);
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c6\u56fe\u3002", (String)"DataLockListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String usage = ((DynamicObject)object).getString("usage");
        String propKey = e.getProperty().getName();
        boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.getEntryEntity(ENTRYENTITY);
        DynamicObject currRow = model.getEntryRowEntity(ENTRYENTITY, rowIndex);
        BgmdEntityTree rootNode = (BgmdEntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
        BgmdEntityTree currentNode = (BgmdEntityTree)LazyTreeUtils.getChildNodeByNodeId((Long)currRow.getLong("id"), (ITreeNode)rootNode);
        BgmdDataLockUtils.changeNodePeriodStatus((BgmdEntityTree)currentNode, (String)propKey, (boolean)newVal, (String)usage);
        BgmdDataLockLazyTreeHandler handler = new BgmdDataLockLazyTreeHandler();
        handler.doFillEntryRow(currRow, (ITreeNode)currentNode);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(handler.getEntryKey());
        this.fillEntityChildrenBox(model.getEntryRowCount(ENTRYENTITY), model, ENTRYENTITY, rowIndex, handler, currentNode);
        this.fillEntityParentBox(model, ENTRYENTITY, rowIndex, handler, currentNode);
        this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)rootNode));
        this.getView().updateView(ENTRYENTITY);
        entryGrid.selectRows(rowIndex);
    }

    private void fillEntityParentBox(IDataModel dataModel, String entryKey, int rowIndex, BgmdDataLockLazyTreeHandler handler, BgmdEntityTree currentNode) {
        Long perentId = dataModel.getEntryRowEntity(entryKey, rowIndex).getLong("pid");
        if (currentNode == null || currentNode.getParent() == null || perentId == 0L) {
            return;
        }
        for (int i = rowIndex - 1; i >= 0; --i) {
            DynamicObject parentRow = dataModel.getEntryRowEntity(entryKey, i);
            if (!parentRow.get("id").equals(perentId)) continue;
            BgmdEntityTree parent = currentNode.getParent();
            handler.doFillEntryRow(parentRow, (ITreeNode)parent);
            this.fillEntityParentBox(dataModel, entryKey, i, handler, parent);
            break;
        }
    }

    private int fillEntityChildrenBox(int allCount, IDataModel dataModel, String entryKey, int rowIndex, BgmdDataLockLazyTreeHandler handler, BgmdEntityTree currentNode) {
        int endIndex = rowIndex;
        Long perentId = dataModel.getEntryRowEntity(entryKey, rowIndex).getLong("id");
        for (int i = rowIndex + 1; i < allCount; ++i) {
            DynamicObject childRow = dataModel.getEntryRowEntity(entryKey, i);
            if (childRow.get("pid").equals(perentId)) {
                for (BgmdEntityTree child : currentNode.getChildren()) {
                    if (!child.getId().equals(childRow.getLong("id"))) continue;
                    handler.doFillEntryRow(childRow, (ITreeNode)child);
                    if (!childRow.getBoolean("isGroupNode")) continue;
                    i = this.fillEntityChildrenBox(allCount, dataModel, entryKey, i, handler, child);
                }
                continue;
            }
            endIndex = i - 1;
            break;
        }
        return endIndex;
    }

    private void propertyChangedTitie(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Long modelId = this.getModelId();
        long businessModelId = this.getBusinessModelId();
        switch (name) {
            case "model": {
                this.dataChanged = true;
                if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
                    this.getModel().setValue(MODEL, e.getChangeSet()[0].getOldValue());
                    return;
                }
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
                if (ModelUtil.isBGModel((Long)modelId)) {
                    DynamicObject val = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)modelId);
                    businessModelId = val.getLong("id");
                } else {
                    businessModelId = UserSelectUtils.getUserSelectBusinessModelId((IFormView)this.getView(), (long)modelId);
                }
                this.getModel().beginInit();
                if (IDUtils.isEmptyLong((Long)businessModelId).booleanValue()) {
                    this.getModel().setValue(BUSINESSMODEL, null);
                } else {
                    this.getModel().setValue(BUSINESSMODEL, (Object)businessModelId);
                }
                this.getModel().endInit();
                this.getView().updateView(BUSINESSMODEL);
                this.initPageSelectAndEntryEntity(modelId, businessModelId);
                break;
            }
            case "businessmodel": {
                if (IDUtils.isEmptyLong((Long)businessModelId).booleanValue()) {
                    this.dataChanged = true;
                    this.getModel().setValue(BUSINESSMODEL, e.getChangeSet()[0].getOldValue());
                    return;
                }
                UserSelectUtils.saveUserSelectBusinessModelId((IFormView)this.getView(), (long)modelId, (long)businessModelId);
                this.dataChanged = true;
                this.initPageSelectAndEntryEntity(modelId, businessModelId);
                break;
            }
            case "period": 
            case "version": 
            case "datatype": 
            case "audittrail": 
            case "dimensionview": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue == null) {
                    this.dataChanged = true;
                    this.getModel().setValue(name, e.getChangeSet()[0].getOldValue());
                    return;
                }
                DataLockPageUserSelect dataLockPageUserSelect = this.getDataLockPageUserSelect();
                UserSelectUtils.saveWholeUserSelectByBusinessModelId((IFormView)this.getView(), (Long)businessModelId, (Object)dataLockPageUserSelect);
                this.initEntryEntity((long)modelId, businessModelId, dataLockPageUserSelect);
                break;
            }
        }
    }

    private DataLockPageUserSelect getDataLockPageUserSelect() {
        return this.putInDataLockPageUserSelect(PERIOD, VERSION, DATATYPE, AUDITTRAIL, DIMENSIONVIEW);
    }

    private DataLockPageUserSelect putInDataLockPageUserSelect(String ... propertys) {
        DataLockPageUserSelect dataLockPageUserSelect = new DataLockPageUserSelect();
        for (String property : propertys) {
            Object object = this.getModel().getValue(property);
            if (object == null) continue;
            dataLockPageUserSelect.putByPropertyName(property, Long.valueOf(((DynamicObject)object).getLong("id")));
        }
        return dataLockPageUserSelect;
    }

    @Override
    public Long getModelId() {
        Object model = this.getModel().getValue(MODEL);
        if (model instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        return 0L;
    }

    public long getBusinessModelId() {
        Object businessmodel = this.getModel().getValue(BUSINESSMODEL);
        if (businessmodel instanceof DynamicObject) {
            return ((DynamicObject)businessmodel).getLong("id");
        }
        return 0L;
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        BgmdEntityTree treeRoot = (BgmdEntityTree)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new BgmdDataLockLazyTreeHandler(), (ITreeNode)treeRoot).queryTreeNodeChildren(treeNodeEvent);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DataLockPageUserSelect dataLockPageUserSelect = this.getDataLockPageUserSelect();
        if (!this.checkDataLockPageUserSelect(dataLockPageUserSelect)) {
            return;
        }
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String propKey = hyperLinkClickEvent.getFieldName();
        String entryKey = ((EntryGrid)hyperLinkClickEvent.getSource()).getEntryKey();
        DynamicObject clickRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        this.getModel().setValue(propKey, (Object)(!clickRow.getBoolean(propKey) ? 1 : 0));
        this.dataChange(true);
    }

    public String getBizCtrlRangeKey() {
        return BUSINESSMODEL;
    }
}

