/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.AbstractDataLockPlugin;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.CasePageCache;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCase;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockConstant;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockPageCache;
import kd.epm.eb.model.utils.ModelUtil;

public class CaseButtonControl
implements DataLockConstant,
DataLockPageCache,
ClickListener {
    public static final Log log = LogFactory.getLog(CaseButtonControl.class);
    private IFormView view;
    private AbstractDataLockPlugin plugin;
    private String formId;
    FlexPanelAp headPanelAp;
    List<CasePageCache> casePageCacheList;

    public CaseButtonControl(AbstractDataLockPlugin plugin, IFormView view) {
        this.plugin = plugin;
        this.view = view;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        try {
            Field formConfigField = e.getClass().getDeclaredField("formConfig");
            ReflectionUtils.makeAccessible((Field)formConfigField);
            Map formConfig = (Map)formConfigField.get(e);
            this.formId = (String)formConfig.get("formId");
        }
        catch (Exception formConfigField) {
            // empty catch block
        }
        FlexPanelAp headAp = this.createDynamicPanel();
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "myfieldcontainer");
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void modelUpdate(long modelId) {
        Map<String, Object> defaultStyle = this.getDefaultStyle();
        Map<String, Object> highLightStyle = this.getHighLightStyle();
        List<CasePageCache> lastCasePageCache = this.getCasePageCacheList();
        int btnSize = lastCasePageCache.size();
        this.casePageCacheList = this.buildCasePageCacheList(btnSize, modelId);
        this.view.getPageCache().put("casePageCacheList", JsonUtils.getJsonString(this.casePageCacheList));
        CasePageCache defaultCase = null;
        for (CasePageCache casePageCache : this.casePageCacheList) {
            this.plugin.getView().updateControlMetadata(casePageCache.getBtnKey(), defaultStyle);
            if (casePageCache.getId() == null) {
                this.view.setVisible(Boolean.valueOf(false), new String[]{casePageCache.getBtnKey()});
                continue;
            }
            this.view.setVisible(Boolean.valueOf(true), new String[]{casePageCache.getBtnKey()});
            if (casePageCache.isDefaul()) {
                defaultCase = casePageCache;
                this.plugin.getView().updateControlMetadata(casePageCache.getBtnKey(), highLightStyle);
            }
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
            map.put("text", new LocaleString(casePageCache.getName()));
            this.plugin.getView().updateControlMetadata(casePageCache.getBtnKey(), map);
        }
        if (defaultCase != null) {
            this.setCaseByCaseId(defaultCase.getId());
            this.view.getPageCache().put("currCaseKey", defaultCase.getBtnKey());
        } else {
            this.plugin.reset = true;
            IDataModel model = this.view.getModel();
            if (ModelUtil.isBGModel((Long)modelId)) {
                DynamicObject val = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)modelId);
                model.setValue("bizmodel", (Object)val);
            } else {
                model.setValue("bizmodel", null);
            }
            model.setValue("entityview", null);
            model.setValue("period", null);
            model.setValue("version", null);
            model.setValue("datatype", null);
            model.setValue("audittrail", null);
            model.setValue("casename", null);
            this.view.getPageCache().remove("currCaseKey");
        }
    }

    public CasePageCache initButton() {
        FlexPanelAp dynamicPanel = this.createDynamicPanel();
        Container myFldPanel = (Container)this.plugin.getView().getControl("myfieldcontainer");
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.plugin.getView().createControlIndex(myFldPanel.getItems());
        Map<String, Object> fieldMap = this.getDefaultStyle();
        Map<String, Object> highLightStyle = this.getHighLightStyle();
        List<CasePageCache> casePageCacheList = this.getCasePageCacheList();
        CasePageCache defaultCase = null;
        for (CasePageCache casePageCache : casePageCacheList) {
            this.plugin.getView().updateControlMetadata(casePageCache.getBtnKey(), fieldMap);
            if (casePageCache.getId() == null) {
                this.view.setVisible(Boolean.valueOf(false), new String[]{casePageCache.getBtnKey()});
                continue;
            }
            if (!casePageCache.isDefaul()) continue;
            defaultCase = casePageCache;
            this.plugin.getView().updateControlMetadata(casePageCache.getBtnKey(), highLightStyle);
        }
        return defaultCase;
    }

    private List<CasePageCache> buildCasePageCacheList(Integer preBtnSize, Long modelId) {
        DynamicObjectCollection caseColl = null;
        this.casePageCacheList = new ArrayList<CasePageCache>(16);
        if (modelId != null && modelId != 0L) {
            QFBuilder qfBuilder = QFBuilder.newQFilter();
            qfBuilder.add("model", "=", (Object)modelId);
            caseColl = QueryServiceHelper.query((String)"bgmd_datalockcase", (String)"id,name,default", (QFilter[])qfBuilder.toArray(), (String)"modifydate desc");
        }
        int index = 1;
        if (caseColl != null) {
            for (DynamicObject caseDoj : caseColl) {
                CasePageCache casePageCache = new CasePageCache();
                casePageCache.setBtnKey("autobutton_" + index++);
                casePageCache.setId(caseDoj.getLong("id"));
                casePageCache.setName(caseDoj.getString("name"));
                casePageCache.setDefaul(caseDoj.getBoolean("default"));
                this.casePageCacheList.add(casePageCache);
            }
        }
        if (preBtnSize != null) {
            if (preBtnSize < index) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u3002", (String)"DataLockService_6", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            while (index <= preBtnSize) {
                CasePageCache casePageCache = new CasePageCache();
                casePageCache.setBtnKey("autobutton_" + index++);
                this.casePageCacheList.add(casePageCache);
            }
        } else {
            for (int i = 0; i < 60; ++i) {
                CasePageCache casePageCache = new CasePageCache();
                casePageCache.setBtnKey("autobutton_" + index++);
                this.casePageCacheList.add(casePageCache);
            }
        }
        return this.casePageCacheList;
    }

    private FlexPanelAp createDynamicPanel() {
        if (this.headPanelAp == null) {
            List<CasePageCache> casePageCacheList = this.getCasePageCacheList();
            this.headPanelAp = new FlexPanelAp();
            this.headPanelAp.setKey("headAp");
            for (CasePageCache casePageCache : casePageCacheList) {
                ButtonAp buttonAp = this.getButtonAp(casePageCache);
                this.headPanelAp.getItems().add(buttonAp);
            }
        }
        return this.headPanelAp;
    }

    private List<CasePageCache> getCasePageCacheList() {
        if (this.casePageCacheList == null) {
            if (this.view == null) {
                Long modelId = this.plugin.getSpecialUserSelectModelId(this.formId);
                this.casePageCacheList = this.buildCasePageCacheList(null, modelId);
            } else {
                String pageCacheCase = this.view.getPageCache().get("casePageCacheList");
                if (StringUtils.isEmpty((String)pageCacheCase)) {
                    Long modelId = this.plugin.getSpecialUserSelectModelId();
                    this.casePageCacheList = this.buildCasePageCacheList(null, modelId);
                    this.view.getPageCache().put("casePageCacheList", JsonUtils.getJsonString(this.casePageCacheList));
                } else {
                    this.casePageCacheList = (List)JsonUtils.readValue((String)pageCacheCase, (TypeReference)new TypeReference<List<CasePageCache>>(){});
                }
            }
        }
        return this.casePageCacheList;
    }

    private ButtonAp getButtonAp(CasePageCache casePageCache) {
        ButtonAp buttonAp = new ButtonAp();
        buttonAp.setId(casePageCache.getBtnKey());
        buttonAp.setKey(casePageCache.getBtnKey());
        buttonAp.setName(new LocaleString(casePageCache.getName()));
        return buttonAp;
    }

    public void onGetControl(OnGetControlArgs source) {
        Button button = new Button();
        button.setKey(source.getKey());
        button.setView(this.plugin.getView());
        button.addClickListener((ClickListener)this);
        source.setControl((Control)button);
    }

    public void beforeClick(BeforeClickEvent evt) {
        this.plugin.beforeClick(evt);
    }

    public void click(EventObject evt) {
        String lastKey;
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.startsWith("autobutton_") && ((lastKey = this.plugin.getPageCache().get("currCaseKey")) == null || !lastKey.equals(key))) {
            this.setButtonColor(key);
            this.setCaseByBtnKey(key);
            this.plugin.getPageCache().put("currCaseKey", key);
        }
    }

    public void setCaseByBtnKey(String btnKey) {
        Long caseId = this.getCaseId(btnKey);
        if (caseId != null) {
            this.setCaseByCaseId(caseId);
        }
    }

    public void setCaseByCaseId(Long id) {
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bgmd_datalockcase");
        this.plugin.reset = true;
        IDataModel model = this.view.getModel();
        try {
            model.setValue("model", (Object)doj.getDynamicObject("model"));
            model.setValue("bizmodel", (Object)doj.getDynamicObject("bizmodel"));
            model.setValue("entityview", (Object)doj.getDynamicObject("entityview"));
            model.setValue("period", (Object)doj.getDynamicObjectCollection("period"));
            model.setValue("version", (Object)doj.getDynamicObjectCollection("version"));
            model.setValue("datatype", (Object)doj.getDynamicObjectCollection("datatype"));
            model.setValue("audittrail", (Object)doj.getDynamicObjectCollection("audittrail"));
            model.setValue("casename", (Object)doj.getString("name"));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.view.showErrorNotification(e.getMessage());
        }
    }

    private void setButtonColor(String key) {
        this.changeLastButtonColor();
        Map<String, Object> fieldMap = this.getHighLightStyle();
        this.plugin.getView().updateControlMetadata(key, fieldMap);
    }

    private void changeLastButtonColor() {
        String caseName = this.plugin.getPageCache().get("currCaseKey");
        if (StringUtils.isNotEmpty((String)caseName)) {
            Map<String, Object> fieldMap = this.getDefaultStyle();
            this.plugin.getView().updateControlMetadata(caseName, fieldMap);
        }
    }

    private Map<String, Object> getHighLightStyle() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("fc", "#ffffff");
        fieldMap.put("bc", "#6AABF6");
        return fieldMap;
    }

    private Map<String, Object> getDefaultStyle() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("fc", "#3E7CD1");
        fieldMap.put("bc", "#F3F9FF");
        HashMap map2 = new HashMap();
        HashMap<String, String> map3 = new HashMap<String, String>();
        map2.put("b", map3);
        map3.put("r", "1px_solid_#A6C7EE");
        map3.put("l", "1px_solid_#A6C7EE");
        map3.put("t", "1px_solid_#A6C7EE");
        map3.put("b", "1px_solid_#A6C7EE");
        HashMap<String, String> map4 = new HashMap<String, String>();
        map4.put("l", "10px");
        map4.put("r", "10px");
        map2.put("m", map4);
        fieldMap.put("s", map2);
        fieldMap.put("h", map2);
        return fieldMap;
    }

    public void newButton(DataLockCase dataLockCase) {
        List<CasePageCache> casePageCacheList = this.getCasePageCacheList();
        boolean hasUpdate = false;
        for (CasePageCache casePageCache : casePageCacheList) {
            if (casePageCache.getId() != null) continue;
            casePageCache.setId(dataLockCase.getId());
            casePageCache.setName(dataLockCase.getName());
            this.view.setVisible(Boolean.valueOf(true), new String[]{casePageCache.getBtnKey()});
            this.changeLastButtonColor();
            this.updateControlName(casePageCache);
            this.view.getPageCache().put("currCaseKey", casePageCache.getBtnKey());
            hasUpdate = true;
            break;
        }
        this.view.getPageCache().put("casePageCacheList", JsonUtils.getJsonString(casePageCacheList));
        if (!hasUpdate) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u3002", (String)"DataLockService_6", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    private void updateControlName(CasePageCache casePageCache) {
        Map<String, Object> fieldMap = this.getHighLightStyle();
        fieldMap.put("text", new LocaleString(casePageCache.getName()));
        this.plugin.getView().updateControlMetadata(casePageCache.getBtnKey(), fieldMap);
    }

    public void updateButton(DataLockCase dataLockCase) {
        List<CasePageCache> casePageCacheList = this.getCasePageCacheList();
        for (CasePageCache casePageCache : casePageCacheList) {
            if (!dataLockCase.getId().equals(casePageCache.getId())) continue;
            casePageCache.setName(dataLockCase.getName());
            this.updateControlName(casePageCache);
            break;
        }
        this.view.getPageCache().put("casePageCacheList", JsonUtils.getJsonString(casePageCacheList));
    }

    public Long getCaseId(String caseKey) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)caseKey)) {
            return null;
        }
        List<CasePageCache> casePageCacheList = this.getCasePageCacheList();
        Optional<CasePageCache> firstOptional = casePageCacheList.stream().filter(casePageCache -> caseKey.equals(casePageCache.getBtnKey())).findFirst();
        if (firstOptional.isPresent()) {
            CasePageCache casePageCache2 = firstOptional.get();
            return casePageCache2.getId();
        }
        return null;
    }

    public void deleteButton(String caseKey) {
        List<CasePageCache> casePageCacheList = this.getCasePageCacheList();
        CasePageCache preCase = null;
        for (int i = 0; i < casePageCacheList.size(); ++i) {
            CasePageCache casePageCache = casePageCacheList.get(i);
            if (caseKey.equals(casePageCache.getBtnKey())) {
                Map<String, Object> fieldMap = this.getDefaultStyle();
                this.plugin.getView().updateControlMetadata(casePageCache.getBtnKey(), fieldMap);
                preCase = casePageCache;
            }
            if (preCase == null || casePageCache.getId() == null) continue;
            preCase.setId(casePageCache.getId());
            preCase.setName(casePageCache.getName());
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
            map.put("text", new LocaleString(preCase.getName()));
            this.plugin.getView().updateControlMetadata(preCase.getBtnKey(), map);
            preCase = casePageCache;
        }
        if (preCase != null) {
            preCase.setId(null);
            preCase.setName(null);
            this.view.setVisible(Boolean.valueOf(false), new String[]{preCase.getBtnKey()});
        }
        this.view.getPageCache().put("casePageCacheList", JsonUtils.getJsonString(casePageCacheList));
    }
}

