/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.dataperm.EbMembPerm;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.AbstractDataLockPlugin;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.CaseButtonControl;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.CasePageCache;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCaseSaveOp;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.lang3.StringUtils;

public class DataLockCasePlugin
extends AbstractDataLockPlugin
implements BeforeF7SelectListener,
EbMembPerm {
    private CaseButtonControl caseButtonControl;

    public CaseButtonControl getButtonControl() {
        if (this.caseButtonControl == null) {
            this.caseButtonControl = new CaseButtonControl(this, this.getView());
        }
        return this.caseButtonControl;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnreset", "btnnewcase", "btnsavecase"});
        this.addItemClickListeners(new String[]{"toolbarap1"});
        this.addF7SelectListener(this, new String[]{"model", "bizmodel", "entityview", "period", "version", "datatype", "audittrail"});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        this.getButtonControl().loadCustomControlMetas(e);
    }

    @Override
    public void beforeBindData(EventObject e) {
        CasePageCache defaultCase = this.getButtonControl().initButton();
        if (defaultCase != null) {
            this.getButtonControl().setCaseByCaseId(defaultCase.getId());
            this.getPageCache().put("currCaseKey", defaultCase.getBtnKey());
        } else {
            Long modelId = this.getSpecialUserSelectModelId();
            if (modelId != null && modelId != 0L) {
                this.getModel().setValue("model", (Object)modelId);
                if (ModelUtil.isBGModel((Long)modelId)) {
                    DynamicObject val = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)modelId);
                    this.getModel().setValue("bizmodel", (Object)val);
                } else {
                    this.getModel().setValue("bizmodel", null);
                }
            }
        }
    }

    public void onGetControl(OnGetControlArgs source) {
        if (source.getKey().startsWith("autobutton_")) {
            this.getButtonControl().onGetControl(source);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.reset) {
            return;
        }
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject oldmodel = (DynamicObject)changeData.getOldValue();
            DynamicObject newmodel = (DynamicObject)changeData.getNewValue();
            if (newmodel == null) {
                this.reset = true;
                this.getModel().setValue("model", (Object)oldmodel);
                return;
            }
            if (oldmodel != null) {
                this.getPageCache().put("oldmodel", SerializationUtils.serializeToBase64((Object)oldmodel));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d1\u73b0\u4f53\u7cfb\u53d8\u5316\uff0c\u662f\u5426\u91cd\u6784\u65b9\u6848\u5217\u5e76\u4e14\u663e\u793a\u9ed8\u8ba4\u65b9\u6848\u3002", (String)"DataLockService_7", (String)"epm-eb-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("changeModel"));
            } else {
                long modelId = newmodel.getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
                this.getButtonControl().modelUpdate(modelId);
            }
            return;
        }
        if ("bizmodel".equals(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject oldDynamicObject = (DynamicObject)changeData.getOldValue();
            DynamicObject newDynamicObject = (DynamicObject)changeData.getNewValue();
            if (oldDynamicObject == null || newDynamicObject == null) {
                return;
            }
            if (oldDynamicObject.getPkValue().equals(newDynamicObject.getPkValue())) {
                return;
            }
            IDataModel model = this.getView().getModel();
            model.setValue("entityview", null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callback = event.getCallBackId();
        if ("changeModel".equals(callback)) {
            if (MessageBoxResult.Yes == event.getResult()) {
                DynamicObject newmodel = (DynamicObject)this.getModel().getValue("model");
                long modelId = newmodel.getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
                this.getButtonControl().modelUpdate(modelId);
            } else {
                this.reset = true;
                DynamicObject oldmodel = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("oldmodel"));
                this.getModel().setValue("model", (Object)oldmodel);
            }
        } else if ("bardelete".equals(callback) && MessageBoxResult.Yes == event.getResult()) {
            new DataLockCaseSaveOp(this, this.getView(), this.getModel(), "bardelete").delete();
        }
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnreset": {
                String caseKey = this.getPageCache().get("currCaseKey");
                this.getButtonControl().setCaseByBtnKey(caseKey);
                break;
            }
            case "btnnewcase": 
            case "btnsavecase": {
                boolean save = new DataLockCaseSaveOp(this, this.getView(), this.getModel(), key).save();
                if (!save) break;
                String caseName = (String)this.getModel().getValue("casename");
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BizRuleGroupListPlugin2_28", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6570\u636e\u9501\u5b9a\u65b9\u6848(%1$s)\u6210\u529f", "DataLockService_32", "epm-eb-common");
                this.writeLog(caseName, "save", opName, opDesc, new String[]{caseName});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barsetdefault": {
                new DataLockCaseSaveOp(this, this.getView(), this.getModel(), key).setDefault();
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848", "BizRuleGroupListPlugin2_56", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u8bbe\u7f6e\u6570\u636e\u9501\u5b9a\u65b9\u6848(%1$s)\u4e3a\u9ed8\u8ba4\u65b9\u6848\u6210\u529f", "BizRuleGroupListPlugin2_57", "epm-eb-formplugin");
                this.writeLog(null, "default", opName, opDesc, new String[]{(String)this.getModel().getValue("casename")});
                break;
            }
            case "bardelete": {
                String caseKey = this.getPageCache().get("currCaseKey");
                if (caseKey == null || caseKey.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u518d\u70b9\u51fb\u5220\u9664\u3002", (String)"DataLockService_21", (String)"epm-eb-common", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u65b9\u6848\u4f1a\u5bfc\u81f4\u8be5\u65b9\u6848\u9501\u5b9a\u7684\u7ec4\u7ec7\u548c\u671f\u95f4\u89e3\u9501\uff0c\u662f\u5426\u786e\u5b9a\u5220\u9664\uff1f", (String)"DataLockService_8", (String)"epm-eb-common", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("bardelete", (IFormPlugin)this));
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        this.setFilter(beforeF7SelectEvent, name);
    }

    private void setFilter(BeforeF7SelectEvent beforeF7SelectEvent, String name) {
        String sourceMethod = beforeF7SelectEvent.getSourceMethod();
        BasedataEdit control = (BasedataEdit)this.getControl(name);
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = control.getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(10);
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        switch (name) {
            case "model": {
                List modelFilter = ModelUtil.getModelFilter((IFormView)this.getView());
                qFilterList.addAll(modelFilter);
                formShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            case "bizmodel": {
                if (model == null) {
                    if (!StringUtils.equals((CharSequence)"setItemByNumber", (CharSequence)sourceMethod)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\uff0c\u518d\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"UserPermQueryFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter qFilter = new QFilter("model", "=", (Object)model.getLong("id"));
                qFilterList.add(qFilter);
                formShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            case "entityview": {
                DynamicObject bizModel = (DynamicObject)this.getModel().getValue("bizmodel");
                if (model == null || bizModel == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u548c\u4e1a\u52a1\u6a21\u578b\u518d\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"DataLockService_9", (String)"epm-eb-common", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Map viewMap = modelCache.getViewGroupViewsByBusModel(Long.valueOf(bizModel.getLong("id")));
                List viewIds = (List)viewMap.get(SysDimensionEnum.Entity.getNumber());
                qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                qFilterList.add(new QFilter("id", "in", (Object)viewIds));
                formShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            case "period": 
            case "version": 
            case "datatype": 
            case "audittrail": {
                if (model == null) {
                    if (!StringUtils.equals((CharSequence)"setItemByNumber", (CharSequence)sourceMethod)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\uff0c\u518d\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"UserPermQueryFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    beforeF7SelectEvent.setCancel(true);
                }
                qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                this.setDimFilter(beforeF7SelectEvent, qFilterList, name);
                break;
            }
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        switch (controlKey) {
            case "period": {
                return SysDimensionEnum.BudgetPeriod.getNumber();
            }
            case "version": {
                return SysDimensionEnum.Version.getNumber();
            }
            case "datatype": {
                return SysDimensionEnum.DataType.getNumber();
            }
            case "audittrail": {
                return SysDimensionEnum.AuditTrail.getNumber();
            }
        }
        return "";
    }

    private void setDimFilter(BeforeF7SelectEvent beforeF7SelectEvent, List<QFilter> qFilterList, String name) {
        LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
        leftTreeF7Parameter.setMultiple(false);
        if (!"period".equals(name)) {
            leftTreeF7Parameter.setOnlyLeaf(true);
            qFilterList.add(new QFilter("isleaf", "=", (Object)true));
            if ("audittrail".equals(name)) {
                qFilterList.add(new QFilter("number", "!=", (Object)"BudgetOccupation"));
            }
        } else {
            leftTreeF7Parameter.setCanSelectRoot(false);
            leftTreeF7Parameter.setCanSelectBudgetPeriodRoot(false);
            qFilterList.add(new QFilter("level", "!=", (Object)1));
        }
        leftTreeF7Parameter.setCheckPerm(false);
        this.switchLeftTreeF7(beforeF7SelectEvent, 0L, leftTreeF7Parameter);
    }
}

