/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCase;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCasePlugin;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCaseService;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockConstant;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockPageCache;
import org.apache.commons.lang3.StringUtils;

public class DataLockCaseSaveOp
implements DataLockConstant,
DataLockPageCache {
    private DataLockCasePlugin plugin;
    private IFormView view;
    private IDataModel model;
    private String key;

    public DataLockCaseSaveOp(DataLockCasePlugin plugin, IFormView view, IDataModel model, String key) {
        this.plugin = plugin;
        this.view = view;
        this.model = model;
        this.key = key;
    }

    public boolean save() {
        boolean isUpdate = "btnsavecase".equals(this.key);
        Long modelId = this.plugin.getModelId();
        Long bizModelId = this.plugin.getBizModelId();
        Long entityViewId = this.plugin.getIdByDoj("entityview");
        List<Long> periods = this.plugin.getIdListByDoj("period");
        List<Long> versions = this.plugin.getIdListByDoj("version");
        List<Long> datatypes = this.plugin.getIdListByDoj("datatype");
        List<Long> audittrails = this.plugin.getIdListByDoj("audittrail");
        if (modelId == null || bizModelId == null || entityViewId == null || periods == null || versions == null || datatypes == null || audittrails == null) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u586b\u9879\u662f\u5426\u4e3a\u7a7a\u3002", (String)"UserPermQueryFormPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String currCaseKey = this.plugin.getPageCache().get("currCaseKey");
        DataLockCase dataLockCase = new DataLockCase();
        if (isUpdate) {
            Long caseId = this.plugin.getButtonControl().getCaseId(currCaseKey);
            if (caseId != null) {
                dataLockCase.setId(caseId);
            } else {
                isUpdate = false;
            }
        }
        this.buildDataLockCase(dataLockCase, modelId, bizModelId, entityViewId, periods, versions, datatypes, audittrails);
        if (StringUtils.isEmpty((CharSequence)dataLockCase.getName())) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u65b9\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataLockService_10", (String)"epm-eb-common", (Object[])new Object[0]));
            return false;
        }
        QFBuilder qfBuilder = QFBuilder.newQFilter();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("name", "=", (Object)dataLockCase.getName());
        if (isUpdate) {
            qfBuilder.add("id", "!=", (Object)dataLockCase.getId());
        }
        if (QueryServiceHelper.exists((String)"bgmd_datalockcase", (QFilter[])qfBuilder.toArray())) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataLockService_11", (String)"epm-eb-common", (Object[])new Object[0]));
            return false;
        }
        List<String> intersectionCaseNames = DataLockCaseService.getInstance().checkIntersection(modelId, bizModelId, dataLockCase);
        if (intersectionCaseNames != null && !intersectionCaseNames.isEmpty()) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0e\u65b9\u6848%s\u76f8\u4ea4\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataLockService_12", (String)"epm-eb-common", (Object[])new Object[]{intersectionCaseNames}));
            return false;
        }
        dataLockCase = DataLockCaseService.getInstance().saveCase(dataLockCase);
        if (isUpdate) {
            DataLockService.getInstance().clearCache(modelId, bizModelId);
            this.plugin.getButtonControl().updateButton(dataLockCase);
        } else {
            this.plugin.getButtonControl().newButton(dataLockCase);
        }
        this.view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataLockService_20", (String)"epm-eb-common", (Object[])new Object[0]));
        return true;
    }

    private void buildDataLockCase(DataLockCase dataLockCase, Long modelId, Long bizModelId, Long entityViewId, List<Long> periods, List<Long> versions, List<Long> datatypes, List<Long> audittrails) {
        dataLockCase.setName((String)this.model.getValue("casename"));
        dataLockCase.setModelId(modelId);
        dataLockCase.setBizModelId(bizModelId);
        dataLockCase.setEntityViewId(entityViewId);
        dataLockCase.setPeriods(periods);
        dataLockCase.setVersions(versions);
        dataLockCase.setDatatypes(datatypes);
        dataLockCase.setAudittrails(audittrails);
    }

    public void setDefault() {
        String caseKey = this.plugin.getPageCache().get("currCaseKey");
        Long caseId = this.plugin.getButtonControl().getCaseId(caseKey);
        if (caseId != null) {
            DynamicObject[] load;
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)this.plugin.getModelId());
            qfBuilder.add("default", "=", (Object)true);
            for (DynamicObject doj : load = BusinessDataServiceHelper.load((String)"bgmd_datalockcase", (String)"id,default", (QFilter[])qfBuilder.toArray())) {
                if (caseId.equals(doj.getLong("id"))) continue;
                doj.set("default", (Object)false);
            }
            DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"bgmd_datalockcase");
            doj.set("default", (Object)true);
            SaveServiceHelper.save((DynamicObject[])load);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
            this.view.showSuccessNotification(ResManager.loadResFormat((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"DataLockService_13", (String)"epm-eb-common", (Object[])new Object[0]));
        } else {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u518d\u8bbe\u7f6e\u9ed8\u8ba4\u3002", (String)"DataLockService_38", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public void delete() {
        String caseKey = this.plugin.getPageCache().get("currCaseKey");
        Object casename = this.model.getValue("casename");
        Long caseId = this.plugin.getButtonControl().getCaseId(caseKey);
        if (caseId != null) {
            DynamicObject old = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"bgmd_datalockcase", (String)"id,bizmodel.id");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.plugin.getModelId());
            DataLockService.getInstance().dropLockRule(caseId, Long.valueOf(old.getLong("bizmodel.id")), modelCache);
            DeleteServiceHelper.delete((String)"bgmd_datalockcase", (QFilter[])new QFilter("id", "=", (Object)caseId).toArray());
            DeleteServiceHelper.delete((String)"bgmd_datalockcasedetail", (QFilter[])new QFilter("case", "=", (Object)caseId).toArray());
            DataLockService.getInstance().clearCache(this.plugin.getModelId(), this.plugin.getBizModelId());
            this.plugin.getButtonControl().deleteButton(caseKey);
            this.plugin.getPageCache().remove("currCaseKey");
            this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalyzeListSet_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "BizRuleGroupListPlugin2_31", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u6570\u636e\u9501\u5b9a\u65b9\u6848(%1$s)\u6210\u529f", "BizRuleGroupListPlugin2_58", "epm-eb-formplugin");
            this.plugin.writeLog((String)casename, "delete", opName, opDesc, new String[]{(String)casename});
        }
    }
}

