/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.pojo.EdgePojo;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCase;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockRowNode;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase3.DataLockEntityContext;

public class DataLockCaseService {
    private static final DataLockCaseService instance = new DataLockCaseService();

    public static DataLockCaseService getInstance() {
        return instance;
    }

    public List<String> checkIntersection(Long modelId, Long bizModelId, DataLockCase dataLockCase) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("bizmodel", "=", (Object)bizModelId);
        if (dataLockCase.getId() != null) {
            qfBuilder.add("id", "!=", (Object)dataLockCase.getId());
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        DynamicObject[] otherCaseDoj = BusinessDataServiceHelper.load((String)"bgmd_datalockcase", (String)"name,period,version,datatype,audittrail", (QFilter[])qfBuilder.toArray());
        ArrayList<String> res = new ArrayList<String>(16);
        for (DynamicObject doj : otherCaseDoj) {
            if (!this.checkIntersection(modelCache, dataLockCase.getPeriods(), "period", doj) || !this.checkIntersection(modelCache, dataLockCase.getVersions(), "version", doj) || !this.checkIntersection(modelCache, dataLockCase.getDatatypes(), "datatype", doj) || !this.checkIntersection(modelCache, dataLockCase.getAudittrails(), "audittrail", doj)) continue;
            res.add(doj.getString("name"));
        }
        return res;
    }

    private boolean checkIntersection(IModelCacheHelper modelCache, List<Long> ids, String propertyName, DynamicObject doj) {
        HashSet<Object> idSet;
        boolean isBudget = SysDimensionEnum.BudgetPeriod.getNumber().equals(propertyName);
        if (isBudget) {
            idSet = new HashSet(16);
            for (Long id : ids) {
                Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), id);
                if (member.isLeaf()) {
                    idSet.add(member.getId());
                    continue;
                }
                List leafs = modelCache.getLeaf(member);
                for (Member leaf : leafs) {
                    idSet.add(leaf.getId());
                }
            }
        } else {
            idSet = new HashSet<Long>(ids);
        }
        DynamicObjectCollection dojs = doj.getDynamicObjectCollection(propertyName);
        for (DynamicObject propertyDoj : dojs) {
            long id = propertyDoj.getLong("fbasedataid_id");
            if (isBudget) {
                Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), Long.valueOf(id));
                if (member.isLeaf()) {
                    if (!idSet.contains(member.getId())) continue;
                    return true;
                }
                List leafs = modelCache.getLeaf(member);
                for (Member leaf : leafs) {
                    if (!idSet.contains(leaf.getId())) continue;
                    return true;
                }
                continue;
            }
            if (!idSet.contains(id)) continue;
            return true;
        }
        return false;
    }

    public DataLockCase saveCase(DataLockCase dataLockCase) {
        DynamicObject dynamicObject;
        if (dataLockCase.getId() == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bgmd_datalockcase");
            dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataLockCase.getId(), (String)"bgmd_datalockcase");
        }
        LinkedList quotes = Lists.newLinkedList();
        dynamicObject.set("name", (Object)dataLockCase.getName());
        dynamicObject.set("model", (Object)dataLockCase.getModelId());
        dynamicObject.set("bizmodel", (Object)dataLockCase.getBizModelId());
        dynamicObject.set("entityview", (Object)dataLockCase.getEntityViewId());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)dataLockCase.getModelId());
        this.putInDojs(dataLockCase.getPeriods(), modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber()), "period", dynamicObject, dataLockCase.getModelId(), quotes);
        this.putInDojs(dataLockCase.getVersions(), modelCache.getDimension(SysDimensionEnum.Version.getNumber()), "version", dynamicObject, dataLockCase.getModelId(), quotes);
        this.putInDojs(dataLockCase.getDatatypes(), modelCache.getDimension(SysDimensionEnum.DataType.getNumber()), "datatype", dynamicObject, dataLockCase.getModelId(), quotes);
        this.putInDojs(dataLockCase.getAudittrails(), modelCache.getDimension(SysDimensionEnum.AuditTrail.getNumber()), "audittrail", dynamicObject, dataLockCase.getModelId(), quotes);
        try (TXHandle tx = TX.required((String)"saveCase");){
            try {
                if (dataLockCase.getId() != null) {
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.DataLock.getType(), Lists.newArrayList((Object[])new Long[]{dataLockCase.getId()})});
                }
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                dataLockCase.setId(((DynamicObject)save[0]).getLong("id"));
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return dataLockCase;
    }

    private void putInDojs(List<Long> ids, Dimension dimension, String propertyName, DynamicObject dynamicObject, Long modelId, List<MemberQuoteDao> quotes) {
        DynamicObjectCollection periodDojs = dynamicObject.getDynamicObjectCollection(propertyName);
        periodDojs.clear();
        for (Long period : ids) {
            DynamicObject doj = periodDojs.addNew();
            doj.set("fbasedataid_id", (Object)period);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), period, MemberQuoteResourceEnum.DataLock, Long.valueOf(dynamicObject.getLong("id"))));
        }
    }

    public void saveCaseDetail(Long modelId, Long bizModelId, Long caseId, DataLockRowNode rootNode) {
        ArrayList<DataLockRowNode> needSaveNode = new ArrayList<DataLockRowNode>();
        this.dfs(rootNode, null, needSaveNode);
        ArrayList<Object[]> savez = new ArrayList<Object[]>();
        for (DataLockRowNode dataLockRowNode : needSaveNode) {
            String entityNumber = dataLockRowNode.getEntityNumber();
            for (String lockPeriod : dataLockRowNode.getLockPeriods()) {
                savez.add(new Object[]{null, entityNumber, lockPeriod, caseId});
            }
        }
        if (savez.size() > 0) {
            long[] ids = DB.genGlobalLongIds((int)savez.size());
            for (int i = 0; i < savez.size(); ++i) {
                ((Object[])savez.get((int)i))[0] = ids[i];
            }
        }
        try (TXHandle tx = TX.required((String)"saveCaseDetail");){
            try {
                DeleteServiceHelper.delete((String)"bgmd_datalockcasedetail", (QFilter[])new QFilter("case", "=", (Object)caseId).toArray());
                if (savez.size() > 0) {
                    String sql1 = "insert into t_bgmd_datalockcasedetail(fid,fentity,fperiod,fcaseid) values (?,?,?,?)";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql1, savez);
                }
            }
            catch (Exception e) {
                tx.setRollback(true);
                throw new KDBizException(e.getMessage());
            }
        }
        DataLockService.getInstance().clearCache(modelId, bizModelId);
    }

    public void saveCaseDetail2(DataLockEntityContext dataLockEntityContext) {
        int sizeInt = dataLockEntityContext.getAddEdgePojoList().size();
        ArrayList<Object[]> paramArrayList = new ArrayList<Object[]>(sizeInt);
        long[] idLongArray = DB.genGlobalLongIds((int)sizeInt);
        for (int i = 0; i < sizeInt; ++i) {
            EdgePojo edgePojo = dataLockEntityContext.getAddEdgePojoList().get(i);
            paramArrayList.add(new Object[]{idLongArray[i], edgePojo.getFromString(), edgePojo.getToString(), dataLockEntityContext.getDataLockCaseIdLong()});
        }
        HashSet versionSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet auditSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet dataTypeSet = Sets.newHashSetWithExpectedSize((int)10);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)dataLockEntityContext.getModelIdLong());
        HashMap lockScopeMap = Maps.newHashMapWithExpectedSize((int)10);
        if (paramArrayList.size() > 0) {
            for (Long vId : dataLockEntityContext.getVersionIdLongSet()) {
                versionSet.add(modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, vId).getNumber());
            }
            for (Long auditId : dataLockEntityContext.getAudittrailIdLongSet()) {
                auditSet.add(modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, auditId).getNumber());
            }
            for (Long dId : dataLockEntityContext.getDatatypeIdLongSet()) {
                dataTypeSet.add(modelCache.getMember(SysDimensionEnum.DataType.getNumber(), null, dId).getNumber());
            }
            Map<String, Set> bgGroup = dataLockEntityContext.getAddEdgePojoList().stream().collect(Collectors.toMap(EdgePojo::getToString, e -> Sets.newHashSet((Object[])new String[]{e.getFromString()}), (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            }));
            bgGroup.forEach((bp, groupSet) -> {
                HashSet bpSet = Sets.newHashSetWithExpectedSize((int)10);
                bpSet.addAll(modelCache.getMemberIncludeCosmic(SysDimensionEnum.BudgetPeriod.getNumber(), null, bp, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                HashSet entitySet = Sets.newHashSetWithExpectedSize((int)1);
                groupSet.forEach(item -> entitySet.addAll(modelCache.getMemberIncludeCosmic(SysDimensionEnum.Entity.getNumber(), dataLockEntityContext.getEntityViewIdLong(), item, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet())));
                LinkedHashMap lockScope = Maps.newLinkedHashMap();
                lockScope.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpSet);
                lockScope.put(SysDimensionEnum.Version.getNumber(), versionSet);
                lockScope.put(SysDimensionEnum.DataType.getNumber(), dataTypeSet);
                lockScope.put(SysDimensionEnum.AuditTrail.getNumber(), auditSet);
                lockScope.put(SysDimensionEnum.Entity.getNumber(), entitySet);
                lockScopeMap.put(bp, lockScope);
            });
        }
        String sqlString = "insert into t_bgmd_datalockcasedetail(fid,fentity,fperiod,fcaseid) values (?,?,?,?)";
        try (TXHandle tx = TX.required((String)"saveCaseDetail");){
            try {
                DeleteServiceHelper.delete((String)"bgmd_datalockcasedetail", (QFilter[])new QFilter("case", "=", (Object)dataLockEntityContext.getDataLockCaseIdLong()).toArray());
                DataLockService.getInstance().dropLockRule(dataLockEntityContext.getDataLockCaseIdLong(), dataLockEntityContext.getBusinessModelIdLong(), modelCache);
                if (paramArrayList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sqlString, paramArrayList);
                    DataLockService.getInstance().updateOrCreateLockRule(dataLockEntityContext.getDataLockCaseIdLong(), (Map)lockScopeMap, dataLockEntityContext.getBusinessModelIdLong(), modelCache);
                } else {
                    DataLockService.getInstance().dropLockRule(dataLockEntityContext.getDataLockCaseIdLong(), dataLockEntityContext.getBusinessModelIdLong(), modelCache);
                }
            }
            catch (Exception e2) {
                tx.setRollback(true);
                throw new KDBizException(e2.getMessage());
            }
        }
        DataLockService.getInstance().clearCache(dataLockEntityContext.getModelIdLong(), dataLockEntityContext.getBusinessModelIdLong());
    }

    private void dfs(DataLockRowNode rootNode, DataLockRowNode parentNode, List<DataLockRowNode> needSaveNode) {
        Set<String> periods = rootNode.getLockPeriods();
        if (!periods.isEmpty()) {
            if (parentNode == null) {
                needSaveNode.add(rootNode);
            } else {
                Set<String> parentPeriods = parentNode.getLockPeriods();
                if (!periods.equals(parentPeriods)) {
                    needSaveNode.add(rootNode);
                }
            }
        }
        for (DataLockRowNode child : rootNode.getChildren()) {
            this.dfs(child, rootNode, needSaveNode);
        }
    }
}

