/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockRowNode;

public class DataLockCaseUtils {
    public static void rebuildPeriodLock(DataLockRowNode root) {
        DataLockCaseUtils.lockToChild(new HashSet<String>(2), root);
        DataLockCaseUtils.aggChildLock(root);
    }

    private static void lockToChild(Set<String> parentLock, DataLockRowNode root) {
        root.getLockPeriods().addAll(parentLock);
        Set<String> lockPeriods = root.getLockPeriods();
        for (DataLockRowNode child : root.getChildren()) {
            DataLockCaseUtils.lockToChild(lockPeriods, child);
        }
    }

    private static Set<String> aggChildLock(DataLockRowNode root) {
        if (root.isLeaf()) {
            return root.getLockPeriods();
        }
        Sets.SetView curr = null;
        for (DataLockRowNode child : root.getChildren()) {
            Set<String> next = DataLockCaseUtils.aggChildLock(child);
            if (curr == null) {
                curr = new HashSet(next);
                continue;
            }
            if (curr.isEmpty()) continue;
            curr = Sets.intersection(curr, next);
        }
        root.setLockPeriods(new HashSet<String>((Collection<String>)curr));
        return curr;
    }
}

