/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeContainer;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.AbstractDataLockPlugin;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.CaseButtonControl;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCaseService;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockCaseUtils;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockConstant;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockPageCache;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockRowNode;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.LazyTreeHandler;
import org.apache.commons.lang3.StringUtils;

public class DataLockEntityPlugin
extends AbstractDataLockPlugin
implements ItemClickListener,
DataLockPageCache,
DataLockConstant,
HyperLinkClickListener,
TreeNodeQueryListener {
    private static final List<String> periodColumns = Lists.newArrayList((Object[])new String[]{"p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "p16", "p17", "p18", "p19", "p20", "p21", "p22", "p23", "p24", "p25", "p26", "p27", "p28", "p29", "p30", "p31", "p32", "p33", "p34", "p35", "p36", "p37", "p38", "p39", "p40", "p41", "p42", "p43", "p44", "p45", "p46", "p47", "p48", "p49", "p50"});
    boolean isInit = false;
    DataLockRowNode rootNode;

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getPageCache().get("currCaseKey") != null) {
            Button btn = (Button)this.getView().getControl("btnquery");
            this.addClickListeners(new String[]{"btnquery"});
            btn.addClickListener((ClickListener)this);
            btn.click();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeEntryGrid entry = (TreeEntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
        entry.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnquery": {
                String caseKey = this.getPageCache().get("currCaseKey");
                Long caseId = new CaseButtonControl(this, this.getView()).getCaseId(caseKey);
                if (caseId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u518d\u70b9\u51fb\u67e5\u8be2\u3002", (String)"DataLockService_14", (String)"epm-eb-common", (Object[])new Object[0]));
                    return;
                }
                DynamicObject caseDoj = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"bgmd_datalockcase");
                if (caseDoj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u3002", (String)"DataLockService_15", (String)"epm-eb-common", (Object[])new Object[0]));
                    return;
                }
                if (this.checkChange(caseDoj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u65b9\u6848\u4fee\u6539\u540e\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u6216\u91cd\u7f6e\u540e\u518d\u70b9\u51fb\u67e5\u8be2\u3002", (String)"DataLockService_16", (String)"epm-eb-common", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put("entrycaseId", String.valueOf(caseId));
                this.initEntryEntity(caseId);
                this.getPageCache().remove("DataChange");
            }
        }
    }

    private boolean checkChange(DynamicObject caseDoj) {
        String caseKey = this.getPageCache().get("currCaseKey");
        Long caseId = new CaseButtonControl(this, this.getView()).getCaseId(caseKey);
        if (!caseId.equals(caseDoj.getLong("id"))) {
            return false;
        }
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        Long entityViewId = this.getIdByDoj("entityview");
        List<Long> periods = this.getIdListByDoj("period");
        List<Long> versions = this.getIdListByDoj("version");
        List<Long> datatypes = this.getIdListByDoj("datatype");
        List<Long> audittrails = this.getIdListByDoj("audittrail");
        if (modelId == null || bizModelId == null || entityViewId == null || periods == null || versions == null || datatypes == null || audittrails == null) {
            return true;
        }
        return !bizModelId.equals(caseDoj.getLong("bizmodel.id")) || !entityViewId.equals(caseDoj.getLong("entityview.id")) || !this.checkEquals(periods, "period", caseDoj) || !this.checkEquals(versions, "version", caseDoj) || !this.checkEquals(datatypes, "datatype", caseDoj) || !this.checkEquals(audittrails, "audittrail", caseDoj);
    }

    private boolean checkEquals(List<Long> pageSelectIds, String field, DynamicObject caseDoj) {
        DynamicObjectCollection dynamicObjectCollection = caseDoj.getDynamicObjectCollection(field);
        Set dojSelect = dynamicObjectCollection.stream().map(doj -> doj.getLong("fbasedataid_id")).collect(Collectors.toSet());
        return dojSelect.equals(new HashSet<Long>(pageSelectIds));
    }

    private void initEntryEntity(Long caseId) {
        if (caseId != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryentity"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"toolbarap"});
            DynamicObject caseDoj = BusinessDataServiceHelper.loadSingleFromCache((Object)caseId, (String)"bgmd_datalockcase");
            if (caseDoj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u3002", (String)"DataLockService_15", (String)"epm-eb-common", (Object[])new Object[0]));
                return;
            }
            this.getModel().beginInit();
            this.getModel().deleteEntryData("entryentity");
            this.getModel().endInit();
            this.buildEntryEntityColumn(caseDoj);
            this.fillEntryEntity(caseId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u518d\u70b9\u51fb\u67e5\u8be2\u3002", (String)"DataLockService_14", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    private void fillEntryEntity(Long caseId) {
        this.isInit = true;
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        String entityViewIdStr = this.getPageCache().get("entityview");
        Long entityViewId = Long.valueOf(entityViewIdStr);
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        View view = dimension.getView(entityViewId);
        Member rootMember = null;
        if (view != null) {
            rootMember = modelCache.getRootMember(SysDimensionEnum.Entity.getNumber(), view.getId());
        }
        if (rootMember == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u6ca1\u6709[Entity]\u6839\u8282\u70b9\uff0c\u8bf7\u4fee\u590d\u89c6\u56fe\u540e\u91cd\u8bd5\u3002", (String)"DataLockService_17", (String)"epm-eb-common", (Object[])new Object[0]));
            return;
        }
        HashMap<String, DataLockRowNode> nodeMap = new HashMap<String, DataLockRowNode>();
        this.buildTree(rootMember, nodeMap);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("case", "=", (Object)caseId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryCaseDetail", (String)"bgmd_datalockcasedetail", (String)"entity,period", (QFilter[])qfBuilder.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                String entity = next.getString("entity");
                String period = next.getString("period");
                DataLockRowNode dataLockRowNode = (DataLockRowNode)nodeMap.get(entity);
                if (dataLockRowNode == null) continue;
                dataLockRowNode.getLockPeriods().add(period);
            }
        }
        String periodInColumnStr = this.getPageCache().get("periodToColumn");
        Map periodTnColumn = (Map)JsonUtils.readValue((String)periodInColumnStr, Map.class);
        this.rootNode = (DataLockRowNode)nodeMap.get(SysDimensionEnum.Entity.getNumber());
        DataLockCaseUtils.rebuildPeriodLock(this.rootNode);
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new LazyTreeHandler(periodTnColumn), (ITreeNode)this.rootNode).initTree();
        this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)this.rootNode));
    }

    private void cacheRootNode() {
        if (!this.isInit) {
            this.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)this.rootNode));
        }
    }

    private void buildTree(Member member, Map<String, DataLockRowNode> nodeMap) {
        DataLockRowNode rowNode = new DataLockRowNode();
        rowNode.setId(member.getId());
        rowNode.setEntityName(member.getName());
        rowNode.setEntityNumber(member.getNumber());
        String parentNumber = member.getParentNumber();
        if (StringUtils.isNotEmpty((CharSequence)parentNumber) && nodeMap.containsKey(parentNumber)) {
            DataLockRowNode parentNode = nodeMap.get(parentNumber);
            rowNode.setParent(parentNode);
            rowNode.setParentId(parentNode.getId());
            parentNode.addChild(rowNode);
        }
        nodeMap.put(member.getNumber(), rowNode);
        for (Member child : member.getChildren()) {
            this.buildTree(child, nodeMap);
        }
    }

    private void buildEntryEntityColumn(DynamicObject caseDoj) {
        DynamicObjectCollection periodDojs = caseDoj.getDynamicObjectCollection("period");
        if (periodDojs.size() > periodColumns.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5355\u636e\u4f53\u671f\u95f4\u5217\u4e0d\u80fd\u8d85\u8fc7%s\u5217\uff0c\u8bf7\u7f29\u51cf\u65b9\u6848\u4e2d\u7684\u5217\u3002", (String)"DataLockService_18", (String)"epm-eb-common", (Object[])new Object[]{periodColumns.size()}));
            return;
        }
        HashMap<String, String> periodToColumn = new HashMap<String, String>(16);
        HashMap<String, String> columnToPeriod = new HashMap<String, String>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int i = 0; i < periodColumns.size(); ++i) {
            DynamicObject periodDoj;
            String periodColumn = periodColumns.get(i);
            DynamicObject dynamicObject = periodDoj = periodDojs.size() <= i ? null : (DynamicObject)periodDojs.get(i);
            if (periodDoj != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{periodColumn});
                String periodName = periodDoj.getDynamicObject("fbasedataid").getString("name");
                String periodNumber = periodDoj.getDynamicObject("fbasedataid").getString("number");
                entryGrid.setColumnProperty(periodColumn, "header", (Object)new LocaleString(periodName));
                periodToColumn.put(periodNumber, periodColumn);
                columnToPeriod.put(periodColumn, periodNumber);
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{periodColumn});
        }
        this.getPageCache().put("entityview", caseDoj.getString("entityview.id"));
        this.getPageCache().put("periodToColumn", JsonUtils.getJsonString(periodToColumn));
        this.getPageCache().put("columnToPeriod", JsonUtils.getJsonString(columnToPeriod));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barsave": {
                this.saveCaseDetail();
                this.getPageCache().remove("DataChange");
                break;
            }
            case "barreset": {
                String caseIdStr = this.getPageCache().get("entrycaseId");
                if (caseIdStr == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\uff0c\u7136\u540e\u70b9\u51fb\u91cd\u7f6e\u3002", (String)"DataLockService_19", (String)"epm-eb-common", (Object[])new Object[0]));
                    return;
                }
                this.initEntryEntity(Long.valueOf(caseIdStr));
                this.getPageCache().remove("DataChange");
                break;
            }
            case "barexit": {
                DynamicObject caseDoj;
                String caseId = this.getPageCache().get("entrycaseId");
                if (StringUtils.isNotEmpty((CharSequence)caseId) && QueryServiceHelper.exists((String)"bgmd_datalockcase", (Object)Long.parseLong(caseId)) && (caseDoj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(caseId), (String)"bgmd_datalockcase")) != null && (this.checkChange(caseDoj) || this.getPageCache().get("DataChange") != null)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u65b9\u6848\u4fee\u6539\u540e\u672a\u4fdd\u5b58\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9000\u51fa\u3002", (String)"DataLockService_39", (String)"epm-eb-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
                    return;
                }
                this.getView().close();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callback = evt.getCallBackId();
        if ("barexit".equals(callback)) {
            MessageBoxResult result = evt.getResult();
            if (result == MessageBoxResult.No) {
                return;
            }
            this.getView().close();
        }
    }

    private void saveCaseDetail() {
        this.rootNode = this.getRootNode();
        String caseIdStr = this.getPageCache().get("entrycaseId");
        if (caseIdStr == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u518d\u70b9\u51fb\u4fdd\u5b58\u3002", (String)"DataLockService_40", (String)"epm-eb-common", (Object[])new Object[0]));
            return;
        }
        Long caseId = Long.valueOf(caseIdStr);
        DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((Object)caseId, (String)"bgmd_datalockcase");
        if (doj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u3002", (String)"DataLockService_15", (String)"epm-eb-common", (Object[])new Object[0]));
            return;
        }
        long modelId = doj.getLong("model.id");
        long bizModelId = doj.getLong("bizmodel.id");
        DataLockCaseService.getInstance().saveCaseDetail(modelId, bizModelId, caseId, this.rootNode);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataLockService_20", (String)"epm-eb-common", (Object[])new Object[0]));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BizRuleGroupListPlugin2_28", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6570\u636e\u9501\u5b9a\u65b9\u6848(%1$s)\u6210\u529f", "DataLockService_32", "epm-eb-common");
        this.writeLog(doj.getString("number"), "save", opName, opDesc, new String[]{doj.getString("name")});
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        this.rootNode = this.getRootNode();
        String periodInColumnStr = this.getPageCache().get("periodToColumn");
        Map periodTnColumn = (Map)JsonUtils.readValue((String)periodInColumnStr, Map.class);
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new LazyTreeHandler(periodTnColumn), (ITreeNode)this.rootNode).queryTreeNodeChildren(treeNodeEvent);
        this.cacheRootNode();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String columnName = hyperLinkClickEvent.getFieldName();
        boolean lockStatus = (Boolean)this.getModel().getValue(columnName, rowIndex) == false;
        this.rootNode = this.getRootNode();
        String periodNumber = this.getPeriodNumber(columnName);
        DataLockRowNode currNode = DataLockEntityPlugin.getChildNodeByRowIndex(rowIndex, this.rootNode);
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(16);
        this.changeStatus(lockStatus, periodNumber, currNode, rowIndexs);
        this.cacheRootNode();
        Iterator iterator = rowIndexs.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.getModel().setValue(columnName, (Object)lockStatus, index);
        }
        this.getPageCache().put("DataChange", "true");
    }

    private DataLockRowNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = (DataLockRowNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cacheRoot"));
        }
        return this.rootNode;
    }

    private void changeStatus(boolean lockStatus, String periodNumber, DataLockRowNode currNode, List<Integer> rowIndexs) {
        if (currNode != null) {
            this.changeChildren(lockStatus, periodNumber, currNode, rowIndexs);
            this.changeParent(lockStatus, periodNumber, currNode.getParent(), rowIndexs);
        }
    }

    private void changeChildren(boolean lockStatus, String periodNumber, DataLockRowNode currNode, List<Integer> rowIndexs) {
        if (currNode != null) {
            this.changeCurr(lockStatus, periodNumber, currNode, rowIndexs);
            for (DataLockRowNode child : currNode.getChildren()) {
                this.changeChildren(lockStatus, periodNumber, child, rowIndexs);
            }
        }
    }

    private void changeCurr(boolean lockStatus, String periodNumber, DataLockRowNode currNode, List<Integer> rowIndexs) {
        Set<String> lockPeriods = currNode.getLockPeriods();
        if (lockStatus) {
            lockPeriods.add(periodNumber);
        } else {
            lockPeriods.remove(periodNumber);
        }
        currNode.setLockPeriods(lockPeriods);
        if (currNode.getRowIndex() != null) {
            rowIndexs.add(currNode.getRowIndex());
        }
    }

    private void changeParent(boolean lockStatus, String periodNumber, DataLockRowNode currNode, List<Integer> rowIndexs) {
        if (currNode != null) {
            if (lockStatus) {
                Set<String> lockPeriods = currNode.getLockPeriods();
                List<DataLockRowNode> children = currNode.getChildren();
                boolean allChildHasLock = true;
                for (DataLockRowNode child : children) {
                    allChildHasLock = allChildHasLock && child.getLockPeriods().contains(periodNumber);
                }
                if (allChildHasLock) {
                    lockPeriods.add(periodNumber);
                    currNode.setLockPeriods(lockPeriods);
                    if (currNode.getRowIndex() != null) {
                        rowIndexs.add(currNode.getRowIndex());
                    }
                    this.changeParent(lockStatus, periodNumber, currNode.getParent(), rowIndexs);
                }
            } else {
                this.changeCurr(lockStatus, periodNumber, currNode, rowIndexs);
                this.changeParent(lockStatus, periodNumber, currNode.getParent(), rowIndexs);
            }
        }
    }

    private String getPeriodNumber(String columnName) {
        String columnToPeriodStr = this.getPageCache().get("columnToPeriod");
        Map columnToPeriod = (Map)JsonUtils.readValue((String)columnToPeriodStr, Map.class);
        return (String)columnToPeriod.get(columnName);
    }

    public static DataLockRowNode getChildNodeByRowIndex(int rowIndex, DataLockRowNode root) {
        if (root == null) {
            return null;
        }
        if (root.getRowIndex() != null && rowIndex == root.getRowIndex()) {
            return root;
        }
        for (DataLockRowNode child : root.getChildren()) {
            DataLockRowNode node = DataLockEntityPlugin.getChildNodeByRowIndex(rowIndex, child);
            if (node == null) continue;
            return node;
        }
        return null;
    }
}

