/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockRowNode;

public class LazyTreeHandler
implements ILazyTreeHandler {
    private Map<String, String> periodToColumn;

    public LazyTreeHandler(Map<String, String> periodToColumn) {
        this.periodToColumn = periodToColumn;
    }

    public String getEntryKey() {
        return "entryentity";
    }

    public boolean needCacheRowIndex() {
        return true;
    }

    public boolean cacheRootAfterInit() {
        return false;
    }

    public void doFillEntryRow(DynamicObject row, ITreeNode tree) {
        DataLockRowNode entityTree = (DataLockRowNode)tree;
        row.set("id", (Object)entityTree.getId());
        row.set("name", (Object)entityTree.getEntityName());
        row.set("number", (Object)entityTree.getEntityNumber());
        for (String lockPeriod : entityTree.getLockPeriods()) {
            String propertyName = this.periodToColumn.get(lockPeriod);
            if (propertyName == null) continue;
            row.set(propertyName, (Object)true);
        }
    }

    public boolean match(ITreeNode treeNode, String text) {
        return false;
    }

    public List<ITreeNode> findNodeCascadeSuper(Long currNodeId, ITreeNode rootNode) {
        ITreeNode currNode = LazyTreeUtils.getChildNodeByNodeId((Long)currNodeId, (ITreeNode)rootNode);
        ArrayList<ITreeNode> treeNodes = new ArrayList<ITreeNode>(16);
        for (DataLockRowNode entityTree = (DataLockRowNode)currNode; entityTree != null; entityTree = entityTree.getParent()) {
            treeNodes.add(entityTree);
        }
        Collections.reverse(treeNodes);
        return treeNodes;
    }
}

