/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datalock.bgmddatalockcase3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.ColumnPojo;
import kd.epm.eb.common.pojo.EdgePojo;
import kd.epm.eb.common.utils.base.GraphUtils;
import kd.epm.eb.common.utils.base.helper.GraphHelper;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockConstant;
import kd.epm.eb.formplugin.datalock.bgmddatalockcase.DataLockRowNode;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class DataLockEntityUtils
implements DataLockConstant {
    public static GraphHelper getPeriodGraphHelper(IModelCacheHelper modelCacheHelper, List<ColumnPojo> columnPojoList) {
        LinkedList<Member> memberList = new LinkedList<Member>();
        HashSet<String> memberNumberStringSet = new HashSet<String>(16);
        block0: for (ColumnPojo columnPojo : columnPojoList) {
            Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, columnPojo.getNumberString());
            if (memberNumberStringSet.contains(member.getParentNumber())) continue;
            do {
                memberNumberStringSet.add(member.getNumber());
                if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(member.getParentNumber())) continue;
                memberList.add(member);
                continue block0;
            } while (!memberNumberStringSet.contains((member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, member.getParentNumber())).getNumber()));
        }
        return GraphHelper.init(DataLockEntityUtils.getEdgePojoMap(memberList).values());
    }

    public static Map<String, EdgePojo> getEdgePojoMap(List<Member> memberList) {
        return DataLockEntityUtils.getEdgePojoMap(memberList, new HashMap<String, EdgePojo>(16));
    }

    public static Map<String, EdgePojo> getEdgePojoMap(List<Member> memberList, Map<String, EdgePojo> edgePojoMap) {
        if (CollectionUtils.isEmpty(memberList)) {
            return edgePojoMap;
        }
        for (Member member : memberList) {
            edgePojoMap.putIfAbsent(member.getParentNumber() + "!" + member.getNumber(), new EdgePojo().setFromString(member.getParentNumber()).setToString(member.getNumber()));
            DataLockEntityUtils.getEdgePojoMap(member.getChildren(), edgePojoMap);
        }
        return edgePojoMap;
    }

    public static int[][] getValueGraphArray(GraphHelper entityGraphHelper, GraphHelper periodGraphHelper, List<EdgePojo> addEdgePojoList, List<EdgePojo> removeEdgePojoList) {
        int[][] intArray = new int[entityGraphHelper.getSizeInt()][periodGraphHelper.getSizeInt()];
        GraphUtils.getSwitchEnableGraphArray((GraphHelper)entityGraphHelper, (GraphHelper)periodGraphHelper, (int[][])intArray, (boolean)true, addEdgePojoList);
        GraphUtils.getSwitchEnableGraphArray((GraphHelper)entityGraphHelper, (GraphHelper)periodGraphHelper, (int[][])intArray, (boolean)false, removeEdgePojoList);
        GraphUtils.rebuildGraphArray((GraphHelper)entityGraphHelper, (GraphHelper)periodGraphHelper, (int[][])intArray);
        return intArray;
    }

    public static void setValue(IDataModel dataModel, GraphHelper entityGraphHelper, List<ColumnPojo> periodColumnPojoList, GraphHelper periodGraphHelper, int[][] resultGraphArray, Collection<DataLockRowNode> entityDataLockRowNodeList) {
        LinkedList<Triple> tripleList = new LinkedList<Triple>();
        for (DataLockRowNode dataLockRowNode : entityDataLockRowNodeList) {
            if (dataLockRowNode.getRowIndex() == null) continue;
            for (ColumnPojo periodColumnPojo : periodColumnPojoList) {
                boolean oldEnableBoolean;
                Integer entityIndexInteger = entityGraphHelper.getIndexInteger(dataLockRowNode.getEntityNumber());
                Integer periodIndexInteger = periodGraphHelper.getIndexInteger(periodColumnPojo.getNumberString());
                boolean newEnableBoolean = resultGraphArray[entityIndexInteger][periodIndexInteger] == 1;
                if (newEnableBoolean == (oldEnableBoolean = Boolean.TRUE.equals(dataModel.getValue(periodColumnPojo.getColumnString(), dataLockRowNode.getRowIndex().intValue())))) continue;
                tripleList.add(Triple.of((Object)periodColumnPojo.getColumnString(), (Object)newEnableBoolean, (Object)dataLockRowNode.getRowIndex()));
            }
        }
        for (Triple triple : tripleList) {
            dataModel.setValue((String)triple.getLeft(), triple.getMiddle(), ((Integer)triple.getRight()).intValue());
        }
    }

    public static Map<String, DataLockRowNode> getDataLockRowNodeMap(Member member) {
        return DataLockEntityUtils.getDataLockRowNodeMap(member, new HashMap<String, DataLockRowNode>(16));
    }

    public static Map<String, DataLockRowNode> getDataLockRowNodeMap(Member member, Map<String, DataLockRowNode> dataLockRowNodeMap) {
        DataLockRowNode dataLockRowNode = new DataLockRowNode();
        dataLockRowNode.setId(member.getId());
        dataLockRowNode.setEntityName(member.getName());
        dataLockRowNode.setEntityNumber(member.getNumber());
        String parentNumberString = member.getParentNumber();
        if (StringUtils.isNotEmpty((CharSequence)parentNumberString) && dataLockRowNodeMap.containsKey(parentNumberString)) {
            DataLockRowNode parentDataLockRowNode = dataLockRowNodeMap.get(parentNumberString);
            dataLockRowNode.setParent(parentDataLockRowNode);
            dataLockRowNode.setParentId(parentDataLockRowNode.getId());
            parentDataLockRowNode.addChild(dataLockRowNode);
        }
        dataLockRowNodeMap.put(member.getNumber(), dataLockRowNode);
        for (Member childMember : member.getChildrenNotWithCosmic(true)) {
            DataLockEntityUtils.getDataLockRowNodeMap(childMember, dataLockRowNodeMap);
        }
        return dataLockRowNodeMap;
    }

    public static Pair<List<EdgePojo>, List<DataLockRowNode>> getEdgeListAndNodeMapPair(DataLockRowNode rootDataLockRowNode) {
        LinkedList<EdgePojo> entityEdgePojoList = new LinkedList<EdgePojo>();
        HashMap<String, DataLockRowNode> dataLockRowNodeMap = new HashMap<String, DataLockRowNode>(16);
        dataLockRowNodeMap.put(rootDataLockRowNode.getEntityNumber(), rootDataLockRowNode);
        LinkedList<DataLockRowNode> dataLockRowNodeList = new LinkedList<DataLockRowNode>();
        dataLockRowNodeList.add(rootDataLockRowNode);
        LinkedList<DataLockRowNode> _dataLockRowNodeList = new LinkedList<DataLockRowNode>();
        while (true) {
            for (DataLockRowNode dataLockRowNode : dataLockRowNodeList) {
                for (DataLockRowNode childDataLockRowNode : dataLockRowNode.getChildren()) {
                    entityEdgePojoList.add(new EdgePojo().setFromString(dataLockRowNode.getEntityNumber()).setToString(childDataLockRowNode.getEntityNumber()));
                    _dataLockRowNodeList.add(childDataLockRowNode);
                }
            }
            if (_dataLockRowNodeList.isEmpty()) break;
            for (DataLockRowNode dataLockRowNode : _dataLockRowNodeList) {
                dataLockRowNodeMap.putIfAbsent(dataLockRowNode.getEntityNumber(), dataLockRowNode);
            }
            dataLockRowNodeList.clear();
            dataLockRowNodeList.addAll(_dataLockRowNodeList);
            _dataLockRowNodeList.clear();
        }
        return Pair.of(entityEdgePojoList, new ArrayList(dataLockRowNodeMap.values()));
    }

    public static boolean memberScopeChangedBoolean(List<Long> memberIdLongList, String fieldString, DynamicObject dataLockCaseDynamicObject) {
        return !DataLockEntityUtils.getScopeIdLongSet(dataLockCaseDynamicObject, fieldString).equals(new HashSet<Long>(memberIdLongList));
    }

    public static Set<Long> getPeriodScopeIdLongSet(DynamicObject dataLockCaseDynamicObject) {
        return DataLockEntityUtils.getScopeIdLongSet(dataLockCaseDynamicObject, "period");
    }

    public static Set<Long> getVersionScopeIdLongSet(DynamicObject dataLockCaseDynamicObject) {
        return DataLockEntityUtils.getScopeIdLongSet(dataLockCaseDynamicObject, "version");
    }

    public static Set<Long> getDatatypeScopeIdLongSet(DynamicObject dataLockCaseDynamicObject) {
        return DataLockEntityUtils.getScopeIdLongSet(dataLockCaseDynamicObject, "datatype");
    }

    public static Set<Long> getAudittrailScopeIdLongSet(DynamicObject dataLockCaseDynamicObject) {
        return DataLockEntityUtils.getScopeIdLongSet(dataLockCaseDynamicObject, "audittrail");
    }

    public static Set<Long> getScopeIdLongSet(DynamicObject dataLockCaseDynamicObject, String fieldString) {
        DynamicObjectCollection dynamicObjectCollection = dataLockCaseDynamicObject.getDynamicObjectCollection(fieldString);
        return dynamicObjectCollection.stream().map(item -> item.getLong("fbasedataid_id")).collect(Collectors.toSet());
    }
}

