/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataset;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.servicehelper.SearchHelper;
import kd.epm.eb.business.utils.TreeEntryEntityUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekMemberServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.jetbrains.annotations.NotNull;

public class AccountMemberBatchUpdatePlugin
extends MainSubAbstractFormPlugin {
    private static final String FOCUSNODEID = "focusnodeid";
    private static final String HEADNODEID = "headnodeid";
    private static final String allshowrowid = "allshowrowid";
    private static final String rowlist = "rowlist";
    private static final String rowcount = "rowcount";
    private static final String[] proArr = new String[]{"number", "shownumber", "name", "aggoprt", "storagetype", "accounttype", "drcrdirect", "description", "level"};
    private static final String CACHE_ACCOUNT_IDS = "CACHE_ACCOUNT_IDS";
    private static final String CACHE_ACCOUNT_AGG_IDS = "CACHE_ACCOUNT_AGG_IDS";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit modelBaseData = (BasedataEdit)this.getView().getControl("model");
        modelBaseData.addBeforeF7SelectListener(this::registerListener);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"imageup", "imagedown"});
        TreeView tview = (TreeView)this.getControl("treeviewap");
        final TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                AccountMemberBatchUpdatePlugin.this.getPageCache().put(AccountMemberBatchUpdatePlugin.FOCUSNODEID, evt.getNodeId().toString());
                AccountMemberBatchUpdatePlugin.this.dealEntryLock();
                AccountMemberBatchUpdatePlugin.this.treeOnClick(tree);
            }
        });
        final TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl("treeentryentity");
        treeEntry.addHyperClickListener((HyperLinkClickListener)this);
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                DynamicObject select;
                int[] rows = treeEntry.getSelectRows();
                int selectRow = 0;
                if (rows.length > 0) {
                    selectRow = rows[0];
                }
                if ((select = AccountMemberBatchUpdatePlugin.this.getModel().getEntryRowEntity("treeentryentity", selectRow)) == null) {
                    AccountMemberBatchUpdatePlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u79d1\u76ee\u3002", (String)"AccountMemberBatchUpdatePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                String selectPk = select.getString("id");
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    AccountMemberBatchUpdatePlugin.this.Search(var1.getText().toLowerCase().trim(), selectRow, selectPk);
                } else {
                    AccountMemberBatchUpdatePlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"AccountMemberBatchUpdatePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        if (!IDUtils.isNotNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AccountMemberBatchUpdatePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("model", modelId.toString());
        this.modelChanged(modelId);
        this.dealEntryLock();
        this.getView().updateView("treeentryentity");
    }

    public void modelChanged(Long modelId) {
        this.initTree();
        this.getPageCache().put("model", modelId.toString());
        this.getPageCache().put("modelNum", null);
        this.getPageCache().put("KEY_DIM_ID", null);
        this.getPageCache().put("ACCOUNTDIM", null);
    }

    public void initTree() {
        long modelId = this.getModelId();
        String rootId = String.valueOf(GlobalIdUtil.genGlobalLongId());
        if (modelId != 0L) {
            TreeNode root = new TreeNode();
            QFilter qb = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection dataset = QueryServiceHelper.query((String)"eb_dataset", (String)"id,number,name,catalog", (QFilter[])new QFilter[]{qb}, (String)"catalog.createtime, catalog.number, createdate, number");
            ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>();
            if (!dataset.isEmpty()) {
                for (DynamicObject data : dataset) {
                    HashMap<String, String> memberMap1 = new HashMap<String, String>();
                    memberMap1.put("id", data.getString("id"));
                    memberMap1.put("number", data.getString("number"));
                    memberMap1.put("name", data.getString("name"));
                    memberMap1.put("parentid", rootId);
                    memberMap1.put("type", "dataset");
                    treeList.add(memberMap1);
                }
            }
            root.setId(rootId);
            root.setParentid("");
            root.setText(ResManager.loadKDString((String)"\u6570\u636e\u96c6", (String)"AccountMemberBatchUpdatePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            root.setData((Object)"catalog");
            this.setEntryNode(root, treeList, rootId);
            AccountMemberBatchUpdatePlugin.spreadAllNode(root);
            this.getPageCache().put("treelist", SerializationUtils.serializeToBase64((Object)root));
            this.getPageCache().put(HEADNODEID, rootId);
            TreeView tree = (TreeView)this.getControl("treeviewap");
            tree.deleteAllNodes();
            tree.addNode(root);
            this.getView().updateView("treeviewap");
            if (root.getChildren() != null && root.getChildren().size() > 0 && root.getChildren().get(0) != null) {
                tree.focusNode((TreeNode)root.getChildren().get(0));
                tree.treeNodeClick(root.getId(), ((TreeNode)root.getChildren().get(0)).getId());
                this.treeOnClick(tree);
            }
            this.getPageCache().put(FOCUSNODEID, tree.getTreeState().getFocusNodeId());
        }
    }

    public static void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                AccountMemberBatchUpdatePlugin.spreadAllNode(t);
            }
        }
    }

    protected void treeOnClick(TreeView tree) {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl("treeentryentity");
        String nodeId = tree.getTreeState().getFocusNodeId();
        if (nodeId == null) {
            return;
        }
        this.getModel().deleteEntryData("treeentryentity");
        TreeNode treeNode = this.getSelectedNode(nodeId);
        if ("dataset".equals(treeNode.getData())) {
            this.refreshAccountEntry(treeEntry, nodeId);
        }
        this.getPageCache().put(FOCUSNODEID, nodeId);
    }

    private TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            ArrayList<Map<String, String>> nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<Map<String, String>>();
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        return this.createNode(root, nodeMap, headId);
    }

    private TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(16);
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name") + '(' + map.get("number") + ')');
                entry.setData((Object)map.get("type"));
                String entryHeadId = map.get("id");
                this.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }

    public String getCurrentNodeId() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        return treeView.getTreeState().getFocusNodeId();
    }

    public TreeNode getCacheLefTreeRoot() {
        String rootStr = this.getPageCache().get("treelist");
        TreeNode root = null;
        if (rootStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u6811\u7f13\u5b58\u83b7\u53d6\u5931\u8d25\u3002", (String)"AccountMemberBatchUpdatePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        root = (TreeNode)SerializationUtils.deSerializeFromBase64((String)rootStr);
        return root;
    }

    private TreeNode getSelectedNode(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        TreeNode root = this.getCacheLefTreeRoot();
        TreeNode currentNode = root.getTreeNode(nodeId, 20);
        return currentNode;
    }

    private void refreshList() {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl("treeentryentity");
        String nodeId = tree.getTreeState().getFocusNodeId();
        if (nodeId == null) {
            return;
        }
        this.cacheAccountIds(this.getPageCache(), CACHE_ACCOUNT_IDS, null);
        this.cacheAccountIds(this.getPageCache(), CACHE_ACCOUNT_AGG_IDS, null);
        this.getModel().deleteEntryData("treeentryentity");
        TreeNode treeNode = this.getSelectedNode(nodeId);
        if ("dataset".equals(treeNode.getData())) {
            this.refreshAccountEntry(treeEntry, nodeId);
        }
    }

    private String getSelectMemberField() {
        return "id,name,number,shownumber,dseq,parent,aggoprt,accounttype,drcrdirect,description,level,isleaf,storagetype";
    }

    private void refreshAccountEntry(TreeEntryGrid treeEntry, String datasetId) {
        QFilter[] memberFilters;
        String menberentityid = "epm_accountmembertree";
        String selectMemberFields = this.getSelectMemberField();
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("dataset", "=", (Object)Long.parseLong(datasetId));
        QFilter rootQf = new QFilter("number", "=", (Object)"Account");
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        Set permIds = DimMembPermUtil.getDimManagerHasPermMembIds((Long)modelId, (Long)UserUtils.getUserId(), (String)SysDimensionEnum.Account.getNumber(), null, (boolean)false);
        if (permIds == null) {
            memberFilters = new QFilter[]{qFilter.or(rootQf), modelQf};
        } else {
            QFilter perQf = new QFilter("id", "in", (Object)permIds);
            memberFilters = new QFilter[]{qFilter.and(perQf).or(rootQf), modelQf};
        }
        DynamicObjectCollection members = QueryServiceHelper.query((String)menberentityid, (String)selectMemberFields, (QFilter[])memberFilters, (String)"dseq");
        List<String> properties = this.getProperties();
        if (members.size() == 0) {
            return;
        }
        TreeEntryEntityUtils.fillTreeEntryEntityUserSeq((IDataModel)this.getModel(), (DynamicObjectCollection)members, properties, (boolean)true);
        treeEntry.setCollapse(true);
        treeEntry.expandOne(0);
        this.dealEntryLock();
        this.getView().updateView("treeentryentity");
    }

    private List<String> getProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.addAll(Arrays.asList(proArr));
        return properties;
    }

    @Override
    public Long getModelId() {
        return UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
    }

    private void dealEntryLock() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection docs = billObj.getDynamicObjectCollection("treeentryentity");
        int j = docs.size();
        for (int i = 0; i < j; ++i) {
            DynamicObject obj = (DynamicObject)docs.get(i);
            int level = obj.getInt("level");
            if (level != 0) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"number", "name", "memberid", "aggoprt", "storagetype", "accounttype", "dimentryentity", "drcrdirect", "description"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baritemsave": {
                this.batchUpdateDimMemberInfo();
            }
            case "baritemrefresh": {
                this.refreshList();
                break;
            }
            case "baritemclose": {
                this.getView().returnDataToParent((Object)"refreshList");
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        super.propertyChanged(e);
        switch (propertyKey = e.getProperty().getName()) {
            case "aggoprt": {
                this.propertyChanged_aggOprt(e);
            }
            case "accounttype": 
            case "drcrdirect": 
            case "description": {
                this.propertyChanged_propertyValue(e);
            }
        }
    }

    protected void propertyChanged_aggOprt(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas != null && changeDatas.length > 0) {
            DynamicObject account = changeDatas[0].getDataEntity();
            this.propertyChanged_propertyValue(account, CACHE_ACCOUNT_AGG_IDS);
        }
    }

    protected void propertyChanged_propertyValue(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas != null && changeDatas.length > 0) {
            DynamicObject account = changeDatas[0].getDataEntity();
            this.propertyChanged_propertyValue(account, CACHE_ACCOUNT_IDS);
        }
    }

    private void propertyChanged_propertyValue(DynamicObject account, String cacheKey) {
        if (account == null) {
            return;
        }
        Set<Long> accountIds = this.getAccountIdsFromCache(this.getPageCache(), cacheKey);
        if (accountIds == null) {
            accountIds = new HashSet<Long>();
        }
        accountIds.add(account.getLong("id"));
        this.cacheAccountIds(this.getPageCache(), cacheKey, accountIds);
    }

    private void cacheAccountIds(@NotNull IPageCache pageCache, String pageCacheKey, Set<Long> accountIds) {
        if (accountIds == null || accountIds.isEmpty()) {
            pageCache.remove(pageCacheKey);
        } else {
            pageCache.put(pageCacheKey, JSON.toJSONString(accountIds));
        }
    }

    private Set<Long> getAccountIdsFromCache(@NotNull IPageCache pageCache, String pageCacheKey) {
        String _cacheStr = pageCache.get(pageCacheKey);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)_cacheStr)) {
            return (Set)JSON.parseObject((String)_cacheStr, Set.class);
        }
        return new HashSet<Long>();
    }

    private void batchUpdateDimMemberInfo() {
        Set<Long> accountIds = this.getAccountIdsFromCache(this.getPageCache(), CACHE_ACCOUNT_IDS);
        if (accountIds == null || accountIds.isEmpty()) {
            return;
        }
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = billObj.getDynamicObjectCollection("treeentryentity");
        Map<Long, DynamicObject> entryMap = entries.stream().filter(Objects::nonNull).collect(Collectors.toMap(doc -> doc.getLong("id"), doc -> doc));
        DynamicObject[] toUpdateMembers = BusinessDataServiceHelper.load((String)"epm_accountmembertree", (String)"id,aggoprt,accounttype,drcrdirect,description", (QFilter[])new QFilter("id", "in", accountIds).toArray());
        if (toUpdateMembers != null) {
            for (DynamicObject toUpdateMember : toUpdateMembers) {
                DynamicObject doc2 = entryMap.get(toUpdateMember.getLong("id"));
                if (doc2 == null) continue;
                toUpdateMember.set("aggoprt", doc2.get("aggoprt"));
                toUpdateMember.set("accounttype", doc2.get("accounttype"));
                toUpdateMember.set("drcrdirect", doc2.get("drcrdirect"));
                toUpdateMember.set("description", doc2.get("description"));
            }
        }
        try {
            SaveServiceHelper.save((DynamicObject[])toUpdateMembers);
            CubeUtils.updateDimensionVersion((Long)this.getModelId(), (Long)this.getAndCacheDimId());
            ArrayList members = Lists.newArrayListWithExpectedSize((int)accountIds.size());
            accountIds = this.getAccountIdsFromCache(this.getPageCache(), CACHE_ACCOUNT_AGG_IDS);
            if (accountIds != null && !accountIds.isEmpty()) {
                Dataset dataset;
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId(), (boolean)true);
                Dimension accountDim = modelCache.getDimension("Account");
                for (Long _accountId : accountIds) {
                    Member parent;
                    Member member = accountDim.getMember(null, _accountId);
                    if (member == null || (parent = accountDim.getMember(null, member.getParentId())) == null) continue;
                    members.add(parent);
                }
                if (!members.isEmpty() && (dataset = DatasetServiceHelper.getInstance().getDataSet(IDUtils.toLong((Object)this.getCurrentNodeId()))) != null) {
                    ShrekConfig config = ShrekConfigServiceHelper.getBgMDConfig();
                    ShrekMemberServiceHelper.updateCubeMembers((Model)modelCache.getModelobj(), Collections.singletonList(dataset), (String)"Account", (List)members, (ShrekConfig)config);
                }
            }
            this.cacheAccountIds(this.getPageCache(), CACHE_ACCOUNT_IDS, null);
            this.cacheAccountIds(this.getPageCache(), CACHE_ACCOUNT_AGG_IDS, null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AccountMemberBatchUpdatePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"AccountMemberBatchUpdatePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Long getAndCacheDimId() {
        String dimId = this.getPageCache().get("KEY_DIM_ID");
        if (dimId != null) {
            return Long.valueOf(dimId);
        }
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter numberQf = new QFilter("number", "=", (Object)"Account");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{modelQf, numberQf});
        dimId = dynamicObject.getString("id");
        this.getPageCache().put("KEY_DIM_ID", dimId);
        return Long.valueOf(dimId);
    }

    protected void Search(String text, int selectRow, Object selectPk) {
        this.getModel().beginInit();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl("treeentryentity");
        Long dimensionID = this.getAndCacheDimId();
        String _defaultModelId = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)_defaultModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u3002", (String)"AccountMemberBatchUpdatePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = Long.valueOf(_defaultModelId);
        QFilter qcf = new QFilter("model", "=", (Object)modelId);
        QFilter qcd = new QFilter("dimension", "=", (Object)dimensionID);
        QFilter qdataset = new QFilter("dataset", "=", (Object)Long.parseLong(this.getCurrentNodeId()));
        QFilter qdroot = new QFilter("number", "=", (Object)"Account");
        QFilter[] memberFilters = new QFilter[]{qcf, qcd, qdataset.or(qdroot)};
        String selectMemberFields = this.getSelectMemberFields();
        DynamicObjectCollection members = QueryServiceHelper.query((String)this.getClass().getName(), (String)"epm_accountmembertree", (String)selectMemberFields, (QFilter[])memberFilters, (String)"dseq");
        int memberSize = members.size();
        if (memberSize == 0) {
            return;
        }
        TreeMap rowTreeMapAll = new TreeMap();
        TreeMap rowTreeMap = SearchHelper.getSearchItemId((String)text, (DynamicObjectCollection)members, rowTreeMapAll, (boolean)true);
        if (rowTreeMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AccountMemberBatchUpdatePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            treeEntry.selectRows(0);
            return;
        }
        ArrayList rowList = new ArrayList(rowTreeMap.values());
        this.getPageCache().put(rowlist, SerializationUtils.toJsonString(rowList));
        long focusID = (Long)rowList.get(0);
        this.getPageCache().put(rowcount, "0");
        if (selectRow > 0 && selectPk != null) {
            int realSelectRow = 0;
            for (Map.Entry entry : rowTreeMapAll.entrySet()) {
                if (!((Long)entry.getValue()).toString().equals(String.valueOf(selectPk))) continue;
                realSelectRow = (Integer)entry.getKey();
                break;
            }
            for (int i = realSelectRow; i < memberSize; ++i) {
                Map.Entry entrySelRow;
                if (rowTreeMap.get(i) == null) continue;
                focusID = (Long)rowTreeMap.get(i);
                Iterator iterRowTreeMap = rowTreeMap.entrySet().iterator();
                int selectRowCount = 0;
                while (iterRowTreeMap.hasNext() && !((Long)(entrySelRow = iterRowTreeMap.next()).getValue()).equals(focusID)) {
                    ++selectRowCount;
                }
                this.getPageCache().put(rowcount, selectRowCount + "");
                break;
            }
        }
        this.dealEbMembSearch(modelId, dimensionID, String.valueOf(focusID), "epm_accountmembertree", true);
        this.getPageCache().put(allshowrowid, SerializationUtils.toJsonString(new HashSet()));
        this.getModel().endInit();
    }

    public void dealEbMembSearch(Long model, Long dimension, String focusID, String entityname, boolean isCol) {
        List parentlist = SearchHelper.getOrgParentNodeList((Long)model, (Long)dimension, (String)focusID, (String)entityname);
        HashSet<String> allShowRowid = new HashSet<String>();
        allShowRowid.add(String.valueOf(focusID));
        parentlist.add(0, focusID);
        List<Integer> matchRowIndex = AccountMemberBatchUpdatePlugin.removeExistNodeForSearchShow(parentlist, this.getModel().getEntryEntity("treeentryentity"));
        if (parentlist.size() == 1) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
            entryGrid.selectRows(matchRowIndex.get(matchRowIndex.size() - 1).intValue());
            matchRowIndex.remove(matchRowIndex.size() - 1);
            int[] pRowIndexs = new int[matchRowIndex.size()];
            for (int i = 0; i < matchRowIndex.size(); ++i) {
                pRowIndexs[i] = matchRowIndex.get(i);
            }
            entryGrid.expandOne(pRowIndexs);
        } else {
            parentlist.remove(0);
            QFilter qcd = new QFilter("dimension", "=", (Object)dimension);
            for (int i = parentlist.size() - 1; i >= 0; --i) {
                String parentid = (String)parentlist.get(i);
                QFilter qf1 = new QFilter("parent", "=", (Object)parentid);
                DynamicObjectCollection theSameLevel = QueryServiceHelper.query((String)entityname, (String)"id", (QFilter[])new QFilter[]{qcd, qf1});
                if (theSameLevel == null || theSameLevel.size() <= 0) continue;
                for (DynamicObject dy : theSameLevel) {
                    allShowRowid.add(dy.getString("id"));
                }
            }
            allShowRowid.add((String)parentlist.get(parentlist.size() - 1));
            this.insertAndRefreshTreeEntry(allShowRowid, entityname, Long.parseLong(focusID), isCol, matchRowIndex.get(matchRowIndex.size() - 1), (String)parentlist.get(parentlist.size() - 1));
        }
    }

    private void insertAndRefreshTreeEntry(Set<String> allShowRowid, String entityname, long focusID, boolean col, int parentRow, String parentId) {
        QFilter qf2 = new QFilter("id", "in", (Object)allShowRowid.toArray());
        String selectFields = this.getSelectMemberFields();
        DynamicObjectCollection membercolls = QueryServiceHelper.query((String)entityname, (String)selectFields, (QFilter[])new QFilter[]{qf2});
        if (membercolls.size() == 0) {
            return;
        }
        List<String> properties = this.getPropertiesAndLeaf();
        int focusrow = 0;
        focusrow = SearchHelper.fillTreeEntryEntity((IDataModel)this.getModel(), (DynamicObjectCollection)membercolls, properties, (String)String.valueOf(focusID), (int)parentRow, (String)parentId);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl("treeentryentity");
        this.getView().updateView("treeentryentity");
        int[] eids = TreeEntryEntityUtils.focus((IDataModel)this.getModel(), (int)focusrow);
        if (col) {
            treeEntry.collapse(0);
        }
        this.collapseExpNode(parentRow + 1, membercolls.size() - 1, treeEntry);
        treeEntry.expandOne(eids);
        treeEntry.selectRows(focusrow);
    }

    private List<String> getPropertiesAndLeaf() {
        List<String> list = this.getProperties();
        list.add("isleaf");
        return list;
    }

    private void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] allRowIndexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            allRowIndexs[i] = beginRow + i;
        }
        entryGrid.collapseOne(allRowIndexs);
    }

    protected String getSelectMemberFields() {
        String selectMemberFields = "id,id as memberid,name,number,dseq,parent,aggoprt,storagetype,modifier.name as modifier,modifyTime,isleaf,level ,description ,accounttype,drcrdirect";
        return selectMemberFields;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String currentNodeId = this.getCurrentNodeId();
        if (currentNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9\u3002", (String)"AccountMemberBatchUpdatePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (c.getKey().toLowerCase()) {
            case "imageup": 
            case "imagedown": {
                this.preAndNextSearch(c.getKey().toLowerCase());
                break;
            }
        }
    }

    private void preAndNextSearch(String key) {
        if ("imageup".equals(key) || "imagedown".equals(key)) {
            String rowcache = this.getPageCache().get(rowlist);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u76f8\u5173\u5185\u5bb9", (String)"AccountMemberBatchUpdatePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long dimensionID = this.getAndCacheDimId();
            Long defaultModelId = Long.valueOf(this.getPageCache().get("model"));
            String menberentityid = "epm_accountmembertree";
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            int rowCount = Integer.parseInt(this.getPageCache().get(rowcount));
            if ("imageup".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"AccountMemberBatchUpdatePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(rowcount, String.valueOf(--rowCount));
                Long focusID = (Long)rowList.get(rowCount);
                this.dealEbMembSearch(defaultModelId, dimensionID, String.valueOf(focusID), menberentityid, false);
            } else {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"AccountMemberBatchUpdatePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(rowcount, String.valueOf(++rowCount));
                Long focusID = (Long)rowList.get(rowCount);
                this.dealEbMembSearch(defaultModelId, dimensionID, String.valueOf(focusID), menberentityid, false);
            }
        }
    }

    public static List<Integer> removeExistNodeForSearchShow(List<String> parentlist, DynamicObjectCollection currentRowObjs) {
        int lastIndex;
        int rowIndex = 0;
        int currentIndex = lastIndex = parentlist.size();
        ArrayList<Integer> pRowIndexs = new ArrayList<Integer>();
        if (!currentRowObjs.isEmpty()) {
            for (DynamicObject row : currentRowObjs) {
                String rowId = row.getString("id");
                if (parentlist.contains(rowId)) {
                    if (parentlist.indexOf(rowId) > currentIndex) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u66f4\u65b0\u6210\u5458\u7ed3\u6784\uff0c\u8bf7\u5237\u65b0\u3002", (String)"AccountMemberBatchUpdatePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    pRowIndexs.add(rowIndex);
                    currentIndex = parentlist.indexOf(rowId);
                }
                if (currentIndex == 0) break;
                ++rowIndex;
            }
        }
        if (currentIndex == lastIndex - 1 && lastIndex != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u66f4\u65b0\u6210\u5458\u7ed3\u6784\uff0c\u8bf7\u5237\u65b0\u3002", (String)"AccountMemberBatchUpdatePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (int i = lastIndex - 1; i >= 0; --i) {
            if (currentIndex >= i) continue;
            parentlist.set(i, null);
        }
        parentlist.removeIf(pid -> pid == null);
        return pRowIndexs;
    }
}

