/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.servicehelper.SearchHelper;
import kd.epm.eb.business.utils.DatasetCheckUtil;
import kd.epm.eb.business.utils.TreeEntryEntityUtils;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.DataSetPresetDimEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.DataSetAddDimEvent;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.MemberInfo;
import kd.epm.eb.common.rule.edit.OpenRulePojo;
import kd.epm.eb.common.rule.edit.OpenRulePojoTypeEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.cube.dimension.ImportAndExport.Export.AccountMemberExport;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.AbstractDimFormPlugin;
import kd.epm.eb.formplugin.dimension.action.ActionFactory;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.dimension.action.MemberCustomPropertyAction;
import kd.epm.eb.formplugin.dimension.action.MemberCutAction;
import kd.epm.eb.formplugin.dimension.action.MemberDownAction;
import kd.epm.eb.formplugin.dimension.action.MemberMoveAction;
import kd.epm.eb.formplugin.dimension.action.MemberPasteAction;
import kd.epm.eb.formplugin.dimension.action.MemberSortAction;
import kd.epm.eb.formplugin.dimension.action.MemberUpAction;
import kd.epm.eb.formplugin.rulemanage.eventbus.RuleEvent;
import kd.epm.eb.formplugin.rulemanage.eventbus.RuleEventBusUtils;
import kd.epm.eb.formplugin.rulemanage.eventbus.RuleEventTypeEnum;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.utils.BizRuleGroup.DataSetTreeCommon;
import kd.epm.eb.formplugin.utils.OpenMenuPageUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.jetbrains.annotations.NotNull;

public class DataSetListPlugin
extends AbstractDimFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public static final Log log = LogFactory.getLog(DataSetListPlugin.class);
    private static final String BTN_ADD_MEMBER = "baritemaddsub";
    private static final String BTN_ADD_LEVEL = "baritemaddlevel";
    private static final String BTN_DEL_MEMBER = "baritemdel";
    private static final String BTN_REFRESH = "baritemrefresh";
    private static final String BTN_CLOSE = "baritemclose";
    private static final String BTN_CUT = "baritemcut";
    private static final String BTN_PASTE = "baritempaste";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_CUSTOM_PROPERTY = "barcustomproperty";
    private static final String CACHE_DATASET_ID = "cache-dataset-id";
    private static final String BILLLISTAP = "billlistap";
    private static final String FOCUSNODEID = "focusnodeid";
    private static final String HEADNODEID = "headnodeid";
    public static final String KEY_DIM_ID = "KEY_DIM_ID";
    public static final String ACCOUNTDIM = "ACCOUNTDIM";
    private static final String ADD_CATALOG_CLOSECALLBACK = "ADD_CATALOG_CLOSECALLBACK";
    private static final String ADD_DATASET_CLOSECALLBACK = "ADD_DATASET_CLOSECALLBACK";
    private static final String ADD_DIM_CLOSECALLBACK = "addDimension";
    private static final String ADD_DIM_CLOSECALLBACK_NO_DEAL = "addDimensionNoDeal";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String TOOLBARAP = "toolbarap";
    protected static final String TREEVIEWAP = "treeviewap";
    public static final String MODELSWITCH = "modelswitch";
    public static final String MODELLABEL = "modellabel";
    private static String allshowrowid = "allshowrowid";
    private static String rowlist = "rowlist";
    private static String rowcount = "rowcount";
    private static final String TREE_MAPKEY_CATEGORY = "catalog";
    private static final String TREE_MAPKEY_DATA = "dataset";
    private static final String TREE_MAPKEY_TYPE = "type";
    private static final List<String> proArr = Arrays.asList("number", "shownumber", "name", "aggoprt", "storagetype", "drcrdirect", "metricdatatype", "initdatabytime", "defaultmetricname", "ctview", "ctformula", "modifier", "modifytime", "disable");
    private static int doubleClick = 0;

    public void initialize() {
        super.initialize();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntry.addHyperClickListener((HyperLinkClickListener)this);
        treeEntry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent event) {
            }

            public void cellDoubleClick(CellClickEvent event) {
                if ("modifytime".equals(event.getFieldKey())) {
                    doubleClick++;
                    if (doubleClick > 5) {
                        doubleClick = 0;
                        DataSetListPlugin.this.beforeSortMember();
                    }
                } else {
                    doubleClick = 0;
                }
            }
        });
    }

    protected void beforeSortMember() {
        String description = ResManager.loadKDString((String)"\u662f\u5426\u91cd\u65b0\u6309\u7f16\u7801\u987a\u5e8f\u751f\u6210\u5f53\u524d\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u53ca\u5144\u5f1f\u6210\u5458\u7684\u663e\u793a\u987a\u5e8f\uff1f", (String)"DataSetListPlugin_77", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("sortMemberConfirmBack", (IFormPlugin)this));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnaddcatalog", "btnadd", "btnedit", "btndel", "imageup", "imagedown", MODELSWITCH});
        this.addItemClickListeners(new String[]{TOOLBARAP, ADVCONTOOLBARAP, "toolbarap1"});
        this.addClickListeners(new String[]{BTN_DISABLE, BTN_ENABLE});
        BasedataEdit model = (BasedataEdit)this.getView().getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                DataSetListPlugin.this.treeViewMapTreeNodeClick(evt.getNodeId().toString());
            }
        });
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(evt -> {
            String key = evt.getTabKey();
            if ("dimtab".equalsIgnoreCase(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", BTN_ADD_MEMBER, BTN_DEL_MEMBER, BTN_CUT, "baritemup", "baritemsysimp", "baritembatchupdate", "barimportcc", BTN_DISABLE, BTN_ENABLE});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3", BTN_ADD_MEMBER, BTN_DEL_MEMBER, BTN_CUT, "baritemup", "baritemsysimp", "baritembatchupdate", "barimportcc", BTN_DISABLE, BTN_ENABLE});
            }
        });
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(evt -> {
            DynamicObject select;
            int selectRow = 0;
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] rows = treeEntry.getSelectRows();
            if (rows.length > 0) {
                selectRow = rows[0];
            }
            if ((select = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectRow)) == null) {
                TreeNode node = this.getSelectedNode(this.getCurrentNodeId());
                if (node == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u6570\u636e\u96c6\u4e2d\u8fdb\u884c\u641c\u7d22\u3002", (String)"DataSetListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map dataMap = (Map)node.getData();
                String type = (String)dataMap.get(TREE_MAPKEY_TYPE);
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)type)) {
                    return;
                }
                if (!TREE_MAPKEY_DATA.equals(type)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u6570\u636e\u96c6\u4e2d\u8fdb\u884c\u641c\u7d22\u3002", (String)"DataSetListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u79d1\u76ee\u3002", (String)"DataSetListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String selectPk = select.getString("id");
            if (evt.getText() != null && !"".equals(evt.getText())) {
                this.Search(evt.getText().toLowerCase().trim(), selectRow, selectPk);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"DataSetListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addPagerClickListener(evt -> this.refreshBillList());
        billList.addSetFilterListener(evt -> {
            QFilter qFilter1 = this.getQFilter(this.getCurrentNodeId());
            evt.getQFilters().add(qFilter1);
        });
    }

    public void treeViewMapTreeNodeClick(String nodeIdString) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nodeIdString)) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        this.getPageCache().put(FOCUSNODEID, nodeIdString);
        this.treeOnClick(tree);
        this.refreshDimEntry();
    }

    protected void refreshBillList() {
        String nodeId = this.getCurrentNodeId();
        QFilter qFilter1 = this.getQFilter(nodeId);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setFilter(qFilter1);
        billList.setClearSelection(true);
        billList.refresh();
    }

    protected QFilter getQFilter(String nodeId) {
        if (nodeId == null) {
            return new QFilter(TREE_MAPKEY_CATEGORY, "=", (Object)-1);
        }
        TreeNode root = this.getCacheLefTreeRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        if (node != null && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)node.getParentid())) {
            return new QFilter("model", "=", (Object)this.getModelId());
        }
        List<Long> childNodeIds = this.getNodeAllChildId(nodeId);
        QFilter qFilter = !childNodeIds.isEmpty() ? new QFilter(TREE_MAPKEY_CATEGORY, "in", childNodeIds) : new QFilter(TREE_MAPKEY_CATEGORY, "=", (Object)-1);
        return qFilter;
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLLISTAP});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DataSetListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        modelId = this.getModelIdAfterCreateNewData(modelId);
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.modelChanged(modelId);
        this.refreshDimEntry();
        this.getAndCacheDimId();
        this.getView().updateView(TREEENTRYENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabap", BTN_ADD_MEMBER, BTN_DEL_MEMBER, "writerule", "rulelist", BTN_CUT, "baritemup", "baritemsysimp", "baritembatchupdate", "barimportcc", "model", BTN_DISABLE, BTN_ENABLE, BTN_CUSTOM_PROPERTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{BILLLISTAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{"ctview", "ctformula"});
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue("model");
        String modelName = "";
        if (modelDy != null) {
            modelName = modelDy.getString("name");
        }
        ((Label)this.getControl(MODELLABEL)).setText(modelName);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes != evt.getResult()) {
            return;
        }
        switch (evt.getCallBackId()) {
            case "delMemberConfirmBack": 
            case "pasteMemberConfirmBack": 
            case "sortMemberConfirmBack": {
                this.executeAction(evt.getCallBackId(), true, new Object[0]);
                break;
            }
        }
        if (!"delete_comfirm".equals(evt.getCallBackId()) && !"paste_comfirm".equals(evt.getCallBackId())) {
            String currentNodeId;
            if ("delete_catalog".equals(evt.getCallBackId())) {
                currentNodeId = this.getCurrentNodeId();
                this.deleteCatalog(currentNodeId);
            } else if ("delete_dataset".equals(evt.getCallBackId())) {
                currentNodeId = this.getCurrentNodeId();
                if (this.existAccountInDataSet(currentNodeId, String.valueOf(this.getModelId()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0b\u5b58\u5728\u79d1\u76ee\u6210\u5458\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DataSetListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isDataSetQuote(currentNodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataSetListPlugin_76", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.deleteDataSet(currentNodeId);
                    this.refreshList();
                }
            } else if ("delete_dimNoAccount".equalsIgnoreCase(evt.getCallBackId())) {
                this.setTab(false);
                EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] rows = eg.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DataSetListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dim = (DynamicObject)this.getModel().getValue("dimname", rows[0]);
                this.getModel().beginInit();
                this.getModel().deleteEntryRows(ENTRYENTITY, rows);
                this.getModel().endInit();
                this.getView().updateView(ENTRYENTITY);
                this.saveDims();
                this.dealDeleteDim(dim);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DataSetListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isDataSetQuote(String dataSetId) {
        return QueryServiceHelper.exists((String)"bgm_targetscheme", (QFilter[])new QFilter("bizmodel", "=", (Object)Long.parseLong(dataSetId)).toArray());
    }

    public void clearCache() {
        this.clearSearchCache();
        this.clearCutCache();
    }

    protected void clearSearchCache() {
        this.getPageCache().remove(allshowrowid);
        this.getPageCache().remove(rowlist);
        this.getPageCache().remove(rowcount);
    }

    protected void clearCutCache() {
        this.getPageCache().remove("cutMemberIds");
        this.getPageCache().remove("cutViewMemberIds");
        this.getPageCache().remove(CACHE_DATASET_ID);
    }

    private void dealDeleteDim(DynamicObject dim) {
        if (dim == null) {
            return;
        }
        String number = dim.getString("number");
    }

    public void setTab(boolean isAccountTab) {
        Tab tab = (Tab)this.getControl("tabap");
        if (isAccountTab && !"accounttab".equals(tab.getCurrentTab())) {
            tab.activeTab("accounttab");
        }
    }

    protected void refreshDimEntry() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        String nodeId = this.getCurrentNodeId();
        if (nodeId == null) {
            return;
        }
        TreeNode node = this.getSelectedNode(nodeId);
        Map dataMap = (Map)node.getData();
        String type = (String)dataMap.get(TREE_MAPKEY_TYPE);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        if (TREE_MAPKEY_DATA.equals(type)) {
            List sysSet = DataSetPresetDimEnum.getNumberExcludeAccount();
            QFilter qf = new QFilter("id", "=", (Object)Long.parseLong(nodeId));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_dataset", (String)"entryentity.datasetdim.id,entryentity.datasetdim.number", (QFilter[])new QFilter[]{qf});
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5df2\u88ab\u5220\u9664\u3002", (String)"DataSetListPlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, dynamicObjects.size());
            int in = dynamicObjects.size();
            for (int i = 0; i < in; ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                String id = dynamicObject.getString("entryentity.datasetdim.id");
                if (id == null || "0".equals(id)) continue;
                this.getModel().setValue("dimname", (Object)dynamicObject.getLong("entryentity.datasetdim.id"), i);
                String number = dynamicObject.getString("entryentity.datasetdim.number");
                this.getModel().setValue("dimnumber", (Object)number, i);
                if (sysSet.contains(number)) {
                    this.getModel().setValue("issysset", (Object)"1", i);
                    continue;
                }
                this.getModel().setValue("issysset", (Object)"0", i);
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    protected void treeOnClick(TreeView tree) {
        IFormView view = this.getView();
        view.setEnable(Boolean.TRUE, new String[]{"btnaddcatalog", "btnadd"});
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        String nodeId = tree.getTreeState().getFocusNodeId();
        if (nodeId == null) {
            return;
        }
        TreeNode treeNode = this.getSelectedNode(nodeId);
        Map dataMap = (Map)treeNode.getData();
        String type = (String)dataMap.get(TREE_MAPKEY_TYPE);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        if (TREE_MAPKEY_DATA.equals(type)) {
            view.setVisible(Boolean.TRUE, new String[]{"tabap", "flexpanelap3", BTN_ADD_MEMBER, BTN_DEL_MEMBER, "writerule", "rulelist", BTN_CUT, "baritemup", "baritemsysimp", "baritembatchupdate", "barimportcc", BTN_DISABLE, BTN_ENABLE, BTN_CUSTOM_PROPERTY});
            view.setVisible(Boolean.FALSE, new String[]{BILLLISTAP});
            view.setEnable(Boolean.FALSE, new String[]{"btnaddcatalog", "btnadd"});
            this.setTab(true);
            this.refreshAccountEntry(treeEntry, nodeId);
        } else {
            int level = this.getCatalogLevel(nodeId);
            if (level >= 3) {
                view.setEnable(Boolean.FALSE, new String[]{"btnaddcatalog"});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"btnaddcatalog"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "tabap", BTN_ADD_MEMBER, BTN_DEL_MEMBER, "writerule", "rulelist", BTN_CUT, "baritemup", "baritemsysimp", "baritembatchupdate", "barimportcc", BTN_DISABLE, BTN_ENABLE, BTN_CUSTOM_PROPERTY});
            view.setVisible(Boolean.TRUE, new String[]{BILLLISTAP});
            this.refreshBillList();
        }
        this.clearCache();
        this.getPageCache().put(FOCUSNODEID, nodeId);
    }

    private void refreshAccountEntry(TreeEntryGrid treeEntry, String datasetId) {
        String menberentityid = "epm_accountmembertree";
        String selectMemberFields = this.getSelectMemberField();
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter(TREE_MAPKEY_DATA, "=", (Object)Long.parseLong(datasetId));
        QFilter rootQf = new QFilter("number", "=", (Object)"Account");
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter[] memberFilters = null;
        memberFilters = new QFilter[]{qFilter.or(rootQf), modelQf, new QFilter("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex())};
        HashMap formulaMap = new HashMap();
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)menberentityid, (String)selectMemberFields, (QFilter[])memberFilters, (String)"dseq");
        for (DynamicObject dobj : dobjs = this.reGetMember(dobjs, menberentityid, selectMemberFields)) {
            String formula;
            DynamicObjectCollection d = dobj.getDynamicObjectCollection(ENTRYENTITY);
            if (d == null || d.size() == 0) continue;
            int index = 0;
            for (int i = 0; i < d.size(); ++i) {
                if (!"Money".equals(((DynamicObject)d.get(i)).getString("metric.number"))) continue;
                index = i;
            }
            dobj.set("defaultmetricname", (Object)((DynamicObject)d.get(index)).getString("metric.name"));
            dobj.set("metricdatatype", (Object)((DynamicObject)d.get(index)).getLong("metric.datatype"));
            dobj.set("initdatabytime", (Object)((DynamicObject)d.get(index)).getLong("databytime"));
            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dobj.getString("ctmember")) || !kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(formula = (String)formulaMap.get(dobj.getString("ctmember") + "_" + dobj.getString("ctview.id"))))) continue;
            dobj.set("ctformula", (Object)formula);
        }
        DynamicObjectCollection members = new DynamicObjectCollection();
        members.addAll(Arrays.asList(dobjs));
        List<String> properties = this.getProperties();
        if (members.size() == 0) {
            return;
        }
        TreeEntryEntityUtils.fillTreeEntryEntityUserSeq((IDataModel)this.getModel(), (DynamicObjectCollection)members, properties, (boolean)true);
        treeEntry.setCollapse(true);
        treeEntry.expandOne(0);
        this.getView().updateView(TREEENTRYENTITY);
    }

    private List<String> getProperties() {
        return proArr;
    }

    protected String getSelectMemberField() {
        String selectMemberFields = "id,name,number,shownumber,dseq,parent,aggoprt,storageType,isleaf,level,drcrdirect,description, accounttype,metricdatatype,initdatabytime,defaultmetricname,entryentity.metric,entryentity.databytime,ctview,ctformula,ctmember,modifytime,modifier,disable";
        return selectMemberFields;
    }

    public Long getAndCacheDimId() {
        String dimId = this.getPageCache().get(KEY_DIM_ID);
        if (dimId != null) {
            return Long.valueOf(dimId);
        }
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter numberQf = new QFilter("number", "=", (Object)"Account");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{modelQf, numberQf});
        if (dynamicObject == null) {
            return 0L;
        }
        dimId = dynamicObject.getString("id");
        this.getPageCache().put(KEY_DIM_ID, dimId);
        return Long.valueOf(dimId);
    }

    private String getDimensionId(String number) {
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter numberQf = new QFilter("number", "=", (Object)number);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{modelQf, numberQf});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("id");
    }

    private String getSelectNumber() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        int[] rows = treeEntry.getSelectRows();
        if (rows.length > 0) {
            DynamicObject d = this.getModel().getEntryRowEntity(TREEENTRYENTITY, rows[0]);
            return d.getString("number");
        }
        return null;
    }

    private void addNew(String key, String datasetId) {
        Long selectMemberId = this.getSelectMemberId();
        if (IDUtils.isNull((Long)selectMemberId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DataSetListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long dimensionId = this.getAndCacheDimId();
        Long modelId = this.getModelId();
        DimManagerInfo dimInfo = new DimManagerInfo(modelId.longValue(), dimensionId.longValue(), selectMemberId.longValue());
        IAction action = ActionFactory.getAction(DimMembActionEnum.ADDCHILD, this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
        action.beforeAction();
        if (!action.isBeforeAction()) {
            return;
        }
        this.clearCache();
        String dimensionName = ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DataSetListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String entityId = "epm_accountmembertree";
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(entityId);
        showParameter.setCustomParam("id", (Object)selectMemberId);
        showParameter.setCustomParam("dimensionName", (Object)dimensionName);
        showParameter.setCustomParam("entityId", (Object)entityId);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        showParameter.setCustomParam("actionName", (Object)key);
        showParameter.setCustomParam("dimensionId", (Object)this.getAndCacheDimId());
        showParameter.setCustomParam("dimensionNumber", (Object)"Account");
        showParameter.setCustomParam("pageid", (Object)this.getView().getPageId());
        showParameter.setCustomParam(TREE_MAPKEY_DATA, (Object)datasetId);
        showParameter.setCustomParam("isSysDim", (Object)"1");
        showParameter.setCustomParam("addcontinue", (Object)"0");
        showParameter.setCaption(ResManager.loadResFormat((String)"%1\u6210\u5458", (String)"DataSetListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionName}));
        String selectFields = "level,number,membersource";
        QFilter fdimenId = new QFilter("id", "=", (Object)selectMemberId);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityId, (String)selectFields, (QFilter[])filters, null);
        int level = ((DynamicObject)dcs.get(0)).getInt("level");
        if (BTN_ADD_MEMBER.equals(key)) {
            showParameter.setCustomParam("level", (Object)String.valueOf(level + 1));
            showParameter.setCustomParam("parentId", (Object)selectMemberId);
        } else if (BTN_ADD_LEVEL.equals(key)) {
            showParameter.setCustomParam("level", (Object)String.valueOf(level));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject getSelectMember(Long selectMemberId) {
        return QueryServiceHelper.queryOne((String)"epm_accountmembertree", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectMemberId)});
    }

    protected Long getSelectMemberId() {
        int selectIndex = 0;
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows != null && rows.length > 0) {
            selectIndex = rows[rows.length - 1];
        }
        if (selectIndex < 0) {
            return 0L;
        }
        DynamicObject select = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectIndex);
        if (select != null) {
            return select.getLong("id");
        }
        return 0L;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if ("model".equals(e.getProperty().getName())) {
            Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
            if (IDUtils.isNotNull((Long)modelId)) {
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                this.modelChanged(modelId);
                this.refreshList();
            } else {
                this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            }
            this.getPageCache().put("isModelAdmin", null);
        }
    }

    public void modelChanged(Long modelId) {
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.initTree(null, modelId, Boolean.TRUE);
        this.getView().updateView(TREEVIEWAP);
        this.getPageCache().put("model", modelId.toString());
        this.getPageCache().put("modelNum", null);
        this.getPageCache().put(KEY_DIM_ID, null);
        this.getPageCache().put(ACCOUNTDIM, null);
        this.refreshBillList();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String actionKey = evt.getItemKey();
        if (BTN_CLOSE.equals(actionKey)) {
            return;
        }
        if (BTN_REFRESH.equals(actionKey)) {
            this.refreshDimEntry();
            this.refreshMembers();
            return;
        }
        if (BTN_DISABLE.equals(actionKey) || BTN_ENABLE.equals(actionKey)) {
            Long modelId = this.getModelId();
            String dimNumber = SysDimensionEnum.Account.getNumber();
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setCanSelectRoot(false);
            f7Param.setDatasetId(Long.valueOf(this.getCurrentDatasetId()));
            if (BTN_DISABLE.equals(actionKey)) {
                f7Param.setForDisable(true);
            } else {
                f7Param.setForEnable(true);
            }
            f7Param.setShowDisable(true);
            f7Param.setShowDisableVisible(false);
            f7Param.setVerifyManagerPermission(true);
            f7Param.setVerifyPermission(false);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionKey));
            return;
        }
        DimManagerInfo dimInfo = this.getDimManagerInfo();
        if (dimInfo == null) {
            return;
        }
        if (!this.memberPermCheck(actionKey, dimInfo)) {
            return;
        }
        switch (actionKey) {
            case "add": {
                if (!this.checkBeforeClick()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6570\u636e\u96c6\u4e0d\u53ef\u589e\u52a0\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.addSelectDim(this.getCurrentNodeId());
                break;
            }
            case "delete": {
                this.deleteSelectDim(dimInfo.getModelId(), this.getCurrentNodeId());
                break;
            }
            case "baritemaddsub": 
            case "baritemaddlevel": {
                if (!this.checkBeforeClick()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6570\u636e\u96c6\u4e0d\u53ef\u589e\u52a0\u79d1\u76ee\u3002", (String)"DataSetListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.addNew(actionKey, this.getCurrentNodeId());
                break;
            }
            case "baritemdel": {
                this.beforeDeleteMember(actionKey);
                break;
            }
            case "baritemcut": 
            case "baritempaste": {
                this.setTab(true);
                this.memberCutAndPaste(actionKey, dimInfo);
                break;
            }
            case "baritemdowm": 
            case "baritemup": {
                this.setTab(true);
                this.downAndUpMember(actionKey, dimInfo);
                break;
            }
            case "baritemsysimp": {
                if (!this.checkBeforeClick()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6", (String)"DataSetListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.systemImport();
                break;
            }
            case "barimportcc": {
                if (!this.checkBeforeClick()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6", (String)"DataSetListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openImportPage();
                break;
            }
            case "barexportcc": {
                if (!this.checkBeforeClick()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6", (String)"DataSetListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.accountExport();
                break;
            }
            case "baritembatchupdate": {
                this.jumpToBatchUpdatePage();
                break;
            }
            case "writerule": {
                if (!this.checkBeforeClick()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6", (String)"DataSetListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                OpenRulePojo openRulePojo = new OpenRulePojo();
                openRulePojo.setTypeString(OpenRulePojoTypeEnum.NEW.name());
                openRulePojo.setModelIdLong(this.getModelId());
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Long businessModelIdLong = modelCacheHelper.getBusModelByDataSet(ObjUtils.getLong((Object)this.getCurrentNodeId()));
                openRulePojo.setBusinessModelIdLong(businessModelIdLong);
                RuleUtils.openRule(this.getView(), openRulePojo);
                break;
            }
            case "rulelist": {
                this.showRuleForm("eb_bizrulegrouplist2", dimInfo.getModelId(), null, ResManager.loadKDString((String)"\u89c4\u5219\u5217\u8868", (String)"DataSetListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "barcustomproperty": {
                this.customProperty(actionKey);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate _operate = (FormOperate)args.getSource();
            this.checkPermission(this.getView(), _operate.getOperateKey());
            DimManagerInfo dimInfo = this.getDimManagerInfo();
            if (dimInfo == null) {
                return;
            }
            switch (_operate.getOperateKey()) {
                case "adddim": {
                    if (!this.checkBeforeClick()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6570\u636e\u96c6\u4e0d\u53ef\u589e\u52a0\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.addSelectDim(this.getCurrentNodeId());
                    break;
                }
                case "deletedim": {
                    this.deleteSelectDim(dimInfo.getModelId(), this.getCurrentNodeId());
                }
            }
        }
    }

    @Override
    protected DimManagerInfo getDimManagerInfo() {
        long selectMemberId = this.getSelectMemberId();
        if (IDUtils.isNull((long)selectMemberId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DataSetListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long modelId = this.getModelId();
        long dimensionId = this.getAndCacheDimId();
        DimManagerInfo dimInfo = new DimManagerInfo(modelId, dimensionId, selectMemberId);
        dimInfo.setDataset(this.getCurrentDatasetId());
        return dimInfo;
    }

    @Override
    protected IAction getAction(String actionKey, DimManagerInfo dimInfo) {
        IAction action = null;
        switch (actionKey) {
            case "baritemcut": {
                action = new MemberCutAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setActionKey("btn_cut");
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "baritempaste": 
            case "pasteMemberConfirmBack": {
                action = new MemberPasteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setActionKey("btn_paste");
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "baritemdel": 
            case "delMemberConfirmBack": {
                action = ActionFactory.getAction(DimMembActionEnum.DELETE, this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "sortMemberConfirmBack": {
                action = new MemberSortAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setActionKey("btn_editmember");
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "barcustomproperty": {
                action = new MemberCustomPropertyAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setActionKey(BTN_CUSTOM_PROPERTY);
                break;
            }
        }
        return action;
    }

    private void deleteSelectDim(Long modelId, String curNodeId) {
        this.setTab(false);
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DataSetListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("dimname", rows[0]);
        if (dynamicObject != null) {
            Long dimensionId = dynamicObject.getLong("id");
            String number = dynamicObject.getString("number");
            List preList = DataSetPresetDimEnum.getNumberExcludeAccount();
            if (preList.contains(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7ef4\u5ea6\u4e0d\u53ef\u5220\u9664\u3002", (String)"DataSetListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long datasetId = 0L;
            TreeNode currentNode = this.getSelectedNode(this.getCurrentNodeId());
            if (currentNode != null) {
                datasetId = Long.valueOf(currentNode.getId());
            }
            CheckQuote checkQuote = QuoteBuilder.build((Long)modelId, (Long)dimensionId, (Long)dimensionId, (MemberTypeEnum)MemberTypeEnum.DIMENSION);
            checkQuote.setDatasetId(datasetId);
            checkQuote.addExclude(MemberQuoteResourceEnum.BusinessModel);
            checkQuote.addExclude(MemberQuoteResourceEnum.DimView);
            checkQuote.addExclude(MemberQuoteResourceEnum.CustomProperty);
            QuoteCheckResult check = MemberQuote.get().checkQuoteResult(checkQuote);
            if (check.isHasQuote()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DimDeleteAction_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), check.getMsg(), MessageTypes.Default);
                return;
            }
            if (DatasetCheckUtil.checkQutoByTemplate((Long)modelId, (Long)Long.parseLong(curNodeId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u5df2\u5f15\u7528\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (DatasetCheckUtil.checkQutoByBizrule((long)modelId, (long)Long.parseLong(curNodeId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5df2\u5f15\u7528\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_70", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (DatasetCheckUtil.checkQutoByApllyTemplate((Long)modelId, (Long)Long.parseLong(curNodeId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u7533\u62a5\u6a21\u677f\u5df2\u5f15\u7528\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_72", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkDeleteDimension(modelId, curNodeId, dynamicObject.getLong("id"))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6240\u9009\u7ef4\u5ea6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataSetListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_dimNoAccount", (IFormPlugin)this));
            }
        }
    }

    private boolean checkDeleteDimension(Long modelId, String datasetId, Long dimensionId) {
        boolean re = true;
        try {
            CubeUtils.get().checkDeleteDimension(modelId, Long.valueOf(datasetId), dimensionId);
        }
        catch (KDBizException ex) {
            re = false;
            this.getView().showTipNotification(ex.getMessage());
        }
        return re;
    }

    private List<Long> getIsRelateIds() {
        String dataSetId = this.getCurrentNodeId();
        ArrayList<Long> curIds = new ArrayList<Long>();
        DynamicObjectCollection currentDataAccount = this.loadAccountInDataSet(dataSetId);
        if (currentDataAccount == null || currentDataAccount.size() == 0) {
            return curIds;
        }
        for (DynamicObject dynamicObject : currentDataAccount) {
            if (!dynamicObject.getBoolean("isrelated")) continue;
            curIds.add(dynamicObject.getLong("id"));
        }
        return curIds;
    }

    private boolean checkBeforeClick() {
        TreeNode node = this.getSelectedNode(this.getCurrentNodeId());
        if (node == null) {
            return false;
        }
        Map dataMap = (Map)node.getData();
        String type = (String)dataMap.get(TREE_MAPKEY_TYPE);
        return !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)type) && TREE_MAPKEY_DATA.equals(type);
    }

    private void showRuleForm(String entity, Long modelId, Long dataSetId, String caption) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("MODELID", (Object)modelId);
        formShowParameter.setFormId(entity);
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long dataSetIdLong = ObjUtils.getLong((Object)this.getCurrentNodeId());
        LambdaUtils.run(() -> {
            if (!ObjUtils.notNullOrZero((Long[])new Long[]{dataSetIdLong})) {
                return;
            }
            formShowParameter.setCustomParam("DATASETID", (Object)dataSetIdLong);
            DynamicObject bizModelObj = DatasetServiceHelper.getBusModelObjByDataset((Long)dataSetIdLong);
            if (bizModelObj == null) {
                return;
            }
            formShowParameter.setCustomParam("bizModelId", (Object)bizModelObj.getLong("id"));
        });
        if (IDUtils.isNotNull((Long)dataSetId)) {
            this.getView().showForm(formShowParameter);
        } else {
            String markId;
            String menuPageID;
            IFormView parentView = this.getView().getParentView();
            IFormView mainView = this.getView().getMainView();
            if (mainView.getView(menuPageID = (markId = OpenMenuPageUtil.getMarkIdByFormApp(entity, parentView)) + mainView.getPageId()) != null) {
                IFormView childFormView = mainView.getView(menuPageID);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            } else {
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                formShowParameter.setPageId(menuPageID);
                IFormView appPageView = this.getView().getView(parentView.getPageId());
                appPageView.showForm(formShowParameter);
                this.getView().sendFormAction(appPageView);
            }
        }
    }

    private void jumpToBatchUpdatePage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        formShowParameter.setFormId("eb_accountupdate");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"DataSetListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchUpdate"));
        this.getView().showForm(formShowParameter);
    }

    public void accountExport() {
        try {
            AccountMemberExport export = new AccountMemberExport("epm_accountmembertree", this.getModelId().longValue(), this.getAndCacheDimId().longValue(), Long.parseLong(this.getCurrentNodeId()));
            String url = export.exportData();
            if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
                POIUtils.downloadFile((IFormView)this.getView(), (String)url);
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"accountExport", (Throwable)ex);
        }
    }

    public void openImportPage() {
        Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
        Long dimensionID = this.getAndCacheDimId();
        boolean exist = QueryServiceHelper.exists((String)"epm_model", (Object)modelId);
        if (!exist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u9519\u8bef\u6216\u4e0d\u5b58\u5728\u3002", (String)"DataSetListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam(TREE_MAPKEY_DATA, (Object)Long.parseLong(this.getCurrentNodeId()));
        showParameter.setCustomParam("dimensionId", (Object)dimensionID);
        showParameter.setCustomParam("memberKey", (Object)"epm_accountmembertree");
        showParameter.setCustomParam("dimensionNumber", (Object)"Account");
        showParameter.setCustomParam("dimensionName", (Object)ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DataSetListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCaption(ResManager.loadKDString((String)"\u79d1\u76ee - \u5bfc\u5165", (String)"DataSetListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.importplugin.AccountMemberImport");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importPage");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void systemImport() {
        this.clearCache();
        Long dimensionID = this.getAndCacheDimId();
        Long modelID = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
        String selectFields = "name,number,membermodel,issysdimension,dseq";
        QFilter fdimenId = new QFilter("id", "=", (Object)dimensionID);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
        if (dcs != null && dcs.size() == 1) {
            String dimensionName = ((DynamicObject)dcs.get(0)).getString("name");
            String membermodel = ((DynamicObject)dcs.get(0)).getString("membermodel");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epm_sysimport_account");
            showParameter.setCustomParam("dimensionName", (Object)dimensionName);
            showParameter.setCustomParam("memberKey", (Object)membermodel);
            showParameter.setCustomParam("dimensionId", (Object)dimensionID);
            showParameter.setCustomParam("datasetId", (Object)this.getCurrentNodeId());
            showParameter.setCustomParam("dataset_number", (Object)this.getCurrentDatasetNumber());
            showParameter.setCustomParam("dimensionNumber", (Object)"Account");
            showParameter.setCustomParam("model", (Object)modelID);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7cfb\u7edf\u5bfc\u5165 - \u79d1\u76ee", (String)"DataSetListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "sysimport");
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private String getCurrentDatasetNumber() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        TreeNode selectedNode = this.getSelectedNode(nodeId);
        if (selectedNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"DataSetListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map nodeDatas = (Map)selectedNode.getData();
        return (String)nodeDatas.get("dataset_number");
    }

    private long getCurrentDatasetId() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        TreeNode selectedNode = this.getSelectedNode(nodeId);
        if (selectedNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"DataSetListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map dataMap = (Map)selectedNode.getData();
        if (TREE_MAPKEY_DATA.equals(dataMap.get(TREE_MAPKEY_TYPE))) {
            return Long.parseLong(nodeId);
        }
        return 0L;
    }

    private DynamicObject getSelectMember() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        int selectIndex = 0;
        int[] rows = treeEntry.getSelectRows();
        if (rows != null && rows.length > 0) {
            selectIndex = rows[rows.length - 1];
        }
        if (selectIndex < 0) {
            return null;
        }
        return this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downAndUpMember(String actionKey, DimManagerInfo dimInfo) {
        block8: {
            MemberMoveAction action;
            this.clearCache();
            LogStats stats = new LogStats("member-log:");
            if ("baritemup".equals(actionKey)) {
                action = new MemberUpAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setActionKey("btn_upmove");
            } else {
                action = new MemberDownAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setActionKey("btn_downmove");
            }
            action.setPermKey(DimMembActionEnum.EDIT.getKey());
            action.setStats(stats);
            stats.add("begin-" + action.getActionKey());
            try {
                action.beforeAction();
                if (!action.isBeforeAction()) break block8;
                try {
                    action.doAction();
                }
                finally {
                    action.afterAction();
                }
            }
            finally {
                stats.addInfo("end-" + action.getActionKey());
                log.info(stats.toString());
            }
        }
    }

    public void forceMember(DimManagerInfo dimInfo) {
        if (dimInfo == null) {
            return;
        }
        boolean force = false;
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(TREEENTRYENTITY);
        if (dimInfo.getMember().getSeq() >= 0 && dimInfo.getMember().getSeq() < dcs.size() && ((DynamicObject)dcs.get(dimInfo.getMember().getSeq())).getString("number").equals(dimInfo.getMember().getNumber())) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            entryGrid.selectRows(dimInfo.getMember().getSeq());
            force = true;
        }
        if (!force) {
            int count = dcs.size();
            for (int index = 0; index < count; ++index) {
                if (!((DynamicObject)dcs.get(index)).getString("number").equals(dimInfo.getMember().getNumber())) continue;
                TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
                entryGrid.selectRows(index);
                break;
            }
        }
    }

    private void memberCutAndPaste(String actionKey, DimManagerInfo dimInfo) {
        DynamicObject object = this.getSelectMember(dimInfo.getMemberId());
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6210\u5458\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c\u3002", (String)"DataSetListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String datasetId = this.getCurrentNodeId();
        dimInfo.setDataset(Long.parseLong(datasetId));
        if (BTN_CUT.equals(actionKey)) {
            this.cacheAllSub(dimInfo);
            this.getPageCache().put(CACHE_DATASET_ID, datasetId);
        } else {
            String oldDatasetId = this.getPageCache().get(CACHE_DATASET_ID);
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)oldDatasetId) || !oldDatasetId.equals(datasetId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5c06\u79d1\u76ee\u7c98\u8d34\u5230\u5176\u4ed6\u6570\u636e\u96c6\u4e0b\u3002", (String)"DataSetListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        IAction action = this.getAction(actionKey, dimInfo);
        if (action != null) {
            this.executeAction(action, false);
        }
    }

    protected void beforeDeleteMember(String actionKey) {
        Long selectMemberId = this.getSelectMemberId();
        if (IDUtils.isNull((Long)selectMemberId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DataSetListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DimManagerInfo dimInfo = this.getDimManagerInfo();
        IAction action = this.getAction(actionKey, dimInfo);
        if (action != null) {
            this.executeAction(action, false);
        }
    }

    protected void customProperty(String actionKey) {
        DimManagerInfo dimInfo = this.getDimManagerInfo();
        IAction action = this.getAction(actionKey, dimInfo);
        if (action != null) {
            this.executeAction(action, false);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String currentNodeId = this.getCurrentNodeId();
        if (currentNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5de6\u6811\u8282\u70b9\u3002", (String)"DataSetListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode currentNode = this.getSelectedNode(currentNodeId);
        Map dataMap = (Map)currentNode.getData();
        String type = (String)dataMap.get(TREE_MAPKEY_TYPE);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        switch (c.getKey().toLowerCase()) {
            case "btnaddcatalog": {
                if (TREE_MAPKEY_DATA.equals(type)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0b\u4e0d\u53ef\u65b0\u589e\u5206\u7c7b\u3002", (String)"DataSetListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showFormCatalog(currentNodeId, true);
                break;
            }
            case "btnadd": {
                if (TREE_MAPKEY_DATA.equals(type)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u65b0\u589e\u5b50\u7ea7\u6570\u636e\u96c6\u3002", (String)"DataSetListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)currentNode.getParentid())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u5206\u7c7b\u3002", (String)"DataSetListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showFormDataset(currentNodeId, true);
                break;
            }
            case "btnedit": {
                if (TREE_MAPKEY_CATEGORY.equals(type)) {
                    this.showFormCatalog(currentNodeId, false);
                    break;
                }
                if (!TREE_MAPKEY_DATA.equals(type)) break;
                this.showFormDataset(currentNodeId, false);
                break;
            }
            case "btndel": {
                if ("default".equals(dataMap.get("dataset_number"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u7cfb\u7edf\u9ed8\u8ba4\u7684\u5206\u7c7b\u6216\u6570\u636e\u96c6\u3002", (String)"DataSetListPlugin_71", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (TREE_MAPKEY_CATEGORY.equals(type)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u8be5\u6570\u636e\u96c6\u5206\u7c7b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataSetListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_catalog", (IFormPlugin)this));
                    break;
                }
                if (!TREE_MAPKEY_DATA.equals(type)) break;
                Long modelId = this.getModelId();
                Long datasetId = Long.valueOf(currentNode.getId());
                CheckQuote checkQuote = QuoteBuilder.build((Long)modelId, (Long)0L, (Long)datasetId, (MemberTypeEnum)MemberTypeEnum.DATASET);
                QuoteCheckResult check = MemberQuote.get().checkQuoteResult(checkQuote);
                if (check.isHasQuote()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataSetListPlugin_76", (String)"epm-eb-formplugin", (Object[])new Object[0]), check.getMsg(), MessageTypes.Default);
                    return;
                }
                if (DatasetCheckUtil.checkQutoByTemplate((Long)modelId, (Long)datasetId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u5df2\u5f15\u7528\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ExecuteAnalyseUtil.getInstance().checkQuoteByExec(modelId, datasetId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u96c6\u5df2\u88ab\u9884\u7b97\u5206\u6790\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataSetListPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u8be5\u6570\u636e\u96c6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataSetListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_dataset", (IFormPlugin)this));
                break;
            }
            case "imageup": 
            case "imagedown": {
                this.setTab(true);
                this.preAndNextSearch(c.getKey().toLowerCase());
                break;
            }
            case "modelswitch": {
                BasedataEdit clickModel = (BasedataEdit)this.getView().getControl("model");
                clickModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                clickModel.click();
            }
        }
    }

    private int getCatalogLevel(String nodeId) {
        DynamicObject catalog = QueryServiceHelper.queryOne((String)"eb_datasetcatalog", (String)"id,longname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(nodeId))});
        if (catalog == null || kd.bos.util.StringUtils.isEmpty((String)catalog.getString("longname"))) {
            return 0;
        }
        String longname = catalog.getString("longname");
        String[] number = longname.split("\\.");
        return number.length;
    }

    private boolean existAccountInDataSet(String datasetId, String modelId) {
        QFilter modelQf = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        QFilter qFilter = new QFilter(TREE_MAPKEY_DATA, "=", (Object)Long.parseLong(datasetId));
        return QueryServiceHelper.exists((String)"epm_accountmembertree", (QFilter[])new QFilter[]{modelQf, qFilter});
    }

    private void preAndNextSearch(String key) {
        if ("imageup".equals(key) || "imagedown".equals(key)) {
            String rowcache = this.getPageCache().get(rowlist);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u76f8\u5173\u5185\u5bb9", (String)"DataSetListPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long dimensionID = this.getAndCacheDimId();
            Long defaultModelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
            String menberentityid = "epm_accountmembertree";
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            int rowCount = Integer.parseInt(this.getPageCache().get(rowcount));
            if ("imageup".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DataSetListPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(rowcount, String.valueOf(--rowCount));
                Long focusID = (Long)rowList.get(rowCount);
                this.dealEbMembSearch(defaultModelId, dimensionID, String.valueOf(focusID), menberentityid, false);
            } else {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DataSetListPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(rowcount, String.valueOf(++rowCount));
                Long focusID = (Long)rowList.get(rowCount);
                this.dealEbMembSearch(defaultModelId, dimensionID, String.valueOf(focusID), menberentityid, false);
            }
        }
    }

    private void addSelectDim(@NotNull String datasetId) {
        List<String> dims = this.getEntryEntiryDimsNumber();
        Long businessModelId = DatasetServiceHelper.getInstance().queryBizmodelByDatasetId(Long.valueOf(Long.parseLong(datasetId)));
        if (IDUtils.isNull((Long)businessModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u4e3a\u7a7a\u3002", (String)"DataSetListPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_dimselect");
        showParameter.setCustomParam("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        showParameter.setCustomParam("existdims", (Object)SerializationUtils.serializeToBase64(dims));
        showParameter.setCustomParam(TREE_MAPKEY_DATA, (Object)datasetId);
        showParameter.setCustomParam("bizId", (Object)String.valueOf(businessModelId));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_DIM_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    private String getCurrentNodeId() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        return treeView.getTreeState().getFocusNodeId();
    }

    private void deleteCatalog(String nodeId) {
        TreeNode currentNode = this.getSelectedNode(nodeId);
        if (currentNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"DataSetListPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String parentId = currentNode.getParentid();
        if ("0".equals(parentId) || "".equals(parentId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u53ef\u5220\u9664\u3002", (String)"DataSetListPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            List<Long> childNodeIds = this.getNodeAllChildId(nodeId);
            if (!childNodeIds.isEmpty()) {
                QFBuilder qb = new QFBuilder(new QFilter(TREE_MAPKEY_CATEGORY, "in", childNodeIds));
                if (QueryServiceHelper.exists((String)"eb_dataset", (QFilter[])qb.toArrays())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u6216\u4e0b\u7ea7\u5b50\u8282\u70b9\u5b58\u5728\u6570\u636e\u96c6\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DataSetListPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                qb = new QFBuilder(new QFilter("id", "in", childNodeIds));
                DeleteServiceHelper.delete((String)"eb_datasetcatalog", (QFilter[])qb.toArrays());
                this.initTree(null, this.getModelId(), true);
            }
        }
    }

    private void deleteDataSet(String nodeId) {
        if (nodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u3002", (String)"DataSetListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            TreeNode currentNode = this.getSelectedNode(nodeId);
            if (currentNode == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"DataSetListPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Long modelId = this.getModelId();
            Long datasetId = Long.valueOf(currentNode.getId());
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            if (model == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataSetListPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            CubeUtils utils = CubeUtils.get();
            if (utils.checkDeleteDataSet(modelId, datasetId)) {
                utils.deleteDataSet(modelId, datasetId);
            }
            if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
                Map datasetMap = BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)"id, number", (QFilter[])new QFilter("id", "=", (Object)datasetId).toArray());
                Model _model = Model.of((DynamicObject)model);
                List _datasets = Dataset.of((Map)datasetMap);
                try {
                    for (Dataset _dataset : _datasets) {
                        if (!ShrekOlapServiceHelper.existCube((Model)_model, (Dataset)_dataset)) continue;
                        ShrekOlapServiceHelper.dropCube((Model)_model, Collections.singletonList(_dataset));
                    }
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
            }
            QFBuilder qb = new QFBuilder(new QFilter("id", "=", (Object)datasetId));
            DeleteServiceHelper.delete((String)"eb_dataset", (QFilter[])qb.toArrays());
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "DataSetListPlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6570\u636e\u96c6\u5220\u9664\u6210\u529f\u3002", "DataSetListPlugin_57", "epm-eb-formplugin"));
            this.initTree(null, this.getModelId(), true);
        }
    }

    public List<Long> getNodeAllChildId(String nodeId) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ids.add(Long.parseLong(nodeId));
        QFBuilder qb = new QFBuilder(new QFilter("model", "=", (Object)this.getModelId()));
        qb.add("longname", "like", (Object)("%" + nodeId + "%"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_datasetcatalog", (String)"id", (QFilter[])qb.toArrays(), null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong("id"));
        }
        dataSet.close();
        return ids;
    }

    private void showFormCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("model", this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CATALOG_CLOSECALLBACK);
        if (isAddNew) {
            long id = Long.parseLong(nodeId);
            params.put("parent", id);
            this.showForm("eb_datasetcatalog", params, closeCallBack, 0L);
        } else if (nodeId.equals(this.getPageCache().get(HEADNODEID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u53ef\u4fee\u6539\u3002", (String)"DataSetListPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            long id = Long.parseLong(nodeId);
            this.showForm("eb_datasetcatalog", params, closeCallBack, id);
        }
    }

    private void showFormDataset(String nodeId, boolean isAddNew) {
        if (nodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6570\u636e\u96c6\u5206\u7c7b\u3002", (String)"DataSetListPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("model", this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_DATASET_CLOSECALLBACK);
        if (isAddNew) {
            params.put(TREE_MAPKEY_CATEGORY, nodeId);
            this.showForm("eb_dataset", params, closeCallBack, 0L);
        } else {
            long id = Long.parseLong(nodeId);
            this.showForm("eb_dataset", params, closeCallBack, id);
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void setDefaultDim(Long modelId, String returnData) {
        long datasetId = Long.parseLong(returnData);
        QFilter dataQf = new QFilter("id", "=", (Object)datasetId);
        QFilter existdimQf = new QFilter("entryentity.datasetdim.number", "in", (Object)DataSetPresetDimEnum.getNumberExcludeAccount());
        boolean isExist = QueryServiceHelper.exists((String)"eb_dataset", (QFilter[])new QFilter[]{dataQf, existdimQf});
        if (isExist) {
            this.syncOlapData(datasetId);
            return;
        }
        String entity = "epm_dimension";
        String selects = "id,number,name,dseq";
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter dimQf = new QFilter("number", "in", (Object)DataSetPresetDimEnum.getNumberExcludeAccount());
        DynamicObjectCollection dims = QueryServiceHelper.query((String)entity, (String)selects, (QFilter[])new QFilter[]{modelQf, dimQf});
        DynamicObject dataset = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"eb_dataset");
        DynamicObjectCollection dcs = dataset.getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject dim : dims) {
            DynamicObject d = new DynamicObject(dcs.getDynamicObjectType());
            d.set("datasetdim", (Object)dim.getLong("id"));
            dcs.add((Object)d);
        }
        dataset.set(ENTRYENTITY, (Object)dcs);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataset});
        DynamicObject modelObj = dataset.getDynamicObject("model");
        if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)modelObj)) {
            dataset = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"eb_dataset");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            ShrekOlapServiceHelper.createCube((Model)Model.of((DynamicObject)modelObj), (Dataset)Dataset.of((DynamicObject)dataset), (IModelCacheHelper)modelCache, (ShrekConfig)ShrekConfigServiceHelper.getBgMDConfig());
        }
    }

    private void syncOlapData(Long datasetId) {
        Long modelId = this.getModelId();
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
        String dimNumber = SysDimensionEnum.Account.getNumber();
        if (StringUtils.isNotEmpty((String)dimNumber) && ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
            DynamicObject dataset = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"eb_dataset");
            ShrekOlapServiceHelper.updateDimension((Model)Model.of((DynamicObject)model), Collections.singletonList(Dataset.of((DynamicObject)dataset)), (String)dimNumber, null, (ShrekConfig)ShrekConfigServiceHelper.getBgMDConfig());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        List dimList = DataSetPresetDimEnum.getNumberExcludeAccount();
        IDataModel iDataModel = this.getModel();
        Long dimensionId = this.getAndCacheDimId();
        switch (key) {
            case "ADD_CATALOG_CLOSECALLBACK": {
                if (backData == null) break;
                String newID = backData instanceof List && !((List)backData).isEmpty() ? IDUtils.toString(((List)backData).get(0)) : String.valueOf(backData);
                this.initTree(newID, this.getModelId(), Boolean.TRUE);
                break;
            }
            case "ADD_DATASET_CLOSECALLBACK": {
                if (backData == null) break;
                String newID = String.valueOf(backData);
                this.setDefaultDim(this.getModelId(), newID);
                this.initTree(newID, this.getModelId(), Boolean.TRUE);
                this.treeViewMapTreeNodeClick(newID);
                break;
            }
            case "addDimension": {
                int index;
                if (backData == null) break;
                Map dMap = (Map)backData;
                List<Long> curDims = this.getEntryEntiryDims();
                Map dims = (Map)dMap.keySet().iterator().next();
                if (curDims.size() == 0) {
                    iDataModel.deleteEntryData(ENTRYENTITY);
                    iDataModel.batchCreateNewEntryRow(ENTRYENTITY, dims.size());
                    index = 0;
                    for (Map.Entry entry : dims.entrySet()) {
                        iDataModel.setValue("dimnumber", entry.getValue(), index);
                        iDataModel.setValue("dimname", entry.getKey(), index);
                        if (dimList.contains(entry.getValue())) {
                            iDataModel.setValue("issysset", (Object)"1", index);
                        } else {
                            iDataModel.setValue("issysset", (Object)"0", index);
                        }
                        ++index;
                    }
                } else {
                    index = curDims.size();
                    iDataModel.beginInit();
                    for (Map.Entry entry : dims.entrySet()) {
                        iDataModel.insertEntryRow(ENTRYENTITY, index);
                        iDataModel.setValue("dimnumber", entry.getValue(), index);
                        iDataModel.setValue("dimname", entry.getKey(), index);
                        if (dimList.contains(entry.getValue())) {
                            iDataModel.setValue("issysset", (Object)"1", index);
                        } else {
                            iDataModel.setValue("issysset", (Object)"0", index);
                        }
                        ++index;
                    }
                    iDataModel.endInit();
                }
                this.getView().updateView(ENTRYENTITY);
                try {
                    this.saveDims();
                    this.dealAccountRelate(dMap);
                    break;
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
            case "addDimensionNoDeal": {
                this.addDimCloseCallBack(backData, dimList);
                break;
            }
            case "baritemaddsub": 
            case "sysimport": 
            case "importPage": {
                CubeUtils.get().checkDimension(this.getModelId(), dimensionId);
                this.refreshMembers();
                break;
            }
            case "hyperLinkClose": {
                this.refreshMembers();
                break;
            }
            case "model": {
                if (backData == null) {
                    return;
                }
                ListSelectedRowCollection seleModel = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                String modelName = seleModel.get(0).getName();
                Object model = seleModel.get(0).getPrimaryKeyValue();
                ((Label)this.getControl(MODELLABEL)).setText(modelName);
                this.getModel().setValue("model", model);
            }
            case "btn_disable": 
            case "btn_enable": {
                this.refreshMembers();
            }
            case "batchUpdate": {
                this.refreshList();
                break;
            }
        }
    }

    private void addDimCloseCallBack(Object backData, List<String> dimList) {
        if (backData != null) {
            int index;
            Map dims = (Map)SerializationUtils.deSerializeFromBase64((String)((String)backData));
            List<Long> curDims = this.getEntryEntiryDims();
            IDataModel iDataModel = this.getModel();
            if (curDims.size() == 0) {
                iDataModel.deleteEntryData(ENTRYENTITY);
                iDataModel.batchCreateNewEntryRow(ENTRYENTITY, dims.size());
                index = 0;
                for (Map.Entry dim : dims.entrySet()) {
                    iDataModel.setValue("dimnumber", dim.getValue(), index);
                    iDataModel.setValue("dimname", dim.getKey(), index);
                    if (dimList.contains(dim.getValue())) {
                        iDataModel.setValue("issysset", (Object)"1", index);
                    } else {
                        iDataModel.setValue("issysset", (Object)"0", index);
                    }
                    ++index;
                }
            } else {
                index = curDims.size();
                iDataModel.beginInit();
                for (Map.Entry dim : dims.entrySet()) {
                    int i = this.getModel().insertEntryRow(ENTRYENTITY, index);
                    iDataModel.setValue("dimnumber", dim.getValue(), i);
                    iDataModel.setValue("dimname", dim.getKey(), i);
                    if (dimList.contains(dim.getValue())) {
                        iDataModel.setValue("issysset", (Object)"1", index);
                    } else {
                        iDataModel.setValue("issysset", (Object)"0", index);
                    }
                    ++index;
                }
                iDataModel.endInit();
            }
            this.getView().updateView(ENTRYENTITY);
            Long modelId = this.getModelId();
            Long datasetId = IDUtils.toLong((Object)this.getCurrentNodeId());
            try {
                this.saveDims();
                this.updateApplyTempAfterAddDim(dims);
                AnalyseReportUtil.getInstance().updateDimGroups(modelId, datasetId);
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"UpdateOldRuleService", (String)"autoUpdateOldRule", (Object[])new Object[]{modelId, false});
                RuleEvent ruleEvent = new RuleEvent();
                ruleEvent.setRuleEventTypeEnum(RuleEventTypeEnum.ADD_DIMENSION);
                ruleEvent.setModelIdLong(modelId);
                RuleEventBusUtils.post(ruleEvent);
                DataSetAddDimEvent addDimEvent = new DataSetAddDimEvent();
                addDimEvent.setDataSetId(datasetId);
                addDimEvent.setModelId(modelId);
                addDimEvent.setDims(dims);
                EventBusUtil.asyncPost((Object)addDimEvent);
            }
            catch (Exception e) {
                try {
                    throw new KDBizException(e.getMessage());
                }
                catch (Throwable throwable) {
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6570\u636e\u96c6\u589e\u52a0\u7ef4\u5ea6", "DataSetListPlugin_78", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u6570\u636e\u96c6\u589e\u52a0\u7ef4\u5ea6\uff1a%1$s\u3002", "DataSetListPlugin_79", "epm-eb-formplugin");
                    this.writeLog(null, "addnew", opName, opDescription, new String[]{StringUtils.join(dims.values(), (char)',')});
                    throw throwable;
                }
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6570\u636e\u96c6\u589e\u52a0\u7ef4\u5ea6", "DataSetListPlugin_78", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u6570\u636e\u96c6\u589e\u52a0\u7ef4\u5ea6\uff1a%1$s\u3002", "DataSetListPlugin_79", "epm-eb-formplugin");
            this.writeLog(null, "addnew", opName, opDescription, new String[]{StringUtils.join(dims.values(), (char)',')});
        }
    }

    private DynamicObjectCollection loadAccountInDataSet(String datasetId) {
        String selectMemberFields = "id,number,name,dataset,isrelated,relatedaccount";
        QFilter qFilter = new QFilter(TREE_MAPKEY_DATA, "=", (Object)Long.parseLong(datasetId));
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        return QueryServiceHelper.query((String)"epm_accountmembertree", (String)selectMemberFields, (QFilter[])new QFilter[]{modelQf, qFilter});
    }

    private List<Object> loadAccountIds(String datasetId) {
        QFilter qFilter = new QFilter(TREE_MAPKEY_DATA, "=", (Object)Long.parseLong(datasetId));
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        return QueryServiceHelper.queryPrimaryKeys((String)"epm_accountmembertree", (QFilter[])new QFilter[]{modelQf, qFilter}, null, (int)10);
    }

    private void dealAccountRelate(Map<Map<Long, String>, DynamicObjectCollection> dMap) {
        String dataSetId = this.getCurrentNodeId();
        List<Object> dynamicObjects = this.loadAccountIds(dataSetId);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return;
        }
        Map<Long, String> newDims = null;
        DynamicObjectCollection entryentiry = null;
        for (Map.Entry<Map<Long, String>, DynamicObjectCollection> entry : dMap.entrySet()) {
            newDims = entry.getKey();
            entryentiry = entry.getValue();
        }
        if (newDims == null || entryentiry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"DataSetListPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        HashMap<Long, DynamicObject> newDimMap = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection dimensions = DimensionServiceHelper.queryDimensionByIds((Long)this.getModelId(), (Long[])newDims.keySet().toArray(new Long[0]), (String)"id,name,number,shortnumber,issysdimension,fieldmapped");
        for (DynamicObject dimension : dimensions) {
            newDimMap.put(dimension.getLong("id"), dimension);
        }
        this.dealadd(newDimMap, entryentiry);
    }

    private void dealadd(Map<Long, DynamicObject> dims, DynamicObjectCollection rowData) {
        DynamicObject[] others;
        if (rowData.size() == 0 || dims.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> maps = new HashMap<Long, DynamicObject>();
        for (DynamicObject row : rowData) {
            DynamicObject account = row.getDynamicObject("account");
            maps.put(account.getLong("id"), row);
        }
        for (DynamicObject other : others = this.queryAccountById(maps.keySet().toArray(new Long[0]))) {
            DynamicObject row = (DynamicObject)maps.get(other.getLong("id"));
            if (row == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5904\u7406\u79d1\u76ee\u5173\u8054\u5931\u8d25\u3002", (String)"DataSetListPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection dynamicObjects = other.getDynamicObjectCollection("entryentity3");
            for (Map.Entry<Long, DynamicObject> entry : dims.entrySet()) {
                DynamicObject member = entry.getValue();
                DynamicObject dim = entry.getValue();
                DynamicObject dynamicObject = dynamicObjects.addNew();
                String dimNumber = dim.getString("number");
                if ((member = member.getBoolean("issysdimension") ? row.getDynamicObject(dimNumber.toLowerCase()) : row.getDynamicObject(member.getString("fieldmapped"))) == null) continue;
                dynamicObject.set("dimid", (Object)dim.getString("id"));
                dynamicObject.set("dimnumber", (Object)dimNumber);
                dynamicObject.set("memberid", (Object)member.getString("id"));
                dynamicObject.set("membernumber", (Object)member.getString("number"));
                dynamicObject.set("source", (Object)"1");
            }
        }
        SaveServiceHelper.save((DynamicObject[])others);
    }

    private DynamicObject[] queryAccountById(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"epm_accountmembertree").getDynamicObjectType());
    }

    private void initTree(String newId, Long modelId, Boolean isDataCube) {
        DataSetTreeCommon dataSetobj = new DataSetTreeCommon();
        dataSetobj.setCache_focusnodeid(FOCUSNODEID);
        dataSetobj.setCache_headnodeid(HEADNODEID);
        dataSetobj.setTreeViewctrlName(TREEVIEWAP);
        dataSetobj.initTree(newId, modelId, isDataCube, this);
    }

    public void refreshMembers() {
        this.clearCache();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        int focusRowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
        this.getPageCache().put("keepTree", "true");
        ArrayList expandIds = (ArrayList)treeEntry.getExpandNodes();
        if (expandIds == null) {
            expandIds = new ArrayList();
        }
        this.refreshList();
        LinkedHashSet<Integer> rowIndexs = new LinkedHashSet<Integer>();
        DynamicObjectCollection objs = null;
        for (int i = 0; i < expandIds.size(); ++i) {
            int row = -1;
            if (objs == null) {
                objs = this.getModel().getEntryEntity(TREEENTRYENTITY);
            }
            for (int j = 0; j < objs.size(); ++j) {
                if (!expandIds.contains(((DynamicObject)objs.get(j)).getString("id"))) continue;
                row = j;
                if (rowIndexs.contains(row)) {
                    row = -1;
                    continue;
                }
                rowIndexs.add(row);
                break;
            }
            if (row < 0) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowkey", row);
            map.put("id", ((DynamicObject)objs.get(row)).get("id"));
            treeEntry.loadChildrenData(map);
            objs = null;
        }
        treeEntry.expandOne(rowIndexs.stream().mapToInt(Integer::intValue).sorted().toArray());
        treeEntry.selectRows(focusRowIndex);
        this.getPageCache().put("keepTree", "false");
    }

    public void refreshList() {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        String nodeId = tree.getTreeState().getFocusNodeId();
        if (nodeId == null) {
            return;
        }
        TreeNode treeNode = this.getSelectedNode(nodeId);
        Map dataMap = (Map)treeNode.getData();
        String type = (String)dataMap.get(TREE_MAPKEY_TYPE);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        if (TREE_MAPKEY_DATA.equals(type)) {
            this.refreshAccountEntry(treeEntry, nodeId);
        }
        this.clearCache();
    }

    private List<Long> getEntryEntiryDims() {
        DynamicObjectCollection entitys = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Long> dims = new ArrayList<Long>();
        for (DynamicObject entity : entitys) {
            dims.add(entity.getLong("dimname.id"));
        }
        return dims;
    }

    private List<String> getEntryEntiryDimsNumber() {
        DynamicObjectCollection entitys = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<String> dims = new ArrayList<String>();
        for (DynamicObject entity : entitys) {
            dims.add(entity.getString("dimname.number"));
        }
        return dims;
    }

    private void saveDims() {
        String dataSetId = this.getCurrentNodeId();
        List<Long> newDimIds = this.getEntryEntiryDims();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(dataSetId), (String)"eb_dataset");
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        Set oldDimIds = dynamicObjects.stream().map(p -> p.getLong("datasetdim.id")).collect(Collectors.toSet());
        dynamicObjects.clear();
        DynamicObjectType dynamicObjectType = dynamicObjects.getDynamicObjectType();
        for (Long dim : newDimIds) {
            DynamicObject d = new DynamicObject(dynamicObjectType);
            d.set("datasetdim", (Object)dim);
            dynamicObjects.add((Object)d);
        }
        dynamicObject.set(ENTRYENTITY, (Object)dynamicObjects);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        Long modelId = this.getModelId();
        CubeUtils.get().checkDataset(modelId, Long.valueOf(dataSetId));
        Long accountId = this.getAndCacheDimId();
        ArrayList<Long> dimsList = new ArrayList<Long>(newDimIds);
        dimsList.add(accountId);
        CubeUtils.get().checkDimension(modelId, dimsList.toArray(new Long[0]));
        DynamicObject model = dynamicObject.getDynamicObject("model");
        if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Dataset dataset = new Dataset(Long.valueOf(Long.parseLong(dataSetId)), dynamicObject.getString("number"));
            dataset.addViewIds(BusinessModelServiceHelper.getViewIds((Long)dynamicObject.getLong("businessmodel.id")));
            if (newDimIds.size() > oldDimIds.size()) {
                newDimIds.removeAll(oldDimIds);
                for (Long dim : newDimIds) {
                    dataset.addDimension(modelCacheHelper.getDimension(dim));
                }
                ShrekOlapServiceHelper.addCubeDimension((Model)Model.of((DynamicObject)model), (Dataset)dataset, newDimIds, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)ShrekConfigServiceHelper.getBgMDConfig());
            } else if (oldDimIds.size() > newDimIds.size()) {
                newDimIds.forEach(oldDimIds::remove);
                for (Long dim : oldDimIds) {
                    dataset.addDimension(modelCacheHelper.getDimension(dim));
                }
                ShrekOlapServiceHelper.dropCubeDimensions((Model)Model.of((DynamicObject)dynamicObject.getDynamicObject("model")), (Dataset)dataset);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("model".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "model"));
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)beforeF7SelectEvent);
        }
    }

    public TreeNode getCacheLefTreeRoot() {
        String rootStr = this.getPageCache().get("treelist");
        if (rootStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u6811\u7f13\u5b58\u83b7\u53d6\u5931\u8d25\u3002", (String)"DataSetListPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        TreeNode root = (TreeNode)SerializationUtils.deSerializeFromBase64((String)rootStr);
        return root;
    }

    private TreeNode getSelectedNode(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        TreeNode root = this.getCacheLefTreeRoot();
        return root.getTreeNode(nodeId);
    }

    @Override
    public Long getModelId() {
        Long f7SelectId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
        if (f7SelectId == null) {
            return super.getModelId();
        }
        return f7SelectId;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject dy;
        DynamicObjectCollection dyc;
        super.hyperLinkClick(arg0);
        String key = arg0.getFieldName();
        if ("number".equals(key)) {
            dyc = this.getModel().getEntryEntity(TREEENTRYENTITY);
            dy = (DynamicObject)dyc.get(arg0.getRowIndex());
            String selectMemberId = dy.getString("id");
            this.onhyperLinkClick(selectMemberId);
        }
        if ("dimnumber".equals(key)) {
            dyc = this.getModel().getEntryEntity(ENTRYENTITY);
            dy = (DynamicObject)dyc.get(arg0.getRowIndex());
            String dimnumber = dy.getString("dimnumber");
            this.openDimensionDisplayList(dimnumber);
        }
    }

    private void openDimensionDisplayList(String dimNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_dimensionmanager");
        showParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406", (String)"DataSetListPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        showParameter.setCustomParam("datasetDimId", (Object)this.getDimensionId(dimNumber));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    protected void onhyperLinkClick(String selectMemberId) {
        Long dimensionID = this.getAndCacheDimId();
        String selectFields = "membermodel,name";
        QFilter filter = new QFilter("id", "=", (Object)dimensionID);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
        if (dimension != null) {
            DynamicObject member = QueryServiceHelper.queryOne((String)dimension.getString("membermodel"), (String)"level,storagetype,membersource,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(selectMemberId))});
            int level = 0;
            String fStoragetype = "";
            if (member != null) {
                level = member.getInt("level");
                fStoragetype = member.getString("storagetype");
            }
            if (1 == level) {
                HashMap<String, String> openParameter = new HashMap<String, String>();
                openParameter.put("formId", "epm_dimension");
                openParameter.put("pkId", String.valueOf(dimensionID));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
                showParameter.setStatus(OperationStatus.EDIT);
                if ("3".equals(fStoragetype)) {
                    showParameter.setCustomParam("isstorage", (Object)ResManager.loadKDString((String)"\u5171\u4eab", (String)"DataSetListPlugin_64", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String dimensionName = ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DataSetListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                showParameter.setCustomParam("dimensionName", (Object)dimensionName);
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                showParameter.setCustomParam("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                showParameter.setCustomParam("dimensionId", (Object)dimensionID);
                showParameter.setCustomParam("dimensionNumber", (Object)"Account");
                showParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u2014\u7f16\u8f91", (String)"DataSetListPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hyperLinkClose");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else {
                IFormView thisView = this.getView();
                if (member == null) {
                    return;
                }
                String markId = member.getString("number");
                String menuPageID = markId + thisView.getPageId() + ModelUtil.queryApp((IFormView)this.getView()).getAppnum();
                Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
                String membersource = member.getString("membersource");
                this.showAccountPage(modelId, dimension, dimensionID, selectMemberId, fStoragetype, membersource, menuPageID);
            }
        }
    }

    private void showAccountPage(Long modelId, DynamicObject dimension, Long dimensionId, String selectMemberId, String fStoragetype, String membersource, String menuPageID) {
        HashMap<String, String> openParameter = new HashMap<String, String>();
        String formId = dimension.getString("membermodel");
        openParameter.put("formId", formId);
        openParameter.put("pkId", selectMemberId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.setPageId(menuPageID);
        showParameter.setParentPageId(this.getView().getParentView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setStatus(OperationStatus.EDIT);
        if ("3".equals(fStoragetype)) {
            showParameter.setCustomParam("isstorage", (Object)ResManager.loadKDString((String)"\u5171\u4eab", (String)"DataSetListPlugin_64", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String dimensionName = ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DataSetListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        showParameter.setCustomParam("dimensionName", (Object)dimensionName);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("dimensionId", (Object)dimensionId);
        showParameter.setCustomParam("dimensionNumber", (Object)"Account");
        showParameter.setCustomParam("id", (Object)selectMemberId);
        showParameter.setCustomParam("membersource", (Object)membersource);
        showParameter.setCustomParam("pageid", (Object)this.getView().getPageId());
        showParameter.setCustomParam("parentpageid", (Object)this.getView().getPageId());
        showParameter.setCustomParam("isSysDim", (Object)"1");
        showParameter.setCaption(ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458", (String)"DataSetListPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hyperLinkClose");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    protected void Search(String text, int selectRow, Object selectPk) {
        this.setTab(true);
        this.getModel().beginInit();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        Long dimensionID = this.getAndCacheDimId();
        String _defaultModelId = this.getPageCache().get("KEY_MODEL_ID");
        if (kd.bos.util.StringUtils.isEmpty((String)_defaultModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u3002", (String)"DataSetListPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long defaultModelId = Long.valueOf(_defaultModelId);
        String menberentityid = "epm_accountmembertree";
        QFilter qcf = new QFilter("model", "=", (Object)defaultModelId);
        QFilter qcd = new QFilter("dimension", "=", (Object)dimensionID);
        QFilter qdataset = new QFilter(TREE_MAPKEY_DATA, "=", (Object)Long.parseLong(this.getCurrentNodeId()));
        QFilter qdroot = new QFilter("number", "=", (Object)"Account");
        QFilter[] memberFilters = new QFilter[]{qcf, qcd, qdataset.or(qdroot)};
        String selectMemberFields = this.getSelectMemberFields();
        DynamicObjectCollection members = QueryServiceHelper.query((String)this.getClass().getName(), (String)menberentityid, (String)selectMemberFields, (QFilter[])memberFilters, (String)"dseq");
        int memberSize = members.size();
        if (memberSize == 0) {
            return;
        }
        TreeMap rowTreeMapAll = new TreeMap();
        TreeMap rowTreeMap = SearchHelper.getSearchItemId((String)text, (DynamicObjectCollection)members, rowTreeMapAll, (boolean)true);
        if (rowTreeMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"DataSetListPlugin_68", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            treeEntry.selectRows(0);
            return;
        }
        ArrayList rowList = new ArrayList(rowTreeMap.values());
        this.getPageCache().put(rowlist, SerializationUtils.toJsonString(rowList));
        long focusID = (Long)rowList.get(0);
        this.getPageCache().put(rowcount, "0");
        if (selectRow > 0 && selectPk != null) {
            int realSelectRow = 0;
            for (Map.Entry entry : rowTreeMapAll.entrySet()) {
                if (!((Long)entry.getValue()).toString().equals(String.valueOf(selectPk))) continue;
                realSelectRow = (Integer)entry.getKey();
                break;
            }
            for (int i = realSelectRow; i < memberSize; ++i) {
                Map.Entry entrySelRow;
                if (rowTreeMap.get(i) == null) continue;
                focusID = (Long)rowTreeMap.get(i);
                Iterator iterRowTreeMap = rowTreeMap.entrySet().iterator();
                int selectRowCount = 0;
                while (iterRowTreeMap.hasNext() && !((Long)(entrySelRow = iterRowTreeMap.next()).getValue()).equals(focusID)) {
                    ++selectRowCount;
                }
                this.getPageCache().put(rowcount, selectRowCount + "");
                break;
            }
        }
        this.dealEbMembSearch(defaultModelId, dimensionID, String.valueOf(focusID), menberentityid, true);
        this.getPageCache().put(allshowrowid, SerializationUtils.toJsonString(new HashSet()));
        this.getModel().endInit();
    }

    protected String getSelectMemberFields() {
        return "id,id as memberid,name,number,dseq,parent,aggoprt,storageType,modifier.name as modifier,modifyTime,isleaf,level ,description ,accounttype,drcrdirect,disable";
    }

    public static List<Integer> removeExistNodeForSearchShow(List<String> parentlist, DynamicObjectCollection currentRowObjs) {
        int lastIndex;
        int rowIndex = 0;
        int currentIndex = lastIndex = parentlist.size();
        ArrayList<Integer> pRowIndexs = new ArrayList<Integer>();
        if (!currentRowObjs.isEmpty()) {
            for (DynamicObject row : currentRowObjs) {
                String rowId = row.getString("id");
                if (parentlist.contains(rowId)) {
                    if (parentlist.indexOf(rowId) > currentIndex) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u7ed3\u6784\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"DataSetListPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    pRowIndexs.add(rowIndex);
                    currentIndex = parentlist.indexOf(rowId);
                }
                if (currentIndex == 0) break;
                ++rowIndex;
            }
        }
        if (currentIndex == lastIndex - 1 && lastIndex != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u7ed3\u6784\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"DataSetListPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (int i = lastIndex - 1; i >= 0; --i) {
            if (currentIndex >= i) continue;
            parentlist.set(i, null);
        }
        parentlist.removeIf(Objects::isNull);
        return pRowIndexs;
    }

    public void dealEbMembSearch(Long model, Long dimension, String focusID, String entityname, boolean isCol) {
        List parentlist = SearchHelper.getOrgParentNodeList((Long)model, (Long)dimension, (String)focusID, (String)entityname);
        HashSet<String> allShowRowid = new HashSet<String>();
        allShowRowid.add(String.valueOf(focusID));
        parentlist.add(0, focusID);
        List<Integer> matchRowIndex = DataSetListPlugin.removeExistNodeForSearchShow(parentlist, this.getModel().getEntryEntity(TREEENTRYENTITY));
        if (parentlist.size() == 1) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            this.cacheSearchedRow(matchRowIndex.get(matchRowIndex.size() - 1));
            entryGrid.selectRows(matchRowIndex.get(matchRowIndex.size() - 1).intValue());
            matchRowIndex.remove(matchRowIndex.size() - 1);
            int[] pRowIndexs = new int[matchRowIndex.size()];
            for (int i = 0; i < matchRowIndex.size(); ++i) {
                pRowIndexs[i] = matchRowIndex.get(i);
            }
            entryGrid.expandOne(pRowIndexs);
        } else {
            parentlist.remove(0);
            QFilter qcd = new QFilter("dimension", "=", (Object)dimension);
            for (int i = parentlist.size() - 1; i >= 0; --i) {
                String parentid = (String)parentlist.get(i);
                QFilter qf1 = new QFilter("parent", "=", (Object)parentid);
                DynamicObjectCollection theSameLevel = QueryServiceHelper.query((String)entityname, (String)"id", (QFilter[])new QFilter[]{qcd, qf1});
                if (theSameLevel == null || theSameLevel.size() <= 0) continue;
                for (DynamicObject dy : theSameLevel) {
                    allShowRowid.add(dy.getString("id"));
                }
            }
            allShowRowid.add((String)parentlist.get(parentlist.size() - 1));
            this.insertAndRefreshTreeEntry(allShowRowid, entityname, Long.parseLong(focusID), isCol, matchRowIndex.get(matchRowIndex.size() - 1), (String)parentlist.get(parentlist.size() - 1));
        }
    }

    protected void insertAndRefreshTreeEntry(Set<String> allShowRowid, String entityname, long focusID, boolean col, int parentRow, String parentId) {
        QFilter qf2 = new QFilter("id", "in", (Object)allShowRowid.toArray());
        String selectFields = this.getSelectMemberFields();
        DynamicObjectCollection membercolls = QueryServiceHelper.query((String)entityname, (String)selectFields, (QFilter[])new QFilter[]{qf2});
        if (membercolls.size() == 0) {
            return;
        }
        List<String> properties = this.getPropertiesAndLeaf();
        int focusrow = SearchHelper.fillTreeEntryEntity((IDataModel)this.getModel(), (DynamicObjectCollection)membercolls, properties, (String)String.valueOf(focusID), (int)parentRow, (String)parentId);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        this.getView().updateView(TREEENTRYENTITY);
        int[] eids = TreeEntryEntityUtils.focus((IDataModel)this.getModel(), (int)focusrow);
        if (col) {
            treeEntry.collapse(0);
        }
        this.collapseExpNode(parentRow + 1, membercolls.size() - 1, treeEntry);
        treeEntry.expandOne(eids);
        treeEntry.selectRows(focusrow);
    }

    protected List<String> getPropertiesAndLeaf() {
        List<String> list = this.getProperties();
        list.add("isleaf");
        return list;
    }

    protected void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] allRowIndexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            allRowIndexs[i] = beginRow + i;
        }
        entryGrid.collapseOne(allRowIndexs);
    }

    private void updateApplyTempAfterAddDim(Map<Long, String> newDims) {
        Long modelId = this.getModelId();
        Long busModelId = Long.parseLong(this.getCurrentNodeId());
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add(TREE_MAPKEY_DATA, "=", (Object)busModelId);
        DynamicObject[] tempObjs = BusinessDataServiceHelper.load((String)"eb_applytemplate", (String)"id,cachedata_tag", (QFilter[])qb.toArrays());
        if (tempObjs.length > 0) {
            Map<String, MemberInfo> defaultMemb = this.getDefaultMemb(modelId, newDims.values());
            for (DynamicObject object : tempObjs) {
                String dimConfigStr = object.getString("cachedata_tag");
                List dimConfigs = SerializationUtils.fromJsonStringToList((String)dimConfigStr, TempDimConfig.class);
                int maxNum = 0;
                HashSet<Integer> nums = new HashSet<Integer>(20);
                for (int i = 1; i <= 20; ++i) {
                    nums.add(i);
                }
                for (TempDimConfig config : dimConfigs) {
                    if (!config.getPanel().equals(TempDimConfigType.HIDEDIM.getValue())) continue;
                    String key = config.getKey();
                    int num = Integer.parseInt(key.substring(3));
                    nums.remove(num);
                }
                if (nums.size() < defaultMemb.size()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f\u9690\u85cf\u7ef4\u4e0d\u53ef\u8d85\u8fc720\u4e2a\u3002", (String)"DataSetListPlugin_73", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Iterator numIterator = nums.iterator();
                for (Map.Entry<String, MemberInfo> entry : defaultMemb.entrySet()) {
                    maxNum = (Integer)numIterator.next();
                    String dimNum = entry.getKey();
                    TempDimConfig tempDimConfig = new TempDimConfig();
                    tempDimConfig.setDimensionNumber(dimNum);
                    String memberTreemodelByNumber = SysDimensionEnum.getMemberTreemodelByNumber((String)dimNum);
                    tempDimConfig.setSign(memberTreemodelByNumber);
                    tempDimConfig.setName(entry.getValue().getName());
                    tempDimConfig.setMemberId(entry.getValue().getId().toString());
                    tempDimConfig.setFlag(entry.getValue().getDimName());
                    tempDimConfig.setPanel(TempDimConfigType.HIDEDIM.getValue());
                    tempDimConfig.setKey("hid" + maxNum);
                    tempDimConfig.setDimensionId(entry.getValue().getDimId().toString());
                    tempDimConfig.setMemberNumber(entry.getValue().getNumber());
                    tempDimConfig.setVar(false);
                    dimConfigs.add(tempDimConfig);
                }
                object.set("cachedata_tag", (Object)SerializationUtils.toJsonString((Object)dimConfigs));
            }
            SaveServiceHelper.save((DynamicObject[])tempObjs);
        }
    }

    private Map<String, MemberInfo> getDefaultMemb(Long modelId, Collection<String> dimNums) {
        HashMap<String, MemberInfo> result = new HashMap<String, MemberInfo>(dimNums.size());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (String dimNum : dimNums) {
            Member member;
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            if (dimension == null || (member = dimension.getMember(null, dimension.getNoneNumber())) == null) continue;
            MemberInfo memberInfo = new MemberInfo(member.getName(), member.getNumber(), member.getId(), dimension.getName(), dimension.getId());
            result.put(dimNum, memberInfo);
        }
        return result;
    }

    @Override
    public Map<String, Object> getMainSubParams(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DimManagerInfo dimManager = this.getDimManagerInfo();
        if (dimManager != null) {
            long dimensionId;
            String mainNumber;
            if (dimManager.getMember() != null && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(mainNumber = dimManager.getMember().getNumber()))) {
                map.put("mainNumber", mainNumber);
            }
            if ((dimensionId = dimManager.getDimensionId()) != 0L) {
                map.put("dimensionId", dimensionId);
            }
        }
        return map;
    }

    protected void cacheSearchedRow(int searchedRow) {
    }

    protected Long getModelIdAfterCreateNewData(Long modelId) {
        return modelId;
    }

    protected DynamicObject[] reGetMember(DynamicObject[] members, String menberentityid, String selectFields) {
        return members;
    }

    protected void cacheAllSub(DimManagerInfo dimInfo) {
    }

    protected void setUserSelectIds() {
    }
}

