/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;

public class DimensionSelect
extends AbstractFormPlugin {
    private static final String CUR_DIMS = "curDims";
    private static final String BTN_SURE = "btnsure";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String modelId = (String)formShowParameter.getCustomParam("model");
        String dims = (String)formShowParameter.getCustomParam("existdims");
        String dataset = (String)formShowParameter.getCustomParam("dataset");
        String bizModelId = (String)formShowParameter.getCustomParam("bizId");
        if (modelId != null) {
            this.getPageCache().put("model", modelId);
            this.getPageCache().put("dims", dims);
            this.getPageCache().put("dataset", dataset);
            this.getPageCache().put("bizModelId", bizModelId);
            this.initEntryEntity(modelId, this.getModel(), bizModelId);
        }
    }

    private void initEntryEntity(String modelId, IDataModel dataModel, String bizId) {
        List<Dimension> dims = this.queryDimension(modelId, bizId);
        if (dims == null || dims.size() == 0) {
            return;
        }
        dataModel.deleteEntryData("entryentity");
        dataModel.batchCreateNewEntryRow("entryentity", dims.size());
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dimension = dims.get(i);
            dataModel.setValue("number", (Object)dimension.getId(), i);
            dataModel.setValue("name", (Object)dimension.getName(), i);
            dataModel.setValue("shortnumber", (Object)dimension.getShortNumber(), i);
            Boolean isSys = dimension.isPreset();
            String isSysPreset = "0";
            if (isSys.booleanValue()) {
                isSysPreset = "1";
            }
            dataModel.setValue("issysdimension", (Object)isSysPreset, i);
        }
        this.getView().updateView("entryentity");
    }

    private List<Dimension> queryDimension(String modelId, String bizId) {
        Long model;
        String dims = this.getPageCache().get("dims");
        ArrayList<String> list = new ArrayList<String>();
        if (dims != null) {
            list.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)dims));
            list.add(SysDimensionEnum.Account.getNumber());
            this.getPageCache().put(CUR_DIMS, String.valueOf(list.size()));
        }
        if (IDUtils.isNull((Long)(model = IDUtils.toLong((Object)modelId)))) {
            return new ArrayList<Dimension>();
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)model);
        if (orCreate == null) {
            return new ArrayList<Dimension>();
        }
        List dimensionList = orCreate.getDimensionListByBusModel(IDUtils.toLong((Object)bizId));
        if (CollectionUtils.isEmpty((Collection)dimensionList)) {
            return new ArrayList<Dimension>();
        }
        ArrayList<Dimension> dimlist = new ArrayList<Dimension>();
        for (Dimension dimension : dimensionList) {
            if (list.contains(dimension.getNumber())) continue;
            dimlist.add(dimension);
        }
        return dimlist;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("close".equals(key)) {
            this.getView().close();
        }
        if (BTN_SURE.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DimensionSelect_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getPageCache().get(CUR_DIMS) != null) {
                int existCount = Integer.parseInt(this.getPageCache().get(CUR_DIMS));
                int allowAddCount = 17 - existCount;
                if (rows.length > allowAddCount) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u6700\u591a\u5141\u8bb8\u9009\u62e9\u201c%1\u201d\u4e2a\u7ef4\u5ea6\uff0c\u5f53\u524d\u5df2\u9009%3\u4e2a\uff0c\u53ef\u9009%2\u4e2a\u3002", (String)"DimensionSelect_1", (String)"epm-eb-formplugin", (Object[])new Object[]{17, allowAddCount, rows.length}), Integer.valueOf(3000));
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DimensionSelect_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.validateTemplate();
        }
    }

    private void validateTemplate() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        String dataset = this.getPageCache().get("dataset");
        QFilter qFilter = new QFilter("model", "=", (Object)Long.parseLong(model.toString()));
        qFilter.and("dataset", "=", (Object)Long.parseLong(dataset));
        boolean exists = QueryServiceHelper.exists((String)"eb_templateentity", (QFilter[])qFilter.toArray());
        if (exists) {
            String msg = ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u5df2\u5b58\u5728\uff0c\u6dfb\u52a0\u7ef4\u5ea6\u540e\uff0c\u4f1a\u81ea\u52a8\u5728\u6a21\u677f\u4e2d\u8865\u5145\u8be5\u7ef4\u5ea6\uff0c\u4e14\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DimensionSelect_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String title = ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5f15\u7528\u6821\u9a8c\u3002", (String)"DimensionSelect_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(title, msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("dataset_callback"));
        } else {
            this.setReturnData();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("dataset_callback".equals(callBackId) && (result = messageBoxClosedEvent.getResult()).getValue() == MessageBoxResult.Yes.getValue()) {
            this.setReturnData();
        }
    }

    private void setReturnData() {
        Long datasetId = 0L;
        if (this.getPageCache().get("dataset") != null) {
            datasetId = Long.valueOf(this.getPageCache().get("dataset"));
        }
        if (!this.existAccount(datasetId)) {
            this.getView().getFormShowParameter().getCloseCallBack().setActionId("addDimensionNoDeal");
            this.setReturnDataToParent();
            this.getView().close();
        } else if (this.existNeedDeal(datasetId)) {
            this.openDealPage();
        } else {
            this.getView().getFormShowParameter().getCloseCallBack().setActionId("addDimensionNoDeal");
            this.setReturnDataToParent();
            this.getView().close();
        }
    }

    private boolean existAccount(Long datasetid) {
        boolean isExist = QueryServiceHelper.exists((String)"epm_accountmembertree", (QFilter[])new QFilter[]{new QFilter("dataset", "=", (Object)datasetid)});
        return isExist;
    }

    private boolean existNeedDeal(Long datasetid) {
        ArrayList<String> addDimNumber = new ArrayList<String>(this.getEntryEntityRows().values());
        ArrayList<Long> accountIds = new ArrayList<Long>();
        ArrayList<String> dimnumber = new ArrayList<String>();
        QFilter qFilter = new QFilter("dataset", "=", (Object)datasetid);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject account : accounts) {
            accountIds.add(account.getLong("id"));
        }
        QFilter datasetQf = new QFilter("dataset", "!=", (Object)datasetid);
        QFilter accountQf = new QFilter("relatedaccount", "in", accountIds);
        DynamicObject[] relateAccount = BusinessDataServiceHelper.load((String)"epm_accountmembertree", (String)"id,name,number,dataset", (QFilter[])new QFilter[]{datasetQf, accountQf});
        HashSet<DynamicObject> datasets = new HashSet<DynamicObject>();
        for (DynamicObject dynamicObject : relateAccount) {
            DynamicObject dataset = dynamicObject.getDynamicObject("dataset");
            if (dataset == null) continue;
            datasets.add(dataset);
        }
        for (DynamicObject dynamicObject : datasets) {
            dimnumber.clear();
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                dimnumber.add(object.getString("datasetdim.number"));
            }
            if (dimnumber.containsAll(addDimNumber)) continue;
            return true;
        }
        return false;
    }

    private void openDealPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("model", (Object)this.getPageCache().get("model"));
        Map<Long, String> dims = this.getEntryEntityRows();
        formShowParameter.setCustomParam("dims", (Object)SerializationUtils.serializeToBase64(dims));
        formShowParameter.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        formShowParameter.setShowTitle(true);
        formShowParameter.setFormId("eb_dealrelate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dealpage");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void setReturnDataToParent() {
        Map<Long, String> dims = this.getEntryEntityRows();
        this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(dims));
    }

    private Map<Long, String> getEntryEntityRows() {
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        int[] rows = eg.getSelectRows();
        HashMap<Long, String> dimMaps = new HashMap<Long, String>(rows.length);
        for (int row : rows) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("number", row);
            dimMaps.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        return dimMaps;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("dealpage".equals(key)) {
            Object data = closedCallBackEvent.getReturnData();
            if (data == null) {
                return;
            }
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)data;
            HashMap<Map<Long, String>, DynamicObjectCollection> dMap = new HashMap<Map<Long, String>, DynamicObjectCollection>();
            dMap.put(this.getEntryEntityRows(), dynamicObjects);
            this.getView().returnDataToParent(dMap);
            this.getView().close();
        }
    }
}

