/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.decompose.service.CusMemberServiceHelper;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.BasedataEnum;
import kd.epm.eb.common.decompose.DecDimensionUtil;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeDetail;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeQueryVO;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeRecord;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.AdjustDecomposeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.common.utils.tree.TemplateUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.approveBill.ApproveBillEditSupport;
import kd.epm.eb.formplugin.utils.ReportAdjustUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DecomposeAdjustFormPlugin
extends AbstractFormPlugin
implements ApproveBillEditSupport {
    private static final Log LOG = LogFactory.getLog(DecomposeAdjustFormPlugin.class);
    private static final String FORM_ID = "eb_adjust_trial";
    private static final String ENTRY_ID = "entryentity";
    private List<Map<String, String>> selectedDimensions = null;
    private List<Map<String, String>> dimViewMaps = null;
    private static final String MEMBERJSON = "memberjson";
    private static final String VIEWJSON = "viewjson";
    private static final String DIMENSION_ID = "dimension";
    private static final String NOSAVE_WARN = "adjust_nosave_warn";
    private static final String DECIMAL_FORMAT_STR = "#,###";
    private static final String BTN_REFRESH = "btn_refresh";
    Map<String, List<String>> rowAndCol = null;
    private boolean isAlreadTip = false;
    private String node;
    private IModelCacheHelper modelCacheHelper = null;
    private static DataDecomposeService dataDecomposeService = DataDecomposeService.getInstance();

    public String getNode() {
        if (this.node == null) {
            Long approveBillId = (Long)this.getView().getFormShowParameter().getCustomParam("approveBillId");
            this.node = ApproveUtils.getInstance().getCurNodeIdByApproveBill(approveBillId);
        }
        return this.node;
    }

    public Map<String, List<String>> getRowAndCol() {
        if (this.rowAndCol == null) {
            this.rowAndCol = (Map)this.getView().getFormShowParameter().getCustomParam("rowAndCol");
        }
        return this.rowAndCol;
    }

    public List<Map<String, String>> getSelectedDimensions() {
        if (this.selectedDimensions == null) {
            this.selectedDimensions = (List)this.getView().getFormShowParameter().getCustomParam("selectedDimensions");
        }
        return this.selectedDimensions;
    }

    public List<Map<String, String>> getDimViewMaps() {
        if (this.dimViewMaps == null) {
            this.dimViewMaps = (List)this.getView().getFormShowParameter().getCustomParam("dimViewMaps");
        }
        return this.dimViewMaps;
    }

    public IModelCacheHelper getIModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            Long modelId = this.getModelId();
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    private boolean isRecord() {
        boolean isRecord = false;
        if (this.getView().getFormShowParameter().getCustomParam("isRecord") != null) {
            isRecord = (Boolean)this.getView().getFormShowParameter().getCustomParam("isRecord");
        }
        return isRecord;
    }

    public void afterCreateNewData(EventObject e) {
        try {
            IFormView formView = this.getView();
            for (int i = 1; i <= 22; ++i) {
                formView.setVisible(Boolean.FALSE, new String[]{"entry_dim" + i, "dim" + i});
            }
            if (this.isRecord()) {
                formView.setVisible(Boolean.FALSE, new String[]{"savedatabtn", "logview"});
            }
            formView.setVisible(Boolean.FALSE, new String[]{"entityview1"});
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            this.itemsDynamicBindData(formShowParameter);
            this.refreshList();
            AdjustServiceHelper.refreshBtnUnitStyle((int)Integer.parseInt(this.getUnit()), (IFormView)this.getView(), (String)"btn_dataunit");
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            this.getView().showTipNotification(ex.getMessage());
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void itemsDynamicBindData(FormShowParameter formShowParameter) {
        Control dimensionGrid = this.getControl(DIMENSION_ID);
        Map modelCollection = (Map)formShowParameter.getCustomParam("modelCollection");
        if (modelCollection == null) {
            return;
        }
        for (Map.Entry next : modelCollection.entrySet()) {
            String key = (String)next.getKey();
            String entityName = BasedataEnum.loadByKey((String)key).getEntityName();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(next.getValue(), (String)entityName, (String)"id,name,number");
            dimensionGrid.getModel().setValue(key, (Object)dynamicObject);
        }
        Map<String, String> dimensionMap = this.getSelectedDimensions().get(0);
        Map<String, String> dimViewMap = this.getDimViewMaps().get(0);
        Map<String, List<String>> rowAndCol = this.getRowAndCol();
        List<String> rows = rowAndCol.get("rows");
        List<String> cols = rowAndCol.get("cols");
        Iterator<Map.Entry<String, String>> iterator = dimensionMap.entrySet().iterator();
        int i = 1;
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            String dimenKey = next.getKey();
            String field = "dim" + i;
            if (rows == null || cols == null || rows.contains(dimenKey) || cols.contains(dimenKey)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{field});
            String memberNumber = dimensionMap.get(dimenKey);
            TextEdit textEdit = (TextEdit)this.getView().getControl(field);
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Dimension dimension = modelCacheHelper.getDimension(dimenKey);
            textEdit.setCaption(new LocaleString(dimension.getName()));
            if (memberNumber == null) continue;
            Long dimViewId = IDUtils.toLong((Object)dimViewMap.get(dimension.getNumber()));
            Member member = dimension.getMember(dimViewId, memberNumber);
            if (member == null) {
                member = dimension.getMember(dimViewId, dimension.getNoneNumber());
            }
            dimensionGrid.getModel().setValue(field, (Object)member.getName());
            ++i;
        }
    }

    private void setDimValueToCol(Map<String, String> memberMap, List<String> dims, IDataModel iDataModel, int rowIndex, int colIndex, Map<String, Long> dimViewMap) {
        for (String dim : dims) {
            String field = "entry_dim" + colIndex;
            Dimension dimension = this.modelCacheHelper.getDimension(dim);
            String memberNumber = memberMap.get(dim);
            Long dimViewId = dimViewMap.get(dimension.getNumber());
            Member member = dimension.getMember(dimViewId, memberNumber);
            if (member == null) {
                member = dimension.getMember(dimViewId, dimension.getNoneNumber());
            }
            iDataModel.setValue(field, (Object)member.getName(), rowIndex);
            ++colIndex;
        }
    }

    private void setDimTitleToCol(List<String> dims, int colIndex) {
        for (String dim : dims) {
            String field = "entry_dim" + colIndex;
            this.getView().setVisible(Boolean.TRUE, new String[]{field});
            TextEdit textEdit = (TextEdit)this.getView().getControl(field);
            Dimension dimension = this.modelCacheHelper.getDimension(dim);
            textEdit.setCaption(new LocaleString(dimension.getName()));
            ++colIndex;
        }
    }

    private void refreshList() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ID);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Dimension metricDimension = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
        IDataModel iDataModel = entryGrid.getModel();
        IFormView formView = this.getView();
        Map<String, List<String>> rowAndCol = this.getRowAndCol();
        List<String> rows = rowAndCol.get("rows");
        List<String> cols = rowAndCol.get("cols");
        if (rows != null) {
            this.setDimTitleToCol(rows, 1);
            this.setDimTitleToCol(cols, rows.size() + 1);
        }
        AdjustDecomposeQueryVO queryVO = new AdjustDecomposeQueryVO();
        AdjustDecomposeRecord adjustDecomposeRecord = new AdjustDecomposeRecord();
        adjustDecomposeRecord.setModelId(this.getModelId());
        adjustDecomposeRecord.setBusinessModelId(this.getBizModelId());
        adjustDecomposeRecord.setDataSetId(this.getDatasetId());
        queryVO.setAdjustDecomposeRecord(adjustDecomposeRecord);
        List<Map<String, String>> selectedDimensions = this.getSelectedDimensions();
        List<Map<String, String>> dimViewMaps = this.getDimViewMaps();
        iDataModel.deleteEntryData(ENTRY_ID);
        iDataModel.beginInit();
        if (this.isRecord()) {
            DynamicObjectCollection recordList = AdjustServiceHelper.queryAdjustDecomposeRecordList((AdjustDecomposeQueryVO)queryVO, selectedDimensions);
            if (recordList.isEmpty()) {
                return;
            }
            iDataModel.batchCreateNewEntryRow(ENTRY_ID, recordList.size());
            HashSet<Long> viewIds = new HashSet<Long>(16);
            boolean hasNumberMetric = false;
            formView.setVisible(Boolean.TRUE, new String[]{"adjusttrial"});
            for (int i = 0; i < recordList.size(); ++i) {
                formView.setEnable(Boolean.FALSE, i, new String[]{"pendingtrial", "adjusttrial", "fixtrial"});
                DynamicObject record = (DynamicObject)recordList.get(i);
                String memberMapStr = record.getString("dimensionjson");
                String viewjsonStr = record.getString(VIEWJSON);
                Map memberMap = (Map)JSON.parseObject((String)memberMapStr, HashMap.class);
                Map viewMap = (Map)JSON.parseObject((String)viewjsonStr, HashMap.class);
                iDataModel.setValue(MEMBERJSON, (Object)memberMapStr, i);
                iDataModel.setValue(VIEWJSON, (Object)viewjsonStr, i);
                iDataModel.setValue("modifyoperator", record.get("modifyoperator"), i);
                iDataModel.setValue("modifytime", record.get("modifytime"), i);
                iDataModel.setValue("adjustexplain", record.get("adjustexplain"), i);
                String metricDataType = AdjustServiceHelper.getMetricDataType((Map)memberMap, (Dimension)metricDimension);
                iDataModel.setValue("metrictype", (Object)metricDataType, i);
                iDataModel.setValue("type", (Object)record.getString("type"), i);
                iDataModel.setValue("status", record.get("status"), i);
                if (viewMap != null && viewMap.get(SysDimensionEnum.Entity.getNumber()) != null) {
                    long entityview = Long.parseLong((String)viewMap.get(SysDimensionEnum.Entity.getNumber()));
                    viewIds.add(entityview);
                    if (viewIds.size() > 1) {
                        formView.setVisible(Boolean.TRUE, new String[]{"entityview1"});
                    }
                    iDataModel.setValue("entityview1", (Object)entityview, i);
                }
                if (rows != null) {
                    Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
                    this.setDimValueToCol(memberMap, rows, iDataModel, i, 1, dimViewMap);
                    this.setDimValueToCol(memberMap, cols, iDataModel, i, rows.size() + 1, dimViewMap);
                }
                Object pendingTrial = AdjustServiceHelper.getValueFromDetail((DynamicObject)record, (String)metricDataType, (String)"pendingtrial");
                Object adjustTrial = AdjustServiceHelper.getValueFromDetail((DynamicObject)record, (String)metricDataType, (String)"adjusttrial");
                Object fixTrial = AdjustServiceHelper.getValueFromDetail((DynamicObject)record, (String)metricDataType, (String)"fixtrial");
                if (AdjustServiceHelper.isNumberMetric((String)metricDataType)) {
                    iDataModel.setValue("pendingtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr((BigDecimal)pendingTrial, this.getUnit(), metricDataType), i);
                    iDataModel.setValue("adjusttrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr((BigDecimal)adjustTrial, this.getUnit(), metricDataType), i);
                    iDataModel.setValue("fixtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr((BigDecimal)fixTrial, this.getUnit(), metricDataType), i);
                    hasNumberMetric = true;
                    continue;
                }
                iDataModel.setValue("pendingtrial", pendingTrial, i);
                iDataModel.setValue("adjusttrial", null, i);
                iDataModel.setValue("fixtrial", fixTrial, i);
            }
            if (!hasNumberMetric) {
                formView.setVisible(Boolean.FALSE, new String[]{"adjusttrial"});
            }
        } else {
            AdjustDecomposeDetail adjustDecomposeDetail = new AdjustDecomposeDetail();
            adjustDecomposeDetail.setNode(this.getNode());
            adjustDecomposeDetail.setModifyOperator(UserUtils.getUserId());
            adjustDecomposeDetail.setReportProcessId((Long)formShowParameter.getCustomParam("reportProcessId"));
            adjustDecomposeDetail.setApproveBillId((Long)formShowParameter.getCustomParam("approveBillId"));
            adjustDecomposeDetail.setType(AdjustDecomposeTypeEnum.ADJUST.getNumber());
            queryVO.setAdjustDecomposeDetail(adjustDecomposeDetail);
            DynamicObjectCollection recordList = AdjustServiceHelper.queryAdjustDecomposeRecordList((AdjustDecomposeQueryVO)queryVO, selectedDimensions);
            iDataModel.batchCreateNewEntryRow(ENTRY_ID, selectedDimensions.size());
            for (int i = 0; i < selectedDimensions.size(); ++i) {
                Map<String, String> memberMap = selectedDimensions.get(i);
                Map<Object, Object> dimViewMap = dimViewMaps != null ? dimViewMaps.get(i) : new HashMap(16);
                iDataModel.setValue(MEMBERJSON, (Object)JSON.toJSONString(memberMap), i);
                iDataModel.setValue(VIEWJSON, (Object)JSON.toJSONString(dimViewMap), i);
                String metricDataType = AdjustServiceHelper.getMetricDataType(memberMap, (Dimension)metricDimension);
                iDataModel.setValue("metrictype", (Object)metricDataType, i);
                Map dimensionViewMap = AdjustServiceHelper.getDimViewMap(dimViewMap);
                if (rows != null) {
                    this.setDimValueToCol(memberMap, rows, iDataModel, i, 1, dimensionViewMap);
                    this.setDimValueToCol(memberMap, cols, iDataModel, i, rows.size() + 1, dimensionViewMap);
                }
                IKDCell ikdCell = dataDecomposeService.queryCell(DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheHelper, memberMap), memberMap, modelCacheHelper, dimensionViewMap);
                BigDecimal pendingtrial = BigDecimal.ZERO;
                if (ikdCell != null) {
                    Object value = ikdCell.getValue().getValue();
                    if (AdjustServiceHelper.isNumberMetric((String)metricDataType)) {
                        pendingtrial = (BigDecimal)value;
                        iDataModel.setValue("pendingtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(pendingtrial, this.getUnit(), metricDataType), i);
                        iDataModel.setValue("fixtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(pendingtrial, this.getUnit(), metricDataType), i);
                    } else {
                        iDataModel.setValue("pendingtrial", value, i);
                        iDataModel.setValue("fixtrial", value, i);
                    }
                }
                for (DynamicObject record : recordList) {
                    Map dimensionMap = (Map)JSON.parseObject((String)record.getString("dimensionjson"), HashMap.class);
                    if (!AdjustServiceHelper.removeCustomDimNoneMember(memberMap, (IModelCacheHelper)modelCacheHelper).equals(dimensionMap)) continue;
                    int status = record.getInt("status");
                    Map viewMap = (Map)JSON.parseObject((String)record.getString(VIEWJSON), HashMap.class);
                    if (!dimViewMap.equals(viewMap) || status != DecomposeStatus.WAIT.getValue() && status != DecomposeStatus.NOT_NEED_DECOMPOSE.getValue()) continue;
                    iDataModel.setValue("detailid", (Object)record.getLong("entryid"), i);
                    Object adjustTrial = AdjustServiceHelper.getValueFromDetail((DynamicObject)record, (String)metricDataType, (String)"adjusttrial");
                    Object fixTrial = AdjustServiceHelper.getValueFromDetail((DynamicObject)record, (String)metricDataType, (String)"fixtrial");
                    if (AdjustServiceHelper.isNumberMetric((String)metricDataType)) {
                        iDataModel.setValue("pendingtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(pendingtrial.subtract((BigDecimal)adjustTrial), this.getUnit(), metricDataType), i);
                        iDataModel.setValue("adjusttrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr((BigDecimal)adjustTrial, this.getUnit(), metricDataType), i);
                        iDataModel.setValue("oldadjusttrial", adjustTrial, i);
                        iDataModel.setValue("fixtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(pendingtrial, this.getUnit(), metricDataType), i);
                    } else {
                        iDataModel.setValue("adjusttrial", adjustTrial, i);
                        iDataModel.setValue("fixtrial", fixTrial, i);
                    }
                    iDataModel.setValue("modifyoperator", record.get("modifyoperator"), i);
                    iDataModel.setValue("modifytime", record.get("modifytime"), i);
                    iDataModel.setValue("adjustexplain", record.get("adjustexplain"), i);
                    iDataModel.setValue("status", record.get("status"), i);
                }
            }
        }
        iDataModel.endInit();
        this.getView().updateView(ENTRY_ID);
        iDataModel.setDataChanged(false);
    }

    @Override
    public void registerListener(EventObject args) {
        super.registerListener(args);
        if (this.getView() != null) {
            this.addItemClickListeners(new String[]{"toolbarap", "savedatabtn", "logview"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        try {
            this.dealItemClick(evt);
        }
        catch (Exception e) {
            LOG.error("DecomposeAdjustFormPlugin.itemClick error:", (Throwable)e);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"savedatabtn"});
            throw new KDBizException(e.getMessage());
        }
    }

    private void dealItemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "savedatabtn": {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"savedatabtn"});
                this.saveData();
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"savedatabtn"});
                break;
            }
            case "logview": {
                int[] selectRows = ((EntryGrid)this.getControl(ENTRY_ID)).getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.tip(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u6570\u636e\u884c\u3002", (String)"DynamicReportProcess_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.visitNewPage(selectRows);
                break;
            }
            case "btn_unit0": 
            case "btn_unit3": 
            case "btn_unit4": 
            case "btn_unit6": 
            case "btn_unit8": {
                this.dataUnitChange(itemKey);
                break;
            }
            case "btn_refresh": {
                this.refreshList();
            }
        }
    }

    private void dataUnitChange(String itemKey) {
        String changeunit = itemKey.substring(itemKey.length() - 1);
        String oldUnit = this.getUnit();
        if (StringUtils.equals((CharSequence)oldUnit, (CharSequence)changeunit)) {
            return;
        }
        this.getPageCache().put("unit", changeunit);
        DynamicObject[] dataEntitys = ((EntryGrid)this.getControl(ENTRY_ID)).getEntryData().getDataEntitys();
        for (int i = 0; i < dataEntitys.length; ++i) {
            DynamicObject dynamicObject = dataEntitys[i];
            String metricDataType = dynamicObject.getString("metrictype");
            boolean needReCalc = MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType);
            if (!needReCalc) continue;
            this.getModel().setValue("pendingtrial", (Object)this.calcDataByUnit(changeunit, oldUnit, this.getBigDecimal(dynamicObject, "pendingtrial", false)), i);
            this.getModel().setValue("adjusttrial", (Object)this.calcDataByUnit(changeunit, oldUnit, this.getBigDecimal(dynamicObject, "adjusttrial", false)), i);
            this.getModel().setValue("fixtrial", (Object)this.calcDataByUnit(changeunit, oldUnit, this.getBigDecimal(dynamicObject, "fixtrial", false)), i);
        }
        AdjustServiceHelper.refreshBtnUnitStyle((int)Integer.parseInt(changeunit), (IFormView)this.getView(), (String)"btn_dataunit");
    }

    private String calcDataByUnit(String newUnit, String oldUnit, BigDecimal bigDecimal) {
        BigDecimal divide = bigDecimal.multiply(BigDecimal.TEN.pow(Integer.parseInt(oldUnit))).divide(BigDecimal.TEN.pow(Integer.parseInt(newUnit))).stripTrailingZeros();
        return DecomposeAdjustFormPlugin.transBigDecimalToStr(divide, "0", MetricDataTypeEnum.CURRENCY.getIndex());
    }

    public static String transBigDecimalToStr(BigDecimal number, String unit, String metricDataType) {
        if (BigDecimal.ZERO.compareTo(number) == 0) {
            return "0";
        }
        BigDecimal divide = number;
        if (MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType)) {
            divide = number.divide(BigDecimal.TEN.pow(Integer.parseInt(unit)));
        }
        DecimalFormat format = new DecimalFormat("#,##0.00");
        format.setMinimumFractionDigits(2);
        format.setMaximumFractionDigits(Math.max(divide.scale(), 2));
        return format.format(divide);
    }

    private synchronized void saveData() {
        IPageCache pageCache;
        Long modelId = this.getModelId();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ID);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        ArrayList<AdjustDecomposeRecord> adjustDecomposeRecordList = new ArrayList<AdjustDecomposeRecord>(dataEntitys.length);
        ArrayList<BGCell> cells = new ArrayList<BGCell>(dataEntitys.length);
        Long datasetId = this.getDatasetId();
        ArrayList<Map> deleteOlds = new ArrayList<Map>(10);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long reportProcessId = (Long)formShowParameter.getCustomParam("reportProcessId");
        Long approveBillId = (Long)formShowParameter.getCustomParam("approveBillId");
        HashMap<String, Map> cellViewMap = new HashMap<String, Map>(16);
        for (DynamicObject dynamicObject : dataEntitys) {
            String viewjsonStr;
            Map viewMap;
            String memberjsonStr = dynamicObject.getString(MEMBERJSON);
            Map memberMap = (Map)JSON.parseObject((String)memberjsonStr, HashMap.class);
            boolean checkLock = ReportAdjustUtils.checkLock(modelId, memberMap, this::tip, viewMap = (Map)JSON.parseObject((String)(viewjsonStr = dynamicObject.getString(VIEWJSON)), HashMap.class));
            if (!checkLock) {
                return;
            }
            String metricDataType = dynamicObject.getString("metrictype");
            boolean needRecalc = "1".equals(metricDataType);
            if (!AdjustServiceHelper.isNumber((String)dynamicObject.getString("adjusttrial"), (String)this.getUnit(), (boolean)needRecalc) || !AdjustServiceHelper.isNumber((String)dynamicObject.getString("fixtrial"), (String)this.getUnit(), (boolean)needRecalc)) {
                this.tip(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8c03\u6574\u9879\u3002", (String)"DecomposeAdjustFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            long detailId = dynamicObject.getLong("detailid");
            BigDecimal adjustTrial = this.getBigDecimal(dynamicObject, "adjusttrial", needRecalc);
            if (adjustTrial.equals(BigDecimal.ZERO)) {
                AdjustServiceHelper.deleteAdjustDecomposeDetail((Long)detailId);
                deleteOlds.add(memberMap);
            } else {
                AdjustDecomposeRecord record = new AdjustDecomposeRecord();
                record.setModelId(this.getModelId());
                record.setBusinessModelId(this.getBizModelId());
                record.setDataSetId(this.getDatasetId());
                record.setAccountId(AdjustServiceHelper.getMemberId((String)SysDimensionEnum.Account.getNumber(), (Map)memberMap, (IModelCacheHelper)modelCacheHelper, (Map)viewMap));
                record.setAuditTrailId(AdjustServiceHelper.getMemberId((String)SysDimensionEnum.AuditTrail.getNumber(), (Map)memberMap, (IModelCacheHelper)modelCacheHelper, (Map)viewMap));
                record.setBudgetPeriodId(AdjustServiceHelper.getMemberId((String)SysDimensionEnum.BudgetPeriod.getNumber(), (Map)memberMap, (IModelCacheHelper)modelCacheHelper, (Map)viewMap));
                record.setDataTypeId(AdjustServiceHelper.getMemberId((String)SysDimensionEnum.DataType.getNumber(), (Map)memberMap, (IModelCacheHelper)modelCacheHelper, (Map)viewMap));
                record.setCurrencyId(AdjustServiceHelper.getMemberId((String)SysDimensionEnum.Currency.getNumber(), (Map)memberMap, (IModelCacheHelper)modelCacheHelper, (Map)viewMap));
                record.setEntityId(AdjustServiceHelper.getMemberId((String)SysDimensionEnum.Entity.getNumber(), (Map)memberMap, (IModelCacheHelper)modelCacheHelper, (Map)viewMap));
                record.setVersionId(AdjustServiceHelper.getMemberId((String)SysDimensionEnum.Version.getNumber(), (Map)memberMap, (IModelCacheHelper)modelCacheHelper, (Map)viewMap));
                record.setMemberMap(memberMap);
                AdjustDecomposeDetail adjustDecomposeDetail = new AdjustDecomposeDetail();
                if (IDUtils.isNotNull((long)detailId)) {
                    adjustDecomposeDetail.setId(Long.valueOf(detailId));
                }
                adjustDecomposeDetail.setAdjustTrial((Object)adjustTrial);
                adjustDecomposeDetail.setPendingTrial((Object)this.getBigDecimal(dynamicObject, "pendingtrial", needRecalc));
                adjustDecomposeDetail.setFixTrial((Object)this.getBigDecimal(dynamicObject, "fixtrial", needRecalc));
                adjustDecomposeDetail.setType(AdjustDecomposeTypeEnum.ADJUST.getNumber());
                adjustDecomposeDetail.setAdjustExplain(dynamicObject.getString("adjustexplain"));
                adjustDecomposeDetail.setNode(this.getNode());
                adjustDecomposeDetail.setEntityViewId(Long.valueOf(Long.parseLong((String)viewMap.get(SysDimensionEnum.Entity.getNumber()))));
                adjustDecomposeDetail.setViewMap(viewMap);
                adjustDecomposeDetail.setReportProcessId(reportProcessId);
                adjustDecomposeDetail.setApproveBillId(approveBillId);
                record.setDetails(Collections.singletonList(adjustDecomposeDetail));
                adjustDecomposeRecordList.add(record);
            }
            BGCell cell = new BGCell(memberMap, (Object)adjustTrial.subtract(dynamicObject.getBigDecimal("oldadjusttrial")));
            cells.add(cell);
            cellViewMap.put(memberMap.toString(), AdjustServiceHelper.getDimViewMap((Map)viewMap));
        }
        AdjustServiceHelper.saveAdjustDecomposeRecord(adjustDecomposeRecordList);
        boolean deleteOld = false;
        if (CollectionUtils.isNotEmpty(deleteOlds)) {
            deleteOld = true;
        }
        String templateNumber = TemplateUtils.getTemplateNumberByReportProcessId((Long)reportProcessId);
        OlapTraceServiceHelper.setTraceOpInfo((String)templateNumber);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.AdjustDecompose));
        DataDecomposeService.getInstance().adjustToOlap(modelId.longValue(), datasetId, cells, deleteOld, cellViewMap);
        for (Map memberMap : deleteOlds) {
            Map dimViewMap = (Map)cellViewMap.get(memberMap.toString());
            CusMemberServiceHelper.deleteCosmicMember((Long)modelId, (Map)memberMap, (Map)dimViewMap);
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (pageCache = parentView.getPageCache()) != null) {
            ApproveUtils.getInstance().updateRejectOpinionStatus(IDUtils.toLong((Object)pageCache.get("current_report_id")).longValue(), this.getApproveBillId().longValue());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DynamicReportProcess_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
        this.refreshList();
    }

    private void tip(String msg) {
        this.getView().showTipNotification(msg);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        try {
            String itemKey;
            switch (itemKey = evt.getItemKey()) {
                case "savedatabtn": {
                    DynamicObject[] dataEntitys = ((EntryGrid)this.getControl(ENTRY_ID)).getEntryData().getDataEntitys();
                    for (int i = 0; i < dataEntitys.length; ++i) {
                        DynamicObject dataEntity = dataEntitys[i];
                        String metricDataType = dataEntity.getString("metrictype");
                        boolean needRecalc = "1".equals(metricDataType);
                        if (!this.checkInput(dataEntity.getString("adjusttrial"), needRecalc)) {
                            evt.setCancel(true);
                            return;
                        }
                        if (this.checkInput(dataEntity.getString("fixtrial"), needRecalc)) continue;
                        evt.setCancel(true);
                        return;
                    }
                    break;
                }
            }
            super.beforeItemClick(evt);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private boolean checkInput(String dataEntityString, boolean needRecalc) {
        boolean isNumber = AdjustServiceHelper.isNumber((String)dataEntityString, (String)this.getUnit(), (boolean)needRecalc);
        if (!isNumber) {
            if (!this.isAlreadTip) {
                if (AdjustServiceHelper.checkDecimalLen((String)dataEntityString, (String)this.getUnit(), (boolean)needRecalc) > AdjustServiceHelper.DECIMAL_LEN) {
                    this.tip(ResManager.loadResFormat((String)"\u8f6c\u6362\u4e3a\u5143\u540e\u5c0f\u6570\u4f4d\u4e0d\u8d85\u8fc76\u4f4d\uff1a%1", (String)"DecomposeAdjustFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dataEntityString}));
                } else {
                    this.tip(ResManager.loadResFormat((String)"\u5f53\u524d\u8f93\u5165\u6709\u8bef\uff1a%1\uff0c\u6362\u7b97\u6210\u5143\u540e\uff0c\u8bf7\u8f93\u5165\u6574\u6570\u4e0d\u8d85\u8fc713\u4f4d\u4e14\u5c0f\u6570\u7cbe\u5ea6\u4e0d\u8d85\u8fc76\u4f4d\u7684\u6570\u503c\u3002", (String)"DecomposeAdjustFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dataEntityString}));
                }
            }
            this.isAlreadTip = false;
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            DynamicObject dataEntity;
            String field = e.getProperty().getName();
            if (!"fixtrial".equals(field) && !"adjusttrial".equals(field)) {
                return;
            }
            this.getModel().setDataChanged(true);
            ChangeData[] changeSet = e.getChangeSet();
            Long modelId = this.getModelId();
            for (ChangeData changeData : changeSet) {
                BigDecimal oldValue;
                String oldValueStr;
                int rowIndex = changeData.getRowIndex();
                dataEntity = this.getModel().getEntryRowEntity(ENTRY_ID, rowIndex);
                String metricDataType = dataEntity.getString("metrictype");
                boolean needRecalc = "1".equals(metricDataType);
                Object dataNewValue = changeData.getNewValue();
                if (dataNewValue == null) continue;
                String newValueStr = dataNewValue.toString();
                if (!this.checkInput(newValueStr, needRecalc)) {
                    return;
                }
                Object dataOldValue = changeData.getOldValue();
                if (dataOldValue == null || !AdjustServiceHelper.isNumber((String)(oldValueStr = dataOldValue.toString()), (String)this.getUnit(), (boolean)needRecalc)) continue;
                BigDecimal newValue = this.transBigDecimalForStr(newValueStr, false);
                if (newValue.equals(oldValue = this.transBigDecimalForStr(oldValueStr, false))) {
                    return;
                }
                if (newValue == null || newValue.equals(oldValue)) continue;
                this.getPageCache().put("ADJUST_SAVE_STATUS", Boolean.FALSE.toString());
            }
            for (ChangeData changeData : changeSet) {
                int index = changeData.getRowIndex();
                dataEntity = changeData.getDataEntity();
                BigDecimal pendingTrial = this.getBigDecimal(dataEntity, "pendingtrial", false);
                BigDecimal fixTrial = this.getBigDecimal(dataEntity, "fixtrial", false);
                BigDecimal adjustTrial = this.getBigDecimal(dataEntity, "adjusttrial", false);
                int compareTo = fixTrial.subtract(pendingTrial).compareTo(adjustTrial);
                if (compareTo == 0) continue;
                switch (field) {
                    case "fixtrial": {
                        adjustTrial = fixTrial.subtract(pendingTrial);
                        this.getModel().setValue("adjusttrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(adjustTrial, "0", null), index);
                        this.getModel().setValue("fixtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(fixTrial, "0", null), index);
                        break;
                    }
                    case "adjusttrial": {
                        fixTrial = pendingTrial.add(adjustTrial);
                        this.getModel().setValue("fixtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(fixTrial, "0", null), index);
                        this.getModel().setValue("adjusttrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(adjustTrial, "0", null), index);
                        break;
                    }
                }
                this.getModel().setValue("pendingtrial", (Object)DecomposeAdjustFormPlugin.transBigDecimalToStr(pendingTrial, "0", null), index);
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private BigDecimal getBigDecimal(DynamicObject dataEntity, String key, boolean needMultiply) {
        String decimalStr = dataEntity.getString(key);
        BigDecimal bigDecimal = this.transBigDecimalForStr(decimalStr, needMultiply);
        return bigDecimal;
    }

    private BigDecimal transBigDecimalForStr(String numberStr, boolean needMultiply) {
        if (StringUtils.isBlank((CharSequence)numberStr)) {
            return BigDecimal.ZERO;
        }
        DecimalFormat decimalFormat = new DecimalFormat(DECIMAL_FORMAT_STR);
        decimalFormat.setParseBigDecimal(true);
        ParsePosition parsePosition = new ParsePosition(0);
        if (needMultiply) {
            String tranStr = new BigDecimal(numberStr.replace(",", "")).multiply(BigDecimal.TEN.pow(Integer.parseInt(this.getUnit()))).stripTrailingZeros().toPlainString();
            return (BigDecimal)decimalFormat.parse(tranStr, parsePosition);
        }
        return (BigDecimal)decimalFormat.parse(numberStr, parsePosition);
    }

    @Override
    public Long getModelId() {
        return (Long)this.getModel().getValue("model_id");
    }

    private Long getBizModelId() {
        return (Long)this.getModel().getValue("bizmodel_id");
    }

    private Long getDatasetId() {
        return (Long)this.getModel().getValue("dataset_id");
    }

    private void visitNewPage(int[] selectRows) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IFormView formView = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setPageId(StringUtils.join((Object[])new String[]{parameter.getFormId(), "_", formView.getPageId()}));
        Map customParams = formShowParameter.getCustomParams();
        List<Map<String, String>> selectedDimensions = this.getSelectedDimensions();
        List<Map<String, String>> dimViewMaps = this.getDimViewMaps();
        ArrayList<Map<String, String>> newSelectedDimensions = new ArrayList<Map<String, String>>(selectRows.length);
        ArrayList<Map<String, String>> newDimViewMaps = new ArrayList<Map<String, String>>(selectRows.length);
        for (int selectRow : selectRows) {
            newSelectedDimensions.add(selectedDimensions.get(selectRow));
            newDimViewMaps.add(dimViewMaps.get(selectRow));
        }
        customParams.put("selectedDimensions", newSelectedDimensions);
        customParams.put("dimViewMaps", newDimViewMaps);
        parameter.setCustomParams(customParams);
        parameter.setCustomParam("showtype", (Object)ShowType.NewWindow.getValue());
        parameter.setCustomParam("unit", (Object)this.getUnit());
        parameter.setCustomParam("isRecord", (Object)Boolean.TRUE);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.setFormId(FORM_ID);
        parameter.setStatus(OperationStatus.VIEW);
        formView.showForm(parameter);
    }

    private String getUnit() {
        String unit = this.getPageCache().get("unit");
        if (StringUtils.isEmpty((CharSequence)unit)) {
            Object unitObj = this.getCustomFormParam("unit");
            unit = unitObj == null || StringUtils.isEmpty((CharSequence)String.valueOf(unitObj)) ? "0" : String.valueOf(unitObj);
        }
        return unit;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.isRecord()) {
            try {
                ReportAdjustUtils.unlock(this.getModelId(), this.getSelectedDimensions(), this.getDimViewMaps());
            }
            catch (Exception ex) {
                LOG.info(ex.getMessage());
            }
        }
        super.beforeClosed(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "adjust_nosave_warn": {
                boolean flag;
                boolean bl = flag = messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue();
                if (!flag) break;
                if (this.getPageCache() != null) {
                    this.getModel().setDataChanged(false);
                }
                this.getView().close();
                break;
            }
        }
    }
}

