/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.epm.eb.common.decompose.entity.DecDimension;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class DecomposeDimensionOrderPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String MOVE_UP = "move_up";
    public static final String MOVE_DOWN = "move_down";
    public static final String DIMENSION = "dimension";
    public static final String DIMENSION_LIST = "dimensionList";
    public static final String CURRENT_INDEX = "currentIndex";
    public static final String SAVE = "save";
    public static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{MOVE_UP, MOVE_DOWN, SAVE});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            Object dimension = customParams.get(DIMENSION);
            Object dimensionList = customParams.get(DIMENSION_LIST);
            if (dimension != null && dimensionList != null) {
                String dimensionStr = (String)dimension;
                String dimensions = (String)dimensionList;
                this.getPageCache().put(DIMENSION, dimensionStr);
                this.getPageCache().put(DIMENSION_LIST, dimensions);
                this.showDimension();
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void showDimension() {
        int index;
        String dimension = this.getPageCache().get(DIMENSION);
        String dimensionList = this.getPageCache().get(DIMENSION_LIST);
        List list = JSONArray.parseArray((String)dimensionList, DecDimension.class);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        String[] split = dimension.split(",");
        for (int i = 0; i < split.length; ++i) {
            index = this.getModel().createNewEntryRow(ENTRY_ENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index);
            entryRowEntity.set("index", (Object)(i + 1));
            entryRowEntity.set("dimension_name", (Object)split[i]);
            entryRowEntity.set("dimension_number", (Object)((DecDimension)list.get(i)).getDimNumber());
        }
        this.getView().updateView(ENTRY_ENTITY);
        String currentIndex = this.getPageCache().get(CURRENT_INDEX);
        if (StringUtils.isNotEmpty((String)currentIndex)) {
            index = Integer.parseInt(currentIndex);
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            entryGrid.selectRows(index);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "move_up": {
                this.move(MOVE_UP);
                break;
            }
            case "move_down": {
                this.move(MOVE_DOWN);
                break;
            }
            case "save": {
                this.save();
                break;
            }
        }
    }

    private void save() {
        String dimension = this.getPageCache().get(DIMENSION);
        this.getView().returnDataToParent((Object)dimension);
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent evt) {
        int index = evt.getRow();
        this.getPageCache().put(CURRENT_INDEX, String.valueOf(index));
    }

    private void move(String operator) {
        DecDimension tempDimension;
        String temp;
        String currentIndex = this.getPageCache().get(CURRENT_INDEX);
        if (StringUtils.isEmpty((String)currentIndex)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DecomposeDimensionOrder_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimension = this.getPageCache().get(DIMENSION);
        String dimensionList = this.getPageCache().get(DIMENSION_LIST);
        List list = JSONArray.parseArray((String)dimensionList, DecDimension.class);
        String[] split = dimension.split(",");
        int size = this.getModel().getEntryEntity(ENTRY_ENTITY).size();
        int index = Integer.parseInt(currentIndex);
        String currentCheck = split[index];
        DecDimension decDimension = (DecDimension)list.get(index);
        if (index == 0 && MOVE_UP.equals(operator)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ef4\u5ea6\u5df2\u662f\u7b2c\u4e00\u4f4d\u3002", (String)"DecomposeDimensionOrder_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (index == size - 1 && MOVE_DOWN.equals(operator)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ef4\u5ea6\u5df2\u662f\u6700\u540e\u4e00\u4f4d\u3002", (String)"DecomposeDimensionOrder_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (MOVE_UP.equals(operator)) {
            temp = split[index - 1];
            tempDimension = (DecDimension)list.get(index - 1);
            split[index] = temp;
            list.set(index, tempDimension);
            split[index - 1] = currentCheck;
            list.set(index - 1, decDimension);
            --index;
        } else if (MOVE_DOWN.equals(operator)) {
            temp = split[index + 1];
            tempDimension = (DecDimension)list.get(index + 1);
            split[index] = temp;
            list.set(index, tempDimension);
            split[index + 1] = currentCheck;
            list.set(index + 1, decDimension);
            ++index;
        }
        this.getPageCache().put(CURRENT_INDEX, String.valueOf(index));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                stringBuilder.append(split[i]);
                continue;
            }
            stringBuilder.append(split[i]).append(",");
        }
        this.getPageCache().put(DIMENSION, stringBuilder.toString());
        this.getPageCache().put(DIMENSION_LIST, JSONArray.toJSONString((Object)list));
        this.showDimension();
    }
}

