/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.decompose.service.DecomposeTaskService;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.decompose.entity.DecDimension;
import kd.epm.eb.common.decompose.entity.DecomposeAgentEnum;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.formplugin.dataUpload.importandexport.BaseImportPlugin;
import kd.epm.eb.spread.report.excel.helper.POIHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DecomposeImportPlugin
extends BaseImportPlugin {
    private static final Log log = LogFactory.getLog(DecomposeImportPlugin.class);
    private final FileImportUtils fileImportUtils = FileImportUtils.getInstance();
    private final DecomposeTaskService decomposeTaskService = DecomposeTaskService.getInstance();
    private static final String BTNOK = "btnok";
    private String unit;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, "btncancel"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            List<XSSFWorkbook> uploadBooks = this.getXSSFWorkbooks();
            XSSFWorkbook workbook = uploadBooks.get(0);
            XSSFSheet sheet = workbook.getSheetAt(0);
            IFormView parentView = this.getView().getParentView();
            IDataModel parentViewModel = parentView.getModel();
            DynamicObject model = (DynamicObject)parentViewModel.getValue("model");
            DynamicObject scheme = (DynamicObject)parentViewModel.getValue("scheme");
            this.validScheme(scheme);
            long taskId = Long.parseLong(parentView.getPageCache().get("currentTaskId"));
            String agent = (String)parentViewModel.getValue("decompose_agent");
            String schemeType = scheme.getString("type");
            DynamicObject task = this.decomposeTaskService.queryTaskById(taskId);
            this.validTask(task);
            String decDimensionJson = task.getString("decdimensionjson");
            Map viewMap = (Map)JSON.parseObject((String)task.getString("viewjson"), HashMap.class);
            List decDimensions = JSONArray.parseArray((String)decDimensionJson, DecDimension.class);
            DecDimension decDimension = (DecDimension)JSON.parseObject((String)parentView.getPageCache().get("thisDecDimensionCache"), DecDimension.class);
            this.validDimension(decDimensions, decDimension);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)model.getLong("id"));
            ImportEntity importEntity = this.decomposeTaskService.prepareTemplateData(modelCache, schemeType, decDimensions, decDimension.getDimNumber(), agent);
            Map sheetHeaderMap = importEntity.getSheetHeaderMap();
            this.validHeader(sheetHeaderMap, sheet);
            int lastRowNum = sheet.getLastRowNum();
            int dataStartRowNum = 3;
            ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(lastRowNum);
            XSSFFormulaEvaluator evaluator = new XSSFFormulaEvaluator(workbook);
            XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)workbook);
            for (int i = dataStartRowNum; i <= lastRowNum; ++i) {
                XSSFRow row = sheet.getRow(i);
                HashMap data = new HashMap(sheetHeaderMap.size());
                if (row != null) {
                    int n = 0;
                    for (Map.Entry headerEntry : sheetHeaderMap.entrySet()) {
                        XSSFCell cell = row.getCell(n++);
                        String cellValue = (String)POIHelper.getCellValue((Cell)cell);
                        String entryKey = (String)headerEntry.getKey();
                        if (StringUtils.isNotEmpty((String)cellValue) && "change".equals(entryKey)) {
                            try {
                                BigDecimal bigDecimal = new BigDecimal(cellValue);
                                bigDecimal = bigDecimal.setScale(15, 4);
                                cellValue = bigDecimal.toString();
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        data.put(entryKey, cellValue);
                    }
                }
                dataList.add(data);
            }
            HashMap<Integer, String> errorMap = new HashMap<Integer, String>(16);
            this.validData(modelCache, decDimension, dataList, errorMap, viewMap);
            if (errorMap.isEmpty()) {
                this.importData(modelCache, dataList, decDimension, task);
                task.set("status", (Object)TaskStatus.START.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            } else {
                int cellNum = sheetHeaderMap.size();
                for (Map.Entry entry : errorMap.entrySet()) {
                    XSSFRow row = sheet.getRow((Integer)entry.getKey() + dataStartRowNum);
                    XSSFCell cell = row.createCell(cellNum, CellType.STRING);
                    cell.setCellValue((String)entry.getValue());
                }
                String fileName = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"DecomposeImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                try {
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)ImportAndExportUtil.writeFile((Workbook)workbook, (String)fileName));
                }
                catch (IOException iOException) {
                    String error = ResManager.loadResFormat((String)"\u4e0b\u8f7d\u9519\u8bef\u6587\u4ef6\u9519\u8bef\u3002", (String)"DecomposeImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    log.error(error + iOException.getMessage());
                    KDBizException kdBizException = new KDBizException(error);
                    kdBizException.initCause((Throwable)iOException);
                    throw kdBizException;
                }
            }
        }
    }

    private void validHeader(Map<String, Header> sheetHeaderMap, XSSFSheet sheet) {
        XSSFRow headerRow = sheet.getRow(2);
        if (headerRow == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u6a21\u677f\u9519\u8bef\u3002", (String)"DecomposeImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        int cellNum = 0;
        for (Map.Entry<String, Header> headerEntry : sheetHeaderMap.entrySet()) {
            XSSFCell cell;
            String cellValue;
            if (StringUtils.equals((String)(cellValue = this.fileImportUtils.getCellStringValue((Cell)(cell = headerRow.getCell(cellNum++)))), (String)headerEntry.getValue().getHeader())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u6a21\u677f\u9519\u8bef\u3002", (String)"DecomposeImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void validScheme(DynamicObject scheme) {
        if (scheme == null || !DecomposeSchemeStatus.START.getNumber().equals(scheme.getString("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5141\u8bb8\u5206\u89e3\u3002", (String)"DecomposeImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void validTask(DynamicObject task) {
        if (task == null || TaskStatus.DONE.getValue().equals(task.getInt("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5141\u8bb8\u5206\u89e3\u3002", (String)"DecomposeImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void validDimension(List<DecDimension> decDimensions, DecDimension decDimension) {
        for (DecDimension dimension : decDimensions) {
            if (!StringUtils.equals((String)dimension.getDimNumber(), (String)decDimension.getDimNumber())) continue;
            if (!DecomposeStatus.DONE.getValue().equals(dimension.getStatus())) break;
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u5206\u89e3\u3002", (String)"DecomposeImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void importData(IModelCacheHelper modelCache, List<Map<String, String>> dataList, DecDimension decDimension, DynamicObject task) {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentViewModel = parentView.getModel();
        DynamicObject scheme = (DynamicObject)parentViewModel.getValue("scheme");
        this.validScheme(scheme);
        long taskId = Long.parseLong(parentView.getPageCache().get("currentTaskId"));
        this.validTask(task);
        DynamicObjectCollection decomposeLogs = new DynamicObjectCollection();
        List decList = dataList.stream().filter(data -> Long.parseLong((String)data.get("pid")) == 0L).collect(Collectors.toList());
        dataList = dataList.stream().filter(data -> Long.parseLong((String)data.get("pid")) != 0L).collect(Collectors.toList());
        HashSet<Long> ids = new HashSet<Long>(decList.size());
        for (Map decData : decList) {
            ids.add(Long.parseLong((String)decData.get("id")));
        }
        DynamicObject[] decomposeRows = this.decomposeTaskService.queryDecLogsByIds(ids);
        Map<Long, DynamicObject> decomposeRowMap = Arrays.stream(decomposeRows).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        for (DynamicObject[] decData : decList) {
            DynamicObject parent = decomposeRowMap.get(Long.parseLong((String)decData.get("id")));
            if (parent != null) {
                long parentId = parent.getLong("id");
                this.createDecomposeLogs(modelCache, dataList, decDimension, parent, (String)decData.get("id"), parentId, taskId, decomposeLogs);
                parent.set("pendingtrial", (Object)this.stringToBigDecimal((String)decData.get("pendingtrial")));
                parent.set("change", (Object)this.stringToBigDecimal((String)decData.get("change")));
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u6a21\u677f\u540e\u518d\u5bfc\u5165\u3002", (String)"DecomposeImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Long> pidList = new ArrayList<Long>(decomposeRows.length);
        for (DynamicObject decomposeRow : decomposeRows) {
            pidList.add(decomposeRow.getLong("id"));
        }
        DeleteServiceHelper.delete((String)"eb_decompose_log", (QFilter[])new QFilter("parent", "in", pidList).toArray());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])decomposeLogs.toArray((Object[])new DynamicObject[0])));
        SaveServiceHelper.save((DynamicObject[])decomposeRows);
        String decDimensionJson = task.getString("decdimensionjson");
        List decDimensions = JSONArray.parseArray((String)decDimensionJson, DecDimension.class);
        for (DecDimension dimension : decDimensions) {
            if (!StringUtils.equals((String)dimension.getDimNumber(), (String)decDimension.getDimNumber())) continue;
            dimension.setAgent(DecomposeAgentEnum.INPUT.getValue());
            break;
        }
        task.set("decdimensionjson", (Object)JSONArray.toJSONString((Object)decDimensions));
    }

    private BigDecimal stringToBigDecimal(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            return this.getNewAmount(new BigDecimal(str));
        }
        catch (Exception e) {
            KDBizException kdBizException = new KDBizException(ResManager.loadKDString((String)"\u8868\u683c\u6570\u636e\u8f6c\u6362\u5f02\u5e38\u3002", (String)"DecomposeImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            kdBizException.initCause((Throwable)e);
            throw kdBizException;
        }
    }

    private String getUnit() {
        if (this.unit == null) {
            this.unit = this.getView().getParentView().getPageCache().get("unit");
        }
        return this.unit;
    }

    private BigDecimal getNewAmount(BigDecimal value) {
        if (StringUtils.equals((String)"4", (String)this.getUnit())) {
            return value.multiply(new BigDecimal(10000));
        }
        return value;
    }

    private void createDecomposeLogs(IModelCacheHelper modelCache, List<Map<String, String>> dataList, DecDimension decDimension, DynamicObject parent, String dataPid, long parentId, long taskId, DynamicObjectCollection decomposeLogs) {
        String srcdimensionjson = parent.getString("srcdimensionjson");
        Map srcdimensionMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
        ArrayList<String> dataPids = new ArrayList<String>(10);
        dataPids.add(dataPid);
        dataList = dataList.stream().filter(data -> !"1".equals(data.get("useFlag"))).collect(Collectors.toList());
        for (Map<String, String> data2 : dataList) {
            String pid = data2.get("pid");
            if (!dataPids.contains(data2.get("pid"))) continue;
            String id = data2.get("id");
            dataPids.add(id);
            BigDecimal change = this.stringToBigDecimal(data2.get("change"));
            BigDecimal pendingtrial = this.stringToBigDecimal(data2.get("pendingtrial"));
            String memberNumber = data2.get("number");
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"eb_decompose_log");
            log.set("id", (Object)Long.parseLong(id));
            log.set("pid", (Object)Long.parseLong(pid));
            log.set("task", (Object)taskId);
            log.set("value", (Object)change);
            log.set("change", (Object)change);
            log.set("pendingtrial", (Object)pendingtrial);
            log.set("parent", (Object)parentId);
            log.set("issueflag", (Object)"0");
            srcdimensionMap.put(decDimension.getDimNumber(), memberNumber);
            log.set("srcdimensionjson", (Object)AdjustServiceHelper.toJsonString((Map)srcdimensionMap));
            log.set("submitflag", (Object)"0");
            decomposeLogs.add((Object)log);
            data2.put("useFlag", "1");
        }
    }

    private void validData(IModelCacheHelper modelCache, DecDimension decDimension, List<Map<String, String>> dataList, Map<Integer, String> errorMap, Map<String, String> viewMap) {
        String number;
        Map<String, String> data;
        int i;
        String dimNumber = decDimension.getDimNumber();
        for (i = 0; i < dataList.size(); ++i) {
            Member member;
            data = dataList.get(i);
            if (data.isEmpty()) continue;
            number = data.get("number");
            if (i == 0 && !StringUtils.equals((String)number, (String)decDimension.getDimMember())) {
                errorMap.put(i, ResManager.loadResFormat((String)"\u5f85\u5206\u89e3\u6210\u5458\u5e94\u4e3a%1\u3002", (String)"DecomposeImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{decDimension.getDimMember()}));
            }
            if ((member = modelCache.getMember(decDimension.getDimNumber(), IDUtils.toLong((Object)viewMap.get(decDimension.getDimMember())), number)) != null) continue;
            errorMap.put(i, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DecomposeImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!errorMap.isEmpty()) {
            return;
        }
        for (i = 0; i < dataList.size(); ++i) {
            data = dataList.get(i);
            number = data.get("number");
            Long viewId = IDUtils.toLong((Object)viewMap.get(dimNumber));
            Member member = modelCache.getMember(dimNumber, viewId, number);
            this.validChange(modelCache, dimNumber, dataList, member, errorMap, i, viewId);
        }
    }

    private void validChange(IModelCacheHelper modelCache, String dimNumber, List<Map<String, String>> dataList, Member member, Map<Integer, String> errorMap, int row, Long viewId) {
        if (!member.isLeaf()) {
            BigDecimal aggValue = BigDecimal.ZERO;
            boolean hasChildFlag = false;
            Map<String, String> data = dataList.get(row);
            String id = data.get("id");
            for (int i = 0; i < dataList.size(); ++i) {
                BigDecimal childValue;
                Map<String, String> childData = dataList.get(i);
                if (childData.isEmpty()) continue;
                String pid = childData.get("pid");
                String childNumber = childData.get("number");
                Member childMember = modelCache.getMember(dimNumber, viewId, childNumber);
                if (!childMember.getParentNumber().equals(member.getNumber()) || !StringUtils.equals((String)id, (String)pid) || (childValue = this.stringToBigDecimal(childData.get("change"))) == null || childValue.compareTo(BigDecimal.ZERO) == 0) continue;
                hasChildFlag = true;
                aggValue = this.decomposeTaskService.getNewAmountByAggoprt(childMember.getAggType(), aggValue, childValue);
            }
            if (hasChildFlag) {
                BigDecimal change;
                String valueStr = data.get("change");
                if (StringUtils.isEmpty((String)valueStr)) {
                    change = aggValue;
                    data.put("change", String.valueOf(aggValue));
                } else {
                    change = this.stringToBigDecimal(valueStr);
                }
                if (aggValue.compareTo(change) != 0) {
                    String errorString = ResManager.loadKDString((String)"\u6c47\u603b\u5206\u89e3\u503c\u4e0e\u660e\u7ec6\u5206\u89e3\u503c\u6c47\u603b\u7684\u7ed3\u679c\u4e0d\u4e00\u81f4\u3002", (String)"DecomposeImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    if (errorMap.containsKey(row)) {
                        errorMap.put(row, errorMap.get(row) + errorString);
                    } else {
                        errorMap.put(row, errorString);
                    }
                }
            }
        }
    }
}

